/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.formula;

import java.util.Set;
import org.linqs.psl.model.atom.Atom;
import org.linqs.psl.model.formula.Conjunction;
import org.linqs.psl.model.formula.Disjunction;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.formula.Implication;
import org.linqs.psl.model.term.VariableTypeMap;
import org.linqs.psl.util.HashCode;

public class Negation
implements Formula {
    private final Formula body;
    private final int hash;

    public Negation(Formula f) {
        assert (f != null);
        this.body = f;
        this.hash = HashCode.build(f) + 3;
    }

    public Formula getFormula() {
        return this.body;
    }

    @Override
    public Formula getDNF() {
        Formula flatBody = this.body.flatten();
        if (flatBody instanceof Atom) {
            return this;
        }
        if (flatBody instanceof Negation) {
            return ((Negation)flatBody).body.getDNF();
        }
        if (flatBody instanceof Conjunction) {
            Conjunction conjunction = (Conjunction)flatBody;
            Formula[] components = new Formula[conjunction.length()];
            for (int i = 0; i < components.length; ++i) {
                components[i] = new Negation(conjunction.get(i));
            }
            return new Disjunction(components).getDNF();
        }
        if (flatBody instanceof Disjunction) {
            Disjunction disjunction = (Disjunction)flatBody;
            Formula[] components = new Formula[disjunction.length()];
            for (int i = 0; i < components.length; ++i) {
                components[i] = new Negation(disjunction.get(i));
            }
            return new Conjunction(components).getDNF();
        }
        if (flatBody instanceof Implication) {
            return new Negation(flatBody.getDNF()).getDNF();
        }
        throw new IllegalStateException("Body of negation is unrecognized type.");
    }

    public String toString() {
        return "~( " + this.body + " )";
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object oth) {
        if (oth == this) {
            return true;
        }
        if (oth == null || !this.getClass().isInstance(oth)) {
            return false;
        }
        Negation other = (Negation)oth;
        return this.hash == other.hash && this.body.equals(other.body);
    }

    @Override
    public Set<Atom> getAtoms(Set<Atom> atoms) {
        this.body.getAtoms(atoms);
        return atoms;
    }

    @Override
    public VariableTypeMap collectVariables(VariableTypeMap varMap) {
        this.body.collectVariables(varMap);
        return varMap;
    }

    @Override
    public Formula flatten() {
        Formula flatBody = this.body.flatten();
        if (flatBody instanceof Negation) {
            return ((Negation)flatBody).body;
        }
        return new Negation(flatBody);
    }
}

