/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.util;

public final class BitUtils {
    private BitUtils() {
    }

    public static long toBitSet(boolean[] bits) {
        if (bits.length > 64) {
            throw new IllegalArgumentException(String.format("Number of bits cannot exceed a long (64 bits), got %d.", bits.length));
        }
        long bitSet = 0L;
        long mask = 1L;
        for (boolean bit : bits) {
            if (bit) {
                bitSet |= mask;
            }
            mask <<= 1;
        }
        return bitSet;
    }

    public static boolean[] toBits(long bitSet) {
        return BitUtils.toBits(bitSet, new boolean[64]);
    }

    public static boolean[] toBits(long bitSet, boolean[] bits) {
        if (bits.length > 64) {
            throw new IllegalArgumentException(String.format("Number of bits cannot exceed a long (64 bits), got %d.", bits.length));
        }
        long mask = 1L;
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = (bitSet & mask) != 0L;
            mask <<= 1;
        }
        return bits;
    }

    public static boolean getBit(long bitSet, int index) {
        if (index >= 64) {
            throw new IndexOutOfBoundsException(String.format("Max bitset index is 63, got %d.", index));
        }
        long mask = 1 << index;
        return (bitSet & mask) != 0L;
    }

    public static long setBit(long bitSet, int index, boolean value) {
        if (index >= 64) {
            throw new IndexOutOfBoundsException(String.format("Max bitset index is 63, got %d.", index));
        }
        long mask = 1 << index;
        if (value) {
            return bitSet | mask;
        }
        return bitSet & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }
}

