/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Hash {
    private Hash() {
    }

    public static String md5(String data) {
        return Hash.bytesToHex(Hash.compute(data, "MD5"));
    }

    public static String md5(byte[] data) {
        return Hash.bytesToHex(Hash.compute(data, "MD5"));
    }

    public static String sha(String data) {
        return Hash.bytesToHex(Hash.compute(data, "SHA-1"));
    }

    public static String sha(byte[] data) {
        return Hash.bytesToHex(Hash.compute(data, "SHA-1"));
    }

    public static String sha256(String data) {
        return Hash.bytesToHex(Hash.compute(data, "SHA-256"));
    }

    public static String sha256(byte[] data) {
        return Hash.bytesToHex(Hash.compute(data, "SHA-256"));
    }

    public static String bytesToHex(byte[] data) {
        StringBuffer builder = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            String hex = Integer.toHexString(0xFF & data[i]);
            if (hex.length() == 1) {
                builder.append('0');
            }
            builder.append(hex);
        }
        return builder.toString();
    }

    public static byte[] compute(String data, String algorithm) {
        return Hash.compute(data.getBytes(StandardCharsets.UTF_8), algorithm);
    }

    public static byte[] compute(byte[] data, String algorithm) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        return digest.digest(data);
    }
}

