/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import org.linqs.psl.util.Logger;

public class SystemUtils {
    private static final Logger log = Logger.getLogger(SystemUtils.class);

    private SystemUtils() {
    }

    public static String getTempDir(String prefix) {
        return Paths.get(String.format("%s/%s_%s@%s", SystemUtils.getSystemTempDir(), prefix, SystemUtils.getUsername(), SystemUtils.getHostname()), new String[0]).toString();
    }

    public static String getSystemTempDir() {
        return Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).toString();
    }

    public static String getUsername() {
        return System.getProperty("user.name");
    }

    public static String getHostname() {
        String hostname = "unknown";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostname;
    }
}

