import {
  Fragment,
  Teleport,
  computed,
  createBaseVNode,
  createBlock,
  createCommentVNode,
  createElementBlock,
  createSlots,
  createStaticVNode,
  createTextVNode,
  createVNode,
  customRef,
  defineComponent,
  getCurrentInstance,
  getCurrentScope,
  guardReactiveProps,
  h,
  inject,
  isRef,
  mergeProps,
  nextTick,
  normalizeClass,
  normalizeProps,
  normalizeStyle,
  onBeforeUnmount,
  onMounted,
  onScopeDispose,
  openBlock,
  provide,
  reactive,
  readonly,
  ref,
  renderList,
  renderSlot,
  resolveComponent,
  resolveDynamicComponent,
  shallowRef,
  toDisplayString,
  toRaw,
  toRef,
  unref,
  useAttrs,
  useSlots,
  vModelCheckbox,
  vModelDynamic,
  vModelRadio,
  vModelSelect,
  vModelText,
  vShow,
  watch,
  watchEffect,
  withCtx,
  withDirectives,
  withKeys,
  withModifiers
} from "./chunk-RAKT47ZN.js";
import "./chunk-76J2PTFD.js";

// node_modules/vue-uswds/dist/vue-uswds.es.js
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
var version = "1.3.0";
var stringKebabCase = kebabCase$1;
var wordSeparators = /[\s\u2000-\u206F\u2E00-\u2E7F\\'!"#$%&()*+,\-.\/:;<=>?@\[\]^_`{|}~]+/;
var capital_plus_lower = /[A-ZÀ-Ý\u00C0-\u00D6\u00D9-\u00DD][a-zà-ÿ]/g;
var capitals = /[A-ZÀ-Ý\u00C0-\u00D6\u00D9-\u00DD]+/g;
function kebabCase$1(str) {
  str = str.replace(capital_plus_lower, function(match) {
    return " " + (match[0].toLowerCase() || match[0]) + match[1];
  });
  str = str.replace(capitals, function(match) {
    return " " + match.toLowerCase();
  });
  return str.trim().split(wordSeparators).join("-").replace(/^-/, "").replace(/-\s*$/, "");
}
var arraySplit = split;
function split(arr, n) {
  if (!Array.isArray(arr)) {
    throw new Error("expected an array for the first argument");
  }
  if (n != null && typeof n != "number") {
    throw new Error("expected a number or null/undefined for the second argument");
  }
  n = n != null ? n : arr.length;
  var len = arr.length;
  var groups = [];
  for (var i = 0; i < len; i += n) {
    groups.push(arr.slice(i, i + n));
  }
  return groups;
}
var objectHasKey = (object, key) => Object.prototype.hasOwnProperty.call(object, key);
var kebabCase = (value) => stringKebabCase(value);
var escapeRegExp = (string) => string.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
var splitArray = (array, splitAt) => arraySplit(array, splitAt);
var idPrefix = "vuswds-id-";
var idRegistry = {};
function nextId(componentName = "") {
  var _a2;
  const vm = getCurrentInstance();
  const route = (_a2 = vm.appContext.config.globalProperties) == null ? void 0 : _a2.$route;
  const pathPrefix = (route == null ? void 0 : route.path) ? kebabCase(route.path) : "global";
  if (!idRegistry[pathPrefix]) {
    idRegistry[pathPrefix] = 0;
  }
  return `${idPrefix}${pathPrefix}-${kebabCase(componentName)}-${++idRegistry[pathPrefix]}`;
}
var PREFIX_SEPARATOR = ":";
var GRID_NAMESPACE = "grid-";
var UTILITY_NAMESPACE = "u-";
var IMAGE_PATH = "/assets/img";
var SVG_SPRITE_PATH = "/assets/img/sprite.svg";
var ROUTER_COMPONENT_NAME = null;
var MOBILE_MENU_BREAKPOINT = "64em";
var FOOTER_NAV_COLLAPSIBLE_BREAKPOINT = "30em";
var MIN_DATE = "0000-01-01";
var MAX_DATE = "9999-12-31";
var USA_DATE_REGEX_PATTERN = /^(0[1-9]|1[0-2])\/(0[1-9]|[12][0-9]|3[01])\/\d{4}$/;
var ISO_DATE_REGEX_PATTERN = /^\d{4}-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])$/;
var MONTH_LABELS = [
  "January",
  "February",
  "March",
  "April",
  "May",
  "June",
  "July",
  "August",
  "September",
  "October",
  "November",
  "December"
];
var DAY_OF_WEEK_LABELS = [
  "Sunday",
  "Monday",
  "Tuesday",
  "Wednesday",
  "Thursday",
  "Friday",
  "Saturday"
];
var DAY_OF_WEEK_ABBREVIATION_LABELS = [
  "S",
  "M",
  "T",
  "W",
  "Th",
  "Fr",
  "S"
];
var YEAR_GROUP = 12;
var core = {
  install: (app, options) => {
    const customOptions = options || {};
    const vueUswdsOptions = __spreadProps(__spreadValues({
      prefixSeparator: PREFIX_SEPARATOR,
      gridNamespace: GRID_NAMESPACE,
      utilityNamespace: UTILITY_NAMESPACE,
      imagePath: IMAGE_PATH,
      svgSpritePath: SVG_SPRITE_PATH,
      routerComponentName: ROUTER_COMPONENT_NAME,
      mobileMenuBreakpoint: MOBILE_MENU_BREAKPOINT,
      footerNavBigBreakpoint: FOOTER_NAV_COLLAPSIBLE_BREAKPOINT
    }, customOptions), {
      version
    });
    if (!app.config.globalProperties.$vueUswds) {
      app.config.globalProperties.$vueUswds = vueUswdsOptions;
    }
    app.provide("vueUswds", vueUswdsOptions);
    app.provide("nextId", nextId);
  }
};
var _sfc_main$1z = {
  __name: "BaseHeading",
  props: {
    tag: {
      type: String,
      default: "h2",
      validator(tag) {
        const isValidTag = ["h1", "h2", "h3", "h4", "h5", "h6"].includes(tag);
        if (!isValidTag) {
          console.warn(`'${tag}' is not a valid HTML heading element`);
        }
        return isValidTag;
      }
    }
  },
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(__props.tag), null, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 3
      });
    };
  }
};
var _export_sfc = (sfc, props) => {
  const target = sfc.__vccOpts || sfc;
  for (const [key, val] of props) {
    target[key] = val;
  }
  return target;
};
var _sfc_main$1y = {
  name: "BaseLink",
  inject: {
    globalRouterComponentName: {
      from: "vueUswds.routerComponentName",
      default: ROUTER_COMPONENT_NAME
    }
  },
  inheritAttrs: false,
  props: {
    href: {
      type: String,
      default: ""
    },
    to: {
      type: [String, Object],
      default: ""
    },
    routerComponentName: {
      type: String,
      default: ""
    }
  },
  data() {
    return {
      isNuxt: this == null ? void 0 : this.$nuxt,
      isVueRouter: this == null ? void 0 : this.$router
    };
  },
  computed: {
    isHrefLink() {
      return !!this.href || typeof this.to === "string" && this.to.startsWith("http");
    },
    linkComponent() {
      if (this.routerComponentName) {
        return this.routerComponentName;
      }
      if (this.globalRouterComponentName) {
        return this.globalRouterComponentName;
      }
      if (this.isNuxt) {
        return "nuxt-link";
      }
      if (this.isVueRouter) {
        return "router-link";
      }
      return "a";
    }
  },
  methods: {
    handleSpaceKeydown(event) {
      var _a2, _b;
      if ((_b = (_a2 = this.$attrs) == null ? void 0 : _a2.class) == null ? void 0 : _b.includes("usa-button")) {
        event.target.click();
      }
    }
  }
};
var _hoisted_1$1h = ["href"];
function _sfc_render$5(_ctx, _cache, $props, $setup, $data, $options) {
  return $options.isHrefLink ? (openBlock(), createElementBlock("a", mergeProps({ key: 0 }, _ctx.$attrs, {
    href: $props.href || $props.to,
    onKeydown: _cache[0] || (_cache[0] = withKeys(withModifiers((...args) => $options.handleSpaceKeydown && $options.handleSpaceKeydown(...args), ["prevent"]), ["space"]))
  }), [
    renderSlot(_ctx.$slots, "default")
  ], 16, _hoisted_1$1h)) : (openBlock(), createBlock(resolveDynamicComponent($options.linkComponent), mergeProps({ key: 1 }, _ctx.$attrs, {
    to: $props.to,
    onKeydown: withKeys(withModifiers($options.handleSpaceKeydown, ["prevent"]), ["space"])
  }), {
    default: withCtx(() => [
      renderSlot(_ctx.$slots, "default")
    ]),
    _: 3
  }, 16, ["to", "onKeydown"]));
}
var BaseLink = _export_sfc(_sfc_main$1y, [["render", _sfc_render$5]]);
var useAccordion = (_accordionItems, multiselectable = false) => {
  const accordionItems = reactive(_accordionItems);
  const registerAccordionItem = (id, isOpen) => {
    if (accordionItems[id] === void 0) {
      accordionItems[id] = isOpen;
    }
    if (multiselectable.value) {
      return;
    }
    for (const accordionId in accordionItems) {
      if (accordionId !== id && isOpen) {
        accordionItems[accordionId] = false;
      }
    }
  };
  const unregisterAccordionItem = (id) => {
    delete accordionItems[id];
  };
  const closeItem = (id) => {
    accordionItems[id] = false;
  };
  const openItem = (id) => {
    accordionItems[id] = true;
    if (multiselectable.value) {
      return;
    }
    for (const accordionId in accordionItems) {
      if (accordionId !== id) {
        closeItem(accordionId);
      }
    }
  };
  const toggleItem = (id) => {
    if (accordionItems[id]) {
      closeItem(id);
    } else {
      openItem(id);
    }
  };
  const closeAllItems = () => {
    for (const accordionId in accordionItems) {
      closeItem(accordionId);
    }
  };
  return {
    registerAccordionItem,
    unregisterAccordionItem,
    openItem,
    closeItem,
    toggleItem,
    closeAllItems
  };
};
var _hoisted_1$1g = ["aria-multiselectable"];
var _sfc_main$1x = {
  __name: "UsaAccordion",
  props: {
    bordered: {
      type: Boolean,
      default: false
    },
    multiselectable: {
      type: Boolean,
      default: false
    },
    headingTag: {
      type: String,
      default: "h2"
    }
  },
  emits: ["update:accordionItems"],
  setup(__props, { expose: __expose, emit }) {
    const props = __props;
    const accordionItems = reactive({});
    const isMultiSelectable = toRef(props, "multiselectable");
    const {
      registerAccordionItem,
      unregisterAccordionItem,
      openItem,
      closeItem,
      toggleItem
    } = useAccordion(accordionItems, isMultiSelectable);
    watch(accordionItems, () => {
      emit("update:accordionItems", accordionItems);
    });
    provide("accordionHeadingTag", computed(() => props.headingTag));
    provide("registerAccordionItem", registerAccordionItem);
    provide("unregisterAccordionItem", unregisterAccordionItem);
    provide("toggleItem", toggleItem);
    provide("accordionItems", accordionItems);
    const classes = computed(() => [{ "usa-accordion--bordered": props.bordered }]);
    __expose({
      openItem,
      closeItem,
      toggleItem
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(["usa-accordion", classes.value]),
        "aria-multiselectable": isMultiSelectable.value || null
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 10, _hoisted_1$1g);
    };
  }
};
var _hoisted_1$1f = ["aria-expanded", "aria-controls"];
var _hoisted_2$C = ["id", "hidden"];
var _sfc_main$1w = {
  __name: "UsaAccordionItem",
  props: {
    id: {
      type: String,
      default: ""
    },
    label: {
      type: String,
      default: ""
    },
    open: {
      type: Boolean,
      default: false
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          heading: [],
          button: [],
          content: []
        };
      }
    }
  },
  setup(__props) {
    const props = __props;
    const accordionHeadingTag = inject("accordionHeadingTag");
    const registerAccordionItem = inject("registerAccordionItem");
    const unregisterAccordionItem = inject("unregisterAccordionItem");
    const toggleItem = inject("toggleItem");
    const accordionItems = inject("accordionItems");
    const computedId = computed(() => props.id || nextId("usa-accordion-item"));
    const isOpen = toRef(accordionItems, computedId.value);
    registerAccordionItem(computedId.value, props.open);
    onBeforeUnmount(() => {
      unregisterAccordionItem(computedId.value);
    });
    return (_ctx, _cache) => {
      var _a2, _b;
      return openBlock(), createElementBlock(Fragment, null, [
        createVNode(unref(_sfc_main$1z), mergeProps(_ctx.$attrs, {
          class: ["usa-accordion__heading", (_a2 = __props.customClasses) == null ? void 0 : _a2.heading],
          tag: unref(accordionHeadingTag)
        }), {
          default: withCtx(() => {
            var _a3;
            return [
              createBaseVNode("button", {
                type: "button",
                class: normalizeClass(["usa-accordion__button", (_a3 = __props.customClasses) == null ? void 0 : _a3.button]),
                "aria-expanded": isOpen.value,
                "aria-controls": computedId.value,
                onClick: _cache[0] || (_cache[0] = ($event) => unref(toggleItem)(computedId.value))
              }, [
                renderSlot(_ctx.$slots, "label", {}, () => [
                  createTextVNode(toDisplayString(__props.label), 1)
                ])
              ], 10, _hoisted_1$1f)
            ];
          }),
          _: 3
        }, 16, ["class", "tag"]),
        createBaseVNode("div", {
          id: computedId.value,
          class: normalizeClass(["usa-accordion__content", (_b = __props.customClasses) == null ? void 0 : _b.content]),
          hidden: !isOpen.value
        }, [
          renderSlot(_ctx.$slots, "default")
        ], 10, _hoisted_2$C)
      ], 64);
    };
  }
};
var _hoisted_1$1e = ["role"];
var _hoisted_2$B = { class: "usa-alert__text" };
var _sfc_main$1v = {
  __name: "UsaAlert",
  props: {
    variant: {
      type: String,
      default: "",
      validator(variant) {
        const isValidVariant = [
          "",
          "info",
          "warning",
          "error",
          "success",
          "emergency",
          "validation"
        ].includes(variant);
        if (!isValidVariant) {
          console.warn(`'${variant}' is not a valid alert variant`);
        }
        return isValidVariant;
      }
    },
    slim: {
      type: Boolean,
      default: false
    },
    noIcon: {
      type: Boolean,
      default: false
    },
    role: {
      type: String,
      default: ""
    },
    heading: {
      type: String,
      default: ""
    },
    headingTag: {
      type: String,
      default: "h2"
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          body: [],
          heading: []
        };
      }
    }
  },
  setup(__props) {
    const props = __props;
    const classes = computed(() => {
      return {
        "usa-alert--no-icon": props.noIcon,
        "usa-alert--slim": props.slim,
        "usa-alert--info": props.variant === "info" || props.variant === "validation",
        "usa-alert--warning": props.variant === "warning",
        "usa-alert--error": props.variant === "error",
        "usa-alert--success": props.variant === "success",
        "usa-alert--emergency": props.variant === "emergency",
        "usa-alert--validation": props.variant === "validation"
      };
    });
    const ariaRole = computed(() => {
      if (props.role) {
        return props.role;
      }
      if (!props.role && props.variant === "error") {
        return "alert";
      }
      return null;
    });
    return (_ctx, _cache) => {
      var _a2, _b;
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(["usa-alert", classes.value]),
        role: ariaRole.value
      }, [
        createBaseVNode("div", {
          class: normalizeClass(["usa-alert__body", (_a2 = __props.customClasses) == null ? void 0 : _a2.body])
        }, [
          __props.heading || _ctx.$slots.heading ? (openBlock(), createBlock(unref(_sfc_main$1z), {
            key: 0,
            tag: __props.headingTag,
            class: normalizeClass(["usa-alert__heading", [{ "usa-sr-only": __props.slim }, (_b = __props.customClasses) == null ? void 0 : _b.heading]])
          }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "heading", {}, () => [
                createTextVNode(toDisplayString(__props.heading), 1)
              ])
            ]),
            _: 3
          }, 8, ["tag", "class"])) : createCommentVNode("", true),
          renderSlot(_ctx.$slots, "message", {}, () => [
            createBaseVNode("p", _hoisted_2$B, [
              renderSlot(_ctx.$slots, "default")
            ])
          ])
        ], 2)
      ], 10, _hoisted_1$1e);
    };
  }
};
var useToggle = (_id, idPrefix2 = "", defaultOpen = false, emit) => {
  const propValue = ref(defaultOpen);
  const isOpen = ref(propValue.value);
  const toggleId = computed(() => _id || nextId(idPrefix2));
  const closeContent = () => {
    isOpen.value = false;
  };
  const openContent = () => {
    isOpen.value = true;
  };
  const toggleContent = () => {
    if (isOpen.value) {
      closeContent();
    } else {
      openContent();
    }
  };
  watch(isOpen, (newValue) => {
    if (emit) {
      emit("update:open", newValue);
    }
  });
  watch(propValue, (newValue) => {
    if (propValue.value !== newValue) {
      toggleContent();
    }
  });
  return {
    isOpen: readonly(isOpen),
    toggleId: readonly(toggleId),
    closeContent,
    openContent,
    toggleContent
  };
};
var _hoisted_1$1d = ["src"];
var _hoisted_2$A = { class: "usa-media-block__body" };
var _hoisted_3$m = { key: 2 };
var _hoisted_4$f = createBaseVNode("strong", null, "Official websites use .gov", -1);
var _hoisted_5$b = createBaseVNode("br", null, null, -1);
var _hoisted_6$9 = createBaseVNode("strong", null, ".gov", -1);
var _hoisted_7$6 = ["src"];
var _hoisted_8$3 = { class: "usa-media-block__body" };
var _hoisted_9$3 = { key: 2 };
var _hoisted_10$3 = createBaseVNode("strong", null, "Secure .gov websites use HTTPS", -1);
var _hoisted_11$3 = createBaseVNode("br", null, null, -1);
var _hoisted_12$3 = createBaseVNode("strong", null, "lock", -1);
var _hoisted_13$3 = createBaseVNode("span", { class: "icon-lock" }, [
  createBaseVNode("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    width: "52",
    height: "64",
    viewBox: "0 0 52 64",
    class: "usa-banner__lock-image",
    role: "img",
    "aria-labelledby": "banner-lock-description",
    focusable: "false"
  }, [
    createBaseVNode("title", { id: "banner-lock-title" }, "Lock"),
    createBaseVNode("desc", { id: "banner-lock-description" }, "Locked padlock icon"),
    createBaseVNode("path", {
      fill: "#000000",
      "fill-rule": "evenodd",
      d: "M26 0c10.493 0 19 8.507 19 19v9h3a4 4 0 0 1 4 4v28a4 4 0 0 1-4 4H4a4 4 0 0 1-4-4V32a4 4 0 0 1 4-4h3v-9C7 8.507 15.507 0 26 0zm0 8c-5.979 0-10.843 4.77-10.996 10.712L15 19v9h22v-9c0-6.075-4.925-11-11-11z"
    })
  ])
], -1);
var _hoisted_14$1 = createBaseVNode("strong", null, "https://", -1);
var _sfc_main$1u = {
  __name: "UsaBannerContent",
  setup(__props) {
    const slots = useSlots();
    if (slots == null ? void 0 : slots.tldIcon) {
      console.warn(`The 'tldIcon' slot is deprecated, use 'tld-icon' instead.`);
    }
    if (slots == null ? void 0 : slots.tldDescription) {
      console.warn(`The 'tldDescription' slot is deprecated, use 'tld-description' instead.`);
    }
    if (slots == null ? void 0 : slots.httpsIcon) {
      console.warn(`The 'httpsIcon' slot is deprecated, use 'https-icon' instead.`);
    }
    if (slots == null ? void 0 : slots.httpsDescription) {
      console.warn(`The 'httpsDescription' slot is deprecated, use 'https-description' instead.`);
    }
    const prefixSeparator = inject("vueUswds.prefixSeparator", PREFIX_SEPARATOR);
    const gridNamespace = inject("vueUswds.gridNamespace", GRID_NAMESPACE);
    const imagePath = inject("vueUswds.imagePath", IMAGE_PATH);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(`${unref(gridNamespace)}row ${unref(gridNamespace)}gap-lg`)
      }, [
        createBaseVNode("div", {
          class: normalizeClass(`usa-banner__guidance tablet${unref(prefixSeparator)}${unref(gridNamespace)}col-6`)
        }, [
          _ctx.$slots["tld-icon"] ? renderSlot(_ctx.$slots, "tld-icon", { key: 0 }) : _ctx.$slots.tldIcon ? renderSlot(_ctx.$slots, "tldIcon", { key: 1 }) : (openBlock(), createElementBlock("img", {
            key: 2,
            class: "usa-banner__icon usa-media-block__img",
            src: `${unref(imagePath)}/icon-dot-gov.svg`,
            role: "img",
            alt: "",
            "aria-hidden": "true"
          }, null, 8, _hoisted_1$1d)),
          createBaseVNode("div", _hoisted_2$A, [
            _ctx.$slots["tld-description"] ? renderSlot(_ctx.$slots, "tld-description", { key: 0 }) : _ctx.$slots.tldDescription ? renderSlot(_ctx.$slots, "tldDescription", { key: 1 }) : (openBlock(), createElementBlock("p", _hoisted_3$m, [
              _hoisted_4$f,
              _hoisted_5$b,
              createTextVNode(" A "),
              _hoisted_6$9,
              createTextVNode(" website belongs to an official government organization in the United States. ")
            ]))
          ])
        ], 2),
        createBaseVNode("div", {
          class: normalizeClass(`usa-banner__guidance tablet${unref(prefixSeparator)}${unref(gridNamespace)}col-6`)
        }, [
          _ctx.$slots["https-icon"] ? renderSlot(_ctx.$slots, "https-icon", { key: 0 }) : _ctx.$slots.httpsIcon ? renderSlot(_ctx.$slots, "httpsIcon", { key: 1 }) : (openBlock(), createElementBlock("img", {
            key: 2,
            class: "usa-banner__icon usa-media-block__img",
            src: `${unref(imagePath)}/icon-https.svg`,
            role: "img",
            alt: "",
            "aria-hidden": "true"
          }, null, 8, _hoisted_7$6)),
          createBaseVNode("div", _hoisted_8$3, [
            _ctx.$slots["https-description"] ? renderSlot(_ctx.$slots, "https-description", { key: 0 }) : _ctx.$slots.httpsDescription ? renderSlot(_ctx.$slots, "httpsDescription", { key: 1 }) : (openBlock(), createElementBlock("p", _hoisted_9$3, [
              _hoisted_10$3,
              _hoisted_11$3,
              createTextVNode(" A "),
              _hoisted_12$3,
              createTextVNode(" ( "),
              _hoisted_13$3,
              createTextVNode(" ) or "),
              _hoisted_14$1,
              createTextVNode(" means you've safely connected to the .gov website. Share sensitive information only on official, secure websites. ")
            ]))
          ])
        ], 2)
      ], 2);
    };
  }
};
var _hoisted_1$1c = ["aria-label"];
var _hoisted_2$z = ["src"];
var _hoisted_3$l = { class: "usa-banner__header-text" };
var _hoisted_4$e = { class: "usa-banner__header-action" };
var _hoisted_5$a = ["aria-expanded", "aria-controls"];
var _hoisted_6$8 = { class: "usa-banner__button-text" };
var _hoisted_7$5 = ["id", "hidden"];
var _sfc_main$1t = {
  __name: "UsaBanner",
  props: {
    open: {
      type: Boolean,
      default: false
    },
    id: {
      type: String,
      default: ""
    },
    ariaLabel: {
      type: String,
      default: "Official website of the United States government"
    },
    headerText: {
      type: String,
      default: "An official website of the United States government"
    },
    actionText: {
      type: String,
      default: "Here's how you know"
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          accordion: [],
          bannerHeader: [],
          bannerInner: [],
          button: [],
          bannerContent: []
        };
      }
    }
  },
  emits: ["update:open"],
  setup(__props, { expose: __expose, emit }) {
    const props = __props;
    const prefixSeparator = inject("vueUswds.prefixSeparator", PREFIX_SEPARATOR);
    const gridNamespace = inject("vueUswds.gridNamespace", GRID_NAMESPACE);
    const imagePath = inject("vueUswds.imagePath", IMAGE_PATH);
    const { isOpen, toggleId, openContent, closeContent, toggleContent } = useToggle(props.id, "usa-banner", toRef(props, "open"), emit);
    const headerClasses = computed(() => {
      var _a2;
      return [
        { "usa-banner__header--expanded": isOpen.value },
        ...((_a2 = props.customClasses) == null ? void 0 : _a2.bannerHeader) || []
      ];
    });
    __expose({
      openContent,
      closeContent,
      toggleContent
    });
    return (_ctx, _cache) => {
      var _a2, _b, _c, _d;
      return openBlock(), createElementBlock("section", {
        class: "usa-banner",
        "aria-label": __props.ariaLabel
      }, [
        createBaseVNode("div", {
          class: normalizeClass(["usa-accordion", (_a2 = __props.customClasses) == null ? void 0 : _a2.accordion])
        }, [
          createBaseVNode("header", {
            class: normalizeClass(["usa-banner__header", headerClasses.value])
          }, [
            createBaseVNode("div", {
              class: normalizeClass(["usa-banner__inner", (_b = __props.customClasses) == null ? void 0 : _b.bannerInner])
            }, [
              createBaseVNode("div", {
                class: normalizeClass(`${unref(gridNamespace)}col-auto`)
              }, [
                renderSlot(_ctx.$slots, "flag", {}, () => [
                  createBaseVNode("img", {
                    "aria-hidden": "true",
                    class: "usa-banner__header-flag",
                    src: `${unref(imagePath)}/us_flag_small.png`,
                    alt: ""
                  }, null, 8, _hoisted_2$z)
                ])
              ], 2),
              createBaseVNode("div", {
                "aria-hidden": "true",
                class: normalizeClass(`${unref(gridNamespace)}col-fill tablet${unref(prefixSeparator)}${unref(gridNamespace)}col-auto`)
              }, [
                createBaseVNode("p", _hoisted_3$l, toDisplayString(__props.headerText), 1),
                createBaseVNode("p", _hoisted_4$e, toDisplayString(__props.actionText), 1)
              ], 2),
              createBaseVNode("button", {
                type: "button",
                class: normalizeClass(["usa-accordion__button usa-banner__button", (_c = __props.customClasses) == null ? void 0 : _c.button]),
                "aria-expanded": unref(isOpen),
                "aria-controls": unref(toggleId),
                onClick: _cache[0] || (_cache[0] = ($event) => unref(toggleContent)())
              }, [
                renderSlot(_ctx.$slots, "button", {
                  isOpen: unref(isOpen),
                  actionText: __props.actionText
                }, () => [
                  createBaseVNode("span", _hoisted_6$8, toDisplayString(__props.actionText), 1)
                ])
              ], 10, _hoisted_5$a)
            ], 2)
          ], 2),
          createBaseVNode("div", {
            id: unref(toggleId),
            hidden: !unref(isOpen),
            class: normalizeClass(["usa-banner__content usa-accordion__content", (_d = __props.customClasses) == null ? void 0 : _d.bannerContent])
          }, [
            renderSlot(_ctx.$slots, "default", {}, () => [
              createVNode(unref(_sfc_main$1u))
            ])
          ], 10, _hoisted_7$5)
        ], 2)
      ], 8, _hoisted_1$1c);
    };
  }
};
var _hoisted_1$1b = ["aria-current"];
var _sfc_main$1s = {
  __name: "UsaBreadcrumbItem",
  props: {
    href: {
      type: String,
      default: ""
    },
    to: {
      type: [String, Object],
      default: ""
    },
    routerComponentName: {
      type: String,
      default: ""
    },
    current: {
      type: Boolean,
      default: false
    },
    customClasses: {
      type: Object,
      default: () => ({
        link: [],
        span: []
      })
    }
  },
  setup(__props) {
    const props = __props;
    const ariaCurrent = computed(() => props.current ? "page" : null);
    return (_ctx, _cache) => {
      var _a2, _b;
      return openBlock(), createElementBlock("li", {
        class: "usa-breadcrumb__list-item",
        "aria-current": ariaCurrent.value
      }, [
        __props.current ? (openBlock(), createElementBlock("span", {
          key: 0,
          class: normalizeClass((_a2 = __props.customClasses) == null ? void 0 : _a2.span)
        }, [
          renderSlot(_ctx.$slots, "default")
        ], 2)) : (openBlock(), createBlock(unref(BaseLink), {
          key: 1,
          href: __props.href,
          to: __props.to,
          "router-component-name": __props.routerComponentName,
          class: normalizeClass(["usa-breadcrumb__link", (_b = __props.customClasses) == null ? void 0 : _b.link])
        }, {
          default: withCtx(() => {
            var _a3;
            return [
              createBaseVNode("span", {
                class: normalizeClass((_a3 = __props.customClasses) == null ? void 0 : _a3.span)
              }, [
                renderSlot(_ctx.$slots, "default")
              ], 2)
            ];
          }),
          _: 3
        }, 8, ["href", "to", "router-component-name", "class"]))
      ], 8, _hoisted_1$1b);
    };
  }
};
var _hoisted_1$1a = ["aria-label"];
var _sfc_main$1r = {
  __name: "UsaBreadcrumb",
  props: {
    items: {
      type: Array,
      default: () => []
    },
    wrap: {
      type: Boolean,
      default: false
    },
    ariaLabel: {
      type: String,
      default: "Breadcrumbs"
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          list: [],
          item: [],
          link: [],
          span: []
        };
      }
    }
  },
  setup(__props) {
    const props = __props;
    const classes = computed(() => [
      {
        "usa-breadcrumb--wrap": props.wrap
      }
    ]);
    const hasCurrent = computed(() => props.items.some((item) => item == null ? void 0 : item.current));
    const breadcrumbItems = computed(() => {
      if (!props.items.length) {
        return [];
      }
      if (hasCurrent.value) {
        return props.items;
      }
      const items = [...props.items];
      items[items.length - 1].current = true;
      return items;
    });
    return (_ctx, _cache) => {
      var _a2;
      return openBlock(), createElementBlock("nav", {
        class: normalizeClass(["usa-breadcrumb", classes.value]),
        "aria-label": __props.ariaLabel
      }, [
        createBaseVNode("ol", {
          class: normalizeClass(["usa-breadcrumb__list", (_a2 = __props.customClasses) == null ? void 0 : _a2.list])
        }, [
          renderSlot(_ctx.$slots, "default", { items: breadcrumbItems.value }, () => [
            (openBlock(true), createElementBlock(Fragment, null, renderList(breadcrumbItems.value, (item) => {
              var _a3, _b, _c;
              return openBlock(), createBlock(unref(_sfc_main$1s), {
                key: (item == null ? void 0 : item.id) || item.text,
                class: normalizeClass((_a3 = __props.customClasses) == null ? void 0 : _a3.item),
                to: item.to,
                href: item.href,
                "router-component-name": item.routerComponentName,
                current: item.current,
                "custom-classes": {
                  link: (_b = __props.customClasses) == null ? void 0 : _b.link,
                  span: (_c = __props.customClasses) == null ? void 0 : _c.span
                }
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(item.text), 1)
                ]),
                _: 2
              }, 1032, ["class", "to", "href", "router-component-name", "current", "custom-classes"]);
            }), 128))
          ])
        ], 2)
      ], 10, _hoisted_1$1a);
    };
  }
};
var _hoisted_1$19 = ["type", "disabled"];
var _sfc_main$1q = {
  __name: "UsaButton",
  props: {
    variant: {
      type: String,
      default: "",
      validator(variant) {
        return [
          "",
          "secondary",
          "accent-cool",
          "accent-warm",
          "base",
          "outline",
          "inverse",
          "unstyled"
        ].includes(variant);
      }
    },
    size: {
      type: String,
      default: "",
      validator(size) {
        return ["", "big"].includes(size);
      }
    },
    type: {
      type: String,
      default: "button",
      validator(type) {
        return ["button", "submit", "reset"].includes(type);
      }
    },
    disabled: {
      type: Boolean,
      default: false
    }
  },
  setup(__props) {
    const props = __props;
    const classes = computed(() => [
      {
        "usa-button--secondary": props.variant === "secondary",
        "usa-button--accent-cool": props.variant === "accent-cool",
        "usa-button--accent-warm": props.variant === "accent-warm",
        "usa-button--base": props.variant === "base",
        "usa-button--outline": props.variant === "outline" || props.variant === "inverse",
        "usa-button--inverse": props.variant === "inverse",
        "usa-button--unstyled": props.variant === "unstyled",
        "usa-button--big": props.size === "big"
      }
    ]);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("button", mergeProps(_ctx.$attrs, {
        class: ["usa-button", classes.value],
        type: __props.type,
        disabled: __props.disabled
      }), [
        renderSlot(_ctx.$slots, "before"),
        renderSlot(_ctx.$slots, "default"),
        renderSlot(_ctx.$slots, "after")
      ], 16, _hoisted_1$19);
    };
  }
};
var _sfc_main$1p = {
  __name: "UsaButtonGroup",
  props: {
    segmented: {
      type: Boolean,
      default: false
    }
  },
  setup(__props) {
    const props = __props;
    const classes = computed(() => [
      { "usa-button-group--segmented": props.segmented }
    ]);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("ul", {
        class: normalizeClass(["usa-button-group", classes.value])
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 2);
    };
  }
};
var _sfc_main$1o = {};
var _hoisted_1$18 = { class: "usa-button-group__item" };
function _sfc_render$4(_ctx, _cache) {
  return openBlock(), createElementBlock("li", _hoisted_1$18, [
    renderSlot(_ctx.$slots, "default")
  ]);
}
var UsaButtonGroupItem = _export_sfc(_sfc_main$1o, [["render", _sfc_render$4]]);
var _sfc_main$1n = {
  __name: "UsaCard",
  props: {
    cardTag: {
      type: String,
      default: "div"
    },
    heading: {
      type: String,
      default: ""
    },
    headingTag: {
      type: String,
      default: "h2"
    },
    flag: {
      type: Boolean,
      default: false
    },
    headerFirst: {
      type: Boolean,
      default: false
    },
    insetMedia: {
      type: Boolean,
      default: false
    },
    mediaPosition: {
      type: String,
      default: "left",
      validator(mediaPosition) {
        return ["left", "right"].includes(mediaPosition);
      }
    },
    headerExdent: {
      type: Boolean,
      default: false
    },
    mediaExdent: {
      type: Boolean,
      default: false
    },
    bodyExdent: {
      type: Boolean,
      default: false
    },
    footerExdent: {
      type: Boolean,
      default: false
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          container: [],
          header: [],
          heading: [],
          media: [],
          img: [],
          body: [],
          footer: []
        };
      }
    }
  },
  setup(__props) {
    const props = __props;
    const classes = computed(() => [
      {
        "usa-card--header-first": props.headerFirst,
        "usa-card--flag": props.flag,
        "usa-card--media-right": props.mediaPosition === "right"
      }
    ]);
    const headerClasses = computed(() => {
      var _a2;
      return [
        { "usa-card__header--exdent": props.headerExdent },
        ...((_a2 = props.customClasses) == null ? void 0 : _a2.header) || []
      ];
    });
    const mediaClasses = computed(() => {
      var _a2;
      return [
        {
          "usa-card__media--inset": props.insetMedia,
          "usa-card__media--exdent": props.mediaExdent
        },
        ...((_a2 = props.customClasses) == null ? void 0 : _a2.media) || []
      ];
    });
    const bodyClasses = computed(() => {
      var _a2;
      return [
        { "usa-card__body--exdent": props.bodyExdent },
        ...((_a2 = props.customClasses) == null ? void 0 : _a2.body) || []
      ];
    });
    const footerClasses = computed(() => {
      var _a2;
      return [
        { "usa-card__footer--exdent": props.footerExdent },
        ...((_a2 = props.customClasses) == null ? void 0 : _a2.footer) || []
      ];
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(__props.cardTag), {
        class: normalizeClass(["usa-card", classes.value])
      }, {
        default: withCtx(() => {
          var _a2, _b, _c;
          return [
            createBaseVNode("div", {
              class: normalizeClass(["usa-card__container", (_a2 = __props.customClasses) == null ? void 0 : _a2.container])
            }, [
              __props.heading || _ctx.$slots.heading ? (openBlock(), createElementBlock("header", {
                key: 0,
                class: normalizeClass(["usa-card__header", headerClasses.value])
              }, [
                createVNode(unref(_sfc_main$1z), {
                  tag: __props.headingTag,
                  class: normalizeClass(["usa-card__heading", (_b = __props.customClasses) == null ? void 0 : _b.heading])
                }, {
                  default: withCtx(() => [
                    renderSlot(_ctx.$slots, "heading", {}, () => [
                      createTextVNode(toDisplayString(__props.heading), 1)
                    ])
                  ]),
                  _: 3
                }, 8, ["tag", "class"])
              ], 2)) : createCommentVNode("", true),
              _ctx.$slots.media ? (openBlock(), createElementBlock("div", {
                key: 1,
                class: normalizeClass(["usa-card__media", mediaClasses.value])
              }, [
                createBaseVNode("div", {
                  class: normalizeClass(["usa-card__img", (_c = __props.customClasses) == null ? void 0 : _c.img])
                }, [
                  renderSlot(_ctx.$slots, "media")
                ], 2)
              ], 2)) : createCommentVNode("", true),
              _ctx.$slots.default ? (openBlock(), createElementBlock("div", {
                key: 2,
                class: normalizeClass(["usa-card__body", bodyClasses.value])
              }, [
                renderSlot(_ctx.$slots, "default")
              ], 2)) : createCommentVNode("", true),
              _ctx.$slots.footer ? (openBlock(), createElementBlock("div", {
                key: 3,
                class: normalizeClass(["usa-card__footer", footerClasses.value])
              }, [
                renderSlot(_ctx.$slots, "footer")
              ], 2)) : createCommentVNode("", true)
            ], 2)
          ];
        }),
        _: 3
      }, 8, ["class"]);
    };
  }
};
var _a;
var isClient = typeof window !== "undefined";
var isFunction = (val) => typeof val === "function";
var isString = (val) => typeof val === "string";
var noop = () => {
};
var isIOS = isClient && ((_a = window == null ? void 0 : window.navigator) == null ? void 0 : _a.userAgent) && /iP(ad|hone|od)/.test(window.navigator.userAgent);
function resolveUnref(r) {
  return typeof r === "function" ? r() : unref(r);
}
function createFilterWrapper(filter, fn) {
  function wrapper(...args) {
    return new Promise((resolve, reject) => {
      Promise.resolve(filter(() => fn.apply(this, args), { fn, thisArg: this, args })).then(resolve).catch(reject);
    });
  }
  return wrapper;
}
var bypassFilter = (invoke) => {
  return invoke();
};
function debounceFilter(ms, options = {}) {
  let timer;
  let maxTimer;
  let lastRejector = noop;
  const _clearTimeout = (timer2) => {
    clearTimeout(timer2);
    lastRejector();
    lastRejector = noop;
  };
  const filter = (invoke) => {
    const duration = resolveUnref(ms);
    const maxDuration = resolveUnref(options.maxWait);
    if (timer)
      _clearTimeout(timer);
    if (duration <= 0 || maxDuration !== void 0 && maxDuration <= 0) {
      if (maxTimer) {
        _clearTimeout(maxTimer);
        maxTimer = null;
      }
      return Promise.resolve(invoke());
    }
    return new Promise((resolve, reject) => {
      lastRejector = options.rejectOnCancel ? reject : resolve;
      if (maxDuration && !maxTimer) {
        maxTimer = setTimeout(() => {
          if (timer)
            _clearTimeout(timer);
          maxTimer = null;
          resolve(invoke());
        }, maxDuration);
      }
      timer = setTimeout(() => {
        if (maxTimer)
          _clearTimeout(maxTimer);
        maxTimer = null;
        resolve(invoke());
      }, duration);
    });
  };
  return filter;
}
function identity(arg) {
  return arg;
}
function computedWithControl(source, fn) {
  let v = void 0;
  let track;
  let trigger;
  const dirty = ref(true);
  const update = () => {
    dirty.value = true;
    trigger();
  };
  watch(source, update, { flush: "sync" });
  const get = isFunction(fn) ? fn : fn.get;
  const set = isFunction(fn) ? void 0 : fn.set;
  const result = customRef((_track, _trigger) => {
    track = _track;
    trigger = _trigger;
    return {
      get() {
        if (dirty.value) {
          v = get();
          dirty.value = false;
        }
        track();
        return v;
      },
      set(v2) {
        set == null ? void 0 : set(v2);
      }
    };
  });
  if (Object.isExtensible(result))
    result.trigger = update;
  return result;
}
function tryOnScopeDispose(fn) {
  if (getCurrentScope()) {
    onScopeDispose(fn);
    return true;
  }
  return false;
}
function useDebounceFn(fn, ms = 200, options = {}) {
  return createFilterWrapper(debounceFilter(ms, options), fn);
}
function refDebounced(value, ms = 200, options = {}) {
  const debounced = ref(value.value);
  const updater = useDebounceFn(() => {
    debounced.value = value.value;
  }, ms, options);
  watch(value, () => updater());
  return debounced;
}
function resolveRef(r) {
  return typeof r === "function" ? computed(r) : ref(r);
}
function tryOnMounted(fn, sync = true) {
  if (getCurrentInstance())
    onMounted(fn);
  else if (sync)
    fn();
  else
    nextTick(fn);
}
var __getOwnPropSymbols$6 = Object.getOwnPropertySymbols;
var __hasOwnProp$6 = Object.prototype.hasOwnProperty;
var __propIsEnum$6 = Object.prototype.propertyIsEnumerable;
var __objRest$5 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$6.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$6)
    for (var prop of __getOwnPropSymbols$6(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$6.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function watchWithFilter(source, cb, options = {}) {
  const _a2 = options, {
    eventFilter = bypassFilter
  } = _a2, watchOptions = __objRest$5(_a2, [
    "eventFilter"
  ]);
  return watch(source, createFilterWrapper(eventFilter, cb), watchOptions);
}
var __defProp$4 = Object.defineProperty;
var __defProps$4 = Object.defineProperties;
var __getOwnPropDescs$4 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$4 = Object.getOwnPropertySymbols;
var __hasOwnProp$4 = Object.prototype.hasOwnProperty;
var __propIsEnum$4 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$4 = (obj, key, value) => key in obj ? __defProp$4(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$4 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$4.call(b, prop))
      __defNormalProp$4(a, prop, b[prop]);
  if (__getOwnPropSymbols$4)
    for (var prop of __getOwnPropSymbols$4(b)) {
      if (__propIsEnum$4.call(b, prop))
        __defNormalProp$4(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$4 = (a, b) => __defProps$4(a, __getOwnPropDescs$4(b));
var __objRest$3 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$4.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$4)
    for (var prop of __getOwnPropSymbols$4(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$4.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function watchDebounced(source, cb, options = {}) {
  const _a2 = options, {
    debounce = 0,
    maxWait = void 0
  } = _a2, watchOptions = __objRest$3(_a2, [
    "debounce",
    "maxWait"
  ]);
  return watchWithFilter(source, cb, __spreadProps$4(__spreadValues$4({}, watchOptions), {
    eventFilter: debounceFilter(debounce, { maxWait })
  }));
}
function unrefElement(elRef) {
  var _a2;
  const plain = resolveUnref(elRef);
  return (_a2 = plain == null ? void 0 : plain.$el) != null ? _a2 : plain;
}
var defaultWindow = isClient ? window : void 0;
isClient ? window.document : void 0;
isClient ? window.navigator : void 0;
isClient ? window.location : void 0;
function useEventListener(...args) {
  let target;
  let events;
  let listeners;
  let options;
  if (isString(args[0]) || Array.isArray(args[0])) {
    [events, listeners, options] = args;
    target = defaultWindow;
  } else {
    [target, events, listeners, options] = args;
  }
  if (!target)
    return noop;
  if (!Array.isArray(events))
    events = [events];
  if (!Array.isArray(listeners))
    listeners = [listeners];
  const cleanups = [];
  const cleanup = () => {
    cleanups.forEach((fn) => fn());
    cleanups.length = 0;
  };
  const register = (el, event, listener, options2) => {
    el.addEventListener(event, listener, options2);
    return () => el.removeEventListener(event, listener, options2);
  };
  const stopWatch = watch(() => [unrefElement(target), resolveUnref(options)], ([el, options2]) => {
    cleanup();
    if (!el)
      return;
    cleanups.push(...events.flatMap((event) => {
      return listeners.map((listener) => register(el, event, listener, options2));
    }));
  }, { immediate: true, flush: "post" });
  const stop = () => {
    stopWatch();
    cleanup();
  };
  tryOnScopeDispose(stop);
  return stop;
}
var _iOSWorkaround = false;
function onClickOutside(target, handler, options = {}) {
  const { window: window2 = defaultWindow, ignore = [], capture = true, detectIframe = false } = options;
  if (!window2)
    return;
  if (isIOS && !_iOSWorkaround) {
    _iOSWorkaround = true;
    Array.from(window2.document.body.children).forEach((el) => el.addEventListener("click", noop));
  }
  let shouldListen = true;
  const shouldIgnore = (event) => {
    return ignore.some((target2) => {
      if (typeof target2 === "string") {
        return Array.from(window2.document.querySelectorAll(target2)).some((el) => el === event.target || event.composedPath().includes(el));
      } else {
        const el = unrefElement(target2);
        return el && (event.target === el || event.composedPath().includes(el));
      }
    });
  };
  const listener = (event) => {
    const el = unrefElement(target);
    if (!el || el === event.target || event.composedPath().includes(el))
      return;
    if (event.detail === 0)
      shouldListen = !shouldIgnore(event);
    if (!shouldListen) {
      shouldListen = true;
      return;
    }
    handler(event);
  };
  const cleanup = [
    useEventListener(window2, "click", listener, { passive: true, capture }),
    useEventListener(window2, "pointerdown", (e) => {
      const el = unrefElement(target);
      if (el)
        shouldListen = !e.composedPath().includes(el) && !shouldIgnore(e);
    }, { passive: true }),
    detectIframe && useEventListener(window2, "blur", (event) => {
      var _a2;
      const el = unrefElement(target);
      if (((_a2 = window2.document.activeElement) == null ? void 0 : _a2.tagName) === "IFRAME" && !(el == null ? void 0 : el.contains(window2.document.activeElement)))
        handler(event);
    })
  ].filter(Boolean);
  const stop = () => cleanup.forEach((fn) => fn());
  return stop;
}
var createKeyPredicate = (keyFilter) => {
  if (typeof keyFilter === "function")
    return keyFilter;
  else if (typeof keyFilter === "string")
    return (event) => event.key === keyFilter;
  else if (Array.isArray(keyFilter))
    return (event) => keyFilter.includes(event.key);
  return () => true;
};
function onKeyStroke(...args) {
  let key;
  let handler;
  let options = {};
  if (args.length === 3) {
    key = args[0];
    handler = args[1];
    options = args[2];
  } else if (args.length === 2) {
    if (typeof args[1] === "object") {
      key = true;
      handler = args[0];
      options = args[1];
    } else {
      key = args[0];
      handler = args[1];
    }
  } else {
    key = true;
    handler = args[0];
  }
  const { target = defaultWindow, eventName = "keydown", passive = false } = options;
  const predicate = createKeyPredicate(key);
  const listener = (e) => {
    if (predicate(e))
      handler(e);
  };
  return useEventListener(target, eventName, listener, passive);
}
function useActiveElement(options = {}) {
  var _a2;
  const { window: window2 = defaultWindow } = options;
  const document2 = (_a2 = options.document) != null ? _a2 : window2 == null ? void 0 : window2.document;
  const activeElement = computedWithControl(() => null, () => document2 == null ? void 0 : document2.activeElement);
  if (window2) {
    useEventListener(window2, "blur", (event) => {
      if (event.relatedTarget !== null)
        return;
      activeElement.trigger();
    }, true);
    useEventListener(window2, "focus", activeElement.trigger, true);
  }
  return activeElement;
}
function useSupported(callback, sync = false) {
  const isSupported = ref();
  const update = () => isSupported.value = Boolean(callback());
  update();
  tryOnMounted(update, sync);
  return isSupported;
}
function useMediaQuery(query, options = {}) {
  const { window: window2 = defaultWindow } = options;
  const isSupported = useSupported(() => window2 && "matchMedia" in window2 && typeof window2.matchMedia === "function");
  let mediaQuery;
  const matches2 = ref(false);
  const cleanup = () => {
    if (!mediaQuery)
      return;
    if ("removeEventListener" in mediaQuery)
      mediaQuery.removeEventListener("change", update);
    else
      mediaQuery.removeListener(update);
  };
  const update = () => {
    if (!isSupported.value)
      return;
    cleanup();
    mediaQuery = window2.matchMedia(resolveRef(query).value);
    matches2.value = mediaQuery.matches;
    if ("addEventListener" in mediaQuery)
      mediaQuery.addEventListener("change", update);
    else
      mediaQuery.addListener(update);
  };
  watchEffect(update);
  tryOnScopeDispose(() => cleanup());
  return matches2;
}
var _global = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
var globalKey = "__vueuse_ssr_handlers__";
_global[globalKey] = _global[globalKey] || {};
_global[globalKey];
function useFocus(target, options = {}) {
  const { initialValue = false } = options;
  const innerFocused = ref(false);
  const targetElement = computed(() => unrefElement(target));
  useEventListener(targetElement, "focus", () => innerFocused.value = true);
  useEventListener(targetElement, "blur", () => innerFocused.value = false);
  const focused = computed({
    get: () => innerFocused.value,
    set(value) {
      var _a2, _b;
      if (!value && innerFocused.value)
        (_a2 = targetElement.value) == null ? void 0 : _a2.blur();
      else if (value && !innerFocused.value)
        (_b = targetElement.value) == null ? void 0 : _b.focus();
    }
  });
  watch(targetElement, () => {
    focused.value = initialValue;
  }, { immediate: true, flush: "post" });
  return { focused };
}
var SwipeDirection;
(function(SwipeDirection2) {
  SwipeDirection2["UP"] = "UP";
  SwipeDirection2["RIGHT"] = "RIGHT";
  SwipeDirection2["DOWN"] = "DOWN";
  SwipeDirection2["LEFT"] = "LEFT";
  SwipeDirection2["NONE"] = "NONE";
})(SwipeDirection || (SwipeDirection = {}));
var __defProp$1 = Object.defineProperty;
var __getOwnPropSymbols$1 = Object.getOwnPropertySymbols;
var __hasOwnProp$1 = Object.prototype.hasOwnProperty;
var __propIsEnum$1 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1 = (obj, key, value) => key in obj ? __defProp$1(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1.call(b, prop))
      __defNormalProp$1(a, prop, b[prop]);
  if (__getOwnPropSymbols$1)
    for (var prop of __getOwnPropSymbols$1(b)) {
      if (__propIsEnum$1.call(b, prop))
        __defNormalProp$1(a, prop, b[prop]);
    }
  return a;
};
var _TransitionPresets = {
  easeInSine: [0.12, 0, 0.39, 0],
  easeOutSine: [0.61, 1, 0.88, 1],
  easeInOutSine: [0.37, 0, 0.63, 1],
  easeInQuad: [0.11, 0, 0.5, 0],
  easeOutQuad: [0.5, 1, 0.89, 1],
  easeInOutQuad: [0.45, 0, 0.55, 1],
  easeInCubic: [0.32, 0, 0.67, 0],
  easeOutCubic: [0.33, 1, 0.68, 1],
  easeInOutCubic: [0.65, 0, 0.35, 1],
  easeInQuart: [0.5, 0, 0.75, 0],
  easeOutQuart: [0.25, 1, 0.5, 1],
  easeInOutQuart: [0.76, 0, 0.24, 1],
  easeInQuint: [0.64, 0, 0.78, 0],
  easeOutQuint: [0.22, 1, 0.36, 1],
  easeInOutQuint: [0.83, 0, 0.17, 1],
  easeInExpo: [0.7, 0, 0.84, 0],
  easeOutExpo: [0.16, 1, 0.3, 1],
  easeInOutExpo: [0.87, 0, 0.13, 1],
  easeInCirc: [0.55, 0, 1, 0.45],
  easeOutCirc: [0, 0.55, 0.45, 1],
  easeInOutCirc: [0.85, 0, 0.15, 1],
  easeInBack: [0.36, 0, 0.66, -0.56],
  easeOutBack: [0.34, 1.56, 0.64, 1],
  easeInOutBack: [0.68, -0.6, 0.32, 1.6]
};
__spreadValues$1({
  linear: identity
}, _TransitionPresets);
var _hoisted_1$17 = { class: "usa-character-count" };
var _hoisted_2$y = ["id"];
var _hoisted_3$k = {
  class: "usa-character-count__sr-status usa-sr-only",
  "aria-live": "polite"
};
var _sfc_main$1m = {
  __name: "UsaCharacterCount",
  props: {
    maxlength: {
      type: Number,
      required: true,
      validator(maxLength) {
        const isValidMaxLength = maxLength > 0;
        if (!isValidMaxLength) {
          console.warn(`${maxLength} is not a valid maxlength`);
        }
        return isValidMaxLength;
      }
    },
    id: {
      type: String,
      default: ""
    }
  },
  setup(__props) {
    const props = __props;
    const statusMessageRef = ref("");
    const srOnlyStatusMessage = ref("");
    const charactersRemaining = ref(props.maxlength);
    const charactersOver = computed(() => charactersRemaining.value < 0 ? charactersRemaining.value * -1 : 0);
    const countStatus = computed(() => {
      if (charactersRemaining.value === props.maxlength) {
        return "equal";
      } else if (charactersOver.value > 0) {
        return "over";
      }
      return "under";
    });
    const computedId = computed(() => props.id || nextId("usa-character-count"));
    const messageClasses = computed(() => [
      { "usa-character-count__message--invalid": countStatus.value === "over" }
    ]);
    const updateCharacterCount = (inputValue) => charactersRemaining.value = props.maxlength - `${inputValue}`.length;
    watchDebounced(charactersRemaining, () => {
      var _a2;
      srOnlyStatusMessage.value = (_a2 = statusMessageRef.value) == null ? void 0 : _a2.textContent;
    }, { debounce: 1e3, immediate: true });
    provide("updateCharacterCount", updateCharacterCount);
    provide("characterCountMaxlength", computed(() => props.maxlength));
    provide("characterCountMessageId", computed(() => computedId.value));
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$17, [
        renderSlot(_ctx.$slots, "default"),
        createBaseVNode("span", {
          id: computedId.value,
          class: "usa-character-count__message usa-sr-only"
        }, [
          renderSlot(_ctx.$slots, "default-message", {}, () => [
            createTextVNode("You can enter up to " + toDisplayString(__props.maxlength) + " characters", 1)
          ])
        ], 8, _hoisted_2$y),
        createBaseVNode("div", {
          ref_key: "statusMessageRef",
          ref: statusMessageRef,
          class: normalizeClass(["usa-character-count__status usa-hint", messageClasses.value]),
          "aria-hidden": "true"
        }, [
          countStatus.value === "equal" ? renderSlot(_ctx.$slots, "equal-message", {
            key: 0,
            maxlength: __props.maxlength
          }, () => [
            createTextVNode(toDisplayString(__props.maxlength) + " character", 1),
            __props.maxlength !== 1 ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
              createTextVNode("s")
            ], 64)) : createCommentVNode("", true),
            createTextVNode(" allowed")
          ]) : countStatus.value === "under" ? renderSlot(_ctx.$slots, "remaining-message", {
            key: 1,
            charactersRemaining: charactersRemaining.value,
            maxlength: __props.maxlength
          }, () => [
            createTextVNode(toDisplayString(charactersRemaining.value) + " character", 1),
            charactersRemaining.value !== 1 ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
              createTextVNode("s")
            ], 64)) : createCommentVNode("", true),
            createTextVNode(" left")
          ]) : countStatus.value === "over" ? renderSlot(_ctx.$slots, "over-message", {
            key: 2,
            charactersOver: charactersOver.value,
            maxlength: __props.maxlength
          }, () => [
            createTextVNode(toDisplayString(charactersOver.value) + " character", 1),
            charactersOver.value !== 1 ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
              createTextVNode("s")
            ], 64)) : createCommentVNode("", true),
            createTextVNode(" over limit")
          ]) : createCommentVNode("", true)
        ], 2),
        createBaseVNode("div", _hoisted_3$k, toDisplayString(srOnlyStatusMessage.value), 1)
      ]);
    };
  }
};
var _hoisted_1$16 = ["id"];
var _hoisted_2$x = ["htmlFor"];
var __default__$g = {
  inheritAttrs: false
};
var _sfc_main$1l = Object.assign(__default__$g, {
  __name: "UsaCheckbox",
  props: {
    tile: {
      type: Boolean,
      default: false
    },
    modelValue: {
      type: Boolean,
      default: false
    },
    label: {
      type: String,
      default: ""
    },
    description: {
      type: String,
      default: ""
    },
    id: {
      type: String,
      default: ""
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          component: [],
          label: [],
          description: []
        };
      }
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit }) {
    const props = __props;
    const computedId = computed(() => props.id || nextId("usa-checkbox"));
    const checkboxValue = computed({
      get() {
        return props.modelValue;
      },
      set(checked) {
        emit("update:modelValue", checked);
      }
    });
    const classes = computed(() => [
      {
        "usa-checkbox__input--tile": props.tile
      }
    ]);
    return (_ctx, _cache) => {
      var _a2, _b, _c;
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(["usa-checkbox", (_a2 = __props.customClasses) == null ? void 0 : _a2.component])
      }, [
        withDirectives(createBaseVNode("input", mergeProps(_ctx.$attrs, {
          id: computedId.value,
          "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => checkboxValue.value = $event),
          class: ["usa-checkbox__input", classes.value],
          type: "checkbox"
        }), null, 16, _hoisted_1$16), [
          [vModelCheckbox, checkboxValue.value]
        ]),
        createBaseVNode("label", {
          class: normalizeClass(["usa-checkbox__label", (_b = __props.customClasses) == null ? void 0 : _b.label]),
          htmlFor: computedId.value
        }, [
          renderSlot(_ctx.$slots, "default", {}, () => [
            createTextVNode(toDisplayString(__props.label), 1)
          ]),
          __props.description || _ctx.$slots.description ? (openBlock(), createElementBlock("span", {
            key: 0,
            class: normalizeClass(["usa-checkbox__label-description", (_c = __props.customClasses) == null ? void 0 : _c.description])
          }, [
            renderSlot(_ctx.$slots, "description", {}, () => [
              createTextVNode(toDisplayString(__props.description), 1)
            ])
          ], 2)) : createCommentVNode("", true)
        ], 10, _hoisted_2$x)
      ], 2);
    };
  }
});
var _hoisted_1$15 = ["aria-label"];
var _sfc_main$1k = {
  __name: "UsaChecklistItem",
  props: {
    checked: {
      type: Boolean,
      default: false
    },
    ariaLabel: {
      type: String,
      default: ""
    }
  },
  setup(__props) {
    const props = __props;
    const classes = computed(() => [
      { "usa-checklist__item--checked": props.checked }
    ]);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", {
        class: normalizeClass(["usa-checklist__item", classes.value]),
        "aria-label": __props.ariaLabel,
        tabindex: "0"
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 10, _hoisted_1$15);
    };
  }
};
var _hoisted_1$14 = { class: "usa-checklist" };
var _sfc_main$1j = {
  __name: "UsaChecklist",
  props: {
    items: {
      type: Array,
      default: () => []
    }
  },
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("ul", _hoisted_1$14, [
        renderSlot(_ctx.$slots, "default", {}, () => [
          (openBlock(true), createElementBlock(Fragment, null, renderList(__props.items, (item) => {
            return openBlock(), createBlock(unref(_sfc_main$1k), {
              key: (item == null ? void 0 : item.id) || item.text,
              checked: item.checked,
              "aria-label": item.ariaLabel
            }, {
              default: withCtx(() => [
                createTextVNode(toDisplayString(item.text), 1)
              ]),
              _: 2
            }, 1032, ["checked", "aria-label"]);
          }), 128))
        ])
      ]);
    };
  }
};
var _sfc_main$1i = {
  __name: "UsaCollection",
  props: {
    condensed: {
      type: Boolean,
      default: false
    }
  },
  setup(__props) {
    const props = __props;
    const classes = computed(() => [
      { "usa-collection--condensed": props.condensed }
    ]);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("ul", {
        class: normalizeClass(["usa-collection", classes.value])
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 2);
    };
  }
};
var _hoisted_1$13 = { class: "usa-collection__calendar-date" };
var _sfc_main$1h = {
  __name: "UsaCollectionCalendar",
  props: {
    month: {
      type: String,
      required: true
    },
    day: {
      type: [String, Number],
      required: true
    },
    datetime: {
      type: String,
      default: ""
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          datetime: [],
          month: [],
          day: []
        };
      }
    }
  },
  setup(__props) {
    const props = __props;
    const timeElement = computed(() => props.datetime ? "time" : "div");
    return (_ctx, _cache) => {
      var _a2;
      return openBlock(), createElementBlock("div", _hoisted_1$13, [
        (openBlock(), createBlock(resolveDynamicComponent(timeElement.value), {
          datetime: __props.datetime || null,
          class: normalizeClass((_a2 = __props.customClasses) == null ? void 0 : _a2.datetime)
        }, {
          default: withCtx(() => {
            var _a3, _b;
            return [
              createBaseVNode("span", {
                class: normalizeClass(["usa-collection__calendar-date-month", (_a3 = __props.customClasses) == null ? void 0 : _a3.month])
              }, toDisplayString(__props.month), 3),
              createBaseVNode("span", {
                class: normalizeClass(["usa-collection__calendar-date-day", (_b = __props.customClasses) == null ? void 0 : _b.day])
              }, toDisplayString(__props.day), 3)
            ];
          }),
          _: 1
        }, 8, ["datetime", "class"]))
      ]);
    };
  }
};
var _sfc_main$1g = {
  __name: "UsaCollectionHeading",
  props: {
    href: {
      type: String,
      default: ""
    },
    to: {
      type: [String, Object],
      default: ""
    },
    routerComponentName: {
      type: String,
      default: ""
    },
    headingTag: {
      type: String,
      default: "h2"
    },
    heading: {
      type: String,
      default: ""
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          link: []
        };
      }
    }
  },
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(_sfc_main$1z), {
        tag: __props.headingTag,
        class: "usa-collection__heading"
      }, {
        default: withCtx(() => {
          var _a2;
          return [
            createVNode(unref(BaseLink), {
              href: __props.href,
              to: __props.to,
              "router-component-name": __props.routerComponentName,
              class: normalizeClass(["usa-link", (_a2 = __props.customClasses) == null ? void 0 : _a2.link])
            }, {
              default: withCtx(() => [
                renderSlot(_ctx.$slots, "default", {}, () => [
                  createTextVNode(toDisplayString(__props.heading), 1)
                ])
              ]),
              _: 3
            }, 8, ["href", "to", "router-component-name", "class"])
          ];
        }),
        _: 3
      }, 8, ["tag"]);
    };
  }
};
var _hoisted_1$12 = { class: "usa-collection__item" };
var _hoisted_2$w = { class: "usa-collection__body" };
var _sfc_main$1f = {
  __name: "UsaCollectionItem",
  props: {
    heading: {
      type: String,
      default: ""
    },
    headingTag: {
      type: String,
      default: "h2"
    },
    href: {
      type: String,
      default: ""
    },
    to: {
      type: [String, Object],
      default: ""
    },
    routerComponentName: {
      type: String,
      default: ""
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          media: [],
          heading: [],
          link: [],
          description: []
        };
      }
    }
  },
  setup(__props) {
    return (_ctx, _cache) => {
      var _a2;
      return openBlock(), createElementBlock("li", _hoisted_1$12, [
        _ctx.$slots.media ? (openBlock(), createElementBlock("div", {
          key: 0,
          class: normalizeClass(["usa-collection__img", (_a2 = __props.customClasses) == null ? void 0 : _a2.media])
        }, [
          renderSlot(_ctx.$slots, "media")
        ], 2)) : renderSlot(_ctx.$slots, "calendar", { key: 1 }),
        createBaseVNode("div", _hoisted_2$w, [
          renderSlot(_ctx.$slots, "heading", {}, () => {
            var _a3, _b;
            return [
              createVNode(unref(_sfc_main$1g), {
                heading: __props.heading,
                "heading-tag": __props.headingTag,
                href: __props.href,
                to: __props.to,
                class: normalizeClass((_a3 = __props.customClasses) == null ? void 0 : _a3.heading),
                "router-component-name": __props.routerComponentName,
                "custom-classes": { link: ((_b = __props.customClasses) == null ? void 0 : _b.link) || [] }
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(__props.heading), 1)
                ]),
                _: 1
              }, 8, ["heading", "heading-tag", "href", "to", "class", "router-component-name", "custom-classes"])
            ];
          }),
          renderSlot(_ctx.$slots, "description", {}, () => {
            var _a3;
            return [
              _ctx.$slots.default ? (openBlock(), createElementBlock("p", {
                key: 0,
                class: normalizeClass(["usa-collection__description", (_a3 = __props.customClasses) == null ? void 0 : _a3.description])
              }, [
                renderSlot(_ctx.$slots, "default")
              ], 2)) : createCommentVNode("", true)
            ];
          }),
          renderSlot(_ctx.$slots, "meta")
        ])
      ]);
    };
  }
};
var _hoisted_1$11 = ["aria-label"];
var _sfc_main$1e = {
  __name: "UsaCollectionMeta",
  props: {
    ariaLabel: {
      type: String,
      required: true
    }
  },
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("ul", {
        class: "usa-collection__meta",
        "aria-label": __props.ariaLabel
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 8, _hoisted_1$11);
    };
  }
};
var _sfc_main$1d = {};
var _hoisted_1$10 = { class: "usa-collection__meta-item" };
function _sfc_render$3(_ctx, _cache) {
  return openBlock(), createElementBlock("li", _hoisted_1$10, [
    renderSlot(_ctx.$slots, "default")
  ]);
}
var UsaCollectionMetaItem = _export_sfc(_sfc_main$1d, [["render", _sfc_render$3]]);
var useComboBox = (_id, _selectedOption, _options, _disabled, _readonly, emit) => {
  const id = ref(_id);
  const options = ref(_options);
  const isDisabled = ref(_disabled);
  const isReadonly = ref(_readonly);
  const selectedOption = computed({
    get() {
      return _selectedOption.value;
    },
    set(newSelectedValue) {
      emit("update:modelValue", newSelectedValue);
    }
  });
  const activeElement = useActiveElement();
  const isDirty = ref(false);
  const searchTerm = ref("");
  const highlightedOption = ref("");
  const isOpen = ref(false);
  const selectedLabel = computed(() => {
    if (selectedOption.value === "") {
      return "";
    }
    const foundOption = options.value.find((option) => option.value === selectedOption.value);
    return (foundOption == null ? void 0 : foundOption.label) || "";
  });
  watch(selectedLabel, (currentLabel) => {
    if (currentLabel !== "") {
      searchTerm.value = currentLabel;
    }
  });
  watch(searchTerm, (currentTerm) => {
    if (isOpen.value && currentTerm !== "") {
      isDirty.value = true;
    }
  });
  if (selectedLabel.value) {
    searchTerm.value = selectedLabel.value;
  }
  const filteredOptions = computed(() => {
    if (searchTerm.value === "" || !isDirty.value && searchTerm.value === selectedLabel.value) {
      return options.value;
    }
    return options.value.filter((option) => {
      const regex = new RegExp(escapeRegExp(searchTerm.value), "gi");
      return regex.test(option.label);
    });
  });
  const totalFilteredOptions = computed(() => {
    var _a2;
    return (_a2 = filteredOptions.value) == null ? void 0 : _a2.length;
  });
  const computedId = computed(() => id.value || nextId("usa-combo-box"));
  const computedLabelId = computed(() => `${computedId.value}-label`);
  const computedErrorMessageId = computed(() => `${computedId.value}-error-message`);
  const computedHintId = computed(() => `${computedId.value}-hint`);
  const computedAssistiveHintId = computed(() => `${computedId.value}-assistive-hint`);
  const computedListId = computed(() => `${computedId.value}-list`);
  const getListItemIdByIndex = (index) => `${computedListId.value}-option-${index}`;
  const componentElement = ref(null);
  const inputElement = ref(null);
  const listElement = ref(null);
  const listItemElements = ref([]);
  const getItemRefById = (id2) => {
    return listItemElements.value.find((item) => item.id === id2);
  };
  const getItemRefByValue = (value) => {
    return listItemElements.value.find((item) => item.dataset.value === value);
  };
  const firstOptionValue = computed(() => {
    return totalFilteredOptions.value ? filteredOptions.value[0].value : "";
  });
  const firstOptionRef = computed(() => {
    const firstItemId = totalFilteredOptions.value ? listItemElements.value[0].id : null;
    return firstItemId ? getItemRefById(firstItemId) : null;
  });
  const selectedOptionRef = computed(() => {
    if (selectedOption.value === "") {
      return null;
    }
    const foundItemRef = listItemElements.value.find((itemRef) => itemRef.dataset.value === selectedOption.value);
    return foundItemRef ? foundItemRef : null;
  });
  const highlightedOptionRef = computed(() => {
    if (highlightedOption.value === "") {
      return null;
    }
    const foundItemRef = listItemElements.value.find((itemRef) => {
      return itemRef.dataset.value === highlightedOption.value;
    });
    return foundItemRef ? foundItemRef : null;
  });
  const isFirstOption = computed(() => {
    const optionIndex = filteredOptions.value.findIndex((item) => item.value === highlightedOption.value);
    return optionIndex === 0;
  });
  const isLastOption = computed(() => {
    const optionIndex = filteredOptions.value.findIndex((item) => item.value === highlightedOption.value);
    return optionIndex === totalFilteredOptions.value - 1;
  });
  const activeDescendent = computed(() => {
    const activeOptionId = activeElement.value.id;
    if (activeOptionId === highlightedOptionId.value) {
      return highlightedOptionId.value;
    }
    if (totalFilteredOptions.value && selectedOption.value !== "" && isOpen.value && activeOptionId === computedId.value) {
      return highlightedOptionId.value;
    }
    return null;
  });
  const scrollList = (elementRef) => {
    if (!elementRef || !(listElement == null ? void 0 : listElement.value)) {
      return;
    }
    const optionBottom = elementRef.offsetTop + elementRef.offsetHeight;
    const currentBottom = listElement.value.scrollTop + listElement.value.offsetHeight;
    if (optionBottom > currentBottom) {
      listElement.value.scrollTop = optionBottom - listElement.value.offsetHeight;
    }
    if (elementRef.offsetTop < listElement.value.scrollTop) {
      listElement.value.scrollTop = elementRef.offsetTop;
    }
  };
  const focusInput = () => {
    inputElement.value.focus();
  };
  const selectOption = (optionValue) => {
    selectedOption.value = optionValue;
    const option = options.value.find((option2) => option2.value === optionValue);
    searchTerm.value = (option == null ? void 0 : option.label) || "";
    isDirty.value = false;
  };
  const clearSelectedOption = () => {
    selectOption("");
  };
  const highlightOption = (optionValue) => {
    highlightedOption.value = optionValue;
  };
  const clearHighlightedOption = () => {
    highlightedOption.value = "";
  };
  const openList = () => {
    if (!isDisabled.value && !isReadonly.value) {
      isOpen.value = true;
    }
  };
  const closeList = () => {
    isOpen.value = false;
    isDirty.value = false;
    clearHighlightedOption();
    listElement.value.scrollTop = 0;
  };
  const listItemTabIndex = (optionValue) => {
    return highlightedOption.value === optionValue || selectedOption.value === optionValue ? 0 : -1;
  };
  const highlightedOptionId = computed(() => {
    if (!highlightedOption.value) {
      return null;
    }
    const highlightedOptionIndex = filteredOptions.value.findIndex((option) => option.value === highlightedOption.value);
    return getListItemIdByIndex(highlightedOptionIndex);
  });
  const clearButtonIsVisible = computed(() => selectedOption.value !== "" && searchTerm.value === selectedLabel.value && !isDisabled.value && !isReadonly.value);
  const handleFilterOnInput = () => {
    if (!isOpen.value) {
      openList();
    }
    if (selectedOption.value !== "") {
      highlightOption(selectedOption.value);
    } else {
      highlightOption(firstOptionValue.value);
    }
  };
  const handleEnterOnInput = () => {
    const foundItem = filteredOptions.value.find((item) => item.label === searchTerm.value);
    if (searchTerm.value !== "" && foundItem.value) {
      selectOption(foundItem.value);
    }
    closeList();
  };
  const handleListToggle = () => {
    if (isOpen.value) {
      closeList();
      clearHighlightedOption();
    } else {
      openList();
      if (selectedOption.value !== "") {
        highlightOption(selectedOption.value);
        nextTick(() => {
          scrollList(selectedOptionRef.value);
        });
      } else {
        highlightOption(firstOptionValue.value);
      }
    }
    focusInput();
  };
  const handleClearInput = () => {
    clearSelectedOption();
    clearHighlightedOption();
    focusInput();
  };
  const handleHoverOnListOption = (value) => {
    highlightOption(value);
    if (highlightedOptionRef.value) {
      highlightedOptionRef.value.focus({ preventScroll: true });
    }
  };
  const handleSpaceOnListOption = (value) => {
    selectOption(value);
    closeList();
    focusInput();
  };
  const handleEnterOnListOption = (value) => {
    selectOption(value);
    closeList();
    focusInput();
  };
  const handleDownOnListOption = (index) => {
    if (!isLastOption.value) {
      highlightOption(filteredOptions.value[index + 1].value);
      const itemRef = getItemRefByValue(highlightedOption.value);
      scrollList(itemRef.value);
      if (highlightedOptionRef.value) {
        highlightedOptionRef.value.focus();
      }
    }
  };
  const handleUpOnListOption = (index) => {
    if (isFirstOption.value) {
      closeList();
      clearHighlightedOption();
      focusInput();
    } else {
      highlightOption(filteredOptions.value[index - 1].value);
      const itemRef = getItemRefByValue(highlightedOption.value);
      scrollList(itemRef.value);
      if (highlightedOptionRef.value) {
        highlightedOptionRef.value.focus();
      }
    }
  };
  const handleClickOutside = () => {
    if (isOpen.value) {
      selectOption(selectedOption.value);
      closeList();
      clearHighlightedOption();
    }
  };
  const handleClickOnListOption = (value) => {
    selectOption(value);
    closeList();
    focusInput();
  };
  const handleEscape = () => {
    selectOption(selectedOption.value);
    closeList();
    clearHighlightedOption();
    focusInput();
  };
  const handleDownOnInput = () => {
    if (!isOpen.value) {
      openList();
    }
    if (!totalFilteredOptions.value) {
      return;
    }
    if (selectedOption.value) {
      highlightOption(selectedOption.value);
      nextTick(() => {
        selectedOptionRef.value.focus();
        scrollList(selectedOptionRef.value);
      });
    } else {
      highlightOption(firstOptionValue.value);
      nextTick(() => {
        highlightedOptionRef.value.focus();
        scrollList(highlightedOptionRef.value);
      });
    }
  };
  const handleClickOnInput = () => {
    if (!isOpen.value) {
      openList();
    }
    if (selectedOption.value) {
      highlightOption(selectedOption.value);
      nextTick(() => {
        scrollList(selectedOptionRef.value);
      });
    } else if (highlightedOption.value === "") {
      highlightOption(firstOptionValue.value);
      nextTick(() => {
        scrollList(firstOptionRef.value);
      });
    }
  };
  onClickOutside(componentElement, () => handleClickOutside());
  onKeyStroke("Escape", () => {
    handleEscape();
  });
  return {
    activeDescendent,
    clearButtonIsVisible,
    componentElement,
    computedAssistiveHintId,
    computedErrorMessageId,
    computedHintId,
    computedId,
    computedLabelId,
    computedListId,
    filteredOptions,
    getListItemIdByIndex,
    handleClearInput,
    handleClickOnInput,
    handleClickOnListOption,
    handleDownOnInput,
    handleDownOnListOption,
    handleEnterOnInput,
    handleEnterOnListOption,
    handleFilterOnInput,
    handleHoverOnListOption,
    handleListToggle,
    handleSpaceOnListOption,
    handleUpOnListOption,
    highlightedOption: readonly(highlightedOption),
    inputElement,
    isDisabled: readonly(isDisabled),
    isOpen: readonly(isOpen),
    isReadonly: readonly(isReadonly),
    listElement,
    listItemElements,
    listItemTabIndex,
    searchTerm,
    selectedOption,
    totalFilteredOptions
  };
};
var __default__$f = {
  inheritAttrs: false
};
var _sfc_main$1c = Object.assign(__default__$f, {
  __name: "UsaFormGroup",
  props: {
    group: {
      type: Boolean,
      default: false
    },
    error: {
      type: Boolean,
      default: false
    }
  },
  setup(__props) {
    const props = __props;
    const classes = computed(() => [{ "usa-form-group--error": props.error }]);
    return (_ctx, _cache) => {
      return __props.group ? (openBlock(), createElementBlock("div", mergeProps({ key: 0 }, _ctx.$attrs, {
        class: ["usa-form-group", classes.value]
      }), [
        renderSlot(_ctx.$slots, "default")
      ], 16)) : renderSlot(_ctx.$slots, "default", { key: 1 });
    };
  }
});
var _hoisted_1$$ = ["htmlFor"];
var _hoisted_2$v = createBaseVNode("abbr", {
  title: "required",
  class: "usa-hint usa-hint--required"
}, "*", -1);
var _sfc_main$1b = {
  __name: "UsaLabel",
  props: {
    for: {
      type: String,
      required: true
    },
    required: {
      type: Boolean,
      default: false
    },
    error: {
      type: Boolean,
      default: false
    }
  },
  setup(__props) {
    const props = __props;
    const classes = computed(() => [{ "usa-label--error": props.error }]);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("label", {
        htmlFor: props.for,
        class: normalizeClass(["usa-label", classes.value])
      }, [
        renderSlot(_ctx.$slots, "default"),
        __props.required ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
          createTextVNode(" "),
          renderSlot(_ctx.$slots, "required", {}, () => [
            _hoisted_2$v
          ])
        ], 64)) : createCommentVNode("", true)
      ], 10, _hoisted_1$$);
    };
  }
};
var _hoisted_1$_ = ["id"];
var _hoisted_2$u = ["id"];
var _hoisted_3$j = ["id", "required", "disabled", "readonly", "aria-owns", "aria-controls", "aria-describedby", "aria-expanded", "aria-activedescendant"];
var _hoisted_4$d = {
  class: "usa-combo-box__clear-input__wrapper",
  tabindex: "-1"
};
var _hoisted_5$9 = ["aria-label", "disabled"];
var _hoisted_6$7 = createBaseVNode("span", { class: "usa-combo-box__input-button-separator" }, " ", -1);
var _hoisted_7$4 = {
  class: "usa-combo-box__toggle-list__wrapper",
  tabindex: "-1"
};
var _hoisted_8$2 = ["aria-label", "disabled"];
var _hoisted_9$2 = ["id", "aria-labelledby", "hidden"];
var _hoisted_10$2 = ["id", "aria-setsize", "aria-posinset", "aria-selected", "tabindex", "data-value", "onClick", "onKeydown", "onMouseover"];
var _hoisted_11$2 = {
  key: 1,
  class: "usa-combo-box__list-option--no-results"
};
var _hoisted_12$2 = {
  class: "usa-combo-box__status usa-sr-only",
  role: "status"
};
var _hoisted_13$2 = ["id"];
var __default__$e = {
  inheritAttrs: false
};
var _sfc_main$1a = Object.assign(__default__$e, {
  __name: "UsaComboBox",
  props: {
    options: {
      type: Array,
      default: () => []
    },
    modelValue: {
      type: [String, Number],
      default: ""
    },
    label: {
      type: String,
      default: ""
    },
    required: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    readonly: {
      type: Boolean,
      default: false
    },
    error: {
      type: Boolean,
      default: false
    },
    id: {
      type: String,
      default: ""
    },
    clearButtonAriaLabel: {
      type: String,
      default: "Clear the select contents"
    },
    toggleButtonAriaLabel: {
      type: String,
      default: "Toggle the dropdown list"
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          formGroup: [],
          component: [],
          label: [],
          input: [],
          list: []
        };
      }
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit }) {
    const props = __props;
    const slots = useSlots();
    const {
      activeDescendent,
      clearButtonIsVisible,
      componentElement,
      computedAssistiveHintId,
      computedErrorMessageId,
      computedHintId,
      computedId,
      computedLabelId,
      computedListId,
      filteredOptions,
      getListItemIdByIndex,
      handleClearInput,
      handleClickOnInput,
      handleClickOnListOption,
      handleDownOnInput,
      handleDownOnListOption,
      handleEnterOnInput,
      handleEnterOnListOption,
      handleFilterOnInput,
      handleHoverOnListOption,
      handleListToggle,
      handleSpaceOnListOption,
      handleUpOnListOption,
      highlightedOption,
      inputElement,
      isOpen,
      isDisabled,
      isReadonly,
      listElement,
      listItemElements,
      listItemTabIndex,
      searchTerm,
      selectedOption,
      totalFilteredOptions
    } = useComboBox(toRef(props, "id"), toRef(props, "modelValue"), toRef(props, "options"), toRef(props, "disabled"), toRef(props, "readonly"), emit);
    const ariaDescribedby = computed(() => {
      const ids = [computedAssistiveHintId.value];
      if (slots.hint) {
        ids.push(computedHintId.value);
      }
      if (props.error && slots["error-message"]) {
        ids.push(computedErrorMessageId.value);
      }
      return ids.join(" ");
    });
    const classes = computed(() => {
      var _a2;
      return [
        { "usa-combo-box--pristine": selectedOption.value !== "" },
        ...((_a2 = props.customClasses) == null ? void 0 : _a2.component) || []
      ];
    });
    return (_ctx, _cache) => {
      var _a2;
      return openBlock(), createBlock(unref(_sfc_main$1c), {
        group: !!_ctx.$slots.hint || __props.error && !!_ctx.$slots["error-message"],
        error: __props.error,
        class: normalizeClass((_a2 = props.customClasses) == null ? void 0 : _a2.formGroup)
      }, {
        default: withCtx(() => {
          var _a3, _b, _c;
          return [
            __props.label || _ctx.$slots.label ? (openBlock(), createBlock(unref(_sfc_main$1b), {
              key: 0,
              id: unref(computedLabelId),
              for: unref(computedId),
              required: __props.required,
              error: __props.error,
              class: normalizeClass((_a3 = __props.customClasses) == null ? void 0 : _a3.label)
            }, {
              default: withCtx(() => [
                renderSlot(_ctx.$slots, "label", {}, () => [
                  createTextVNode(toDisplayString(__props.label), 1)
                ])
              ]),
              _: 3
            }, 8, ["id", "for", "required", "error", "class"])) : createCommentVNode("", true),
            _ctx.$slots.hint ? (openBlock(), createElementBlock("span", {
              key: 1,
              id: unref(computedHintId),
              class: "usa-hint"
            }, [
              renderSlot(_ctx.$slots, "hint")
            ], 8, _hoisted_1$_)) : createCommentVNode("", true),
            __props.error && _ctx.$slots["error-message"] ? (openBlock(), createElementBlock("span", {
              key: 2,
              id: unref(computedErrorMessageId),
              class: "usa-error-message"
            }, [
              renderSlot(_ctx.$slots, "error-message")
            ], 8, _hoisted_2$u)) : createCommentVNode("", true),
            createBaseVNode("div", {
              ref_key: "componentElement",
              ref: componentElement,
              class: normalizeClass(["usa-combo-box", classes.value]),
              "data-enhanced": "true"
            }, [
              withDirectives(createBaseVNode("input", mergeProps(_ctx.$attrs, {
                id: unref(computedId),
                ref_key: "inputElement",
                ref: inputElement,
                "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => isRef(searchTerm) ? searchTerm.value = $event : null),
                required: __props.required,
                disabled: unref(isDisabled),
                readonly: unref(isReadonly),
                "aria-owns": unref(computedListId),
                "aria-controls": unref(computedListId),
                "aria-describedby": ariaDescribedby.value,
                "aria-expanded": unref(isOpen),
                "aria-activedescendant": unref(activeDescendent),
                "aria-autocomplete": "list",
                autocapitalize: "off",
                autocomplete: "off",
                class: ["usa-combo-box__input", (_b = props.customClasses) == null ? void 0 : _b.input],
                type: "text",
                role: "combobox",
                onClick: _cache[1] || (_cache[1] = (...args) => unref(handleClickOnInput) && unref(handleClickOnInput)(...args)),
                onInput: _cache[2] || (_cache[2] = (...args) => unref(handleFilterOnInput) && unref(handleFilterOnInput)(...args)),
                onKeydown: [
                  _cache[3] || (_cache[3] = withKeys(withModifiers((...args) => unref(handleEnterOnInput) && unref(handleEnterOnInput)(...args), ["prevent"]), ["enter"])),
                  _cache[4] || (_cache[4] = withKeys(withModifiers((...args) => unref(handleDownOnInput) && unref(handleDownOnInput)(...args), ["prevent"]), ["down"]))
                ]
              }), null, 16, _hoisted_3$j), [
                [vModelText, unref(searchTerm)]
              ]),
              createBaseVNode("span", _hoisted_4$d, [
                withDirectives(createBaseVNode("button", {
                  type: "button",
                  class: "usa-combo-box__clear-input",
                  "aria-label": __props.clearButtonAriaLabel,
                  disabled: unref(isDisabled) || unref(isReadonly),
                  onClick: _cache[5] || (_cache[5] = (...args) => unref(handleClearInput) && unref(handleClearInput)(...args))
                }, " ", 8, _hoisted_5$9), [
                  [vShow, unref(clearButtonIsVisible)]
                ])
              ]),
              _hoisted_6$7,
              createBaseVNode("span", _hoisted_7$4, [
                createBaseVNode("button", {
                  type: "button",
                  tabindex: "-1",
                  class: "usa-combo-box__toggle-list",
                  "aria-label": __props.toggleButtonAriaLabel,
                  disabled: unref(isDisabled) || unref(isReadonly),
                  onClick: _cache[6] || (_cache[6] = (...args) => unref(handleListToggle) && unref(handleListToggle)(...args))
                }, " ", 8, _hoisted_8$2)
              ]),
              createBaseVNode("ul", {
                id: unref(computedListId),
                ref_key: "listElement",
                ref: listElement,
                tabindex: "-1",
                class: normalizeClass(["usa-combo-box__list", (_c = props.customClasses) == null ? void 0 : _c.list]),
                role: "listbox",
                "aria-labelledby": unref(computedLabelId),
                hidden: !unref(isOpen)
              }, [
                unref(filteredOptions).length ? (openBlock(true), createElementBlock(Fragment, { key: 0 }, renderList(unref(filteredOptions), (option, index) => {
                  return openBlock(), createElementBlock("li", {
                    id: unref(getListItemIdByIndex)(index),
                    ref_for: true,
                    ref_key: "listItemElements",
                    ref: listItemElements,
                    key: option.value,
                    "aria-setsize": unref(totalFilteredOptions),
                    "aria-posinset": index + 1,
                    "aria-selected": unref(selectedOption) === option.value,
                    class: normalizeClass(["usa-combo-box__list-option", [
                      {
                        "usa-combo-box__list-option--selected": unref(selectedOption) === option.value,
                        "usa-combo-box__list-option--focused": unref(highlightedOption) === option.value
                      }
                    ]]),
                    tabindex: unref(listItemTabIndex)(option.value),
                    role: "option",
                    "data-value": option.value,
                    onClick: ($event) => unref(handleClickOnListOption)(option.value),
                    onKeydown: [
                      withKeys(withModifiers(($event) => unref(handleUpOnListOption)(index), ["prevent"]), ["up"]),
                      withKeys(withModifiers(($event) => unref(handleDownOnListOption)(index), ["prevent"]), ["down"]),
                      withKeys(withModifiers(($event) => unref(handleEnterOnListOption)(option.value), ["prevent"]), ["enter"]),
                      withKeys(withModifiers(($event) => unref(handleSpaceOnListOption)(option.value), ["prevent"]), ["space"])
                    ],
                    onMouseover: ($event) => unref(handleHoverOnListOption)(option.value)
                  }, toDisplayString(option.label), 43, _hoisted_10$2);
                }), 128)) : (openBlock(), createElementBlock("li", _hoisted_11$2, [
                  renderSlot(_ctx.$slots, "no-results", {}, () => [
                    createTextVNode("No results found")
                  ])
                ]))
              ], 10, _hoisted_9$2),
              createBaseVNode("div", _hoisted_12$2, [
                unref(isOpen) ? renderSlot(_ctx.$slots, "status", {
                  key: 0,
                  filteredOptions: unref(filteredOptions)
                }, () => [
                  unref(filteredOptions).length ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                    createTextVNode(toDisplayString(unref(filteredOptions).length) + " " + toDisplayString(unref(filteredOptions).length > 1 ? "results" : "result") + " available.", 1)
                  ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                    createTextVNode("No results.")
                  ], 64))
                ]) : createCommentVNode("", true)
              ]),
              createBaseVNode("span", {
                id: unref(computedAssistiveHintId),
                class: "usa-sr-only"
              }, [
                renderSlot(_ctx.$slots, "assistive-hint", {}, () => [
                  createTextVNode("When autocomplete results are available use up and down arrows to review and enter to select. Touch device users, explore by touch or with swipe gestures.")
                ])
              ], 8, _hoisted_13$2)
            ], 2)
          ];
        }),
        _: 3
      }, 8, ["group", "error", "class"]);
    };
  }
});
var _hoisted_1$Z = ["id"];
var _hoisted_2$t = ["id"];
var _hoisted_3$i = ["id", "type", "required", "maxlength", "aria-describedby"];
var _hoisted_4$c = ["id", "type", "required", "maxlength", "aria-describedby"];
var __default__$d = {
  inheritAttrs: false
};
var _sfc_main$19 = Object.assign(__default__$d, {
  __name: "UsaTextInput",
  props: {
    type: {
      type: String,
      default: "text"
    },
    width: {
      type: String,
      default: "",
      validator(width) {
        const isValidWidth = [
          "",
          "2xs",
          "xs",
          "sm",
          "small",
          "md",
          "medium",
          "lg",
          "xl",
          "2xl"
        ].includes(width);
        if (!isValidWidth) {
          console.warn(`'${width}' is not a valid text input width`);
        }
        return isValidWidth;
      }
    },
    modelValue: {
      type: [String, Number],
      default: ""
    },
    group: {
      type: Boolean,
      default: false
    },
    label: {
      type: String,
      default: ""
    },
    required: {
      type: Boolean,
      default: false
    },
    error: {
      type: Boolean,
      default: false
    },
    id: {
      type: String,
      default: ""
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          component: [],
          label: [],
          inputGroup: [],
          inputPrefix: [],
          inputSuffix: []
        };
      }
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit }) {
    const props = __props;
    const inputElement = ref(null);
    const { focused } = useFocus(inputElement);
    const slots = useSlots();
    const attrs = useAttrs();
    const updateCharacterCount = inject("updateCharacterCount", null);
    const characterCountMaxlength = inject("characterCountMaxlength", null);
    const characterCountMessageId = inject("characterCountMessageId", null);
    const registerInput = inject("registerInput", null);
    const unregisterInput = inject("unregisterInput", null);
    const computedId = computed(() => props.id || nextId("usa-text-input"));
    const computedErrorMessageId = computed(() => `${computedId.value}-error-message`);
    const computedHintId = computed(() => `${computedId.value}-hint`);
    const textInputValue = computed({
      get() {
        return props.modelValue;
      },
      set(value) {
        emit("update:modelValue", value);
        if (updateCharacterCount) {
          updateCharacterCount(value);
        }
      }
    });
    onMounted(() => {
      if (updateCharacterCount) {
        updateCharacterCount(props.modelValue);
      }
      if (registerInput) {
        registerInput(computedId.value);
      }
    });
    onBeforeUnmount(() => {
      if (unregisterInput) {
        unregisterInput(computedId.value);
      }
    });
    const classes = computed(() => {
      if (slots["input-prefix"] || slots["input-suffix"]) {
        return [];
      }
      return [
        {
          "usa-input--error": props.error,
          "usa-input--2xs": props.width === "2xs",
          "usa-input--xs": props.width === "xs",
          "usa-input--sm": props.width === "sm",
          "usa-input--small": props.width === "small",
          "usa-input--md": props.width === "md",
          "usa-input--medium": props.width === "medium",
          "usa-input--lg": props.width === "lg",
          "usa-input--xl": props.width === "xl",
          "usa-input--2xl": props.width === "2xl",
          "usa-character-count__field": updateCharacterCount
        }
      ];
    });
    const inputGroupClasses = computed(() => {
      var _a2;
      if (!slots["input-prefix"] && !slots["input-suffix"]) {
        return [];
      }
      return [
        {
          "usa-input-group--error": props.error,
          "usa-input-group--2xs": props.width === "2xs",
          "usa-input-group--xs": props.width === "xs",
          "usa-input-group--sm": props.width === "sm",
          "usa-input-group--small": props.width === "small",
          "usa-input-group--md": props.width === "md",
          "usa-input-group--medium": props.width === "medium",
          "usa-input-group--lg": props.width === "lg",
          "usa-input-group--xl": props.width === "xl",
          "usa-input-group--2xl": props.width === "2xl",
          "is-focused": focused.value === true
        },
        ...((_a2 = props.customClasses) == null ? void 0 : _a2.inputGroup) || []
      ];
    });
    const ariaDescribedby = computed(() => {
      const ids = [];
      if (attrs["aria-describedby"]) {
        ids.push(attrs["aria-describedby"]);
      }
      if (characterCountMessageId) {
        ids.push(characterCountMessageId.value);
      }
      if (slots.hint) {
        ids.push(computedHintId.value);
      }
      if (props.error && slots["error-message"]) {
        ids.push(computedErrorMessageId.value);
      }
      return ids.length ? ids.join(" ") : null;
    });
    const groupElements = computed(() => props.group || !!slots.hint || props.error && !!slots["error-message"]);
    return (_ctx, _cache) => {
      var _a2;
      return openBlock(), createBlock(unref(_sfc_main$1c), {
        group: groupElements.value,
        error: __props.error,
        class: normalizeClass((_a2 = __props.customClasses) == null ? void 0 : _a2.component)
      }, {
        default: withCtx(() => {
          var _a3, _b, _c;
          return [
            __props.label || _ctx.$slots.label ? (openBlock(), createBlock(unref(_sfc_main$1b), {
              key: 0,
              for: computedId.value,
              required: __props.required,
              error: __props.error,
              class: normalizeClass((_a3 = __props.customClasses) == null ? void 0 : _a3.label)
            }, {
              default: withCtx(() => [
                renderSlot(_ctx.$slots, "label", {}, () => [
                  createTextVNode(toDisplayString(__props.label), 1)
                ])
              ]),
              _: 3
            }, 8, ["for", "required", "error", "class"])) : createCommentVNode("", true),
            _ctx.$slots.hint ? (openBlock(), createElementBlock("span", {
              key: 1,
              id: computedHintId.value,
              class: "usa-hint"
            }, [
              renderSlot(_ctx.$slots, "hint")
            ], 8, _hoisted_1$Z)) : createCommentVNode("", true),
            __props.error && _ctx.$slots["error-message"] ? (openBlock(), createElementBlock("span", {
              key: 2,
              id: computedErrorMessageId.value,
              class: "usa-error-message"
            }, [
              renderSlot(_ctx.$slots, "error-message")
            ], 8, _hoisted_2$t)) : createCommentVNode("", true),
            _ctx.$slots["input-prefix"] || _ctx.$slots["input-suffix"] ? (openBlock(), createElementBlock("div", {
              key: 3,
              class: normalizeClass(["usa-input-group", inputGroupClasses.value])
            }, [
              _ctx.$slots["input-prefix"] ? (openBlock(), createElementBlock("div", {
                key: 0,
                class: normalizeClass(["usa-input-prefix", (_b = __props.customClasses) == null ? void 0 : _b.inputPrefix]),
                "aria-hidden": "true",
                onClick: _cache[0] || (_cache[0] = ($event) => inputElement.value.focus())
              }, [
                renderSlot(_ctx.$slots, "input-prefix")
              ], 2)) : createCommentVNode("", true),
              withDirectives(createBaseVNode("input", mergeProps(_ctx.$attrs, {
                id: computedId.value,
                ref_key: "inputElement",
                ref: inputElement,
                "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => textInputValue.value = $event),
                type: __props.type,
                class: ["usa-input", classes.value],
                required: __props.required,
                maxlength: unref(characterCountMaxlength) || _ctx.$attrs.maxlength,
                "aria-describedby": ariaDescribedby.value
              }), null, 16, _hoisted_3$i), [
                [vModelDynamic, textInputValue.value]
              ]),
              _ctx.$slots["input-suffix"] ? (openBlock(), createElementBlock("div", {
                key: 1,
                class: normalizeClass(["usa-input-suffix", (_c = __props.customClasses) == null ? void 0 : _c.inputSuffix]),
                "aria-hidden": "true",
                onClick: _cache[2] || (_cache[2] = ($event) => inputElement.value.focus())
              }, [
                renderSlot(_ctx.$slots, "input-suffix")
              ], 2)) : createCommentVNode("", true)
            ], 2)) : withDirectives((openBlock(), createElementBlock("input", mergeProps({ key: 4 }, _ctx.$attrs, {
              id: computedId.value,
              ref_key: "inputElement",
              ref: inputElement,
              "onUpdate:modelValue": _cache[3] || (_cache[3] = ($event) => textInputValue.value = $event),
              type: __props.type,
              class: ["usa-input", classes.value],
              required: __props.required,
              maxlength: unref(characterCountMaxlength) || _ctx.$attrs.maxlength,
              "aria-describedby": ariaDescribedby.value
            }), null, 16, _hoisted_4$c)), [
              [vModelDynamic, textInputValue.value]
            ])
          ];
        }),
        _: 3
      }, 8, ["group", "error", "class"]);
    };
  }
});
var _hoisted_1$Y = ["id"];
var _hoisted_2$s = ["id"];
var _hoisted_3$h = ["id", "required", "aria-describedby"];
var _hoisted_4$b = {
  key: 0,
  value: ""
};
var _hoisted_5$8 = ["value", "disabled"];
var _hoisted_6$6 = ["label", "disabled"];
var _hoisted_7$3 = ["value", "disabled"];
var __default__$c = {
  inheritAttrs: false
};
var _sfc_main$18 = Object.assign(__default__$c, {
  __name: "UsaSelect",
  props: {
    options: {
      type: Array,
      default: () => []
    },
    emptyLabel: {
      type: String,
      default: "- Select -"
    },
    modelValue: {
      type: [String, Number],
      default: ""
    },
    group: {
      type: Boolean,
      default: false
    },
    label: {
      type: String,
      default: ""
    },
    required: {
      type: Boolean,
      default: false
    },
    error: {
      type: Boolean,
      default: false
    },
    id: {
      type: String,
      default: ""
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          component: [],
          label: []
        };
      }
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit }) {
    const props = __props;
    const slots = useSlots();
    const attrs = useAttrs();
    const computedId = computed(() => props.id || nextId("usa-dropdown"));
    const computedErrorMessageId = computed(() => `${computedId.value}-error-message`);
    const computedHintId = computed(() => `${computedId.value}-hint`);
    const selectedValue = computed({
      get() {
        return props.modelValue;
      },
      set(value) {
        emit("update:modelValue", value);
      }
    });
    const classes = computed(() => [{ "usa-input--error": props.error }]);
    const ariaDescribedby = computed(() => {
      const ids = [];
      if (attrs["aria-describedby"]) {
        ids.push(attrs["aria-describedby"]);
      }
      if (slots.hint) {
        ids.push(computedHintId.value);
      }
      if (props.error && slots["error-message"]) {
        ids.push(computedErrorMessageId.value);
      }
      return ids.length ? ids.join(" ") : null;
    });
    const groupElements = computed(() => props.group || !!slots.hint || props.error && !!slots["error-message"]);
    return (_ctx, _cache) => {
      var _a2;
      return openBlock(), createBlock(unref(_sfc_main$1c), {
        group: groupElements.value,
        error: __props.error,
        class: normalizeClass((_a2 = props.customClasses) == null ? void 0 : _a2.component)
      }, {
        default: withCtx(() => {
          var _a3;
          return [
            __props.label || _ctx.$slots.label ? (openBlock(), createBlock(unref(_sfc_main$1b), {
              key: 0,
              for: computedId.value,
              required: __props.required,
              error: __props.error,
              class: normalizeClass((_a3 = __props.customClasses) == null ? void 0 : _a3.label)
            }, {
              default: withCtx(() => [
                renderSlot(_ctx.$slots, "label", {}, () => [
                  createTextVNode(toDisplayString(__props.label), 1)
                ])
              ]),
              _: 3
            }, 8, ["for", "required", "error", "class"])) : createCommentVNode("", true),
            _ctx.$slots.hint ? (openBlock(), createElementBlock("span", {
              key: 1,
              id: computedHintId.value,
              class: "usa-hint"
            }, [
              renderSlot(_ctx.$slots, "hint")
            ], 8, _hoisted_1$Y)) : createCommentVNode("", true),
            __props.error && _ctx.$slots["error-message"] ? (openBlock(), createElementBlock("span", {
              key: 2,
              id: computedErrorMessageId.value,
              class: "usa-error-message"
            }, [
              renderSlot(_ctx.$slots, "error-message")
            ], 8, _hoisted_2$s)) : createCommentVNode("", true),
            withDirectives(createBaseVNode("select", mergeProps(_ctx.$attrs, {
              id: computedId.value,
              "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => selectedValue.value = $event),
              class: ["usa-select", classes.value],
              required: __props.required,
              "aria-describedby": ariaDescribedby.value
            }), [
              __props.options.length ? (openBlock(), createElementBlock("option", _hoisted_4$b, toDisplayString(__props.emptyLabel), 1)) : createCommentVNode("", true),
              renderSlot(_ctx.$slots, "default", { options: __props.options }, () => [
                (openBlock(true), createElementBlock(Fragment, null, renderList(__props.options, (option) => {
                  return openBlock(), createElementBlock(Fragment, {
                    key: option.value || option.group
                  }, [
                    !option.group ? (openBlock(), createElementBlock("option", {
                      key: 0,
                      value: option.value,
                      disabled: option.disabled
                    }, toDisplayString(option.text || option.value), 9, _hoisted_5$8)) : option.group && option.options.length ? (openBlock(), createElementBlock("optgroup", {
                      key: 1,
                      label: option.group,
                      disabled: option.disabled
                    }, [
                      (openBlock(true), createElementBlock(Fragment, null, renderList(option.options, (groupedOption) => {
                        return openBlock(), createElementBlock("option", {
                          key: groupedOption.value,
                          value: groupedOption.value,
                          disabled: groupedOption.disabled
                        }, toDisplayString(groupedOption.text || groupedOption.value), 9, _hoisted_7$3);
                      }), 128))
                    ], 8, _hoisted_6$6)) : createCommentVNode("", true)
                  ], 64);
                }), 128))
              ])
            ], 16, _hoisted_3$h), [
              [vModelSelect, selectedValue.value]
            ])
          ];
        }),
        _: 3
      }, 8, ["group", "error", "class"]);
    };
  }
});
var _hoisted_1$X = { class: "usa-fieldset" };
var _hoisted_2$r = {
  key: 0,
  class: "usa-legend"
};
var _hoisted_3$g = ["id"];
var _hoisted_4$a = ["id"];
var _hoisted_5$7 = { class: "usa-memorable-date" };
var _sfc_main$17 = {
  __name: "UsaDateInput",
  props: {
    label: {
      type: String,
      default: ""
    },
    day: {
      type: [String, Number],
      default: ""
    },
    month: {
      type: [String, Number],
      default: ""
    },
    year: {
      type: [String, Number],
      default: ""
    },
    dateOrder: {
      type: Array,
      default: () => ["month", "day", "year"]
    },
    dateLabels: {
      type: Object,
      default: () => ({ month: "Month", day: "Day", year: "Year" })
    },
    monthAsSelect: {
      type: Boolean,
      default: false
    },
    monthEmptyLabel: {
      type: String,
      default: void 0
    },
    monthOptions: {
      type: Array,
      default: () => [
        {
          value: 1,
          text: "01 - January"
        },
        {
          value: 2,
          text: "02 - February"
        },
        {
          value: 3,
          text: "03 - March"
        },
        {
          value: 4,
          text: "04 - April"
        },
        {
          value: 5,
          text: "05 - May"
        },
        {
          value: 6,
          text: "06 - June"
        },
        {
          value: 7,
          text: "07 - July"
        },
        {
          value: 8,
          text: "08 - August"
        },
        {
          value: 9,
          text: "09 - September"
        },
        {
          value: 10,
          text: "10 - October"
        },
        {
          value: 11,
          text: "11 - November"
        },
        {
          value: 12,
          text: "12 - December"
        }
      ]
    },
    name: {
      type: String,
      default: "date"
    },
    required: {
      type: Boolean,
      default: false
    },
    error: {
      type: Boolean,
      default: false
    },
    id: {
      type: String,
      default: ""
    }
  },
  emits: ["update:month", "update:day", "update:year"],
  setup(__props, { emit }) {
    const props = __props;
    const slots = useSlots();
    if (!props.monthAsSelect) {
      console.warn(`The 'monthAsSelect' prop is deprecated. Starting with vue-uswds 2.0 the month will always use a select form element. You can set the 'monthAsSelect' prop value to true to minimize changes.`);
    }
    const computedId = computed(() => props.id || nextId("usa-date-input"));
    const computedErrorMessageId = computed(() => `${computedId.value}-error-message`);
    const computedHintId = computed(() => `${computedId.value}-hint`);
    const monthValue = computed({
      get: () => props.month,
      set: (month) => emit("update:month", month)
    });
    const dayValue = computed({
      get: () => props.day,
      set: (day) => emit("update:day", day)
    });
    const yearValue = computed({
      get: () => props.year,
      set: (year) => emit("update:year", year)
    });
    const ariaDescribedby = computed(() => {
      const ids = [];
      if (slots.hint) {
        ids.push(computedHintId.value);
      }
      if (props.error && slots["error-message"]) {
        ids.push(computedErrorMessageId.value);
      }
      return ids.length ? ids.join(" ") : null;
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("fieldset", _hoisted_1$X, [
        __props.label || _ctx.$slots.label ? (openBlock(), createElementBlock("legend", _hoisted_2$r, [
          renderSlot(_ctx.$slots, "label", {}, () => [
            createTextVNode(toDisplayString(__props.label), 1)
          ])
        ])) : createCommentVNode("", true),
        _ctx.$slots.hint ? (openBlock(), createElementBlock("span", {
          key: 1,
          id: computedHintId.value,
          class: "usa-hint"
        }, [
          renderSlot(_ctx.$slots, "hint")
        ], 8, _hoisted_3$g)) : createCommentVNode("", true),
        __props.error && _ctx.$slots["error-message"] ? (openBlock(), createElementBlock("span", {
          key: 2,
          id: computedErrorMessageId.value,
          class: "usa-error-message"
        }, [
          renderSlot(_ctx.$slots, "error-message")
        ], 8, _hoisted_4$a)) : createCommentVNode("", true),
        createBaseVNode("div", _hoisted_5$7, [
          (openBlock(true), createElementBlock(Fragment, null, renderList(__props.dateOrder, (date) => {
            return openBlock(), createElementBlock(Fragment, { key: date }, [
              date === "month" ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                __props.monthAsSelect ? (openBlock(), createBlock(unref(_sfc_main$18), {
                  key: 0,
                  id: `${computedId.value}-${__props.name}-month`,
                  modelValue: monthValue.value,
                  "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => monthValue.value = $event),
                  options: __props.monthOptions,
                  "empty-label": __props.monthEmptyLabel,
                  label: __props.dateLabels[date],
                  group: true,
                  name: `${__props.name}_month`,
                  required: __props.required,
                  "aria-describedby": ariaDescribedby.value,
                  "custom-classes": { component: ["usa-form-group--month"] }
                }, null, 8, ["id", "modelValue", "options", "empty-label", "label", "name", "required", "aria-describedby"])) : (openBlock(), createBlock(unref(_sfc_main$19), {
                  key: 1,
                  id: `${computedId.value}-${__props.name}-month`,
                  modelValue: monthValue.value,
                  "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => monthValue.value = $event),
                  label: __props.dateLabels[date],
                  group: true,
                  name: `${__props.name}_month`,
                  maxlength: 2,
                  required: __props.required,
                  pattern: "[0-9]*",
                  inputmode: "numeric",
                  "aria-describedby": ariaDescribedby.value,
                  "custom-classes": { component: ["usa-form-group--month"] }
                }, null, 8, ["id", "modelValue", "label", "name", "required", "aria-describedby"]))
              ], 64)) : date === "day" ? (openBlock(), createBlock(unref(_sfc_main$19), {
                key: 1,
                id: `${computedId.value}-${__props.name}-day`,
                modelValue: dayValue.value,
                "onUpdate:modelValue": _cache[2] || (_cache[2] = ($event) => dayValue.value = $event),
                label: __props.dateLabels[date],
                group: true,
                name: `${__props.name}_day`,
                maxlength: 2,
                required: __props.required,
                pattern: "[0-9]*",
                inputmode: "numeric",
                "aria-describedby": ariaDescribedby.value,
                "custom-classes": { component: ["usa-form-group--day"] }
              }, null, 8, ["id", "modelValue", "label", "name", "required", "aria-describedby"])) : date === "year" ? (openBlock(), createBlock(unref(_sfc_main$19), {
                key: 2,
                id: `${computedId.value}-${__props.name}-year`,
                modelValue: yearValue.value,
                "onUpdate:modelValue": _cache[3] || (_cache[3] = ($event) => yearValue.value = $event),
                label: __props.dateLabels[date],
                group: true,
                name: `${__props.name}_year`,
                minlength: 4,
                maxlength: 4,
                required: __props.required,
                pattern: "[0-9]*",
                inputmode: "numeric",
                "aria-describedby": ariaDescribedby.value,
                "custom-classes": { component: ["usa-form-group--year"] }
              }, null, 8, ["id", "modelValue", "label", "name", "required", "aria-describedby"])) : createCommentVNode("", true)
            ], 64);
          }), 128))
        ])
      ]);
    };
  }
};
var validateTimeString = (time) => {
  let isValidTimeString = false;
  const [hours, minutes] = time.split(":").map((segment) => parseInt(segment, 10));
  if (!Number.isNaN(hours) && !Number.isNaN(minutes) && hours >= 0 && hours < 24 && minutes >= 0 && minutes < 60) {
    isValidTimeString = true;
  }
  return isValidTimeString;
};
var formatYearString = (year) => `${year}`.padStart(4, "0");
var formatMonthString = (month) => `${month}`.padStart(2, "0");
var formatDayString = (day) => `${day}`.padStart(2, "0");
var getMonthIndex = (dateObject) => dateObject.getMonth();
var getMonth = (dateObject) => getMonthIndex(dateObject) + 1;
var getYear = (dateObject) => dateObject.getFullYear();
var getDay = (dateObject) => dateObject.getDate();
var parseIsoDate = (dateString) => {
  const [year, month, day] = dateString.split("-");
  const newDate = new Date(parseInt(year, 10), parseInt(month, 10) - 1, parseInt(day, 10), 0, 0, 0, 0).setFullYear(parseInt(year, 10), parseInt(month, 10) - 1, parseInt(day, 10));
  return new Date(newDate);
};
var today = () => {
  const now = /* @__PURE__ */ new Date();
  return new Date(now.getFullYear(), now.getMonth(), now.getDate(), 0, 0, 0, 0);
};
var parseUsaDate = (date) => {
  const [month, day, year] = date.split("/");
  const newDate = new Date(parseInt(year, 10), parseInt(month, 10) - 1, parseInt(day, 10), 0, 0, 0, 0).setFullYear(parseInt(year, 10), parseInt(month, 10) - 1, parseInt(day, 10));
  return new Date(newDate);
};
var formatIsoDate = (dateObject) => {
  const year = formatYearString(getYear(dateObject));
  const month = formatMonthString(getMonth(dateObject));
  const day = formatDayString(getDay(dateObject));
  return `${year}-${month}-${day}`;
};
var formatUsaDate = (dateObject) => {
  const year = formatYearString(getYear(dateObject));
  const month = formatMonthString(getMonth(dateObject));
  const day = formatDayString(getDay(dateObject));
  return `${month}/${day}/${year}`;
};
var isDateBefore = (date, dateToCompare) => date.getTime() < dateToCompare.getTime();
var isDateAfter = (date, dateToCompare) => date.getTime() > dateToCompare.getTime();
var isDateInRange = (date, minDate2, maxDate2) => !isDateBefore(date, minDate2) && !isDateAfter(date, maxDate2);
var setYear = (dateObject, newYear) => {
  const year = formatYearString(newYear);
  const month = formatMonthString(getMonth(dateObject));
  const day = formatDayString(getDay(dateObject));
  const newDateString = `${year}-${month}-${day}`;
  return parseIsoDate(newDateString);
};
var setMonth = (dateObject, newMonth) => {
  const year = formatYearString(getYear(dateObject));
  const month = formatMonthString(newMonth);
  const day = formatDayString(getDay(dateObject));
  const newDateString = `${year}-${month}-${day}`;
  return parseIsoDate(newDateString);
};
var isValidDate = (dateObject) => {
  return !Number.isNaN(dateObject == null ? void 0 : dateObject.getTime());
};
var isValidIsoDate = (isoDateString) => ISO_DATE_REGEX_PATTERN.test(isoDateString);
var isValidUsaDate = (usaDateString) => USA_DATE_REGEX_PATTERN.test(usaDateString);
var minDate = (dates) => {
  const timestamps = dates.map((date) => date.getTime());
  const min2 = Math.min(...timestamps);
  return new Date(min2);
};
var maxDate = (dates) => {
  const timestamps = dates.map((date) => date.getTime());
  const max2 = Math.max(...timestamps);
  return new Date(max2);
};
var startOfYear = (dateObject) => {
  const year = getYear(dateObject);
  const date = new Date(formatIsoDate(dateObject));
  date.setFullYear(year, 0, 1);
  date.setHours(0, 0, 0, 0);
  return date;
};
var endOfYear = (dateObject) => {
  const year = getYear(dateObject);
  const date = new Date(formatIsoDate(dateObject));
  date.setFullYear(year + 1, 0, 0);
  date.setHours(23, 59, 59, 999);
  return date;
};
var candidateSelectors = ["input:not([inert])", "select:not([inert])", "textarea:not([inert])", "a[href]:not([inert])", "button:not([inert])", "[tabindex]:not(slot):not([inert])", "audio[controls]:not([inert])", "video[controls]:not([inert])", '[contenteditable]:not([contenteditable="false"]):not([inert])', "details>summary:first-of-type:not([inert])", "details:not([inert])"];
var candidateSelector = candidateSelectors.join(",");
var NoElement = typeof Element === "undefined";
var matches = NoElement ? function() {
} : Element.prototype.matches || Element.prototype.msMatchesSelector || Element.prototype.webkitMatchesSelector;
var getRootNode = !NoElement && Element.prototype.getRootNode ? function(element) {
  var _element$getRootNode;
  return element === null || element === void 0 ? void 0 : (_element$getRootNode = element.getRootNode) === null || _element$getRootNode === void 0 ? void 0 : _element$getRootNode.call(element);
} : function(element) {
  return element === null || element === void 0 ? void 0 : element.ownerDocument;
};
var isInert = function isInert2(node, lookUp) {
  var _node$getAttribute;
  if (lookUp === void 0) {
    lookUp = true;
  }
  var inertAtt = node === null || node === void 0 ? void 0 : (_node$getAttribute = node.getAttribute) === null || _node$getAttribute === void 0 ? void 0 : _node$getAttribute.call(node, "inert");
  var inert = inertAtt === "" || inertAtt === "true";
  var result = inert || lookUp && node && isInert2(node.parentNode);
  return result;
};
var isContentEditable = function isContentEditable2(node) {
  var _node$getAttribute2;
  var attValue = node === null || node === void 0 ? void 0 : (_node$getAttribute2 = node.getAttribute) === null || _node$getAttribute2 === void 0 ? void 0 : _node$getAttribute2.call(node, "contenteditable");
  return attValue === "" || attValue === "true";
};
var getCandidates = function getCandidates2(el, includeContainer, filter) {
  if (isInert(el)) {
    return [];
  }
  var candidates = Array.prototype.slice.apply(el.querySelectorAll(candidateSelector));
  if (includeContainer && matches.call(el, candidateSelector)) {
    candidates.unshift(el);
  }
  candidates = candidates.filter(filter);
  return candidates;
};
var getCandidatesIteratively = function getCandidatesIteratively2(elements, includeContainer, options) {
  var candidates = [];
  var elementsToCheck = Array.from(elements);
  while (elementsToCheck.length) {
    var element = elementsToCheck.shift();
    if (isInert(element, false)) {
      continue;
    }
    if (element.tagName === "SLOT") {
      var assigned = element.assignedElements();
      var content = assigned.length ? assigned : element.children;
      var nestedCandidates = getCandidatesIteratively2(content, true, options);
      if (options.flatten) {
        candidates.push.apply(candidates, nestedCandidates);
      } else {
        candidates.push({
          scopeParent: element,
          candidates: nestedCandidates
        });
      }
    } else {
      var validCandidate = matches.call(element, candidateSelector);
      if (validCandidate && options.filter(element) && (includeContainer || !elements.includes(element))) {
        candidates.push(element);
      }
      var shadowRoot = element.shadowRoot || typeof options.getShadowRoot === "function" && options.getShadowRoot(element);
      var validShadowRoot = !isInert(shadowRoot, false) && (!options.shadowRootFilter || options.shadowRootFilter(element));
      if (shadowRoot && validShadowRoot) {
        var _nestedCandidates = getCandidatesIteratively2(shadowRoot === true ? element.children : shadowRoot.children, true, options);
        if (options.flatten) {
          candidates.push.apply(candidates, _nestedCandidates);
        } else {
          candidates.push({
            scopeParent: element,
            candidates: _nestedCandidates
          });
        }
      } else {
        elementsToCheck.unshift.apply(elementsToCheck, element.children);
      }
    }
  }
  return candidates;
};
var hasTabIndex = function hasTabIndex2(node) {
  return !isNaN(parseInt(node.getAttribute("tabindex"), 10));
};
var getTabIndex = function getTabIndex2(node) {
  if (!node) {
    throw new Error("No node provided");
  }
  if (node.tabIndex < 0) {
    if ((/^(AUDIO|VIDEO|DETAILS)$/.test(node.tagName) || isContentEditable(node)) && !hasTabIndex(node)) {
      return 0;
    }
  }
  return node.tabIndex;
};
var getSortOrderTabIndex = function getSortOrderTabIndex2(node, isScope) {
  var tabIndex = getTabIndex(node);
  if (tabIndex < 0 && isScope && !hasTabIndex(node)) {
    return 0;
  }
  return tabIndex;
};
var sortOrderedTabbables = function sortOrderedTabbables2(a, b) {
  return a.tabIndex === b.tabIndex ? a.documentOrder - b.documentOrder : a.tabIndex - b.tabIndex;
};
var isInput = function isInput2(node) {
  return node.tagName === "INPUT";
};
var isHiddenInput = function isHiddenInput2(node) {
  return isInput(node) && node.type === "hidden";
};
var isDetailsWithSummary = function isDetailsWithSummary2(node) {
  var r = node.tagName === "DETAILS" && Array.prototype.slice.apply(node.children).some(function(child) {
    return child.tagName === "SUMMARY";
  });
  return r;
};
var getCheckedRadio = function getCheckedRadio2(nodes, form) {
  for (var i = 0; i < nodes.length; i++) {
    if (nodes[i].checked && nodes[i].form === form) {
      return nodes[i];
    }
  }
};
var isTabbableRadio = function isTabbableRadio2(node) {
  if (!node.name) {
    return true;
  }
  var radioScope = node.form || getRootNode(node);
  var queryRadios = function queryRadios2(name) {
    return radioScope.querySelectorAll('input[type="radio"][name="' + name + '"]');
  };
  var radioSet;
  if (typeof window !== "undefined" && typeof window.CSS !== "undefined" && typeof window.CSS.escape === "function") {
    radioSet = queryRadios(window.CSS.escape(node.name));
  } else {
    try {
      radioSet = queryRadios(node.name);
    } catch (err) {
      console.error("Looks like you have a radio button with a name attribute containing invalid CSS selector characters and need the CSS.escape polyfill: %s", err.message);
      return false;
    }
  }
  var checked = getCheckedRadio(radioSet, node.form);
  return !checked || checked === node;
};
var isRadio = function isRadio2(node) {
  return isInput(node) && node.type === "radio";
};
var isNonTabbableRadio = function isNonTabbableRadio2(node) {
  return isRadio(node) && !isTabbableRadio(node);
};
var isNodeAttached = function isNodeAttached2(node) {
  var _nodeRoot;
  var nodeRoot = node && getRootNode(node);
  var nodeRootHost = (_nodeRoot = nodeRoot) === null || _nodeRoot === void 0 ? void 0 : _nodeRoot.host;
  var attached = false;
  if (nodeRoot && nodeRoot !== node) {
    var _nodeRootHost, _nodeRootHost$ownerDo, _node$ownerDocument;
    attached = !!((_nodeRootHost = nodeRootHost) !== null && _nodeRootHost !== void 0 && (_nodeRootHost$ownerDo = _nodeRootHost.ownerDocument) !== null && _nodeRootHost$ownerDo !== void 0 && _nodeRootHost$ownerDo.contains(nodeRootHost) || node !== null && node !== void 0 && (_node$ownerDocument = node.ownerDocument) !== null && _node$ownerDocument !== void 0 && _node$ownerDocument.contains(node));
    while (!attached && nodeRootHost) {
      var _nodeRoot2, _nodeRootHost2, _nodeRootHost2$ownerD;
      nodeRoot = getRootNode(nodeRootHost);
      nodeRootHost = (_nodeRoot2 = nodeRoot) === null || _nodeRoot2 === void 0 ? void 0 : _nodeRoot2.host;
      attached = !!((_nodeRootHost2 = nodeRootHost) !== null && _nodeRootHost2 !== void 0 && (_nodeRootHost2$ownerD = _nodeRootHost2.ownerDocument) !== null && _nodeRootHost2$ownerD !== void 0 && _nodeRootHost2$ownerD.contains(nodeRootHost));
    }
  }
  return attached;
};
var isZeroArea = function isZeroArea2(node) {
  var _node$getBoundingClie = node.getBoundingClientRect(), width = _node$getBoundingClie.width, height = _node$getBoundingClie.height;
  return width === 0 && height === 0;
};
var isHidden = function isHidden2(node, _ref) {
  var displayCheck = _ref.displayCheck, getShadowRoot = _ref.getShadowRoot;
  if (getComputedStyle(node).visibility === "hidden") {
    return true;
  }
  var isDirectSummary = matches.call(node, "details>summary:first-of-type");
  var nodeUnderDetails = isDirectSummary ? node.parentElement : node;
  if (matches.call(nodeUnderDetails, "details:not([open]) *")) {
    return true;
  }
  if (!displayCheck || displayCheck === "full" || displayCheck === "legacy-full") {
    if (typeof getShadowRoot === "function") {
      var originalNode = node;
      while (node) {
        var parentElement = node.parentElement;
        var rootNode = getRootNode(node);
        if (parentElement && !parentElement.shadowRoot && getShadowRoot(parentElement) === true) {
          return isZeroArea(node);
        } else if (node.assignedSlot) {
          node = node.assignedSlot;
        } else if (!parentElement && rootNode !== node.ownerDocument) {
          node = rootNode.host;
        } else {
          node = parentElement;
        }
      }
      node = originalNode;
    }
    if (isNodeAttached(node)) {
      return !node.getClientRects().length;
    }
    if (displayCheck !== "legacy-full") {
      return true;
    }
  } else if (displayCheck === "non-zero-area") {
    return isZeroArea(node);
  }
  return false;
};
var isDisabledFromFieldset = function isDisabledFromFieldset2(node) {
  if (/^(INPUT|BUTTON|SELECT|TEXTAREA)$/.test(node.tagName)) {
    var parentNode = node.parentElement;
    while (parentNode) {
      if (parentNode.tagName === "FIELDSET" && parentNode.disabled) {
        for (var i = 0; i < parentNode.children.length; i++) {
          var child = parentNode.children.item(i);
          if (child.tagName === "LEGEND") {
            return matches.call(parentNode, "fieldset[disabled] *") ? true : !child.contains(node);
          }
        }
        return true;
      }
      parentNode = parentNode.parentElement;
    }
  }
  return false;
};
var isNodeMatchingSelectorFocusable = function isNodeMatchingSelectorFocusable2(options, node) {
  if (node.disabled || isInert(node) || isHiddenInput(node) || isHidden(node, options) || isDetailsWithSummary(node) || isDisabledFromFieldset(node)) {
    return false;
  }
  return true;
};
var isNodeMatchingSelectorTabbable = function isNodeMatchingSelectorTabbable2(options, node) {
  if (isNonTabbableRadio(node) || getTabIndex(node) < 0 || !isNodeMatchingSelectorFocusable(options, node)) {
    return false;
  }
  return true;
};
var isValidShadowRootTabbable = function isValidShadowRootTabbable2(shadowHostNode) {
  var tabIndex = parseInt(shadowHostNode.getAttribute("tabindex"), 10);
  if (isNaN(tabIndex) || tabIndex >= 0) {
    return true;
  }
  return false;
};
var sortByOrder = function sortByOrder2(candidates) {
  var regularTabbables = [];
  var orderedTabbables = [];
  candidates.forEach(function(item, i) {
    var isScope = !!item.scopeParent;
    var element = isScope ? item.scopeParent : item;
    var candidateTabindex = getSortOrderTabIndex(element, isScope);
    var elements = isScope ? sortByOrder2(item.candidates) : element;
    if (candidateTabindex === 0) {
      isScope ? regularTabbables.push.apply(regularTabbables, elements) : regularTabbables.push(element);
    } else {
      orderedTabbables.push({
        documentOrder: i,
        tabIndex: candidateTabindex,
        item,
        isScope,
        content: elements
      });
    }
  });
  return orderedTabbables.sort(sortOrderedTabbables).reduce(function(acc, sortable) {
    sortable.isScope ? acc.push.apply(acc, sortable.content) : acc.push(sortable.content);
    return acc;
  }, []).concat(regularTabbables);
};
var tabbable = function tabbable2(container, options) {
  options = options || {};
  var candidates;
  if (options.getShadowRoot) {
    candidates = getCandidatesIteratively([container], options.includeContainer, {
      filter: isNodeMatchingSelectorTabbable.bind(null, options),
      flatten: false,
      getShadowRoot: options.getShadowRoot,
      shadowRootFilter: isValidShadowRootTabbable
    });
  } else {
    candidates = getCandidates(container, options.includeContainer, isNodeMatchingSelectorTabbable.bind(null, options));
  }
  return sortByOrder(candidates);
};
var focusable = function focusable2(container, options) {
  options = options || {};
  var candidates;
  if (options.getShadowRoot) {
    candidates = getCandidatesIteratively([container], options.includeContainer, {
      filter: isNodeMatchingSelectorFocusable.bind(null, options),
      flatten: true,
      getShadowRoot: options.getShadowRoot
    });
  } else {
    candidates = getCandidates(container, options.includeContainer, isNodeMatchingSelectorFocusable.bind(null, options));
  }
  return candidates;
};
var isTabbable = function isTabbable2(node, options) {
  options = options || {};
  if (!node) {
    throw new Error("No node provided");
  }
  if (matches.call(node, candidateSelector) === false) {
    return false;
  }
  return isNodeMatchingSelectorTabbable(options, node);
};
var focusableCandidateSelector = candidateSelectors.concat("iframe").join(",");
var isFocusable = function isFocusable2(node, options) {
  options = options || {};
  if (!node) {
    throw new Error("No node provided");
  }
  if (matches.call(node, focusableCandidateSelector) === false) {
    return false;
  }
  return isNodeMatchingSelectorFocusable(options, node);
};
function ownKeys(e, r) {
  var t = Object.keys(e);
  if (Object.getOwnPropertySymbols) {
    var o = Object.getOwnPropertySymbols(e);
    r && (o = o.filter(function(r2) {
      return Object.getOwnPropertyDescriptor(e, r2).enumerable;
    })), t.push.apply(t, o);
  }
  return t;
}
function _objectSpread2(e) {
  for (var r = 1; r < arguments.length; r++) {
    var t = arguments[r] != null ? arguments[r] : {};
    r % 2 ? ownKeys(Object(t), true).forEach(function(r2) {
      _defineProperty(e, r2, t[r2]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function(r2) {
      Object.defineProperty(e, r2, Object.getOwnPropertyDescriptor(t, r2));
    });
  }
  return e;
}
function _defineProperty(obj, key, value) {
  key = _toPropertyKey(key);
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPrimitive(input, hint) {
  if (typeof input !== "object" || input === null)
    return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (typeof res !== "object")
      return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function _toPropertyKey(arg) {
  var key = _toPrimitive(arg, "string");
  return typeof key === "symbol" ? key : String(key);
}
var activeFocusTraps = {
  activateTrap: function activateTrap(trapStack, trap) {
    if (trapStack.length > 0) {
      var activeTrap = trapStack[trapStack.length - 1];
      if (activeTrap !== trap) {
        activeTrap.pause();
      }
    }
    var trapIndex = trapStack.indexOf(trap);
    if (trapIndex === -1) {
      trapStack.push(trap);
    } else {
      trapStack.splice(trapIndex, 1);
      trapStack.push(trap);
    }
  },
  deactivateTrap: function deactivateTrap(trapStack, trap) {
    var trapIndex = trapStack.indexOf(trap);
    if (trapIndex !== -1) {
      trapStack.splice(trapIndex, 1);
    }
    if (trapStack.length > 0) {
      trapStack[trapStack.length - 1].unpause();
    }
  }
};
var isSelectableInput = function isSelectableInput2(node) {
  return node.tagName && node.tagName.toLowerCase() === "input" && typeof node.select === "function";
};
var isEscapeEvent = function isEscapeEvent2(e) {
  return (e === null || e === void 0 ? void 0 : e.key) === "Escape" || (e === null || e === void 0 ? void 0 : e.key) === "Esc" || (e === null || e === void 0 ? void 0 : e.keyCode) === 27;
};
var isTabEvent = function isTabEvent2(e) {
  return (e === null || e === void 0 ? void 0 : e.key) === "Tab" || (e === null || e === void 0 ? void 0 : e.keyCode) === 9;
};
var isKeyForward = function isKeyForward2(e) {
  return isTabEvent(e) && !e.shiftKey;
};
var isKeyBackward = function isKeyBackward2(e) {
  return isTabEvent(e) && e.shiftKey;
};
var delay = function delay2(fn) {
  return setTimeout(fn, 0);
};
var findIndex = function findIndex2(arr, fn) {
  var idx = -1;
  arr.every(function(value, i) {
    if (fn(value)) {
      idx = i;
      return false;
    }
    return true;
  });
  return idx;
};
var valueOrHandler = function valueOrHandler2(value) {
  for (var _len = arguments.length, params = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    params[_key - 1] = arguments[_key];
  }
  return typeof value === "function" ? value.apply(void 0, params) : value;
};
var getActualTarget = function getActualTarget2(event) {
  return event.target.shadowRoot && typeof event.composedPath === "function" ? event.composedPath()[0] : event.target;
};
var internalTrapStack = [];
var createFocusTrap = function createFocusTrap2(elements, userOptions) {
  var doc = (userOptions === null || userOptions === void 0 ? void 0 : userOptions.document) || document;
  var trapStack = (userOptions === null || userOptions === void 0 ? void 0 : userOptions.trapStack) || internalTrapStack;
  var config = _objectSpread2({
    returnFocusOnDeactivate: true,
    escapeDeactivates: true,
    delayInitialFocus: true,
    isKeyForward,
    isKeyBackward
  }, userOptions);
  var state = {
    containers: [],
    containerGroups: [],
    tabbableGroups: [],
    nodeFocusedBeforeActivation: null,
    mostRecentlyFocusedNode: null,
    active: false,
    paused: false,
    delayInitialFocusTimer: void 0,
    recentNavEvent: void 0
  };
  var trap;
  var getOption = function getOption2(configOverrideOptions, optionName, configOptionName) {
    return configOverrideOptions && configOverrideOptions[optionName] !== void 0 ? configOverrideOptions[optionName] : config[configOptionName || optionName];
  };
  var findContainerIndex = function findContainerIndex2(element, event) {
    var composedPath = typeof (event === null || event === void 0 ? void 0 : event.composedPath) === "function" ? event.composedPath() : void 0;
    return state.containerGroups.findIndex(function(_ref) {
      var container = _ref.container, tabbableNodes = _ref.tabbableNodes;
      return container.contains(element) || (composedPath === null || composedPath === void 0 ? void 0 : composedPath.includes(container)) || tabbableNodes.find(function(node) {
        return node === element;
      });
    });
  };
  var getNodeForOption = function getNodeForOption2(optionName) {
    var optionValue = config[optionName];
    if (typeof optionValue === "function") {
      for (var _len2 = arguments.length, params = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
        params[_key2 - 1] = arguments[_key2];
      }
      optionValue = optionValue.apply(void 0, params);
    }
    if (optionValue === true) {
      optionValue = void 0;
    }
    if (!optionValue) {
      if (optionValue === void 0 || optionValue === false) {
        return optionValue;
      }
      throw new Error("`".concat(optionName, "` was specified but was not a node, or did not return a node"));
    }
    var node = optionValue;
    if (typeof optionValue === "string") {
      node = doc.querySelector(optionValue);
      if (!node) {
        throw new Error("`".concat(optionName, "` as selector refers to no known node"));
      }
    }
    return node;
  };
  var getInitialFocusNode = function getInitialFocusNode2() {
    var node = getNodeForOption("initialFocus");
    if (node === false) {
      return false;
    }
    if (node === void 0 || !isFocusable(node, config.tabbableOptions)) {
      if (findContainerIndex(doc.activeElement) >= 0) {
        node = doc.activeElement;
      } else {
        var firstTabbableGroup = state.tabbableGroups[0];
        var firstTabbableNode = firstTabbableGroup && firstTabbableGroup.firstTabbableNode;
        node = firstTabbableNode || getNodeForOption("fallbackFocus");
      }
    }
    if (!node) {
      throw new Error("Your focus-trap needs to have at least one focusable element");
    }
    return node;
  };
  var updateTabbableNodes = function updateTabbableNodes2() {
    state.containerGroups = state.containers.map(function(container) {
      var tabbableNodes = tabbable(container, config.tabbableOptions);
      var focusableNodes = focusable(container, config.tabbableOptions);
      var firstTabbableNode = tabbableNodes.length > 0 ? tabbableNodes[0] : void 0;
      var lastTabbableNode = tabbableNodes.length > 0 ? tabbableNodes[tabbableNodes.length - 1] : void 0;
      var firstDomTabbableNode = focusableNodes.find(function(node) {
        return isTabbable(node);
      });
      var lastDomTabbableNode = focusableNodes.slice().reverse().find(function(node) {
        return isTabbable(node);
      });
      var posTabIndexesFound = !!tabbableNodes.find(function(node) {
        return getTabIndex(node) > 0;
      });
      return {
        container,
        tabbableNodes,
        focusableNodes,
        posTabIndexesFound,
        firstTabbableNode,
        lastTabbableNode,
        firstDomTabbableNode,
        lastDomTabbableNode,
        nextTabbableNode: function nextTabbableNode(node) {
          var forward = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : true;
          var nodeIdx = tabbableNodes.indexOf(node);
          if (nodeIdx < 0) {
            if (forward) {
              return focusableNodes.slice(focusableNodes.indexOf(node) + 1).find(function(el) {
                return isTabbable(el);
              });
            }
            return focusableNodes.slice(0, focusableNodes.indexOf(node)).reverse().find(function(el) {
              return isTabbable(el);
            });
          }
          return tabbableNodes[nodeIdx + (forward ? 1 : -1)];
        }
      };
    });
    state.tabbableGroups = state.containerGroups.filter(function(group) {
      return group.tabbableNodes.length > 0;
    });
    if (state.tabbableGroups.length <= 0 && !getNodeForOption("fallbackFocus")) {
      throw new Error("Your focus-trap must have at least one container with at least one tabbable node in it at all times");
    }
    if (state.containerGroups.find(function(g) {
      return g.posTabIndexesFound;
    }) && state.containerGroups.length > 1) {
      throw new Error("At least one node with a positive tabindex was found in one of your focus-trap's multiple containers. Positive tabindexes are only supported in single-container focus-traps.");
    }
  };
  var tryFocus = function tryFocus2(node) {
    if (node === false) {
      return;
    }
    if (node === doc.activeElement) {
      return;
    }
    if (!node || !node.focus) {
      tryFocus2(getInitialFocusNode());
      return;
    }
    node.focus({
      preventScroll: !!config.preventScroll
    });
    state.mostRecentlyFocusedNode = node;
    if (isSelectableInput(node)) {
      node.select();
    }
  };
  var getReturnFocusNode = function getReturnFocusNode2(previousActiveElement) {
    var node = getNodeForOption("setReturnFocus", previousActiveElement);
    return node ? node : node === false ? false : previousActiveElement;
  };
  var findNextNavNode = function findNextNavNode2(_ref2) {
    var target = _ref2.target, event = _ref2.event, _ref2$isBackward = _ref2.isBackward, isBackward = _ref2$isBackward === void 0 ? false : _ref2$isBackward;
    target = target || getActualTarget(event);
    updateTabbableNodes();
    var destinationNode = null;
    if (state.tabbableGroups.length > 0) {
      var containerIndex = findContainerIndex(target, event);
      var containerGroup = containerIndex >= 0 ? state.containerGroups[containerIndex] : void 0;
      if (containerIndex < 0) {
        if (isBackward) {
          destinationNode = state.tabbableGroups[state.tabbableGroups.length - 1].lastTabbableNode;
        } else {
          destinationNode = state.tabbableGroups[0].firstTabbableNode;
        }
      } else if (isBackward) {
        var startOfGroupIndex = findIndex(state.tabbableGroups, function(_ref3) {
          var firstTabbableNode = _ref3.firstTabbableNode;
          return target === firstTabbableNode;
        });
        if (startOfGroupIndex < 0 && (containerGroup.container === target || isFocusable(target, config.tabbableOptions) && !isTabbable(target, config.tabbableOptions) && !containerGroup.nextTabbableNode(target, false))) {
          startOfGroupIndex = containerIndex;
        }
        if (startOfGroupIndex >= 0) {
          var destinationGroupIndex = startOfGroupIndex === 0 ? state.tabbableGroups.length - 1 : startOfGroupIndex - 1;
          var destinationGroup = state.tabbableGroups[destinationGroupIndex];
          destinationNode = getTabIndex(target) >= 0 ? destinationGroup.lastTabbableNode : destinationGroup.lastDomTabbableNode;
        } else if (!isTabEvent(event)) {
          destinationNode = containerGroup.nextTabbableNode(target, false);
        }
      } else {
        var lastOfGroupIndex = findIndex(state.tabbableGroups, function(_ref4) {
          var lastTabbableNode = _ref4.lastTabbableNode;
          return target === lastTabbableNode;
        });
        if (lastOfGroupIndex < 0 && (containerGroup.container === target || isFocusable(target, config.tabbableOptions) && !isTabbable(target, config.tabbableOptions) && !containerGroup.nextTabbableNode(target))) {
          lastOfGroupIndex = containerIndex;
        }
        if (lastOfGroupIndex >= 0) {
          var _destinationGroupIndex = lastOfGroupIndex === state.tabbableGroups.length - 1 ? 0 : lastOfGroupIndex + 1;
          var _destinationGroup = state.tabbableGroups[_destinationGroupIndex];
          destinationNode = getTabIndex(target) >= 0 ? _destinationGroup.firstTabbableNode : _destinationGroup.firstDomTabbableNode;
        } else if (!isTabEvent(event)) {
          destinationNode = containerGroup.nextTabbableNode(target);
        }
      }
    } else {
      destinationNode = getNodeForOption("fallbackFocus");
    }
    return destinationNode;
  };
  var checkPointerDown = function checkPointerDown2(e) {
    var target = getActualTarget(e);
    if (findContainerIndex(target, e) >= 0) {
      return;
    }
    if (valueOrHandler(config.clickOutsideDeactivates, e)) {
      trap.deactivate({
        returnFocus: config.returnFocusOnDeactivate
      });
      return;
    }
    if (valueOrHandler(config.allowOutsideClick, e)) {
      return;
    }
    e.preventDefault();
  };
  var checkFocusIn = function checkFocusIn2(event) {
    var target = getActualTarget(event);
    var targetContained = findContainerIndex(target, event) >= 0;
    if (targetContained || target instanceof Document) {
      if (targetContained) {
        state.mostRecentlyFocusedNode = target;
      }
    } else {
      event.stopImmediatePropagation();
      var nextNode;
      var navAcrossContainers = true;
      if (state.mostRecentlyFocusedNode) {
        if (getTabIndex(state.mostRecentlyFocusedNode) > 0) {
          var mruContainerIdx = findContainerIndex(state.mostRecentlyFocusedNode);
          var tabbableNodes = state.containerGroups[mruContainerIdx].tabbableNodes;
          if (tabbableNodes.length > 0) {
            var mruTabIdx = tabbableNodes.findIndex(function(node) {
              return node === state.mostRecentlyFocusedNode;
            });
            if (mruTabIdx >= 0) {
              if (config.isKeyForward(state.recentNavEvent)) {
                if (mruTabIdx + 1 < tabbableNodes.length) {
                  nextNode = tabbableNodes[mruTabIdx + 1];
                  navAcrossContainers = false;
                }
              } else {
                if (mruTabIdx - 1 >= 0) {
                  nextNode = tabbableNodes[mruTabIdx - 1];
                  navAcrossContainers = false;
                }
              }
            }
          }
        } else {
          if (!state.containerGroups.some(function(g) {
            return g.tabbableNodes.some(function(n) {
              return getTabIndex(n) > 0;
            });
          })) {
            navAcrossContainers = false;
          }
        }
      } else {
        navAcrossContainers = false;
      }
      if (navAcrossContainers) {
        nextNode = findNextNavNode({
          target: state.mostRecentlyFocusedNode,
          isBackward: config.isKeyBackward(state.recentNavEvent)
        });
      }
      if (nextNode) {
        tryFocus(nextNode);
      } else {
        tryFocus(state.mostRecentlyFocusedNode || getInitialFocusNode());
      }
    }
    state.recentNavEvent = void 0;
  };
  var checkKeyNav = function checkKeyNav2(event) {
    var isBackward = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : false;
    state.recentNavEvent = event;
    var destinationNode = findNextNavNode({
      event,
      isBackward
    });
    if (destinationNode) {
      if (isTabEvent(event)) {
        event.preventDefault();
      }
      tryFocus(destinationNode);
    }
  };
  var checkKey = function checkKey2(event) {
    if (isEscapeEvent(event) && valueOrHandler(config.escapeDeactivates, event) !== false) {
      event.preventDefault();
      trap.deactivate();
      return;
    }
    if (config.isKeyForward(event) || config.isKeyBackward(event)) {
      checkKeyNav(event, config.isKeyBackward(event));
    }
  };
  var checkClick = function checkClick2(e) {
    var target = getActualTarget(e);
    if (findContainerIndex(target, e) >= 0) {
      return;
    }
    if (valueOrHandler(config.clickOutsideDeactivates, e)) {
      return;
    }
    if (valueOrHandler(config.allowOutsideClick, e)) {
      return;
    }
    e.preventDefault();
    e.stopImmediatePropagation();
  };
  var addListeners = function addListeners2() {
    if (!state.active) {
      return;
    }
    activeFocusTraps.activateTrap(trapStack, trap);
    state.delayInitialFocusTimer = config.delayInitialFocus ? delay(function() {
      tryFocus(getInitialFocusNode());
    }) : tryFocus(getInitialFocusNode());
    doc.addEventListener("focusin", checkFocusIn, true);
    doc.addEventListener("mousedown", checkPointerDown, {
      capture: true,
      passive: false
    });
    doc.addEventListener("touchstart", checkPointerDown, {
      capture: true,
      passive: false
    });
    doc.addEventListener("click", checkClick, {
      capture: true,
      passive: false
    });
    doc.addEventListener("keydown", checkKey, {
      capture: true,
      passive: false
    });
    return trap;
  };
  var removeListeners = function removeListeners2() {
    if (!state.active) {
      return;
    }
    doc.removeEventListener("focusin", checkFocusIn, true);
    doc.removeEventListener("mousedown", checkPointerDown, true);
    doc.removeEventListener("touchstart", checkPointerDown, true);
    doc.removeEventListener("click", checkClick, true);
    doc.removeEventListener("keydown", checkKey, true);
    return trap;
  };
  var checkDomRemoval = function checkDomRemoval2(mutations) {
    var isFocusedNodeRemoved = mutations.some(function(mutation) {
      var removedNodes = Array.from(mutation.removedNodes);
      return removedNodes.some(function(node) {
        return node === state.mostRecentlyFocusedNode;
      });
    });
    if (isFocusedNodeRemoved) {
      tryFocus(getInitialFocusNode());
    }
  };
  var mutationObserver = typeof window !== "undefined" && "MutationObserver" in window ? new MutationObserver(checkDomRemoval) : void 0;
  var updateObservedNodes = function updateObservedNodes2() {
    if (!mutationObserver) {
      return;
    }
    mutationObserver.disconnect();
    if (state.active && !state.paused) {
      state.containers.map(function(container) {
        mutationObserver.observe(container, {
          subtree: true,
          childList: true
        });
      });
    }
  };
  trap = {
    get active() {
      return state.active;
    },
    get paused() {
      return state.paused;
    },
    activate: function activate(activateOptions) {
      if (state.active) {
        return this;
      }
      var onActivate = getOption(activateOptions, "onActivate");
      var onPostActivate = getOption(activateOptions, "onPostActivate");
      var checkCanFocusTrap = getOption(activateOptions, "checkCanFocusTrap");
      if (!checkCanFocusTrap) {
        updateTabbableNodes();
      }
      state.active = true;
      state.paused = false;
      state.nodeFocusedBeforeActivation = doc.activeElement;
      onActivate === null || onActivate === void 0 || onActivate();
      var finishActivation = function finishActivation2() {
        if (checkCanFocusTrap) {
          updateTabbableNodes();
        }
        addListeners();
        updateObservedNodes();
        onPostActivate === null || onPostActivate === void 0 || onPostActivate();
      };
      if (checkCanFocusTrap) {
        checkCanFocusTrap(state.containers.concat()).then(finishActivation, finishActivation);
        return this;
      }
      finishActivation();
      return this;
    },
    deactivate: function deactivate(deactivateOptions) {
      if (!state.active) {
        return this;
      }
      var options = _objectSpread2({
        onDeactivate: config.onDeactivate,
        onPostDeactivate: config.onPostDeactivate,
        checkCanReturnFocus: config.checkCanReturnFocus
      }, deactivateOptions);
      clearTimeout(state.delayInitialFocusTimer);
      state.delayInitialFocusTimer = void 0;
      removeListeners();
      state.active = false;
      state.paused = false;
      updateObservedNodes();
      activeFocusTraps.deactivateTrap(trapStack, trap);
      var onDeactivate = getOption(options, "onDeactivate");
      var onPostDeactivate = getOption(options, "onPostDeactivate");
      var checkCanReturnFocus = getOption(options, "checkCanReturnFocus");
      var returnFocus = getOption(options, "returnFocus", "returnFocusOnDeactivate");
      onDeactivate === null || onDeactivate === void 0 || onDeactivate();
      var finishDeactivation = function finishDeactivation2() {
        delay(function() {
          if (returnFocus) {
            tryFocus(getReturnFocusNode(state.nodeFocusedBeforeActivation));
          }
          onPostDeactivate === null || onPostDeactivate === void 0 || onPostDeactivate();
        });
      };
      if (returnFocus && checkCanReturnFocus) {
        checkCanReturnFocus(getReturnFocusNode(state.nodeFocusedBeforeActivation)).then(finishDeactivation, finishDeactivation);
        return this;
      }
      finishDeactivation();
      return this;
    },
    pause: function pause(pauseOptions) {
      if (state.paused || !state.active) {
        return this;
      }
      var onPause = getOption(pauseOptions, "onPause");
      var onPostPause = getOption(pauseOptions, "onPostPause");
      state.paused = true;
      onPause === null || onPause === void 0 || onPause();
      removeListeners();
      updateObservedNodes();
      onPostPause === null || onPostPause === void 0 || onPostPause();
      return this;
    },
    unpause: function unpause(unpauseOptions) {
      if (!state.paused || !state.active) {
        return this;
      }
      var onUnpause = getOption(unpauseOptions, "onUnpause");
      var onPostUnpause = getOption(unpauseOptions, "onPostUnpause");
      state.paused = false;
      onUnpause === null || onUnpause === void 0 || onUnpause();
      updateTabbableNodes();
      addListeners();
      updateObservedNodes();
      onPostUnpause === null || onPostUnpause === void 0 || onPostUnpause();
      return this;
    },
    updateContainerElements: function updateContainerElements(containerElements) {
      var elementsAsArray = [].concat(containerElements).filter(Boolean);
      state.containers = elementsAsArray.map(function(element) {
        return typeof element === "string" ? doc.querySelector(element) : element;
      });
      if (state.active) {
        updateTabbableNodes();
      }
      updateObservedNodes();
      return this;
    }
  };
  trap.updateContainerElements(elements);
  return trap;
};
var __defProp2 = Object.defineProperty;
var __defProps2 = Object.defineProperties;
var __getOwnPropDescs2 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols2 = Object.getOwnPropertySymbols;
var __hasOwnProp2 = Object.prototype.hasOwnProperty;
var __propIsEnum2 = Object.prototype.propertyIsEnumerable;
var __defNormalProp2 = (obj, key, value) => key in obj ? __defProp2(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues2 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp2.call(b, prop))
      __defNormalProp2(a, prop, b[prop]);
  if (__getOwnPropSymbols2)
    for (var prop of __getOwnPropSymbols2(b)) {
      if (__propIsEnum2.call(b, prop))
        __defNormalProp2(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps2 = (a, b) => __defProps2(a, __getOwnPropDescs2(b));
var __objRest2 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp2.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols2)
    for (var prop of __getOwnPropSymbols2(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum2.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function useFocusTrap(target, options = {}) {
  let trap;
  const _a2 = options, { immediate } = _a2, focusTrapOptions = __objRest2(_a2, ["immediate"]);
  const hasFocus = ref(false);
  const isPaused = ref(false);
  const activate = (opts) => trap && trap.activate(opts);
  const deactivate = (opts) => trap && trap.deactivate(opts);
  const pause = () => {
    if (trap) {
      trap.pause();
      isPaused.value = true;
    }
  };
  const unpause = () => {
    if (trap) {
      trap.unpause();
      isPaused.value = false;
    }
  };
  watch(() => unrefElement(target), (el) => {
    if (!el)
      return;
    trap = createFocusTrap(el, __spreadProps2(__spreadValues2({}, focusTrapOptions), {
      onActivate() {
        hasFocus.value = true;
        if (options.onActivate)
          options.onActivate();
      },
      onDeactivate() {
        hasFocus.value = false;
        if (options.onDeactivate)
          options.onDeactivate();
      }
    }));
    if (immediate)
      activate();
  }, { flush: "post" });
  tryOnScopeDispose(() => deactivate());
  return {
    hasFocus,
    isPaused,
    activate,
    deactivate,
    pause,
    unpause
  };
}
function _typeof(obj) {
  "@babel/helpers - typeof";
  return _typeof = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && typeof Symbol == "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof(obj);
}
function toInteger(dirtyNumber) {
  if (dirtyNumber === null || dirtyNumber === true || dirtyNumber === false) {
    return NaN;
  }
  var number = Number(dirtyNumber);
  if (isNaN(number)) {
    return number;
  }
  return number < 0 ? Math.ceil(number) : Math.floor(number);
}
function requiredArgs(required, args) {
  if (args.length < required) {
    throw new TypeError(required + " argument" + (required > 1 ? "s" : "") + " required, but only " + args.length + " present");
  }
}
function toDate(argument) {
  requiredArgs(1, arguments);
  var argStr = Object.prototype.toString.call(argument);
  if (argument instanceof Date || _typeof(argument) === "object" && argStr === "[object Date]") {
    return new Date(argument.getTime());
  } else if (typeof argument === "number" || argStr === "[object Number]") {
    return new Date(argument);
  } else {
    if ((typeof argument === "string" || argStr === "[object String]") && typeof console !== "undefined") {
      console.warn("Starting with v2.0.0-beta.1 date-fns doesn't accept strings as date arguments. Please use `parseISO` to parse strings. See: https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#string-arguments");
      console.warn(new Error().stack);
    }
    return /* @__PURE__ */ new Date(NaN);
  }
}
function addDays(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var amount = toInteger(dirtyAmount);
  if (isNaN(amount)) {
    return /* @__PURE__ */ new Date(NaN);
  }
  if (!amount) {
    return date;
  }
  date.setDate(date.getDate() + amount);
  return date;
}
function addMonths(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var amount = toInteger(dirtyAmount);
  if (isNaN(amount)) {
    return /* @__PURE__ */ new Date(NaN);
  }
  if (!amount) {
    return date;
  }
  var dayOfMonth = date.getDate();
  var endOfDesiredMonth = new Date(date.getTime());
  endOfDesiredMonth.setMonth(date.getMonth() + amount + 1, 0);
  var daysInMonth = endOfDesiredMonth.getDate();
  if (dayOfMonth >= daysInMonth) {
    return endOfDesiredMonth;
  } else {
    date.setFullYear(endOfDesiredMonth.getFullYear(), endOfDesiredMonth.getMonth(), dayOfMonth);
    return date;
  }
}
var defaultOptions = {};
function getDefaultOptions() {
  return defaultOptions;
}
function startOfWeek(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var defaultOptions2 = getDefaultOptions();
  var weekStartsOn = toInteger((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var date = toDate(dirtyDate);
  var day = date.getDay();
  var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
  date.setDate(date.getDate() - diff);
  date.setHours(0, 0, 0, 0);
  return date;
}
function getTimezoneOffsetInMilliseconds(date) {
  var utcDate = new Date(Date.UTC(date.getFullYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), date.getMilliseconds()));
  utcDate.setUTCFullYear(date.getFullYear());
  return date.getTime() - utcDate.getTime();
}
function startOfDay(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  date.setHours(0, 0, 0, 0);
  return date;
}
var MILLISECONDS_IN_DAY = 864e5;
function differenceInCalendarDays(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var startOfDayLeft = startOfDay(dirtyDateLeft);
  var startOfDayRight = startOfDay(dirtyDateRight);
  var timestampLeft = startOfDayLeft.getTime() - getTimezoneOffsetInMilliseconds(startOfDayLeft);
  var timestampRight = startOfDayRight.getTime() - getTimezoneOffsetInMilliseconds(startOfDayRight);
  return Math.round((timestampLeft - timestampRight) / MILLISECONDS_IN_DAY);
}
function addYears(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var amount = toInteger(dirtyAmount);
  return addMonths(dirtyDate, amount * 12);
}
function isSameDay(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var dateLeftStartOfDay = startOfDay(dirtyDateLeft);
  var dateRightStartOfDay = startOfDay(dirtyDateRight);
  return dateLeftStartOfDay.getTime() === dateRightStartOfDay.getTime();
}
function endOfMonth(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var month = date.getMonth();
  date.setFullYear(date.getFullYear(), month + 1, 0);
  date.setHours(23, 59, 59, 999);
  return date;
}
function startOfMonth(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  date.setDate(1);
  date.setHours(0, 0, 0, 0);
  return date;
}
function endOfWeek(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var defaultOptions2 = getDefaultOptions();
  var weekStartsOn = toInteger((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var date = toDate(dirtyDate);
  var day = date.getDay();
  var diff = (day < weekStartsOn ? -7 : 0) + 6 - (day - weekStartsOn);
  date.setDate(date.getDate() + diff);
  date.setHours(23, 59, 59, 999);
  return date;
}
function isAfter(dirtyDate, dirtyDateToCompare) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var dateToCompare = toDate(dirtyDateToCompare);
  return date.getTime() > dateToCompare.getTime();
}
function isBefore(dirtyDate, dirtyDateToCompare) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var dateToCompare = toDate(dirtyDateToCompare);
  return date.getTime() < dateToCompare.getTime();
}
function isSameMonth(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var dateLeft = toDate(dirtyDateLeft);
  var dateRight = toDate(dirtyDateRight);
  return dateLeft.getFullYear() === dateRight.getFullYear() && dateLeft.getMonth() === dateRight.getMonth();
}
function subDays(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var amount = toInteger(dirtyAmount);
  return addDays(dirtyDate, -amount);
}
function setDate(dirtyDate, dirtyDayOfMonth) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var dayOfMonth = toInteger(dirtyDayOfMonth);
  date.setDate(dayOfMonth);
  return date;
}
function subMonths(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var amount = toInteger(dirtyAmount);
  return addMonths(dirtyDate, -amount);
}
function subYears(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var amount = toInteger(dirtyAmount);
  return addYears(dirtyDate, -amount);
}
var useDayPicker = ({
  activeDate,
  minDate: minDate2,
  maxDate: maxDate2,
  dayOfWeekLabels,
  monthLabels,
  isDateRange,
  dateRangeStart,
  dateRangeEnd
}) => {
  const minDateObject = shallowRef(parseIsoDate(minDate2.value));
  watch(minDate2, (newMinDate) => minDateObject.value = parseIsoDate(newMinDate));
  const maxDateObject = shallowRef(parseIsoDate(maxDate2.value));
  watch(maxDate2, (newMaxDate) => maxDateObject.value = parseIsoDate(newMaxDate));
  const activeDateObject = shallowRef(parseIsoDate(activeDate.value));
  watch(activeDate, (newActiveDate) => activeDateObject.value = parseIsoDate(newActiveDate));
  const activeDateStart = computed(() => startOfWeek(startOfMonth(activeDateObject.value)));
  const activeDateEnd = computed(() => endOfWeek(endOfMonth(activeDateObject.value)));
  const activeMonthIndex = computed(() => activeDateObject.value.getMonth());
  const isPreviousMonth = (currentMonth, monthToCompare) => {
    if (currentMonth === 0) {
      return monthToCompare === 11;
    }
    return currentMonth + 1 === monthToCompare;
  };
  const isCurrentMonth = (currentMonth, monthToCompare) => currentMonth === monthToCompare;
  const isNextMonth = (currentMonth, monthToCompare) => {
    if (currentMonth === 11) {
      return monthToCompare === 0;
    }
    return currentMonth - 1 === monthToCompare;
  };
  const isDateInRange2 = (date) => {
    return !isBefore(date, parseIsoDate(minDate2.value)) && !isAfter(date, parseIsoDate(maxDate2.value));
  };
  const isDateInCurrentRange = (date) => {
    return isDateRange.value && dateRangeStart.value && dateRangeEnd.value && isDateInRange2(date) && !isBefore(subDays(date, 1), parseIsoDate(dateRangeStart.value)) && !isAfter(addDays(date, 1), parseIsoDate(dateRangeEnd.value));
  };
  const formatAriaLabelDate = (date) => {
    const year = `${date.getFullYear()}`.padStart(4, "0");
    const day = date.getDate();
    const dayOfWeekIndex = date.getDay();
    const dayOfWeekLabel = dayOfWeekLabels.value[dayOfWeekIndex];
    const monthIndex = date.getMonth();
    const monthLabel = monthLabels.value[monthIndex];
    return `${day} ${monthLabel} ${year} ${dayOfWeekLabel}`;
  };
  const findClosestPastDate = (start, stop) => {
    let index = start;
    while (!isAfter(index, stop)) {
      if (isDateInRange2(index)) {
        return formatIsoDate(index);
      }
      index = addDays(index, 1);
    }
    return formatIsoDate(start);
  };
  const findClosestFutureDate = (start, stop) => {
    let index = start;
    while (!isBefore(startOfDay(index), stop)) {
      if (isDateInRange2(index)) {
        return formatIsoDate(index);
      }
      index = subDays(index, 1);
    }
    return formatIsoDate(start);
  };
  const findPreviousMonth = (currentDateObject) => {
    return isDateInRange2(subMonths(currentDateObject, 1)) ? formatIsoDate(subMonths(currentDateObject, 1)) : findClosestPastDate(subMonths(currentDateObject, 1), currentDateObject);
  };
  const findNextMonth = (currentDateObject) => {
    return isDateInRange2(addMonths(currentDateObject, 1)) ? formatIsoDate(addMonths(currentDateObject, 1)) : findClosestFutureDate(addMonths(currentDateObject, 1), currentDateObject);
  };
  const findPreviousYear = (currentDateObject) => {
    const currentDay = currentDateObject.getDate();
    const previousYearDateObject = subYears(currentDateObject, 1);
    if (isDateInRange2(previousYearDateObject)) {
      return formatIsoDate(previousYearDateObject);
    }
    const nextAvailableDate = parseIsoDate(findClosestPastDate(previousYearDateObject, currentDateObject));
    const nextDateOnSameDay = setDate(nextAvailableDate, currentDay);
    if (!isValidDate(nextDateOnSameDay) || !isDateInRange2(nextDateOnSameDay) || isSameDay(currentDateObject, nextDateOnSameDay)) {
      return formatIsoDate(nextAvailableDate);
    }
    return formatIsoDate(nextDateOnSameDay);
  };
  const findNextYear = (currentDateObject) => {
    const currentDay = currentDateObject.getDate();
    const nextYearDateObject = addYears(currentDateObject, 1);
    if (isDateInRange2(nextYearDateObject)) {
      return formatIsoDate(nextYearDateObject);
    }
    const nextAvailableDate = parseIsoDate(findClosestFutureDate(nextYearDateObject, currentDateObject));
    const nextDateOnSameDay = setDate(nextAvailableDate, currentDay);
    if (!isValidDate(nextDateOnSameDay) || !isDateInRange2(nextDateOnSameDay) || isSameDay(currentDateObject, nextDateOnSameDay)) {
      return formatIsoDate(nextAvailableDate);
    }
    return formatIsoDate(nextDateOnSameDay);
  };
  const hasPastYear = computed(() => !isSameMonth(activeDateObject.value, minDateObject.value));
  const hasFutureYear = computed(() => !isSameMonth(activeDateObject.value, maxDateObject.value));
  const hasPastMonth = computed(() => !isSameMonth(activeDateObject.value, minDateObject.value));
  const hasFutureMonth = computed(() => !isSameMonth(activeDateObject.value, maxDateObject.value));
  const todaysDate = formatIsoDate(today());
  const visibleDateRange = computed(() => {
    const dates2 = [];
    const totalDays = differenceInCalendarDays(activeDateEnd.value, activeDateStart.value);
    let index = 0;
    while (index <= totalDays) {
      const currentDate = addDays(activeDateStart.value, index);
      const monthIndex = currentDate.getMonth();
      const month = monthIndex + 1;
      dates2.push({
        date: formatIsoDate(currentDate),
        label: formatAriaLabelDate(currentDate),
        day: currentDate.getDate(),
        month,
        year: currentDate.getFullYear(),
        isPreviousMonth: isPreviousMonth(monthIndex, activeMonthIndex.value),
        isCurrentMonth: isCurrentMonth(monthIndex, activeMonthIndex.value),
        isNextMonth: isNextMonth(monthIndex, activeMonthIndex.value),
        isInCurrentRange: isDateInCurrentRange(currentDate),
        previousMonth: findPreviousMonth(currentDate),
        nextMonth: findNextMonth(currentDate),
        previousYear: findPreviousYear(currentDate),
        nextYear: findNextYear(currentDate),
        disabled: !isDateInRange2(currentDate),
        left: isDateInRange2(subDays(currentDate, 1)) ? formatIsoDate(subDays(currentDate, 1)) : null,
        right: isDateInRange2(addDays(currentDate, 1)) ? formatIsoDate(addDays(currentDate, 1)) : null,
        up: isDateInRange2(subDays(currentDate, 7)) ? formatIsoDate(subDays(currentDate, 7)) : findClosestPastDate(parseIsoDate(minDate2.value), currentDate),
        down: isDateInRange2(addDays(currentDate, 7)) ? formatIsoDate(addDays(currentDate, 7)) : findClosestFutureDate(parseIsoDate(maxDate2.value), currentDate),
        home: findClosestPastDate(startOfWeek(currentDate), currentDate),
        end: findClosestFutureDate(endOfWeek(currentDate), currentDate),
        pageUp: findPreviousMonth(currentDate),
        pageDown: findNextMonth(currentDate),
        shiftPageUp: findPreviousYear(currentDate),
        shiftPageDown: findNextYear(currentDate)
      });
      index += 1;
    }
    return dates2;
  });
  const groupedVisibleDateRange = computed(() => splitArray(visibleDateRange.value, 7));
  const dates = computed(() => {
    return groupedVisibleDateRange.value.map((row) => {
      return row.map((item, index) => {
        return __spreadProps(__spreadValues({}, item), {
          id: `${item.date}-${index}`
        });
      });
    });
  });
  return {
    dates,
    todaysDate,
    hasPastYear,
    hasFutureYear,
    hasPastMonth,
    hasFutureMonth
  };
};
var _hoisted_1$W = { class: "usa-date-picker__calendar__row" };
var _hoisted_2$q = { class: "usa-date-picker__calendar__cell usa-date-picker__calendar__cell--center-items" };
var _hoisted_3$f = ["aria-label", "disabled"];
var _hoisted_4$9 = { class: "usa-date-picker__calendar__cell usa-date-picker__calendar__cell--center-items" };
var _hoisted_5$6 = ["aria-label", "disabled"];
var _hoisted_6$5 = { class: "usa-date-picker__calendar__cell usa-date-picker__calendar__month-label" };
var _hoisted_7$2 = ["aria-label"];
var _hoisted_8$1 = ["aria-label"];
var _hoisted_9$1 = { class: "usa-date-picker__calendar__cell usa-date-picker__calendar__cell--center-items" };
var _hoisted_10$1 = ["aria-label", "disabled"];
var _hoisted_11$1 = { class: "usa-date-picker__calendar__cell usa-date-picker__calendar__cell--center-items" };
var _hoisted_12$1 = ["aria-label", "disabled"];
var _hoisted_13$1 = {
  class: "usa-date-picker__calendar__table",
  role: "presentation"
};
var _hoisted_14 = ["aria-label"];
var _hoisted_15 = ["disabled", "tabindex", "data-day", "data-month", "data-year", "data-value", "aria-label", "aria-selected", "onClick", "onMouseover", "onKeydown"];
var _sfc_main$16 = {
  __name: "UsaDatePickerCalendarDay",
  props: {
    selectedDate: {
      type: String,
      default: ""
    },
    activeDate: {
      type: String,
      required: true
    },
    minDate: {
      type: String,
      required: true
    },
    maxDate: {
      type: String,
      required: true
    },
    monthLabels: {
      type: Array,
      required: true
    },
    dayOfWeekLabels: {
      type: Array,
      required: true
    },
    dayOfWeekAbbreviationLabels: {
      type: Array,
      required: true
    },
    previousYearButtonLabel: {
      type: String,
      required: true
    },
    nextYearButtonLabel: {
      type: String,
      required: true
    },
    previousMonthButtonLabel: {
      type: String,
      required: true
    },
    nextMonthButtonLabel: {
      type: String,
      required: true
    },
    monthSelectionButtonLabel: {
      type: String,
      required: true
    },
    yearSelectionButtonLabel: {
      type: String,
      required: true
    },
    previousYearsButtonLabel: {
      type: String,
      required: true
    },
    nextYearsButtonLabel: {
      type: String,
      required: true
    }
  },
  emits: [
    "update:open",
    "update:selectedDate",
    "update:activeDate",
    "update:selectorMode",
    "update:highlightedDate",
    "update:isPristine"
  ],
  setup(__props, { emit }) {
    const props = __props;
    const inputHighlightedDate = inject("inputHighlightedDate");
    const isDateRange = inject("isDateRange", false);
    const dateRangeStart = inject("dateRangeStart", "");
    const dateRangeEnd = inject("dateRangeEnd", "");
    const rangeType = inject("rangeType", "");
    const dayDatePickerRef = ref(null);
    const dateButtonRefs = ref([]);
    const { activate, deactivate } = useFocusTrap(dayDatePickerRef, {
      immediate: true,
      clickOutsideDeactivates: true,
      initialFocus: ".usa-date-picker__calendar__date--focused",
      fallbackFocus: ".usa-date-picker__calendar__date-picker"
    });
    const selectedDate = computed({
      get() {
        return props.selectedDate;
      },
      set(newSelectedDate) {
        emit("update:selectedDate", newSelectedDate);
      }
    });
    const activeDate = computed({
      get() {
        return props.activeDate;
      },
      set(newActiveDate) {
        emit("update:activeDate", newActiveDate);
      }
    });
    const activeDateObject = shallowRef(parseIsoDate(activeDate.value));
    watch(activeDate, (newActiveDate) => {
      activeDateObject.value = parseIsoDate(newActiveDate);
    });
    const activeMonthIndex = computed(() => getMonthIndex(activeDateObject.value));
    const activeMonthLabel = computed(() => props.monthLabels[activeMonthIndex.value]);
    const activeYear = computed(() => getYear(activeDateObject.value));
    const {
      dates,
      hasPastMonth,
      hasFutureMonth,
      hasPastYear,
      hasFutureYear,
      todaysDate
    } = useDayPicker({
      activeDate,
      minDate: toRef(props, "minDate"),
      maxDate: toRef(props, "maxDate"),
      dayOfWeekLabels: toRef(props, "dayOfWeekLabels"),
      monthLabels: toRef(props, "monthLabels"),
      isDateRange,
      dateRangeStart,
      dateRangeEnd
    });
    const highlightedDate = ref(activeDate.value);
    const highlightedRowIndex = ref(null);
    const highlightedButtonIndex = ref(null);
    watch(selectedDate, (newSelectedDate) => {
      if (newSelectedDate) {
        highlightedDate.value = newSelectedDate;
        activeDate.value = newSelectedDate;
      }
    });
    const monthSelectionButtonLabel = computed(() => {
      return props.monthSelectionButtonLabel.replace("%s", activeMonthLabel.value);
    });
    const yearSelectionButtonLabel = computed(() => {
      return props.yearSelectionButtonLabel.replace("%s", activeYear.value);
    });
    const visibleDateRange = computed(() => toRaw(dates.value).flat());
    const tabIndex = (date, rowIndex, buttonIndex) => {
      if (date === highlightedDate.value || date === selectedDate.value || highlightedRowIndex.value === rowIndex && highlightedButtonIndex.value === buttonIndex) {
        return 0;
      }
      return -1;
    };
    const getButtonByDate = (date) => dateButtonRefs.value.find((button) => button.dataset.value === date);
    const setButtonFocusByDate = (date) => {
      const foundButton = getButtonByDate(date);
      if (foundButton) {
        foundButton.focus();
      }
    };
    const toPreviousMonth = () => {
      const previousMonth = isDateInRange(subMonths(activeDateObject.value, 1), parseIsoDate(props.minDate), parseIsoDate(props.maxDate)) ? subMonths(activeDateObject.value, 1) : parseIsoDate(props.minDate);
      activeDate.value = formatIsoDate(previousMonth);
    };
    const toNextMonth = () => {
      const nextMonth = isDateInRange(addMonths(activeDateObject.value, 1), parseIsoDate(props.minDate), parseIsoDate(props.maxDate)) ? addMonths(activeDateObject.value, 1) : parseIsoDate(props.maxDate);
      activeDate.value = formatIsoDate(nextMonth);
    };
    const toPreviousYear = () => {
      const previousYear = isDateInRange(subYears(activeDateObject.value, 1), parseIsoDate(props.minDate), parseIsoDate(props.maxDate)) ? subYears(activeDateObject.value, 1) : parseIsoDate(props.minDate);
      activeDate.value = formatIsoDate(previousYear);
    };
    const toNextYear = () => {
      const nextYear = isDateInRange(addYears(activeDateObject.value, 1), parseIsoDate(props.minDate), parseIsoDate(props.maxDate)) ? addYears(activeDateObject.value, 1) : parseIsoDate(props.maxDate);
      activeDate.value = formatIsoDate(nextYear);
    };
    const handlePreviousMonth = () => {
      const newDate = dates.value[highlightedRowIndex.value][highlightedButtonIndex.value].previousMonth;
      toPreviousMonth();
      highlightedDate.value = newDate;
    };
    const handleNextMonth = () => {
      const newDate = dates.value[highlightedRowIndex.value][highlightedButtonIndex.value].nextMonth;
      toNextMonth();
      highlightedDate.value = newDate;
    };
    const handlePreviousYear = () => {
      const previousYear = dates.value[highlightedRowIndex.value][highlightedButtonIndex.value].previousYear;
      toPreviousYear();
      highlightedDate.value = previousYear;
      nextTick(() => {
        if (isSameMonth(parseIsoDate(highlightedDate.value), parseIsoDate(props.minDate))) {
          setButtonFocusByDate(highlightedDate.value);
        }
      });
    };
    const handleNextYear = () => {
      const nextYear = dates.value[highlightedRowIndex.value][highlightedButtonIndex.value].nextYear;
      toNextYear();
      highlightedDate.value = nextYear;
      nextTick(() => {
        if (isSameMonth(parseIsoDate(highlightedDate.value), parseIsoDate(props.maxDate))) {
          setButtonFocusByDate(highlightedDate.value);
        }
      });
    };
    const handleClickOnDate = (date) => {
      selectedDate.value = date;
      highlightedDate.value = date;
      emit("update:open", false);
    };
    const handleHoverOnDate = (date) => {
      highlightedDate.value = date;
      const foundDate = visibleDateRange.value.find((item) => item.date === date);
      nextTick(() => {
        if (foundDate.isCurrentMonth) {
          setButtonFocusByDate(highlightedDate.value);
        }
      });
    };
    const handlePreviousDate = (date, to = null) => {
      if (!date) {
        return;
      }
      const foundDate = visibleDateRange.value.find((item) => item.date === date);
      if (!foundDate || !foundDate.isCurrentMonth) {
        if (!to || to === "month") {
          toPreviousMonth();
        } else if (to === "year") {
          toPreviousYear();
        }
      }
      highlightedDate.value = date;
      nextTick(() => {
        setButtonFocusByDate(date);
      });
    };
    const handleNextDate = (date, to = null) => {
      if (!date) {
        return;
      }
      const foundDate = visibleDateRange.value.find((item) => item.date === date);
      if (!foundDate || !foundDate.isCurrentMonth) {
        if (!to || to === "month") {
          toNextMonth();
        } else if (to === "year") {
          toNextYear();
        }
      }
      highlightedDate.value = date;
      nextTick(() => {
        setButtonFocusByDate(date);
      });
    };
    watch(highlightedDate, (newHighlightedDate) => {
      emit("update:highlightedDate", newHighlightedDate);
      nextTick(() => {
        if (visibleDateRange.value.some((item) => item.date === newHighlightedDate && item.isCurrentMonth) && isDateInRange(parseIsoDate(newHighlightedDate), parseIsoDate(props.minDate), parseIsoDate(props.maxDate))) {
          const newRowIndex = dates.value.findIndex((row) => row.find(({ date }) => date === newHighlightedDate));
          const newButtonIndex = dates.value[newRowIndex].findIndex(({ date }) => date === newHighlightedDate);
          highlightedRowIndex.value = newRowIndex;
          highlightedButtonIndex.value = newButtonIndex;
        }
      });
    }, { immediate: true });
    watch(inputHighlightedDate, (newHighlightedDate) => {
      highlightedDate.value = newHighlightedDate;
    });
    const stopWatchingHighlightedDate = watch(highlightedDate, () => {
      emit("update:isPristine", false);
      stopWatchingHighlightedDate();
    });
    onMounted(() => {
      activate();
    });
    onBeforeUnmount(() => {
      emit("update:isPristine", true);
      deactivate();
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        ref_key: "dayDatePickerRef",
        ref: dayDatePickerRef,
        tabindex: "-1",
        class: "usa-date-picker__calendar__date-picker"
      }, [
        createBaseVNode("div", _hoisted_1$W, [
          createBaseVNode("div", _hoisted_2$q, [
            createBaseVNode("button", {
              type: "button",
              class: "usa-date-picker__calendar__previous-year",
              "aria-label": __props.previousYearButtonLabel,
              disabled: !unref(hasPastYear),
              onClick: handlePreviousYear
            }, null, 8, _hoisted_3$f)
          ]),
          createBaseVNode("div", _hoisted_4$9, [
            createBaseVNode("button", {
              type: "button",
              class: "usa-date-picker__calendar__previous-month",
              "aria-label": __props.previousMonthButtonLabel,
              disabled: !unref(hasPastMonth),
              onClick: handlePreviousMonth
            }, null, 8, _hoisted_5$6)
          ]),
          createBaseVNode("div", _hoisted_6$5, [
            createBaseVNode("button", {
              type: "button",
              class: "usa-date-picker__calendar__month-selection",
              "aria-label": monthSelectionButtonLabel.value,
              onClick: _cache[0] || (_cache[0] = ($event) => emit("update:selectorMode", "month"))
            }, toDisplayString(activeMonthLabel.value), 9, _hoisted_7$2),
            createBaseVNode("button", {
              type: "button",
              class: "usa-date-picker__calendar__year-selection",
              "aria-label": yearSelectionButtonLabel.value,
              onClick: _cache[1] || (_cache[1] = ($event) => emit("update:selectorMode", "year"))
            }, toDisplayString(activeYear.value), 9, _hoisted_8$1)
          ]),
          createBaseVNode("div", _hoisted_9$1, [
            createBaseVNode("button", {
              type: "button",
              class: "usa-date-picker__calendar__next-month",
              "aria-label": __props.nextMonthButtonLabel,
              disabled: !unref(hasFutureMonth),
              onClick: handleNextMonth
            }, null, 8, _hoisted_10$1)
          ]),
          createBaseVNode("div", _hoisted_11$1, [
            createBaseVNode("button", {
              type: "button",
              class: "usa-date-picker__calendar__next-year",
              "aria-label": __props.nextYearButtonLabel,
              disabled: !unref(hasFutureYear),
              onClick: handleNextYear
            }, null, 8, _hoisted_12$1)
          ])
        ]),
        createBaseVNode("table", _hoisted_13$1, [
          createBaseVNode("thead", null, [
            createBaseVNode("tr", null, [
              (openBlock(true), createElementBlock(Fragment, null, renderList(__props.dayOfWeekLabels, (dayLabel, index) => {
                return openBlock(), createElementBlock("th", {
                  key: dayLabel,
                  class: "usa-date-picker__calendar__day-of-week",
                  scope: "presentation",
                  "aria-label": dayLabel
                }, toDisplayString(__props.dayOfWeekAbbreviationLabels[index]), 9, _hoisted_14);
              }), 128))
            ])
          ]),
          createBaseVNode("tbody", null, [
            (openBlock(true), createElementBlock(Fragment, null, renderList(unref(dates), (row, rowIndex) => {
              return openBlock(), createElementBlock("tr", {
                key: `${rowIndex}-${row.map(({ date }) => date).join("-")}`
              }, [
                (openBlock(true), createElementBlock(Fragment, null, renderList(row, (item, buttonIndex) => {
                  return openBlock(), createElementBlock("td", {
                    key: item.id
                  }, [
                    createBaseVNode("button", {
                      ref_for: true,
                      ref_key: "dateButtonRefs",
                      ref: dateButtonRefs,
                      type: "button",
                      disabled: item.disabled,
                      tabindex: tabIndex(item.date, rowIndex, buttonIndex),
                      class: normalizeClass(["usa-date-picker__calendar__date", {
                        "usa-date-picker__calendar__date--previous-month": item.isPreviousMonth,
                        "usa-date-picker__calendar__date--current-month": item.isCurrentMonth,
                        "usa-date-picker__calendar__date--next-month": item.isNextMonth,
                        "usa-date-picker__calendar__date--today": item.date === unref(todaysDate),
                        "usa-date-picker__calendar__date--selected": selectedDate.value === item.date,
                        "usa-date-picker__calendar__date--focused": highlightedRowIndex.value === rowIndex && highlightedButtonIndex.value === buttonIndex && item.isCurrentMonth,
                        "usa-date-picker__calendar__date--range-date": unref(isDateRange) && unref(dateRangeEnd) && unref(rangeType) === "start" && item.date === unref(dateRangeEnd) || unref(isDateRange) && unref(dateRangeStart) && unref(rangeType) === "end" && item.date === unref(dateRangeStart),
                        "usa-date-picker__calendar__date--within-range": unref(isDateRange) && unref(dateRangeStart) && unref(dateRangeEnd) && item.isInCurrentRange || unref(isDateRange) && unref(dateRangeStart) && !unref(dateRangeEnd) && item.date > unref(dateRangeStart) && item.date < highlightedDate.value || unref(isDateRange) && unref(dateRangeEnd) && !unref(dateRangeStart) && item.date < unref(dateRangeEnd) && item.date > highlightedDate.value,
                        "usa-date-picker__calendar__date--range-date-start": unref(isDateRange) && unref(dateRangeStart) && item.date === unref(dateRangeStart) || unref(isDateRange) && unref(dateRangeEnd) && item.date !== unref(dateRangeEnd) && unref(rangeType) === "start" && !unref(dateRangeStart) && highlightedRowIndex.value === rowIndex && highlightedButtonIndex.value === buttonIndex && item.isCurrentMonth,
                        "usa-date-picker__calendar__date--range-date-end": unref(isDateRange) && unref(dateRangeEnd) && item.date === unref(dateRangeEnd) || unref(isDateRange) && unref(dateRangeStart) && item.date !== unref(dateRangeStart) && unref(rangeType) === "end" && !unref(dateRangeEnd) && highlightedRowIndex.value === rowIndex && highlightedButtonIndex.value === buttonIndex && item.isCurrentMonth
                      }]),
                      "data-day": item.day,
                      "data-month": item.month,
                      "data-year": item.year,
                      "data-value": item.date,
                      "aria-label": item.label,
                      "aria-selected": selectedDate.value === item.date,
                      onClick: ($event) => handleClickOnDate(item.date),
                      onMouseover: ($event) => handleHoverOnDate(item.date),
                      onKeydown: [
                        withKeys(withModifiers(($event) => handlePreviousDate(item.up), ["prevent"]), ["up"]),
                        withKeys(withModifiers(($event) => handleNextDate(item.down), ["prevent"]), ["down"]),
                        withKeys(withModifiers(($event) => handlePreviousDate(item.left), ["prevent"]), ["left"]),
                        withKeys(withModifiers(($event) => handleNextDate(item.right), ["prevent"]), ["right"]),
                        withKeys(withModifiers(($event) => handlePreviousDate(item.home), ["prevent"]), ["home"]),
                        withKeys(withModifiers(($event) => handleNextDate(item.end), ["prevent"]), ["end"]),
                        withKeys(withModifiers(($event) => handlePreviousDate(item.pageUp, "month"), ["prevent", "exact"]), ["page-up"]),
                        withKeys(withModifiers(($event) => handleNextDate(item.pageDown, "month"), ["prevent", "exact"]), ["page-down"]),
                        withKeys(withModifiers(($event) => handlePreviousDate(item.shiftPageUp, "year"), ["prevent", "shift"]), ["page-up"]),
                        withKeys(withModifiers(($event) => handleNextDate(item.shiftPageDown, "year"), ["prevent", "shift"]), ["page-down"])
                      ]
                    }, toDisplayString(item.day), 43, _hoisted_15)
                  ]);
                }), 128))
              ]);
            }), 128))
          ])
        ])
      ], 512);
    };
  }
};
var useMonthPicker = ({
  activeYear,
  monthLabels,
  minDate: minDate$1,
  maxDate: maxDate$1
}) => {
  const minDateObject = shallowRef(parseIsoDate(minDate$1.value));
  const maxDateObject = shallowRef(parseIsoDate(maxDate$1.value));
  watch(minDate$1, (newMinDate) => minDateObject.value = parseIsoDate(newMinDate));
  watch(maxDate$1, (newMaxDate) => maxDateObject.value = parseIsoDate(newMaxDate));
  const minMonthOfActiveYear = computed(() => {
    const activeDateObject = parseIsoDate(`${activeYear.value}-01-01`);
    const startOfActiveYear = startOfYear(activeDateObject);
    const minDateOfActiveYear = maxDate([startOfActiveYear, minDateObject.value]);
    return minDateOfActiveYear.getMonth();
  });
  const maxMonthOfActiveYear = computed(() => {
    const activeDateObject = parseIsoDate(`${activeYear.value}-01-01`);
    const startOfActiveYear = startOfYear(activeDateObject);
    const endOfActiveYear = endOfYear(startOfActiveYear);
    const maxDateOfActiveYear = minDate([endOfActiveYear, maxDateObject.value]);
    return maxDateOfActiveYear.getMonth();
  });
  const validMonthRangeOfActiveYear = computed(() => {
    const validMonthRange = [];
    for (let i = minMonthOfActiveYear.value; i <= maxMonthOfActiveYear.value; i++) {
      validMonthRange.push(i + 1);
    }
    return validMonthRange;
  });
  const isMonthInRange = (month) => validMonthRangeOfActiveYear.value.includes(month);
  const findClosestPastMonth = (start, stop) => {
    for (let index = start; index <= stop; index++) {
      if (isMonthInRange(index)) {
        return index;
      }
    }
    return null;
  };
  const findClosestFutureMonth = (start, stop) => {
    for (let index = start; index >= stop; index--) {
      if (isMonthInRange(index)) {
        return index;
      }
    }
    return null;
  };
  const monthsOfYear = computed(() => Object.keys(monthLabels.value).map((index) => parseInt(index, 10) + 1));
  const groupedMonthRange = computed(() => splitArray(monthsOfYear.value, 3));
  const months = computed(() => groupedMonthRange.value.map((row) => row.map((monthValue, index) => {
    return {
      month: monthValue,
      label: monthLabels.value[monthValue - 1],
      id: `${monthValue}-${index}`,
      disabled: !isMonthInRange(monthValue),
      left: isMonthInRange(monthValue - 1) ? monthValue - 1 : null,
      right: isMonthInRange(monthValue + 1) ? monthValue + 1 : null,
      up: isMonthInRange(monthValue - 3) ? monthValue - 3 : isMonthInRange(monthValue - 1) ? monthValue - 1 : null,
      down: isMonthInRange(monthValue + 3) ? monthValue + 3 : isMonthInRange(monthValue + 1) ? monthValue + 1 : null,
      home: row.find((monthValue2) => isMonthInRange(monthValue2)) || null,
      end: [...row].reverse().find((monthValue2) => isMonthInRange(monthValue2)) || null,
      pageUp: findClosestPastMonth(1, monthValue),
      pageDown: findClosestFutureMonth(12, monthValue)
    };
  })));
  const findRowIndexByMonth = (months2, monthToFind) => {
    const rowIndex = months2.value.findIndex((row) => row.find(({ month }) => month === monthToFind));
    return rowIndex;
  };
  const findButtonIndexByMonth = (months2, rowIndex, monthToFind) => {
    const buttonIndex = months2.value[rowIndex].findIndex(({ month }) => month === monthToFind);
    return buttonIndex;
  };
  return {
    months,
    findRowIndexByMonth,
    findButtonIndexByMonth
  };
};
var _hoisted_1$V = {
  class: "usa-date-picker__calendar__table",
  role: "presentation"
};
var _hoisted_2$p = ["disabled", "tabindex", "data-value", "data-label", "aria-selected", "onClick", "onMouseover", "onKeydown"];
var _sfc_main$15 = {
  __name: "UsaDatePickerCalendarMonth",
  props: {
    activeDate: {
      type: String,
      required: true
    },
    monthLabels: {
      type: Array,
      required: true
    },
    minDate: {
      type: String,
      required: true
    },
    maxDate: {
      type: String,
      required: true
    }
  },
  emits: ["update:activeMonth", "update:selectorMode"],
  setup(__props, { emit }) {
    const props = __props;
    const monthDatePickerRef = ref(null);
    const monthButtonRefs = ref([]);
    const { activate, deactivate } = useFocusTrap(monthDatePickerRef, {
      immediate: true,
      clickOutsideDeactivates: true,
      initialFocus: ".usa-date-picker__calendar__month--focused",
      fallbackFocus: ".usa-date-picker__calendar__date-picker"
    });
    const activeDateObject = shallowRef(parseIsoDate(props.activeDate));
    watch(toRef(props, "activeDate"), (newActiveDate) => activeDateObject.value = parseIsoDate(newActiveDate));
    const activeMonth = computed(() => getMonth(activeDateObject.value));
    const activeYear = computed(() => getYear(activeDateObject.value));
    const { months, findRowIndexByMonth, findButtonIndexByMonth } = useMonthPicker({
      activeYear,
      monthLabels: toRef(props, "monthLabels"),
      minDate: toRef(props, "minDate"),
      maxDate: toRef(props, "maxDate")
    });
    const highlightedMonth = ref(activeMonth.value);
    const highlightedRowIndex = ref(null);
    const highlightedButtonIndex = ref(null);
    const tabIndex = (month, rowIndex, buttonIndex) => {
      if (month === highlightedMonth.value || month === activeMonth.value || highlightedRowIndex.value === rowIndex && highlightedButtonIndex.value === buttonIndex) {
        return 0;
      }
      return -1;
    };
    const getButtonByMonth = (month) => monthButtonRefs.value.find((button) => parseInt(button.dataset.value, 10) === month);
    const setButtonFocusByMonth = (month) => {
      const foundButton = getButtonByMonth(month);
      if (foundButton) {
        foundButton.focus();
      }
    };
    const handleClickOnMonth = (month) => {
      emit("update:activeMonth", month);
      emit("update:selectorMode", "day");
    };
    const handleHoverOnMonth = (month) => {
      highlightedMonth.value = month;
      setButtonFocusByMonth(highlightedMonth.value);
    };
    const handlePreviousMonth = (month) => {
      if (!month) {
        return;
      }
      highlightedMonth.value = month;
      setButtonFocusByMonth(month);
    };
    const handleNextMonth = (month) => {
      if (!month) {
        return;
      }
      highlightedMonth.value = month;
      setButtonFocusByMonth(month);
    };
    watch(highlightedMonth, (newHighlightedMonth) => {
      const newRowIndex = findRowIndexByMonth(months, newHighlightedMonth);
      const newButtonIndex = findButtonIndexByMonth(months, newRowIndex, newHighlightedMonth);
      highlightedRowIndex.value = newRowIndex;
      highlightedButtonIndex.value = newButtonIndex;
    }, { immediate: true });
    onMounted(() => {
      activate();
    });
    onBeforeUnmount(() => {
      deactivate();
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        ref_key: "monthDatePickerRef",
        ref: monthDatePickerRef,
        tabindex: "-1",
        class: "usa-date-picker__calendar__month-picker"
      }, [
        createBaseVNode("table", _hoisted_1$V, [
          createBaseVNode("tbody", null, [
            (openBlock(true), createElementBlock(Fragment, null, renderList(unref(months), (row, rowIndex) => {
              return openBlock(), createElementBlock("tr", {
                key: `${rowIndex}-${row.map(({ month }) => month).join("-")}`
              }, [
                (openBlock(true), createElementBlock(Fragment, null, renderList(row, (item, buttonIndex) => {
                  return openBlock(), createElementBlock("td", {
                    key: item.id
                  }, [
                    createBaseVNode("button", {
                      ref_for: true,
                      ref_key: "monthButtonRefs",
                      ref: monthButtonRefs,
                      type: "button",
                      disabled: item.disabled,
                      tabindex: tabIndex(item.month, rowIndex, buttonIndex),
                      class: normalizeClass(["usa-date-picker__calendar__month", {
                        "usa-date-picker__calendar__month--selected": activeMonth.value === item.month,
                        "usa-date-picker__calendar__month--focused": highlightedRowIndex.value === rowIndex && highlightedButtonIndex.value === buttonIndex
                      }]),
                      "data-value": item.month,
                      "data-label": item.label,
                      "aria-selected": activeMonth.value === item.month,
                      onClick: ($event) => handleClickOnMonth(item.month),
                      onMouseover: ($event) => handleHoverOnMonth(item.month),
                      onKeydown: [
                        withKeys(withModifiers(($event) => handlePreviousMonth(item.up), ["prevent"]), ["up"]),
                        withKeys(withModifiers(($event) => handleNextMonth(item.down), ["prevent"]), ["down"]),
                        withKeys(withModifiers(($event) => handlePreviousMonth(item.left), ["prevent"]), ["left"]),
                        withKeys(withModifiers(($event) => handleNextMonth(item.right), ["prevent"]), ["right"]),
                        withKeys(withModifiers(($event) => handlePreviousMonth(item.home), ["prevent"]), ["home"]),
                        withKeys(withModifiers(($event) => handleNextMonth(item.end), ["prevent"]), ["end"]),
                        withKeys(withModifiers(($event) => handlePreviousMonth(item.pageUp), ["prevent"]), ["page-up"]),
                        withKeys(withModifiers(($event) => handleNextMonth(item.pageDown), ["prevent"]), ["page-down"])
                      ]
                    }, toDisplayString(item.label), 43, _hoisted_2$p)
                  ]);
                }), 128))
              ]);
            }), 128))
          ])
        ])
      ], 512);
    };
  }
};
var useYearPicker = ({ minDate: minDate2, maxDate: maxDate2, activeYear }) => {
  const minYear = computed(() => getYear(parseIsoDate(minDate2.value)));
  const maxYear = computed(() => getYear(parseIsoDate(maxDate2.value)));
  const isYearInRange = (year) => year >= minYear.value && year <= maxYear.value;
  const findClosestPastYear = (start, stop) => {
    for (let index = start; index <= stop; index++) {
      if (isYearInRange(index)) {
        return index;
      }
    }
    return null;
  };
  const findClosestFutureYear = (start, stop) => {
    for (let index = start; index >= stop; index--) {
      if (isYearInRange(index)) {
        return index;
      }
    }
    return null;
  };
  const yearToGroup = computed(() => Math.max(0, activeYear.value - activeYear.value % YEAR_GROUP));
  const visibleYearRange = computed(() => {
    const years2 = [];
    let yearIndex = yearToGroup.value;
    while (years2.length < YEAR_GROUP) {
      years2.push(yearIndex);
      yearIndex += 1;
    }
    return years2;
  });
  const groupedVisibleYearRange = computed(() => splitArray(visibleYearRange.value, 3));
  const years = computed(() => groupedVisibleYearRange.value.map((row) => row.map((year, index) => {
    return {
      year,
      id: `${year}-${index}`,
      disabled: !isYearInRange(year),
      left: isYearInRange(year - 1) ? year - 1 : null,
      right: isYearInRange(year + 1) ? year + 1 : null,
      up: isYearInRange(year - 3) ? year - 3 : null,
      down: isYearInRange(year + 3) ? year + 3 : null,
      home: row.find((year2) => isYearInRange(year2)) || null,
      end: [...row].reverse().find((year2) => isYearInRange(year2)) || null,
      pageUp: findClosestPastYear(year - YEAR_GROUP, year),
      pageDown: findClosestFutureYear(year + YEAR_GROUP, year)
    };
  })));
  const firstVisibleYear = computed(() => visibleYearRange.value[0]);
  const lastVisibleYear = computed(() => visibleYearRange.value[visibleYearRange.value.length - 1]);
  const hasPastYear = computed(() => isYearInRange(firstVisibleYear.value - 1));
  const hasFutureYear = computed(() => isYearInRange(lastVisibleYear.value + 1));
  const firstAvailableVisibleYear = computed(() => findClosestPastYear(firstVisibleYear.value, lastVisibleYear.value));
  const lastAvailableVisibleYear = computed(() => findClosestFutureYear(lastVisibleYear.value, firstVisibleYear.value));
  const isYearAvailable = (year) => {
    return year >= firstAvailableVisibleYear.value && year <= lastAvailableVisibleYear.value;
  };
  const findRowIndexByYear = (years2, yearToFind) => {
    const rowIndex = years2.value.findIndex((row) => row.find(({ year }) => year === yearToFind));
    return rowIndex;
  };
  const findButtonIndexByYear = (years2, rowIndex, yearToFind) => {
    const buttonIndex = years2.value[rowIndex].findIndex(({ year }) => year === yearToFind);
    return buttonIndex;
  };
  return {
    years,
    visibleYearRange,
    firstAvailableVisibleYear,
    lastAvailableVisibleYear,
    isYearAvailable,
    hasPastYear,
    hasFutureYear,
    findRowIndexByYear,
    findButtonIndexByYear
  };
};
var _hoisted_1$U = {
  role: "presentation",
  class: "usa-date-picker__calendar__table"
};
var _hoisted_2$o = ["aria-label", "disabled"];
var _hoisted_3$e = { colspan: "3" };
var _hoisted_4$8 = {
  class: "usa-date-picker__calendar__table",
  role: "presentation"
};
var _hoisted_5$5 = ["disabled", "tabindex", "data-value", "aria-selected", "onClick", "onMouseover", "onKeydown"];
var _hoisted_6$4 = ["aria-label", "disabled"];
var _sfc_main$14 = {
  __name: "UsaDatePickerCalendarYear",
  props: {
    selectedYear: {
      type: Number,
      required: true
    },
    activeDate: {
      type: String,
      required: true
    },
    minDate: {
      type: String,
      required: true
    },
    maxDate: {
      type: String,
      required: true
    },
    previousYearsButtonLabel: {
      type: String,
      required: true
    },
    nextYearsButtonLabel: {
      type: String,
      required: true
    }
  },
  emits: [
    "update:selectedYear",
    "update:selectorMode",
    "update:activeYearStart",
    "update:activeYearEnd"
  ],
  setup(__props, { emit }) {
    const props = __props;
    const yearDatePickerRef = ref(null);
    const yearButtonRefs = ref([]);
    const { activate, deactivate } = useFocusTrap(yearDatePickerRef, {
      immediate: true,
      clickOutsideDeactivates: true,
      initialFocus: ".usa-date-picker__calendar__year--focused",
      fallbackFocus: ".usa-date-picker__calendar__date-picker"
    });
    const activeDateObject = shallowRef(parseIsoDate(props.activeDate));
    watch(toRef(props, "activeDate"), (newActiveDate) => activeDateObject.value = parseIsoDate(newActiveDate));
    const activeYear = computed({
      get() {
        return getYear(activeDateObject.value);
      },
      set(newYear) {
        activeDateObject.value = setYear(activeDateObject.value, newYear);
      }
    });
    const {
      years,
      visibleYearRange,
      firstAvailableVisibleYear,
      lastAvailableVisibleYear,
      isYearAvailable,
      hasPastYear,
      hasFutureYear,
      findRowIndexByYear,
      findButtonIndexByYear
    } = useYearPicker({
      minDate: toRef(props, "minDate"),
      maxDate: toRef(props, "maxDate"),
      activeYear
    });
    watch(firstAvailableVisibleYear, () => emit("update:activeYearStart", firstAvailableVisibleYear.value), {
      immediate: true
    });
    watch(lastAvailableVisibleYear, () => emit("update:activeYearEnd", lastAvailableVisibleYear.value), {
      immediate: true
    });
    const currentSelectedYear = computed({
      get() {
        return props.selectedYear;
      },
      set(newSelectedYear) {
        emit("update:selectedYear", newSelectedYear);
      }
    });
    const highlightedYear = ref(activeYear.value);
    const highlightedRowIndex = ref(null);
    const highlightedButtonIndex = ref(null);
    const tabIndex = (year, rowIndex, buttonIndex) => {
      if (year === highlightedYear.value || year === currentSelectedYear.value || highlightedRowIndex.value === rowIndex && highlightedButtonIndex.value === buttonIndex) {
        return 0;
      }
      return -1;
    };
    const getButtonByYear = (year) => yearButtonRefs.value.find((button) => parseInt(button.dataset.value, 10) === year);
    const setButtonFocusByYear = (year) => {
      const foundButton = getButtonByYear(year);
      if (foundButton) {
        foundButton.focus();
      }
    };
    const toPreviousYears = () => {
      activeYear.value = activeYear.value - YEAR_GROUP;
    };
    const toNextYears = () => {
      activeYear.value = activeYear.value + YEAR_GROUP;
    };
    const handleClickOnYear = (year) => {
      currentSelectedYear.value = year;
      emit("update:selectorMode", "day");
    };
    const handleHoverOnYear = (year) => {
      highlightedYear.value = year;
      setButtonFocusByYear(highlightedYear.value);
    };
    const handlePreviousYear = (year) => {
      if (!year) {
        return;
      }
      if (!visibleYearRange.value.includes(year)) {
        toPreviousYears();
      }
      nextTick(() => {
        highlightedYear.value = year;
        setButtonFocusByYear(year);
      });
    };
    const handleNextYear = (year) => {
      if (!year) {
        return;
      }
      if (!visibleYearRange.value.includes(year)) {
        toNextYears();
      }
      nextTick(() => {
        highlightedYear.value = year;
        setButtonFocusByYear(year);
      });
    };
    watch(highlightedYear, (newHighlightedYear) => {
      if (visibleYearRange.value.includes(newHighlightedYear) && isYearAvailable(newHighlightedYear)) {
        const newRowIndex = findRowIndexByYear(years, newHighlightedYear);
        const newButtonIndex = findButtonIndexByYear(years, newRowIndex, newHighlightedYear);
        highlightedRowIndex.value = newRowIndex;
        highlightedButtonIndex.value = newButtonIndex;
      }
    }, { immediate: true });
    watch(years, (newVisibleYears, oldVisibleYear) => {
      if (newVisibleYears[highlightedRowIndex.value][highlightedButtonIndex.value].disabled) {
        const wantedYear = newVisibleYears[0][0].year < oldVisibleYear[0][0].year ? firstAvailableVisibleYear.value : lastAvailableVisibleYear.value;
        const newRowIndex = findRowIndexByYear(years, wantedYear);
        if (newRowIndex === -1) {
          return;
        }
        const newButtonIndex = findButtonIndexByYear(years, newRowIndex, wantedYear);
        highlightedYear.value = newVisibleYears[newRowIndex][newButtonIndex].year;
      }
    });
    onMounted(() => {
      activate();
    });
    onBeforeUnmount(() => {
      emit("update:activeYearStart", "");
      emit("update:activeYearEnd", "");
      deactivate();
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        ref_key: "yearDatePickerRef",
        ref: yearDatePickerRef,
        tabindex: "-1",
        class: "usa-date-picker__calendar__year-picker"
      }, [
        createBaseVNode("table", _hoisted_1$U, [
          createBaseVNode("tbody", null, [
            createBaseVNode("tr", null, [
              createBaseVNode("td", null, [
                createBaseVNode("button", {
                  type: "button",
                  class: "usa-date-picker__calendar__previous-year-chunk",
                  "aria-label": __props.previousYearsButtonLabel,
                  disabled: !unref(hasPastYear),
                  onClick: toPreviousYears
                }, " ", 8, _hoisted_2$o)
              ]),
              createBaseVNode("td", _hoisted_3$e, [
                createBaseVNode("table", _hoisted_4$8, [
                  createBaseVNode("tbody", null, [
                    (openBlock(true), createElementBlock(Fragment, null, renderList(unref(years), (row, rowIndex) => {
                      return openBlock(), createElementBlock("tr", {
                        key: `${rowIndex}-${row.map(({ year }) => year).join("-")}`
                      }, [
                        (openBlock(true), createElementBlock(Fragment, null, renderList(row, (item, buttonIndex) => {
                          return openBlock(), createElementBlock("td", {
                            key: item.id
                          }, [
                            createBaseVNode("button", {
                              ref_for: true,
                              ref_key: "yearButtonRefs",
                              ref: yearButtonRefs,
                              type: "button",
                              disabled: item.disabled,
                              tabindex: tabIndex(item.year, rowIndex, buttonIndex),
                              class: normalizeClass(["usa-date-picker__calendar__year", {
                                "usa-date-picker__calendar__year--selected": currentSelectedYear.value === item.year,
                                "usa-date-picker__calendar__year--focused": highlightedRowIndex.value === rowIndex && highlightedButtonIndex.value === buttonIndex
                              }]),
                              "data-value": item.year,
                              "aria-selected": currentSelectedYear.value === item.year,
                              onClick: ($event) => handleClickOnYear(item.year),
                              onMouseover: ($event) => handleHoverOnYear(item.year),
                              onKeydown: [
                                withKeys(withModifiers(($event) => handlePreviousYear(item.up), ["prevent"]), ["up"]),
                                withKeys(withModifiers(($event) => handleNextYear(item.down), ["prevent"]), ["down"]),
                                withKeys(withModifiers(($event) => handlePreviousYear(item.left), ["prevent"]), ["left"]),
                                withKeys(withModifiers(($event) => handleNextYear(item.right), ["prevent"]), ["right"]),
                                withKeys(withModifiers(($event) => handlePreviousYear(item.home), ["prevent"]), ["home"]),
                                withKeys(withModifiers(($event) => handleNextYear(item.end), ["prevent"]), ["end"]),
                                withKeys(withModifiers(($event) => handlePreviousYear(item.pageUp), ["prevent"]), ["page-up"]),
                                withKeys(withModifiers(($event) => handleNextYear(item.pageDown), ["prevent"]), ["page-down"])
                              ]
                            }, toDisplayString(item.year), 43, _hoisted_5$5)
                          ]);
                        }), 128))
                      ]);
                    }), 128))
                  ])
                ])
              ]),
              createBaseVNode("td", null, [
                createBaseVNode("button", {
                  type: "button",
                  class: "usa-date-picker__calendar__next-year-chunk",
                  "aria-label": __props.nextYearsButtonLabel,
                  disabled: !unref(hasFutureYear),
                  onClick: toNextYears
                }, " ", 8, _hoisted_6$4)
              ])
            ])
          ])
        ])
      ], 512);
    };
  }
};
var _hoisted_1$T = ["data-value", "hidden"];
var _sfc_main$13 = {
  __name: "UsaDatePickerCalendar",
  props: {
    open: {
      type: Boolean,
      default: false
    },
    selectedDate: {
      type: String,
      default: ""
    },
    activeDate: {
      type: String,
      required: true
    },
    highlightedDate: {
      type: String,
      default: ""
    },
    minDate: {
      type: String,
      required: true
    },
    maxDate: {
      type: String,
      required: true
    },
    selectorMode: {
      type: String,
      required: true
    },
    monthLabels: {
      type: Array,
      required: true
    },
    dayOfWeekLabels: {
      type: Array,
      required: true
    },
    dayOfWeekAbbreviationLabels: {
      type: Array,
      required: true
    },
    previousYearButtonLabel: {
      type: String,
      required: true
    },
    nextYearButtonLabel: {
      type: String,
      required: true
    },
    previousMonthButtonLabel: {
      type: String,
      required: true
    },
    nextMonthButtonLabel: {
      type: String,
      required: true
    },
    monthSelectionButtonLabel: {
      type: String,
      required: true
    },
    yearSelectionButtonLabel: {
      type: String,
      required: true
    },
    previousYearsButtonLabel: {
      type: String,
      required: true
    },
    nextYearsButtonLabel: {
      type: String,
      required: true
    }
  },
  emits: [
    "update:open",
    "update:selectedDate",
    "update:activeDate",
    "update:selectorMode",
    "update:highlightedDate",
    "update:activeYearStart",
    "update:activeYearEnd",
    "update:isPristine"
  ],
  setup(__props, { emit }) {
    const props = __props;
    const calendarPickerRef = ref(null);
    const open = computed({
      get() {
        return props.open;
      },
      set(isOpen) {
        emit("update:open", isOpen);
      }
    });
    const selectorMode = computed({
      get() {
        return props.selectorMode;
      },
      set(newMode) {
        emit("update:selectorMode", newMode);
      }
    });
    const activeDate = computed({
      get() {
        return props.activeDate;
      },
      set(newActiveDate) {
        emit("update:activeDate", newActiveDate);
      }
    });
    const activeDateObject = shallowRef(parseIsoDate(activeDate.value));
    watch(activeDate, (newActiveDate) => {
      activeDateObject.value = parseIsoDate(newActiveDate);
    });
    const activeYear = computed({
      get() {
        return getYear(activeDateObject.value);
      },
      set(newYear) {
        const newDate = setYear(activeDateObject.value, newYear);
        const minimumDate = parseIsoDate(props.minDate);
        const maximumDate = parseIsoDate(props.maxDate);
        if (isDateInRange(newDate, minimumDate, maximumDate)) {
          activeDate.value = formatIsoDate(newDate);
        } else {
          const isAfter2 = isDateAfter(activeDateObject.value, newDate);
          activeDate.value = isAfter2 ? formatIsoDate(minimumDate) : formatIsoDate(maximumDate);
        }
      }
    });
    const highlightedDate = computed({
      get() {
        return props.highlightedDate;
      },
      set(newHighlightedDate) {
        emit("update:highlightedDate", newHighlightedDate);
      }
    });
    const selectMonth = (newMonth) => {
      activeDate.value = formatIsoDate(setMonth(parseIsoDate(highlightedDate.value), newMonth));
    };
    const selectedDate = computed({
      get() {
        return props.selectedDate;
      },
      set(newDate) {
        emit("update:selectedDate", newDate);
      }
    });
    watch(selectedDate, (newSelectedDate) => {
      if (!newSelectedDate) {
        return;
      }
      const newDate = parseIsoDate(newSelectedDate);
      const minimumDate = parseIsoDate(props.minDate);
      const maximumDate = parseIsoDate(props.maxDate);
      if (isDateInRange(newDate, minimumDate, maximumDate)) {
        activeDate.value = formatIsoDate(newDate);
      }
    });
    onMounted(() => {
      emit("update:activeDate", activeDate.value);
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        ref_key: "calendarPickerRef",
        ref: calendarPickerRef,
        class: "usa-date-picker__calendar",
        role: "dialog",
        "aria-modal": "true",
        "data-value": highlightedDate.value,
        hidden: !open.value
      }, [
        open.value ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
          selectorMode.value === "day" ? (openBlock(), createBlock(unref(_sfc_main$16), {
            key: 0,
            "selected-date": selectedDate.value,
            "onUpdate:selectedDate": _cache[0] || (_cache[0] = ($event) => selectedDate.value = $event),
            "active-date": activeDate.value,
            "onUpdate:activeDate": _cache[1] || (_cache[1] = ($event) => activeDate.value = $event),
            "min-date": __props.minDate,
            "max-date": __props.maxDate,
            "month-labels": __props.monthLabels,
            "day-of-week-labels": __props.dayOfWeekLabels,
            "day-of-week-abbreviation-labels": __props.dayOfWeekAbbreviationLabels,
            "previous-year-button-label": __props.previousYearButtonLabel,
            "next-year-button-label": __props.nextYearButtonLabel,
            "previous-month-button-label": __props.previousMonthButtonLabel,
            "next-month-button-label": __props.nextMonthButtonLabel,
            "month-selection-button-label": __props.monthSelectionButtonLabel,
            "year-selection-button-label": __props.yearSelectionButtonLabel,
            "previous-years-button-label": __props.previousYearsButtonLabel,
            "next-years-button-label": __props.nextYearsButtonLabel,
            "onUpdate:open": _cache[2] || (_cache[2] = (isOpen) => open.value = isOpen),
            "onUpdate:selectorMode": _cache[3] || (_cache[3] = (newMode) => selectorMode.value = newMode),
            "onUpdate:highlightedDate": _cache[4] || (_cache[4] = (newDate) => highlightedDate.value = newDate),
            "onUpdate:isPristine": _cache[5] || (_cache[5] = (currentlyPristine) => _ctx.$emit("update:isPristine", currentlyPristine))
          }, null, 8, ["selected-date", "active-date", "min-date", "max-date", "month-labels", "day-of-week-labels", "day-of-week-abbreviation-labels", "previous-year-button-label", "next-year-button-label", "previous-month-button-label", "next-month-button-label", "month-selection-button-label", "year-selection-button-label", "previous-years-button-label", "next-years-button-label"])) : createCommentVNode("", true),
          selectorMode.value === "month" ? (openBlock(), createBlock(unref(_sfc_main$15), {
            key: 1,
            "active-date": activeDate.value,
            "month-labels": __props.monthLabels,
            "min-date": __props.minDate,
            "max-date": __props.maxDate,
            "onUpdate:selectorMode": _cache[6] || (_cache[6] = (newMode) => selectorMode.value = newMode),
            "onUpdate:activeMonth": selectMonth
          }, null, 8, ["active-date", "month-labels", "min-date", "max-date"])) : createCommentVNode("", true),
          selectorMode.value === "year" ? (openBlock(), createBlock(unref(_sfc_main$14), {
            key: 2,
            "selected-year": activeYear.value,
            "onUpdate:selectedYear": _cache[7] || (_cache[7] = ($event) => activeYear.value = $event),
            "active-date": activeDate.value,
            "min-date": __props.minDate,
            "max-date": __props.maxDate,
            "previous-years-button-label": __props.previousYearsButtonLabel,
            "next-years-button-label": __props.nextYearsButtonLabel,
            "onUpdate:selectorMode": _cache[8] || (_cache[8] = (newMode) => selectorMode.value = newMode),
            "onUpdate:activeYearStart": _cache[9] || (_cache[9] = (newStartYear) => _ctx.$emit("update:activeYearStart", newStartYear)),
            "onUpdate:activeYearEnd": _cache[10] || (_cache[10] = (newEndYear) => _ctx.$emit("update:activeYearEnd", newEndYear))
          }, null, 8, ["selected-year", "active-date", "min-date", "max-date", "previous-years-button-label", "next-years-button-label"])) : createCommentVNode("", true)
        ], 64)) : createCommentVNode("", true)
      ], 8, _hoisted_1$T);
    };
  }
};
var _hoisted_1$S = ["id"];
var _hoisted_2$n = ["id"];
var _hoisted_3$d = ["id", "required", "disabled", "readonly", "aria-labelledby", "aria-describedby"];
var _hoisted_4$7 = ["aria-label", "disabled"];
var _hoisted_5$4 = {
  class: "usa-date-picker__status usa-sr-only",
  role: "status",
  "aria-live": "polite"
};
var __default__$b = {
  inheritAttrs: false
};
var _sfc_main$12 = Object.assign(__default__$b, {
  __name: "UsaDatePicker",
  props: {
    minDate: {
      type: String,
      default: MIN_DATE
    },
    maxDate: {
      type: String,
      default: MAX_DATE
    },
    modelValue: {
      type: String,
      default: ""
    },
    rangeType: {
      type: String,
      default: "",
      validator(rangeType) {
        const isValidRangeType = rangeType === "" || rangeType === "start" || rangeType === "end";
        if (!isValidRangeType) {
          console.warn(`'${rangeType}' is an invalid range type. Range must be empty, 'start', or 'end'.`);
        }
        return isValidRangeType;
      }
    },
    label: {
      type: String,
      default: ""
    },
    required: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    readonly: {
      type: Boolean,
      default: false
    },
    error: {
      type: Boolean,
      default: false
    },
    id: {
      type: String,
      default: ""
    },
    dayOfWeekLabels: {
      type: Array,
      default: () => DAY_OF_WEEK_LABELS,
      validator(dayLabels) {
        const totalLabels = dayLabels.length;
        const isValidDayLabelsLength = dayLabels.length === 7;
        if (!isValidDayLabelsLength) {
          console.warn(`Missing labels, there must be a label for each day of the week. 7 total are needed but only ${totalLabels} were given.`);
        }
        return isValidDayLabelsLength;
      }
    },
    dayOfWeekAbbreviationLabels: {
      type: Array,
      default: () => DAY_OF_WEEK_ABBREVIATION_LABELS,
      validator(dayLabels) {
        const totalLabels = dayLabels.length;
        const isValidDayLabelsLength = dayLabels.length === 7;
        if (!isValidDayLabelsLength) {
          console.warn(`Missing labels, there must be a label for each day of the week. 7 total are needed but only ${totalLabels} were given.`);
        }
        return isValidDayLabelsLength;
      }
    },
    monthLabels: {
      type: Array,
      default: () => MONTH_LABELS,
      validator(monthLabels) {
        const totalLabels = monthLabels.length;
        const isValidMonthLength = monthLabels.length === 12;
        if (!isValidMonthLength) {
          console.warn(`Missing labels, there must be a label for each month of the year. 12 total are needed but only ${totalLabels} were given.`);
        }
        return isValidMonthLength;
      }
    },
    toggleButtonAriaLabel: {
      type: String,
      default: "Toggle calendar"
    },
    previousYearButtonLabel: {
      type: String,
      default: "Navigate back one year"
    },
    nextYearButtonLabel: {
      type: String,
      default: "Navigate forward one year"
    },
    previousMonthButtonLabel: {
      type: String,
      default: "Navigate back one month"
    },
    nextMonthButtonLabel: {
      type: String,
      default: "Navigate forward one month"
    },
    yearSelectionButtonLabel: {
      type: String,
      default: "%s. Click to select year"
    },
    monthSelectionButtonLabel: {
      type: String,
      default: "%s. Click to select month"
    },
    previousYearsButtonLabel: {
      type: String,
      default: "Navigate back 12 years"
    },
    nextYearsButtonLabel: {
      type: String,
      default: "Navigate forward 12 years"
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          formGroup: [],
          component: [],
          label: [],
          input: []
        };
      }
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit }) {
    const props = __props;
    const slots = useSlots();
    const isDateRange = inject("isDateRange", false);
    const dateRangeStart = inject("dateRangeStart", "");
    const dateRangeEnd = inject("dateRangeEnd", "");
    const updateDateRangeStart = inject("updateDateRangeStart", null);
    const updateDateRangeEnd = inject("updateDateRangeEnd", null);
    const minDate2 = computed(() => {
      if (isDateRange.value && props.rangeType === "end" && dateRangeStart.value) {
        return dateRangeStart.value;
      }
      return props.minDate;
    });
    const maxDate2 = computed(() => {
      if (isDateRange.value && props.rangeType === "start" && dateRangeEnd.value) {
        return dateRangeEnd.value;
      }
      return props.maxDate;
    });
    const selectedDate = computed({
      get() {
        return props.modelValue;
      },
      set(newDate) {
        emit("update:modelValue", newDate);
        if (!isDateRange.value) {
          return;
        }
        if (props.rangeType === "start" && updateDateRangeStart) {
          updateDateRangeStart(newDate);
        } else if (props.rangeType === "end" && updateDateRangeEnd) {
          updateDateRangeEnd(newDate);
        }
      }
    });
    const initialDate = () => {
      if (selectedDate.value && isDateInRange(parseIsoDate(selectedDate.value), parseIsoDate(minDate2.value), parseIsoDate(maxDate2.value))) {
        return selectedDate.value;
      }
      if (isDateRange.value && props.rangeType === "end" && dateRangeStart.value && !dateRangeEnd.value) {
        return dateRangeStart.value;
      }
      if (isDateRange.value && props.rangeType === "start" && dateRangeEnd.value && !dateRangeStart.value) {
        return dateRangeEnd.value;
      }
      if (isDateInRange(today(), parseIsoDate(minDate2.value), parseIsoDate(maxDate2.value))) {
        return formatIsoDate(today());
      }
      return minDate2.value;
    };
    const datePickerWrapperRef = ref(null);
    const textInputValue = ref(selectedDate.value ? formatUsaDate(parseIsoDate(selectedDate.value)) : "");
    const open = ref(false);
    const isPristine = ref(true);
    const selectorMode = ref("day");
    const yearRangeStart = ref("");
    const yearRangeStop = ref("");
    const highlightedDate = ref("");
    const activeDate = ref(initialDate());
    const activeDateObject = shallowRef(parseIsoDate(activeDate.value));
    watch(activeDate, (newActiveDate) => {
      activeDateObject.value = parseIsoDate(newActiveDate);
    });
    const activeMonthLabel = computed(() => activeDate.value ? props.monthLabels[getMonthIndex(activeDateObject.value)] : "");
    const activeYear = computed(() => activeDate.value ? getYear(activeDateObject.value) : "");
    const closeCalendar = () => {
      open.value = false;
      selectorMode.value = "day";
    };
    const openCalendar = () => {
      activeDate.value = initialDate();
      open.value = true;
    };
    const toggleCalendar = () => {
      if (open.value) {
        closeCalendar();
      } else {
        openCalendar();
      }
    };
    const computedId = computed(() => props.id || nextId("usa-date-picker"));
    const computedLabelId = computed(() => `${computedId.value}-label`);
    const computedErrorMessageId = computed(() => `${computedId.value}-error-message`);
    const computedHintId = computed(() => `${computedId.value}-hint`);
    const ariaDescribedby = computed(() => {
      const ids = [];
      if (slots.hint) {
        ids.push(computedHintId.value);
      }
      if (props.error && slots["error-message"]) {
        ids.push(computedErrorMessageId.value);
      }
      return ids.length ? ids.join(" ") : null;
    });
    const classes = computed(() => {
      var _a2;
      return [
        { "usa-date-picker--active": open.value },
        {
          "usa-date-range-picker__range-start": isDateRange.value && props.rangeType === "start"
        },
        {
          "usa-date-range-picker__range-end": isDateRange.value && props.rangeType === "end"
        },
        ...((_a2 = props.customClasses) == null ? void 0 : _a2.component) || []
      ];
    });
    onKeyStroke("Escape", () => {
      if (open.value) {
        closeCalendar();
      }
    });
    onClickOutside(datePickerWrapperRef, () => {
      if (open.value) {
        closeCalendar();
      }
    });
    watch(textInputValue, (newInputValue) => {
      if (newInputValue === "") {
        selectedDate.value = "";
        return;
      }
      const dateObject = parseUsaDate(newInputValue);
      const minimumDate = parseIsoDate(minDate2.value);
      const maximumDate = parseIsoDate(maxDate2.value);
      const inputValueIsoDate = formatIsoDate(dateObject);
      if (isValidIsoDate(inputValueIsoDate) && isValidUsaDate(newInputValue) && isValidDate(dateObject)) {
        if (isDateInRange(dateObject, minimumDate, maximumDate)) {
          selectedDate.value = inputValueIsoDate;
          activeDate.value = selectedDate.value;
          highlightedDate.value = activeDate.value;
          return;
        }
        const isAfter2 = isDateAfter(activeDateObject.value, dateObject);
        if (isAfter2) {
          activeDate.value = formatIsoDate(minimumDate);
          highlightedDate.value = activeDate.value;
        } else {
          activeDate.value = formatIsoDate(maximumDate);
          highlightedDate.value = activeDate.value;
        }
      }
    });
    watch(selectedDate, (newSelectedDate) => {
      if (textInputValue.value === formatUsaDate(parseIsoDate(newSelectedDate))) {
        return;
      }
      textInputValue.value = newSelectedDate ? formatUsaDate(parseIsoDate(newSelectedDate)) : "";
    });
    provide("inputHighlightedDate", computed(() => highlightedDate.value));
    provide("rangeType", toRef(props, "rangeType"));
    onMounted(() => {
      if (isDateRange.value && props.rangeType === "start" && updateDateRangeStart) {
        updateDateRangeStart(selectedDate.value);
      } else if (isDateRange.value && props.rangeType === "end" && updateDateRangeEnd) {
        updateDateRangeEnd(selectedDate.value);
      }
    });
    return (_ctx, _cache) => {
      var _a2;
      return openBlock(), createBlock(unref(_sfc_main$1c), {
        group: !!_ctx.$slots.hint || __props.error && !!_ctx.$slots["error-message"],
        error: __props.error,
        class: normalizeClass((_a2 = props.customClasses) == null ? void 0 : _a2.formGroup)
      }, {
        default: withCtx(() => {
          var _a3, _b, _c;
          return [
            __props.label || _ctx.$slots.label ? (openBlock(), createBlock(unref(_sfc_main$1b), {
              key: 0,
              id: computedLabelId.value,
              for: computedId.value,
              required: __props.required,
              error: __props.error,
              class: normalizeClass((_a3 = __props.customClasses) == null ? void 0 : _a3.label)
            }, {
              default: withCtx(() => [
                renderSlot(_ctx.$slots, "label", {}, () => [
                  createTextVNode(toDisplayString(__props.label), 1)
                ])
              ]),
              _: 3
            }, 8, ["id", "for", "required", "error", "class"])) : createCommentVNode("", true),
            _ctx.$slots.hint ? (openBlock(), createElementBlock("span", {
              key: 1,
              id: computedHintId.value,
              class: "usa-hint"
            }, [
              renderSlot(_ctx.$slots, "hint")
            ], 8, _hoisted_1$S)) : createCommentVNode("", true),
            __props.error && _ctx.$slots["error-message"] ? (openBlock(), createElementBlock("span", {
              key: 2,
              id: computedErrorMessageId.value,
              class: "usa-error-message"
            }, [
              renderSlot(_ctx.$slots, "error-message")
            ], 8, _hoisted_2$n)) : createCommentVNode("", true),
            createBaseVNode("div", {
              class: normalizeClass(["usa-date-picker usa-date-picker--initialized", classes.value])
            }, [
              createBaseVNode("div", {
                ref_key: "datePickerWrapperRef",
                ref: datePickerWrapperRef,
                class: "usa-date-picker__wrapper"
              }, [
                withDirectives(createBaseVNode("input", mergeProps(_ctx.$attrs, {
                  id: computedId.value,
                  "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => textInputValue.value = $event),
                  required: __props.required,
                  disabled: __props.disabled,
                  readonly: __props.readonly,
                  "aria-labelledby": __props.label || _ctx.$slots.label ? computedLabelId.value : null,
                  "aria-describedby": ariaDescribedby.value,
                  class: [(_b = props.customClasses) == null ? void 0 : _b.input, "usa-input usa-date-picker__external-input"],
                  type: "text"
                }), null, 16, _hoisted_3$d), [
                  [vModelText, textInputValue.value]
                ]),
                createBaseVNode("button", {
                  type: "button",
                  class: "usa-date-picker__button",
                  "aria-haspopup": "true",
                  "aria-label": __props.toggleButtonAriaLabel,
                  disabled: __props.disabled,
                  onClick: toggleCalendar
                }, null, 8, _hoisted_4$7),
                createVNode(unref(_sfc_main$13), {
                  "selected-date": selectedDate.value,
                  "onUpdate:selectedDate": _cache[1] || (_cache[1] = ($event) => selectedDate.value = $event),
                  "selector-mode": selectorMode.value,
                  "onUpdate:selectorMode": _cache[2] || (_cache[2] = ($event) => selectorMode.value = $event),
                  open: open.value,
                  "onUpdate:open": _cache[3] || (_cache[3] = ($event) => open.value = $event),
                  "active-date": activeDate.value,
                  "onUpdate:activeDate": _cache[4] || (_cache[4] = ($event) => activeDate.value = $event),
                  "highlighted-date": highlightedDate.value,
                  "onUpdate:highlightedDate": _cache[5] || (_cache[5] = ($event) => highlightedDate.value = $event),
                  style: normalizeStyle(`top: ${(_c = datePickerWrapperRef.value) == null ? void 0 : _c.offsetHeight}px`),
                  "min-date": minDate2.value,
                  "max-date": maxDate2.value,
                  "month-labels": __props.monthLabels,
                  "day-of-week-labels": __props.dayOfWeekLabels,
                  "day-of-week-abbreviation-labels": __props.dayOfWeekAbbreviationLabels,
                  "previous-year-button-label": __props.previousYearButtonLabel,
                  "next-year-button-label": __props.nextYearButtonLabel,
                  "previous-month-button-label": __props.previousMonthButtonLabel,
                  "next-month-button-label": __props.nextMonthButtonLabel,
                  "month-selection-button-label": __props.monthSelectionButtonLabel,
                  "year-selection-button-label": __props.yearSelectionButtonLabel,
                  "previous-years-button-label": __props.previousYearsButtonLabel,
                  "next-years-button-label": __props.nextYearsButtonLabel,
                  "onUpdate:isPristine": _cache[6] || (_cache[6] = (currentlyPristine) => isPristine.value = currentlyPristine),
                  "onUpdate:activeYearStart": _cache[7] || (_cache[7] = (newStartYear) => yearRangeStart.value = newStartYear),
                  "onUpdate:activeYearEnd": _cache[8] || (_cache[8] = (newEndYear) => yearRangeStop.value = newEndYear)
                }, null, 8, ["selected-date", "selector-mode", "open", "active-date", "highlighted-date", "style", "min-date", "max-date", "month-labels", "day-of-week-labels", "day-of-week-abbreviation-labels", "previous-year-button-label", "next-year-button-label", "previous-month-button-label", "next-month-button-label", "month-selection-button-label", "year-selection-button-label", "previous-years-button-label", "next-years-button-label"]),
                createBaseVNode("div", _hoisted_5$4, [
                  renderSlot(_ctx.$slots, "status", {
                    open: open.value,
                    isPristine: isPristine.value,
                    selectorMode: selectorMode.value,
                    selectedDate: selectedDate.value,
                    highlightedDate: highlightedDate.value,
                    activeMonthLabel: activeMonthLabel.value,
                    activeYear: activeYear.value,
                    yearRangeStart: yearRangeStart.value,
                    yearRangeStop: yearRangeStop.value
                  }, () => [
                    open.value ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                      selectorMode.value === "day" ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                        selectedDate.value && selectedDate.value === highlightedDate.value ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                          createTextVNode("Selected date.")
                        ], 64)) : createCommentVNode("", true),
                        isPristine.value ? (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                          createTextVNode(" You can navigate by day using left and right arrows. Weeks by using up and down arrows. Months by using page up and page down keys. Years by using shift plus page up and shift plus page down. Home and end keys navigate to the beginning and end of a week. ")
                        ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 2 }, [
                          createTextVNode(toDisplayString(activeMonthLabel.value) + " " + toDisplayString(activeYear.value), 1)
                        ], 64))
                      ], 64)) : selectorMode.value === "month" ? (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                        createTextVNode("Select a month.")
                      ], 64)) : selectorMode.value === "year" ? (openBlock(), createElementBlock(Fragment, { key: 2 }, [
                        createTextVNode("Showing years " + toDisplayString(yearRangeStart.value) + " to " + toDisplayString(yearRangeStop.value) + ". Select a year.", 1)
                      ], 64)) : createCommentVNode("", true)
                    ], 64)) : createCommentVNode("", true)
                  ])
                ])
              ], 512)
            ], 2)
          ];
        }),
        _: 3
      }, 8, ["group", "error", "class"]);
    };
  }
});
var _hoisted_1$R = { class: "usa-date-range-picker" };
var _sfc_main$11 = {
  __name: "UsaDateRangePicker",
  setup(__props) {
    const rangeStart = ref("");
    const rangeEnd = ref("");
    const updateDateRangeStart = (newRangeStart) => {
      rangeStart.value = newRangeStart;
    };
    const updateDateRangeEnd = (newRangeEnd) => {
      rangeEnd.value = newRangeEnd;
    };
    provide("isDateRange", ref(true));
    provide("dateRangeStart", rangeStart);
    provide("dateRangeEnd", rangeEnd);
    provide("updateDateRangeStart", updateDateRangeStart);
    provide("updateDateRangeEnd", updateDateRangeEnd);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$R, [
        renderSlot(_ctx.$slots, "default")
      ]);
    };
  }
};
var useFileInput = (_id, _loadedFiles, _acceptedFileFormats, _multiple, _disabled, emit) => {
  const id = ref(_id);
  const allowMultiple = ref(_multiple);
  const isDisabled = ref(_disabled);
  const loadedFiles = ref(_loadedFiles);
  const acceptedFileFormats = ref(_acceptedFileFormats);
  const spacerGif = "data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7";
  const computedId = computed(() => id.value || nextId("usa-file-input"));
  const computedErrorMessageId = computed(() => `${computedId.value}-error-message`);
  const computedHintId = computed(() => `${computedId.value}-hint`);
  const validFileFormats = computed(() => {
    const formats = acceptedFileFormats.value.split(",").map((fileType) => fileType.trim().toLowerCase());
    const validFileFormats2 = {
      types: [],
      extensions: []
    };
    formats.forEach((format) => {
      if (format.includes("/") && !validFileFormats2.types.includes(format)) {
        if (format.endsWith("/*")) {
          validFileFormats2.types.push(format.substring(0, format.length - 1));
        } else {
          validFileFormats2.types.push(format);
        }
      } else if (format.includes(".") && !validFileFormats2.extensions.includes(format)) {
        validFileFormats2.extensions.push(format);
      }
    });
    return validFileFormats2;
  });
  const getFileExtension = (filename) => {
    var _a2;
    const extensionPattern = /(?:.+)\.(.+)$/;
    const match = filename.match(extensionPattern);
    return `.${(_a2 = match == null ? void 0 : match[1]) == null ? void 0 : _a2.toLowerCase()}`;
  };
  const getFileIconClass = (extension) => {
    switch (extension) {
      case ".pdf":
        return "usa-file-input__preview-image--pdf";
      case ".doc":
      case ".docx":
      case ".pages":
        return "usa-file-input__preview-image--word";
      case ".xls":
      case ".xlsx":
      case ".numbers":
        return "usa-file-input__preview-image--excel";
      case ".mov":
      case ".mp4":
        return "usa-file-input__preview-image--video";
      default:
        return "usa-file-input__preview-image--generic";
    }
  };
  const isImage = (fileType) => {
    const pattern = new RegExp(/^image\//gi);
    return pattern.test(fileType);
  };
  const hasFiles = computed(() => {
    var _a2;
    return ((_a2 = loadedFiles.value) == null ? void 0 : _a2.length) > 0;
  });
  const hasInvalidFiles = computed(() => {
    if (!acceptedFileFormats.value || !hasFiles.value) {
      return false;
    }
    const validTypes = validFileFormats.value.types;
    const validExtensions = validFileFormats.value.extensions;
    const someValidFiles = loadedFiles.value.every((file) => {
      const someValidTypes = validTypes.some((type) => {
        const typePattern = new RegExp(escapeRegExp(type), "gi");
        return typePattern.test(file.type);
      });
      const someValidExtensions = validExtensions.some((extension) => {
        const extensionPattern = new RegExp(escapeRegExp(extension), "gi");
        return extensionPattern.test(file.extension);
      });
      return someValidTypes || someValidExtensions;
    });
    return !someValidFiles;
  });
  const loadedFileNames = computed(() => loadedFiles.value.map((file) => file.name).join(", "));
  const generatePreviews = (event, index) => {
    var _a2;
    const file = loadedFiles.value[index];
    if (isImage(file == null ? void 0 : file.type) && ((_a2 = event == null ? void 0 : event.target) == null ? void 0 : _a2.result)) {
      file.iconClasses = null;
      file.src = event.target.result;
    } else {
      file.iconClasses = [getFileIconClass(file.extension)];
    }
  };
  async function loadFiles(fileList) {
    if (!(fileList == null ? void 0 : fileList.length) || isDisabled.value) {
      loadedFiles.value = [];
      return;
    }
    let files = [];
    if (allowMultiple.value) {
      for (let i = 0; i < fileList.length; i++) {
        files.push(fileList.item(i));
      }
    } else {
      files.push(fileList.item(0));
    }
    emit("filesLoaded", files);
    loadedFiles.value = files.reduce((acc, file, index) => {
      const fileExtension = getFileExtension(file.name);
      const metadata = {
        name: file.name,
        type: file.type,
        extension: fileExtension,
        src: spacerGif,
        iconClasses: [getFileIconClass(fileExtension), "is-loading"]
      };
      const reader = new FileReader();
      reader.addEventListener("loadend", (event) => generatePreviews(event, index), false);
      reader.readAsDataURL(file);
      acc.push(metadata);
      return acc;
    }, []);
  }
  return {
    computedErrorMessageId,
    computedHintId,
    computedId,
    hasFiles,
    hasInvalidFiles,
    isDisabled,
    loadFiles,
    loadedFileNames,
    loadedFiles: readonly(loadedFiles)
  };
};
var _hoisted_1$Q = ["id"];
var _hoisted_2$m = ["id"];
var _hoisted_3$c = ["aria-disabled"];
var _hoisted_4$6 = {
  class: "usa-sr-only",
  "aria-live": "polite"
};
var _hoisted_5$3 = createBaseVNode("div", { class: "usa-file-input__box" }, null, -1);
var _hoisted_6$3 = ["hidden"];
var _hoisted_7$1 = { class: "usa-file-input__drag-text" };
var _hoisted_8 = createBaseVNode("span", { class: "usa-file-input__choose" }, "choose from folder", -1);
var _hoisted_9 = { class: "usa-file-input__preview-heading" };
var _hoisted_10 = createBaseVNode("span", { class: "usa-file-input__choose" }, "Change file", -1);
var _hoisted_11 = ["src"];
var _hoisted_12 = {
  key: 1,
  class: "usa-file-input__accepted-files-message"
};
var _hoisted_13 = ["id", "required", "disabled", "accept", "multiple", "aria-label", "aria-describedby"];
var __default__$a = {
  inheritAttrs: false
};
var _sfc_main$10 = Object.assign(__default__$a, {
  __name: "UsaFileInput",
  props: {
    accept: {
      type: String,
      default: ""
    },
    multiple: {
      type: Boolean,
      default: false
    },
    label: {
      type: String,
      default: ""
    },
    required: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    error: {
      type: Boolean,
      default: false
    },
    id: {
      type: String,
      default: ""
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          formGroup: [],
          component: [],
          label: [],
          input: []
        };
      }
    }
  },
  emits: ["filesLoaded"],
  setup(__props, { emit }) {
    const props = __props;
    const slots = useSlots();
    const fileInputRef = ref(null);
    const isOverDropzone = ref(false);
    const {
      computedErrorMessageId,
      computedHintId,
      computedId,
      hasFiles,
      hasInvalidFiles,
      isDisabled,
      loadFiles,
      loadedFileNames,
      loadedFiles
    } = useFileInput(toRef(props, "id"), ref([]), toRef(props, "accept"), toRef(props, "multiple"), toRef(props, "disabled"), emit);
    watch(hasInvalidFiles, (invalid) => {
      if (invalid) {
        fileInputRef.value.value = "";
      }
    });
    const ariaDescribedby = computed(() => {
      const ids = [];
      if (slots.hint) {
        ids.push(computedHintId.value);
      }
      if (props.error && slots["error-message"]) {
        ids.push(computedErrorMessageId.value);
      }
      return ids.length ? ids.join(" ") : null;
    });
    const classes = computed(() => {
      var _a2;
      return [
        {
          "usa-file-input--disabled": isDisabled.value,
          "has-invalid-file": hasInvalidFiles.value
        },
        ...((_a2 = props.customClasses) == null ? void 0 : _a2.component) || []
      ];
    });
    const dropZoneClasses = computed(() => [
      { "usa-file-input--drag": isOverDropzone.value }
    ]);
    const ariaLabel = computed(() => {
      const fileLabel = props.multiple ? "files" : "file";
      if (!hasFiles.value) {
        return `Drag ${fileLabel} here or choose from folder`;
      }
      return `Change ${fileLabel}`;
    });
    return (_ctx, _cache) => {
      var _a2;
      return openBlock(), createBlock(unref(_sfc_main$1c), {
        group: !!_ctx.$slots.hint || __props.error && !!_ctx.$slots["error-message"],
        error: __props.error,
        class: normalizeClass((_a2 = props.customClasses) == null ? void 0 : _a2.formGroup)
      }, {
        default: withCtx(() => {
          var _a3, _b;
          return [
            __props.label || _ctx.$slots.label ? (openBlock(), createBlock(unref(_sfc_main$1b), {
              key: 0,
              for: unref(computedId),
              required: __props.required,
              error: __props.error,
              class: normalizeClass((_a3 = __props.customClasses) == null ? void 0 : _a3.label)
            }, {
              default: withCtx(() => [
                renderSlot(_ctx.$slots, "label", {}, () => [
                  createTextVNode(toDisplayString(__props.label), 1)
                ])
              ]),
              _: 3
            }, 8, ["for", "required", "error", "class"])) : createCommentVNode("", true),
            _ctx.$slots.hint ? (openBlock(), createElementBlock("span", {
              key: 1,
              id: unref(computedHintId),
              class: "usa-hint"
            }, [
              renderSlot(_ctx.$slots, "hint")
            ], 8, _hoisted_1$Q)) : createCommentVNode("", true),
            __props.error && _ctx.$slots["error-message"] ? (openBlock(), createElementBlock("span", {
              key: 2,
              id: unref(computedErrorMessageId),
              class: "usa-error-message"
            }, [
              renderSlot(_ctx.$slots, "error-message")
            ], 8, _hoisted_2$m)) : createCommentVNode("", true),
            createBaseVNode("div", {
              class: normalizeClass(["usa-file-input", classes.value]),
              "aria-disabled": unref(isDisabled) || null
            }, [
              createBaseVNode("div", _hoisted_4$6, [
                renderSlot(_ctx.$slots, "status", {
                  multiple: __props.multiple,
                  loadedFiles: unref(loadedFiles),
                  hasInvalidFiles: unref(hasInvalidFiles)
                }, () => [
                  !unref(loadedFiles).length || unref(hasInvalidFiles) ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                    __props.multiple ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                      createTextVNode("No files selected")
                    ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                      createTextVNode("No file selected")
                    ], 64))
                  ], 64)) : unref(loadedFiles).length === 1 && !unref(hasInvalidFiles) ? (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                    createTextVNode(" You have selected the file: " + toDisplayString(unref(loadedFiles)[0].name), 1)
                  ], 64)) : unref(loadedFiles).length > 1 && !unref(hasInvalidFiles) ? (openBlock(), createElementBlock(Fragment, { key: 2 }, [
                    createTextVNode(" test You have selected " + toDisplayString(unref(loadedFiles).length) + " files: " + toDisplayString(unref(loadedFileNames)), 1)
                  ], 64)) : createCommentVNode("", true)
                ])
              ]),
              createBaseVNode("div", {
                class: normalizeClass(["usa-file-input__target", dropZoneClasses.value])
              }, [
                _hoisted_5$3,
                withDirectives(createBaseVNode("div", {
                  class: "usa-file-input__instructions",
                  "aria-hidden": "true",
                  hidden: !unref(hasInvalidFiles) && unref(hasFiles)
                }, [
                  renderSlot(_ctx.$slots, "instructions", { multiple: __props.multiple }, () => [
                    createBaseVNode("span", _hoisted_7$1, [
                      createTextVNode("Drag file"),
                      __props.multiple ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                        createTextVNode("s")
                      ], 64)) : createCommentVNode("", true),
                      createTextVNode(" here or ")
                    ]),
                    _hoisted_8
                  ])
                ], 8, _hoisted_6$3), [
                  [vShow, unref(hasInvalidFiles) || !unref(hasFiles)]
                ]),
                !unref(hasInvalidFiles) && unref(hasFiles) ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                  createBaseVNode("div", _hoisted_9, [
                    renderSlot(_ctx.$slots, "preview-heading", { loadedFiles: unref(loadedFiles) }, () => [
                      unref(loadedFiles).length === 1 ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                        createTextVNode("Selected file")
                      ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                        createTextVNode(toDisplayString(unref(loadedFiles).length) + " files selected", 1)
                      ], 64)),
                      _hoisted_10
                    ])
                  ]),
                  (openBlock(true), createElementBlock(Fragment, null, renderList(unref(loadedFiles), (file, index) => {
                    return openBlock(), createElementBlock("div", {
                      key: file.name + index,
                      class: "usa-file-input__preview",
                      "aria-hidden": "true"
                    }, [
                      createBaseVNode("img", {
                        src: file.src,
                        alt: "",
                        class: normalizeClass(["usa-file-input__preview-image", file == null ? void 0 : file.iconClasses])
                      }, null, 10, _hoisted_11),
                      createTextVNode(" " + toDisplayString(file.name), 1)
                    ]);
                  }), 128))
                ], 64)) : createCommentVNode("", true),
                unref(hasInvalidFiles) ? (openBlock(), createElementBlock("div", _hoisted_12, [
                  renderSlot(_ctx.$slots, "invalid-files-message", {}, () => [
                    createTextVNode("This is not a valid file type.")
                  ])
                ])) : createCommentVNode("", true),
                createBaseVNode("input", mergeProps(_ctx.$attrs, {
                  id: unref(computedId),
                  ref_key: "fileInputRef",
                  ref: fileInputRef,
                  type: "file",
                  required: __props.required,
                  disabled: unref(isDisabled),
                  accept: __props.accept || null,
                  multiple: __props.multiple || null,
                  class: ["usa-file-input__input", (_b = __props.customClasses) == null ? void 0 : _b.input],
                  "aria-label": ariaLabel.value,
                  "aria-describedby": ariaDescribedby.value,
                  onChange: _cache[0] || (_cache[0] = ($event) => unref(loadFiles)($event.target.files)),
                  onDragenter: _cache[1] || (_cache[1] = ($event) => isOverDropzone.value = true),
                  onDragover: _cache[2] || (_cache[2] = ($event) => isOverDropzone.value = true),
                  onDragleave: _cache[3] || (_cache[3] = ($event) => isOverDropzone.value = false),
                  onDrop: _cache[4] || (_cache[4] = ($event) => isOverDropzone.value = false)
                }), null, 16, _hoisted_13)
              ], 2)
            ], 10, _hoisted_3$c)
          ];
        }),
        _: 3
      }, 8, ["group", "error", "class"]);
    };
  }
});
var _hoisted_1$P = { href: "#" };
var _sfc_main$$ = {
  __name: "UsaFooter",
  props: {
    variant: {
      type: String,
      default: "medium",
      validator(variant) {
        const isValidVariant = ["big", "medium", "slim"].includes(variant);
        if (!isValidVariant) {
          console.warn(`'${variant}' is not a valid footer variant`);
        }
        return isValidVariant;
      }
    },
    jumpLinkText: {
      type: String,
      default: "Return to top"
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          container: []
        };
      }
    }
  },
  setup(__props) {
    const props = __props;
    const gridNamespace = inject("vueUswds.gridNamespace", GRID_NAMESPACE);
    const classes = computed(() => [
      {
        "usa-footer--big": props.variant === "big",
        "usa-footer--medium": props.variant === "medium",
        "usa-footer--slim": props.variant === "slim"
      }
    ]);
    const containerClasses = computed(() => {
      var _a2, _b;
      return ((_b = (_a2 = props.customClasses) == null ? void 0 : _a2.container) == null ? void 0 : _b.length) ? props.customClasses.container : [`${gridNamespace}container`];
    });
    provide("footerVariant", computed(() => props.variant));
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("footer", {
        class: normalizeClass(["usa-footer", classes.value])
      }, [
        createBaseVNode("div", {
          class: normalizeClass(["usa-footer__return-to-top", containerClasses.value])
        }, [
          renderSlot(_ctx.$slots, "jump-link", {}, () => [
            createBaseVNode("a", _hoisted_1$P, toDisplayString(__props.jumpLinkText), 1)
          ])
        ], 2),
        renderSlot(_ctx.$slots, "default")
      ], 2);
    };
  }
};
var _hoisted_1$O = {
  key: 0,
  class: "usa-footer__contact-heading"
};
var _hoisted_2$l = { class: "usa-footer__contact-info" };
var _hoisted_3$b = ["href"];
var _hoisted_4$5 = { class: "usa-footer__contact-info" };
var _hoisted_5$2 = ["href"];
var _hoisted_6$2 = ["href"];
var _hoisted_7 = ["href"];
var __default__$9 = {
  inheritAttrs: false
};
var _sfc_main$_ = Object.assign(__default__$9, {
  __name: "UsaFooterAddress",
  props: {
    heading: {
      type: String,
      default: ""
    },
    email: {
      type: String,
      default: ""
    },
    phone: {
      type: String,
      default: ""
    },
    phoneUrl: {
      type: String,
      default: ""
    }
  },
  setup(__props) {
    const props = __props;
    const prefixSeparator = inject("vueUswds.prefixSeparator", PREFIX_SEPARATOR);
    const gridNamespace = inject("vueUswds.gridNamespace", GRID_NAMESPACE);
    const footerVariant = inject("footerVariant", "medium");
    const emailHref = computed(() => {
      if (props.email) {
        return `mailto:${props.email.trim().toLowerCase()}`;
      }
      return "";
    });
    const phoneHref = computed(() => {
      if (props.phoneUrl) {
        return `tel:${props.phoneUrl.trim()}`;
      }
      return "";
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(Fragment, null, [
        __props.heading && unref(footerVariant) !== "slim" ? (openBlock(), createElementBlock("p", _hoisted_1$O, toDisplayString(__props.heading), 1)) : createCommentVNode("", true),
        createBaseVNode("address", mergeProps({ class: "usa-footer__address" }, _ctx.$attrs), [
          renderSlot(_ctx.$slots, "default", {}, () => [
            unref(footerVariant) === "slim" ? (openBlock(), createElementBlock("div", {
              key: 0,
              class: normalizeClass(`${unref(gridNamespace)}row ${unref(gridNamespace)}gap`)
            }, [
              phoneHref.value ? (openBlock(), createElementBlock("div", {
                key: 0,
                class: normalizeClass(`${unref(gridNamespace)}col-auto mobile-lg${unref(prefixSeparator)}${unref(gridNamespace)}col-12 desktop${unref(prefixSeparator)}${unref(gridNamespace)}col-auto`)
              }, [
                createBaseVNode("div", _hoisted_2$l, [
                  createBaseVNode("a", { href: phoneHref.value }, toDisplayString(__props.phone), 9, _hoisted_3$b)
                ])
              ], 2)) : createCommentVNode("", true),
              emailHref.value ? (openBlock(), createElementBlock("div", {
                key: 1,
                class: normalizeClass(`${unref(gridNamespace)}col-auto mobile-lg${unref(prefixSeparator)}${unref(gridNamespace)}col-12 desktop${unref(prefixSeparator)}${unref(gridNamespace)}col-auto`)
              }, [
                createBaseVNode("div", _hoisted_4$5, [
                  createBaseVNode("a", { href: emailHref.value }, toDisplayString(__props.email), 9, _hoisted_5$2)
                ])
              ], 2)) : createCommentVNode("", true)
            ], 2)) : (openBlock(), createElementBlock("div", {
              key: 1,
              class: normalizeClass(`usa-footer__contact-info ${unref(gridNamespace)}row ${unref(gridNamespace)}gap`)
            }, [
              phoneHref.value ? (openBlock(), createElementBlock("div", {
                key: 0,
                class: normalizeClass(`${unref(gridNamespace)}col-auto`)
              }, [
                createBaseVNode("a", { href: phoneHref.value }, toDisplayString(__props.phone), 9, _hoisted_6$2)
              ], 2)) : createCommentVNode("", true),
              emailHref.value ? (openBlock(), createElementBlock("div", {
                key: 1,
                class: normalizeClass(`${unref(gridNamespace)}col-auto`)
              }, [
                createBaseVNode("a", { href: emailHref.value }, toDisplayString(__props.email), 9, _hoisted_7)
              ], 2)) : createCommentVNode("", true)
            ], 2))
          ])
        ], 16)
      ], 64);
    };
  }
});
var _hoisted_1$N = ["aria-expanded", "aria-controls"];
var _hoisted_2$k = ["id"];
var _sfc_main$Z = {
  __name: "UsaFooterCollapsibleMenuSection",
  props: {
    item: {
      type: Object,
      default: () => {
      }
    },
    headingTag: {
      type: String,
      default: "h4"
    }
  },
  setup(__props) {
    const props = __props;
    const isCollapsible = inject("footerMenuIsCollapsible");
    const menuSections = inject("menuSections");
    const registerMenuSection = inject("registerMenuSection");
    const unregisterMenuSection = inject("unregisterMenuSection");
    const toggleMenuSection = inject("toggleMenuSection");
    const menuSectionId = computed(() => {
      var _a2;
      return ((_a2 = props.item) == null ? void 0 : _a2.id) || nextId("usa-footer-collapsible-menu-section");
    });
    registerMenuSection(menuSectionId.value, false);
    onBeforeUnmount(() => {
      unregisterMenuSection(menuSectionId.value);
    });
    const isOpen = toRef(menuSections, menuSectionId.value);
    return (_ctx, _cache) => {
      var _a2, _b, _c;
      return openBlock(), createElementBlock("section", {
        key: ((_a2 = __props.item) == null ? void 0 : _a2.id) || __props.item.text,
        class: "usa-footer__primary-content usa-footer__primary-content--collapsible"
      }, [
        unref(isCollapsible) ? (openBlock(), createElementBlock("button", {
          key: 0,
          type: "button",
          class: "usa-footer__primary-link usa-footer__primary-link--button",
          "aria-expanded": isOpen.value,
          "aria-controls": menuSectionId.value,
          onClick: _cache[0] || (_cache[0] = ($event) => unref(toggleMenuSection)(menuSectionId.value))
        }, toDisplayString(__props.item.text), 9, _hoisted_1$N)) : (openBlock(), createBlock(unref(_sfc_main$1z), {
          key: 1,
          tag: __props.headingTag,
          class: "usa-footer__primary-link"
        }, {
          default: withCtx(() => [
            createTextVNode(toDisplayString(__props.item.text), 1)
          ]),
          _: 1
        }, 8, ["tag"])),
        ((_c = (_b = __props.item) == null ? void 0 : _b.children) == null ? void 0 : _c.length) ? withDirectives((openBlock(), createElementBlock("ul", {
          key: 2,
          id: menuSectionId.value,
          class: "usa-list usa-list--unstyled"
        }, [
          (openBlock(true), createElementBlock(Fragment, null, renderList(__props.item.children, (subItem) => {
            return openBlock(), createElementBlock("li", {
              key: (subItem == null ? void 0 : subItem.id) || subItem.text,
              class: "usa-footer__secondary-link"
            }, [
              createVNode(unref(BaseLink), {
                to: subItem.to,
                href: subItem.href,
                "router-component-name": subItem.routerComponentName
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(subItem.text), 1)
                ]),
                _: 2
              }, 1032, ["to", "href", "router-component-name"])
            ]);
          }), 128))
        ], 8, _hoisted_2$k)), [
          [vShow, isOpen.value || !unref(isCollapsible)]
        ]) : createCommentVNode("", true)
      ]);
    };
  }
};
var _sfc_main$Y = {
  __name: "UsaFooterCollapsibleMenu",
  props: {
    items: {
      type: Array,
      default: () => []
    },
    headingTag: {
      type: String,
      default: "h4"
    },
    customClasses: {
      type: Object,
      default: () => ({
        gridRow: [],
        gridCol: []
      })
    }
  },
  setup(__props) {
    const props = __props;
    const prefixSeparator = inject("vueUswds.prefixSeparator", PREFIX_SEPARATOR);
    const gridNamespace = inject("vueUswds.gridNamespace", GRID_NAMESPACE);
    const footerNavBigBreakpoint = inject("vueUswds.footerNavBigBreakpoint", FOOTER_NAV_COLLAPSIBLE_BREAKPOINT);
    const isCollapsible = useMediaQuery(`(max-width: ${footerNavBigBreakpoint})`);
    const menuSections = reactive({});
    const {
      registerAccordionItem,
      unregisterAccordionItem,
      closeItem,
      toggleItem,
      closeAllItems
    } = useAccordion(menuSections);
    watch(isCollapsible, closeAllItems);
    const gridRowClasses = computed(() => {
      var _a2, _b;
      if ((_b = (_a2 = props.customClasses) == null ? void 0 : _a2.gridRow) == null ? void 0 : _b.length) {
        return props.customClasses.gridRow;
      }
      return [`${gridNamespace}row`, `${gridNamespace}gap-4`];
    });
    const gridColClasses = computed(() => {
      var _a2, _b;
      if ((_b = (_a2 = props.customClasses) == null ? void 0 : _a2.gridCol) == null ? void 0 : _b.length) {
        return props.customClasses.gridCol;
      }
      return [
        `mobile-lg${prefixSeparator}${gridNamespace}col-6`,
        `desktop${prefixSeparator}${gridNamespace}col-3`
      ];
    });
    provide("registerMenuSection", registerAccordionItem);
    provide("unregisterMenuSection", unregisterAccordionItem);
    provide("toggleMenuSection", toggleItem);
    provide("closeMenuSection", closeItem);
    provide("closeAllMenuSections", closeAllItems);
    provide("menuSections", menuSections);
    provide("footerMenuIsCollapsible", isCollapsible);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(gridRowClasses.value)
      }, [
        createBaseVNode("div", {
          class: normalizeClass(gridColClasses.value)
        }, [
          (openBlock(true), createElementBlock(Fragment, null, renderList(__props.items, (item) => {
            return openBlock(), createBlock(unref(_sfc_main$Z), {
              key: (item == null ? void 0 : item.id) || item.text,
              item,
              "heading-tag": __props.headingTag
            }, null, 8, ["item", "heading-tag"]);
          }), 128))
        ], 2)
      ], 2);
    };
  }
};
var _hoisted_1$M = { class: "usa-footer__logo" };
var _hoisted_2$j = ["src", "alt"];
var _hoisted_3$a = { class: "usa-footer__logo-heading" };
var _sfc_main$X = {
  __name: "UsaFooterLogo",
  props: {
    src: {
      type: String,
      default: ""
    },
    alt: {
      type: String,
      default: ""
    },
    heading: {
      type: String,
      default: ""
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          logoGridCol: [],
          headingGridCol: []
        };
      }
    }
  },
  setup(__props) {
    const props = __props;
    const prefixSeparator = inject("vueUswds.prefixSeparator", PREFIX_SEPARATOR);
    const gridNamespace = inject("vueUswds.gridNamespace", GRID_NAMESPACE);
    const logoGridClasses = computed(() => {
      var _a2, _b;
      return ((_b = (_a2 = props.customClasses) == null ? void 0 : _a2.logoGridCol) == null ? void 0 : _b.length) ? props.customClasses.logoGridCol : [`mobile-lg${prefixSeparator}${gridNamespace}col-auto`];
    });
    const headingGridClasses = computed(() => {
      var _a2, _b;
      return ((_b = (_a2 = props.customClasses) == null ? void 0 : _a2.headingGridCol) == null ? void 0 : _b.length) ? props.customClasses.headingGridCol : [`mobile-lg${prefixSeparator}${gridNamespace}col-auto`];
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$M, [
        createBaseVNode("div", {
          class: normalizeClass(logoGridClasses.value)
        }, [
          renderSlot(_ctx.$slots, "logo", {}, () => [
            __props.src ? (openBlock(), createElementBlock("img", {
              key: 0,
              class: "usa-footer__logo-img",
              src: __props.src,
              alt: __props.alt
            }, null, 8, _hoisted_2$j)) : createCommentVNode("", true)
          ])
        ], 2),
        createBaseVNode("div", {
          class: normalizeClass(headingGridClasses.value)
        }, [
          createBaseVNode("p", _hoisted_3$a, [
            renderSlot(_ctx.$slots, "heading", {}, () => [
              createTextVNode(toDisplayString(__props.heading), 1)
            ])
          ])
        ], 2)
      ]);
    };
  }
};
var _sfc_main$W = {
  __name: "UsaFooterMenu",
  props: {
    items: {
      type: Array,
      default: () => []
    },
    customClasses: {
      type: Object,
      default: () => ({
        gridRow: [],
        gridCol: []
      })
    }
  },
  setup(__props) {
    const props = __props;
    const prefixSeparator = inject("vueUswds.prefixSeparator", PREFIX_SEPARATOR);
    const gridNamespace = inject("vueUswds.gridNamespace", GRID_NAMESPACE);
    const gridRowClasses = computed(() => {
      var _a2, _b;
      if ((_b = (_a2 = props.customClasses) == null ? void 0 : _a2.gridRow) == null ? void 0 : _b.length) {
        return props.customClasses.gridRow;
      }
      return [`${gridNamespace}row`, `${gridNamespace}gap`];
    });
    const griColClasses = computed(() => {
      var _a2, _b;
      if ((_b = (_a2 = props.customClasses) == null ? void 0 : _a2.gridCol) == null ? void 0 : _b.length) {
        return props.customClasses.gridCol;
      }
      return [
        `mobile-lg${prefixSeparator}${gridNamespace}col-6`,
        `desktop${prefixSeparator}${gridNamespace}col-auto`
      ];
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("ul", {
        class: normalizeClass(gridRowClasses.value)
      }, [
        (openBlock(true), createElementBlock(Fragment, null, renderList(__props.items, (item) => {
          return openBlock(), createElementBlock("li", {
            key: (item == null ? void 0 : item.id) || item.text,
            class: normalizeClass(["usa-footer__primary-content", griColClasses.value])
          }, [
            createVNode(unref(BaseLink), {
              to: item.to,
              href: item.href,
              class: "usa-footer__primary-link",
              "router-component-name": item.routerComponentName
            }, {
              default: withCtx(() => [
                createTextVNode(toDisplayString(item.text), 1)
              ]),
              _: 2
            }, 1032, ["to", "href", "router-component-name"])
          ], 2);
        }), 128))
      ], 2);
    };
  }
};
var _hoisted_1$L = ["aria-label"];
var _sfc_main$V = {
  __name: "UsaFooterNav",
  props: {
    ariaLabel: {
      type: String,
      default: "Footer navigation"
    },
    items: {
      type: Array,
      default: () => []
    },
    collapsibleHeadingTag: {
      type: String,
      default: "h4"
    },
    customClasses: {
      type: Object,
      default: () => ({
        gridRow: [],
        gridCol: []
      })
    }
  },
  setup(__props) {
    const footerVariant = inject("footerVariant", "medium");
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("nav", {
        class: "usa-footer__nav",
        "aria-label": __props.ariaLabel
      }, [
        renderSlot(_ctx.$slots, "default", { items: __props.items }, () => [
          __props.items.length ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
            unref(footerVariant) === "big" ? (openBlock(), createBlock(unref(_sfc_main$Y), {
              key: 0,
              items: __props.items,
              "heading-tag": __props.collapsibleHeadingTag,
              "custom-classes": __props.customClasses
            }, null, 8, ["items", "heading-tag", "custom-classes"])) : unref(footerVariant) === "medium" || unref(footerVariant) === "slim" ? (openBlock(), createBlock(unref(_sfc_main$W), {
              key: 1,
              items: __props.items,
              "custom-classes": __props.customClasses
            }, null, 8, ["items", "custom-classes"])) : createCommentVNode("", true)
          ], 64)) : createCommentVNode("", true)
        ])
      ], 8, _hoisted_1$L);
    };
  }
};
var _sfc_main$U = {};
var _hoisted_1$K = { class: "usa-footer__primary-section" };
function _sfc_render$2(_ctx, _cache) {
  return openBlock(), createElementBlock("div", _hoisted_1$K, [
    renderSlot(_ctx.$slots, "default")
  ]);
}
var UsaFooterPrimarySection = _export_sfc(_sfc_main$U, [["render", _sfc_render$2]]);
var _hoisted_1$J = { class: "usa-footer__secondary-section" };
var _sfc_main$T = {
  __name: "UsaFooterSecondarySection",
  props: {
    customClasses: {
      type: Object,
      default: () => ({
        container: []
      })
    }
  },
  setup(__props) {
    const props = __props;
    const gridNamespace = inject("vueUswds.gridNamespace", GRID_NAMESPACE);
    const containerClasses = computed(() => {
      var _a2, _b;
      return ((_b = (_a2 = props.customClasses) == null ? void 0 : _a2.container) == null ? void 0 : _b.length) ? props.customClasses.container : [`${gridNamespace}container`];
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$J, [
        createBaseVNode("div", {
          class: normalizeClass(containerClasses.value)
        }, [
          renderSlot(_ctx.$slots, "default")
        ], 2)
      ]);
    };
  }
};
var _hoisted_1$I = { class: "usa-footer__social-links" };
var _hoisted_2$i = ["src", "alt"];
var _sfc_main$S = {
  __name: "UsaFooterSocialLinks",
  props: {
    items: {
      type: Array,
      default: () => []
    },
    customClasses: {
      type: Object,
      default: () => ({
        gridCol: [],
        link: [],
        icon: []
      })
    }
  },
  setup(__props) {
    const props = __props;
    const gridNamespace = inject("vueUswds.gridNamespace", GRID_NAMESPACE);
    const gridColClasses = computed(() => {
      var _a2, _b;
      return ((_b = (_a2 = props.customClasses) == null ? void 0 : _a2.gridCol) == null ? void 0 : _b.length) ? props.customClasses.gridCol : [`${gridNamespace}col-auto`];
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$I, [
        (openBlock(true), createElementBlock(Fragment, null, renderList(__props.items, (item) => {
          var _a2;
          return openBlock(), createElementBlock("div", {
            key: (item == null ? void 0 : item.id) || item.name,
            class: normalizeClass(gridColClasses.value)
          }, [
            createVNode(unref(BaseLink), {
              to: item.to,
              href: item.href,
              class: normalizeClass(["usa-social-link", (_a2 = __props.customClasses) == null ? void 0 : _a2.link]),
              "router-component-name": item.routerComponentName
            }, {
              default: withCtx(() => [
                renderSlot(_ctx.$slots, (item == null ? void 0 : item.id) || item.name.toLowerCase(), { item }, () => {
                  var _a3;
                  return [
                    createBaseVNode("img", {
                      class: normalizeClass(["usa-social-link__icon", (_a3 = __props.customClasses) == null ? void 0 : _a3.icon]),
                      src: item.icon,
                      alt: item.name
                    }, null, 10, _hoisted_2$i)
                  ];
                })
              ]),
              _: 2
            }, 1032, ["to", "href", "class", "router-component-name"])
          ], 2);
        }), 128))
      ]);
    };
  }
};
var _sfc_main$R = {
  __name: "UsaGraphicList",
  props: {
    variant: {
      type: String,
      default: "dark",
      validator(variant) {
        const isValidVariant = ["light", "dark"].includes(variant);
        if (!isValidVariant) {
          console.warn(`'${variant}' is not a valid graphic list variant`);
        }
        return isValidVariant;
      }
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          container: []
        };
      }
    }
  },
  setup(__props) {
    const props = __props;
    const gridNamespace = inject("vueUswds.gridNamespace", GRID_NAMESPACE);
    const classes = computed(() => [
      {
        "usa-section--dark": props.variant === "dark",
        "usa-section--light": props.variant === "light"
      }
    ]);
    const containerClasses = computed(() => {
      var _a2, _b;
      return ((_b = (_a2 = props.customClasses) == null ? void 0 : _a2.container) == null ? void 0 : _b.length) ? props.customClasses.container : [`${gridNamespace}container`];
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("section", {
        class: normalizeClass(["usa-graphic-list usa-section", classes.value])
      }, [
        createBaseVNode("div", {
          class: normalizeClass(containerClasses.value)
        }, [
          renderSlot(_ctx.$slots, "default", { variant: __props.variant })
        ], 2)
      ], 2);
    };
  }
};
var _sfc_main$Q = {};
var _hoisted_1$H = { class: "usa-graphic-list__row" };
function _sfc_render$1(_ctx, _cache) {
  return openBlock(), createElementBlock("div", _hoisted_1$H, [
    renderSlot(_ctx.$slots, "default")
  ]);
}
var UsaGraphicListRow = _export_sfc(_sfc_main$Q, [["render", _sfc_render$1]]);
var _sfc_main$P = {
  __name: "UsaHeader",
  props: {
    variant: {
      type: String,
      default: "basic",
      validator(variant) {
        const isValidVariant = ["basic", "extended"].includes(variant);
        if (!isValidVariant) {
          console.warn(`'${variant}' is not a valid header variant`);
        }
        return isValidVariant;
      }
    },
    megamenu: {
      type: Boolean,
      default: false
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          navContainer: []
        };
      }
    }
  },
  setup(__props) {
    const props = __props;
    const classes = computed(() => [
      {
        "usa-header--basic": props.variant === "basic",
        "usa-header--extended": props.variant === "extended",
        "usa-header--megamenu": props.megamenu
      }
    ]);
    provide("isExtendedHeader", computed(() => props.variant === "extended"));
    provide("isMegamenu", computed(() => props.megamenu));
    return (_ctx, _cache) => {
      var _a2;
      return openBlock(), createElementBlock("header", {
        class: normalizeClass(["usa-header", classes.value])
      }, [
        __props.variant === "basic" ? (openBlock(), createElementBlock("div", {
          key: 0,
          class: normalizeClass(["usa-nav-container", (_a2 = __props.customClasses) == null ? void 0 : _a2.navContainer])
        }, [
          renderSlot(_ctx.$slots, "default")
        ], 2)) : renderSlot(_ctx.$slots, "default", { key: 1 })
      ], 2);
    };
  }
};
var _hoisted_1$G = ["aria-label"];
var _sfc_main$O = {
  __name: "UsaHero",
  props: {
    backgroundImage: {
      type: String,
      default: ""
    },
    ariaLabel: {
      type: String,
      required: true
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          gridContainer: []
        };
      }
    }
  },
  setup(__props) {
    const props = __props;
    const gridNamespace = inject("vueUswds.gridNamespace", GRID_NAMESPACE);
    const gridContainerClasses = computed(() => {
      var _a2;
      return [
        `${gridNamespace}container`,
        ...((_a2 = props.customClasses) == null ? void 0 : _a2.gridContainer) || []
      ];
    });
    const backgroundImageStyle = computed(() => {
      return {
        backgroundImage: props.backgroundImage ? `url(${props.backgroundImage})` : null
      };
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("section", {
        class: "usa-hero",
        "aria-label": __props.ariaLabel,
        style: normalizeStyle(backgroundImageStyle.value)
      }, [
        createBaseVNode("div", {
          class: normalizeClass(gridContainerClasses.value)
        }, [
          renderSlot(_ctx.$slots, "default")
        ], 2)
      ], 12, _hoisted_1$G);
    };
  }
};
var _hoisted_1$F = { class: "usa-hero__callout" };
var _sfc_main$N = {
  __name: "UsaHeroCallout",
  props: {
    headingAlt: {
      type: String,
      default: ""
    },
    heading: {
      type: String,
      default: ""
    },
    headingTag: {
      type: String,
      default: "h1"
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          heading: [],
          headingAlt: []
        };
      }
    }
  },
  setup(__props) {
    const slots = useSlots();
    if (slots == null ? void 0 : slots.headingAlt) {
      console.warn(`The 'headingAlt' slot is deprecated, use 'heading-alt' instead.`);
    }
    return (_ctx, _cache) => {
      var _a2;
      return openBlock(), createElementBlock("div", _hoisted_1$F, [
        __props.heading || __props.headingAlt || _ctx.$slots.heading || _ctx.$slots.headingAlt || _ctx.$slots["heading-alt"] ? (openBlock(), createBlock(unref(_sfc_main$1z), {
          key: 0,
          tag: __props.headingTag,
          class: normalizeClass(["usa-hero__heading", (_a2 = __props.customClasses) == null ? void 0 : _a2.heading])
        }, {
          default: withCtx(() => {
            var _a3;
            return [
              __props.headingAlt || _ctx.$slots.headingAlt || _ctx.$slots["heading-alt"] ? (openBlock(), createElementBlock("span", {
                key: 0,
                class: normalizeClass(["usa-hero__heading--alt", (_a3 = __props.customClasses) == null ? void 0 : _a3.headingAlt])
              }, [
                _ctx.$slots["heading-alt"] ? renderSlot(_ctx.$slots, "heading-alt", { key: 0 }) : _ctx.$slots.headingAlt ? renderSlot(_ctx.$slots, "headingAlt", { key: 1 }) : (openBlock(), createElementBlock(Fragment, { key: 2 }, [
                  createTextVNode(toDisplayString(__props.headingAlt), 1)
                ], 64))
              ], 2)) : createCommentVNode("", true),
              renderSlot(_ctx.$slots, "heading", {}, () => [
                createTextVNode(toDisplayString(__props.heading), 1)
              ])
            ];
          }),
          _: 3
        }, 8, ["tag", "class"])) : createCommentVNode("", true),
        renderSlot(_ctx.$slots, "default")
      ]);
    };
  }
};
var _hoisted_1$E = ["aria-hidden", "role", "focusable"];
var _sfc_main$M = {
  __name: "UsaIcon",
  props: {
    name: {
      type: String,
      required: true
    },
    size: {
      type: [String, Number],
      default: "",
      validator(size) {
        const isValidSize = ["", "3", "4", "5", "6", "7", "8", "9"].includes(`${size}`);
        if (!isValidSize) {
          console.warn(`'${size}' is not a valid icon size`);
        }
        return isValidSize;
      }
    },
    ariaHidden: {
      type: Boolean,
      default: true
    },
    role: {
      type: String,
      default: "img"
    },
    focusable: {
      type: Boolean,
      default: false
    }
  },
  setup(__props) {
    const props = __props;
    const svgSpritePath = inject("vueUswds.svgSpritePath", SVG_SPRITE_PATH);
    const classes = computed(() => [
      {
        "usa-icon--size-3": `${props.size}` === "3",
        "usa-icon--size-4": `${props.size}` === "4",
        "usa-icon--size-5": `${props.size}` === "5",
        "usa-icon--size-6": `${props.size}` === "6",
        "usa-icon--size-7": `${props.size}` === "7",
        "usa-icon--size-8": `${props.size}` === "8",
        "usa-icon--size-9": `${props.size}` === "9"
      }
    ]);
    const iconHref = computed(() => `${svgSpritePath}#${props.name}`);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("svg", {
        class: normalizeClass(["usa-icon", classes.value]),
        "aria-hidden": __props.ariaHidden,
        role: __props.role,
        focusable: __props.focusable
      }, [
        renderSlot(_ctx.$slots, "title"),
        createBaseVNode("use", normalizeProps(guardReactiveProps({ "xlink:href": iconHref.value })), null, 16)
      ], 10, _hoisted_1$E);
    };
  }
};
var _sfc_main$L = {
  __name: "UsaIconList",
  props: {
    color: {
      type: String,
      default: ""
    },
    size: {
      type: [String, Object],
      default: "",
      validator(size) {
        let isValidSize = false;
        const validSizes = ["", "2xs", "xs", "sm", "md", "lg", "xl", "2xl"];
        if (typeof size === "string") {
          isValidSize = validSizes.includes(size);
        }
        if (typeof size === "object") {
          isValidSize = Object.values(size).some((breakpointSize) => validSizes.includes(breakpointSize));
        }
        if (!isValidSize) {
          console.warn(`'${size}' is not a valid icon list size`);
        }
        return isValidSize;
      }
    }
  },
  setup(__props) {
    const props = __props;
    const prefixSeparator = inject("vueUswds.prefixSeparator", PREFIX_SEPARATOR);
    const sizeClasses = computed(() => {
      if (!!props.size && typeof props.size === "string") {
        return [`usa-icon-list--size-${props.size}`];
      }
      if (typeof props.size === "object" && Object.keys(props.size).length) {
        return Object.keys(props.size).reduce((acc, breakpoint) => {
          acc.push(`${breakpoint}${prefixSeparator}usa-icon-list--size-${props.size[breakpoint]}`);
          return acc;
        }, []);
      }
      return [];
    });
    const classes = computed(() => [
      { [`usa-icon-list--${props.color}`]: props.color },
      ...sizeClasses.value
    ]);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("ul", {
        class: normalizeClass(["usa-icon-list", classes.value])
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 2);
    };
  }
};
var _hoisted_1$D = { class: "usa-icon-list__item" };
var _sfc_main$K = {
  __name: "UsaIconListItem",
  props: {
    icon: {
      type: String,
      required: true
    },
    title: {
      type: String,
      default: ""
    },
    titleTag: {
      type: String,
      default: "h2"
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          icon: [],
          content: [],
          title: []
        };
      }
    }
  },
  setup(__props) {
    return (_ctx, _cache) => {
      var _a2, _b, _c;
      return openBlock(), createElementBlock("li", _hoisted_1$D, [
        createBaseVNode("div", {
          class: normalizeClass(["usa-icon-list__icon", (_a2 = __props.customClasses) == null ? void 0 : _a2.icon])
        }, [
          renderSlot(_ctx.$slots, "icon", {}, () => [
            createVNode(unref(_sfc_main$M), { name: __props.icon }, null, 8, ["name"])
          ])
        ], 2),
        createBaseVNode("div", {
          class: normalizeClass(["usa-icon-list__content", (_b = __props.customClasses) == null ? void 0 : _b.content])
        }, [
          __props.title || _ctx.$slots.title ? (openBlock(), createBlock(unref(_sfc_main$1z), {
            key: 0,
            tag: __props.titleTag,
            class: normalizeClass(["usa-icon-list__title", (_c = __props.customClasses) == null ? void 0 : _c.title])
          }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "title", {}, () => [
                createTextVNode(toDisplayString(__props.title), 1)
              ])
            ]),
            _: 3
          }, 8, ["tag", "class"])) : createCommentVNode("", true),
          renderSlot(_ctx.$slots, "default")
        ], 2)
      ]);
    };
  }
};
var _hoisted_1$C = ["aria-label"];
var _hoisted_2$h = { class: "usa-identifier__container" };
var _hoisted_3$9 = { class: "usa-identifier__usagov-description" };
var _hoisted_4$4 = ["href"];
var _sfc_main$J = {
  __name: "UsaIdentiferMoreInfo",
  props: {
    ariaLabel: {
      type: String,
      default: "U.S. government information and services"
    },
    description: {
      type: String,
      default: "Looking for U.S. government information and services?"
    },
    linkText: {
      type: String,
      default: "Visit USA.gov"
    },
    linkUrl: {
      type: String,
      default: "https://www.usa.gov"
    }
  },
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("section", {
        class: "usa-identifier__section usa-identifier__section--usagov",
        "aria-label": __props.ariaLabel
      }, [
        createBaseVNode("div", _hoisted_2$h, [
          createBaseVNode("div", _hoisted_3$9, toDisplayString(__props.description), 1),
          createTextVNode("  "),
          createBaseVNode("a", {
            href: __props.linkUrl,
            class: "usa-link"
          }, toDisplayString(__props.linkText), 9, _hoisted_4$4)
        ])
      ], 8, _hoisted_1$C);
    };
  }
};
var _sfc_main$I = {};
var _hoisted_1$B = { class: "usa-identifier" };
function _sfc_render(_ctx, _cache) {
  return openBlock(), createElementBlock("div", _hoisted_1$B, [
    renderSlot(_ctx.$slots, "default")
  ]);
}
var UsaIdentifier = _export_sfc(_sfc_main$I, [["render", _sfc_render]]);
var _hoisted_1$A = ["src", "alt"];
var _sfc_main$H = {
  __name: "UsaIdentifierLogo",
  props: {
    href: {
      type: String,
      default: ""
    },
    to: {
      type: [String, Object],
      default: ""
    },
    routerComponentName: {
      type: String,
      default: ""
    },
    src: {
      type: String,
      default: ""
    },
    alt: {
      type: String,
      default: ""
    },
    customClasses: {
      type: Object,
      default: () => ({
        image: []
      })
    }
  },
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(BaseLink), {
        href: __props.href,
        to: __props.to,
        "router-component-name": __props.routerComponentName,
        class: "usa-identifier__logo"
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default", {}, () => {
            var _a2;
            return [
              __props.src ? (openBlock(), createElementBlock("img", {
                key: 0,
                class: normalizeClass(["usa-identifier__logo-img", (_a2 = __props.customClasses) == null ? void 0 : _a2.image]),
                src: __props.src,
                alt: __props.alt,
                role: "img"
              }, null, 10, _hoisted_1$A)) : createCommentVNode("", true)
            ];
          })
        ]),
        _: 3
      }, 8, ["href", "to", "router-component-name"]);
    };
  }
};
var _hoisted_1$z = ["aria-label"];
var _hoisted_2$g = { class: "usa-identifier__container" };
var _hoisted_3$8 = {
  key: 0,
  class: "usa-identifier__logos"
};
var _hoisted_4$3 = ["aria-label"];
var _hoisted_5$1 = {
  key: 0,
  class: "usa-identifier__identity-domain"
};
var _hoisted_6$1 = {
  key: 1,
  class: "usa-identifier__identity-disclaimer"
};
var _sfc_main$G = {
  __name: "UsaIdentifierMasthead",
  props: {
    ariaLabel: {
      type: String,
      default: "Agency identifier"
    },
    descriptionAriaLabel: {
      type: String,
      default: "Agency description"
    }
  },
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("section", {
        class: "usa-identifier__section usa-identifier__section--masthead",
        "aria-label": __props.ariaLabel
      }, [
        createBaseVNode("div", _hoisted_2$g, [
          renderSlot(_ctx.$slots, "default", {}, () => [
            _ctx.$slots.logos ? (openBlock(), createElementBlock("div", _hoisted_3$8, [
              renderSlot(_ctx.$slots, "logos")
            ])) : createCommentVNode("", true),
            _ctx.$slots.domain || _ctx.$slots.disclaimer ? (openBlock(), createElementBlock("div", {
              key: 1,
              class: "usa-identifier__identity",
              "aria-label": __props.descriptionAriaLabel
            }, [
              _ctx.$slots.domain ? (openBlock(), createElementBlock("p", _hoisted_5$1, [
                renderSlot(_ctx.$slots, "domain")
              ])) : createCommentVNode("", true),
              _ctx.$slots.disclaimer ? (openBlock(), createElementBlock("p", _hoisted_6$1, [
                renderSlot(_ctx.$slots, "disclaimer")
              ])) : createCommentVNode("", true)
            ], 8, _hoisted_4$3)) : createCommentVNode("", true)
          ])
        ])
      ], 8, _hoisted_1$z);
    };
  }
};
var _hoisted_1$y = ["aria-label"];
var _hoisted_2$f = { class: "usa-identifier__container" };
var _hoisted_3$7 = { class: "usa-identifier__required-links-list" };
var _sfc_main$F = {
  __name: "UsaIdentifierRequiredLinks",
  props: {
    ariaLabel: {
      type: String,
      default: "Important links"
    },
    items: {
      type: Array,
      default: () => []
    }
  },
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("nav", {
        class: "usa-identifier__section usa-identifier__section--required-links",
        "aria-label": __props.ariaLabel
      }, [
        createBaseVNode("div", _hoisted_2$f, [
          createBaseVNode("ul", _hoisted_3$7, [
            (openBlock(true), createElementBlock(Fragment, null, renderList(__props.items, (item) => {
              return openBlock(), createElementBlock("li", {
                key: (item == null ? void 0 : item.id) || item.text,
                class: "usa-identifier__required-links-item"
              }, [
                createVNode(unref(BaseLink), {
                  to: item.to,
                  href: item.href,
                  "router-component-name": item.routerComponentName,
                  class: "usa-identifier__required-link usa-link"
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(item.text), 1)
                  ]),
                  _: 2
                }, 1032, ["to", "href", "router-component-name"])
              ]);
            }), 128))
          ])
        ])
      ], 8, _hoisted_1$y);
    };
  }
};
var _sfc_main$E = {
  __name: "UsaLink",
  props: {
    alt: {
      type: Boolean,
      default: false
    },
    external: {
      type: Boolean,
      default: false
    }
  },
  setup(__props) {
    const props = __props;
    const classes = computed(() => [
      {
        "usa-link--alt": props.alt,
        "usa-link--external": props.external
      }
    ]);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(BaseLink), {
        class: normalizeClass(["usa-link", classes.value])
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 3
      }, 8, ["class"]);
    };
  }
};
var _hoisted_1$x = { class: "usa-logo" };
var _sfc_main$D = {
  __name: "UsaLogo",
  props: {
    title: {
      type: String,
      default: ""
    },
    href: {
      type: String,
      default: ""
    },
    to: {
      type: [String, Object],
      default: "/"
    },
    routerComponentName: {
      type: String,
      default: ""
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          text: [],
          link: []
        };
      }
    }
  },
  setup(__props) {
    return (_ctx, _cache) => {
      var _a2, _b;
      return openBlock(), createElementBlock("div", _hoisted_1$x, [
        createBaseVNode("em", {
          class: normalizeClass(["usa-logo__text", (_a2 = __props.customClasses) == null ? void 0 : _a2.text])
        }, [
          createVNode(unref(BaseLink), {
            href: __props.href,
            to: __props.to,
            "router-component-name": __props.routerComponentName,
            title: __props.title,
            class: normalizeClass((_b = __props.customClasses) == null ? void 0 : _b.link)
          }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "default", {}, () => [
                createTextVNode(toDisplayString(__props.title), 1)
              ])
            ]),
            _: 3
          }, 8, ["href", "to", "router-component-name", "title", "class"])
        ], 2)
      ]);
    };
  }
};
var _hoisted_1$w = { class: "usa-media-block" };
var _sfc_main$C = {
  __name: "UsaMediaBlock",
  props: {
    customClasses: {
      type: Object,
      default: () => {
        return {
          media: [],
          body: []
        };
      }
    }
  },
  setup(__props) {
    return (_ctx, _cache) => {
      var _a2, _b;
      return openBlock(), createElementBlock("div", _hoisted_1$w, [
        createBaseVNode("div", {
          class: normalizeClass(["usa-media-block__img", (_a2 = __props.customClasses) == null ? void 0 : _a2.media])
        }, [
          renderSlot(_ctx.$slots, "media")
        ], 2),
        createBaseVNode("div", {
          class: normalizeClass(["usa-media-block__body", (_b = __props.customClasses) == null ? void 0 : _b.body])
        }, [
          renderSlot(_ctx.$slots, "default")
        ], 2)
      ]);
    };
  }
};
var UseFocusTrap = defineComponent({
  name: "UseFocusTrap",
  props: ["as", "options"],
  setup(props, { slots }) {
    let trap;
    const target = ref();
    const activate = () => trap && trap.activate();
    const deactivate = () => trap && trap.deactivate();
    watch(() => unrefElement(target), (el) => {
      if (!el)
        return;
      trap = createFocusTrap(el, props.options || {});
      activate();
    }, { flush: "post" });
    onScopeDispose(() => deactivate());
    return () => {
      if (slots.default)
        return h(props.as || "div", { ref: target }, slots.default());
    };
  }
});
var _hoisted_1$v = ["aria-label"];
var _hoisted_2$e = {
  key: 0,
  class: "usa-icon",
  "aria-hidden": "true",
  focusable: "false",
  role: "img"
};
var _sfc_main$B = {
  __name: "UsaModalCloseButton",
  props: {
    ariaLabel: {
      type: String,
      required: true
    }
  },
  setup(__props) {
    const svgSpritePath = inject("vueUswds.svgSpritePath", SVG_SPRITE_PATH);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("button", {
        type: "button",
        class: "usa-button usa-modal__close",
        "aria-label": __props.ariaLabel
      }, [
        renderSlot(_ctx.$slots, "default", { svgSpritePath: unref(svgSpritePath) }, () => [
          unref(svgSpritePath) ? (openBlock(), createElementBlock("svg", _hoisted_2$e, [
            createBaseVNode("use", normalizeProps(guardReactiveProps({ "xlink:href": `${unref(svgSpritePath)}#close` })), null, 16)
          ])) : createCommentVNode("", true)
        ])
      ], 8, _hoisted_1$v);
    };
  }
};
var _hoisted_1$u = ["id", "aria-labelledby", "aria-describedby"];
var modalBodyClass = "usa-js-modal--active";
var noClickBodyClass = "usa-js-no-click";
var focusTrapClass = "js-focus-trap-wrapper";
var _sfc_main$A = {
  __name: "UsaModal",
  props: {
    size: {
      type: String,
      default: "",
      validator(size) {
        const isValidSize = ["", "lg"].includes(size);
        if (!isValidSize) {
          console.warn(`'${size}' is not a valid modal size`);
        }
        return isValidSize;
      }
    },
    id: {
      type: String,
      default: ""
    },
    visible: {
      type: Boolean,
      default: false
    },
    forceAction: {
      type: Boolean,
      default: false
    },
    closeButtonLabel: {
      type: String,
      default: "Close this window"
    },
    heading: {
      type: String,
      default: ""
    },
    headingTag: {
      type: String,
      default: "h2"
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          focusTrap: [],
          modal: [],
          overlay: [],
          content: [],
          main: [],
          heading: [],
          description: [],
          footer: []
        };
      }
    }
  },
  emits: ["update:visible"],
  setup(__props, { emit }) {
    const props = __props;
    const slots = useSlots();
    if (slots == null ? void 0 : slots.closeButton) {
      console.warn(`The 'closeButton' slot is deprecated, use 'close-button' instead.`);
    }
    const modal = ref(null);
    const isVisible = computed({
      get: () => props.visible,
      set: (currentlyVisibility) => emit("update:visible", currentlyVisibility)
    });
    const classes = computed(() => {
      return [{ "is-visible": isVisible.value }];
    });
    const modalClasses = computed(() => {
      var _a2;
      return [{ "usa-modal--lg": props.size === "lg" }, (_a2 = props.customClasses) == null ? void 0 : _a2.modal];
    });
    const computedId = computed(() => props.id || nextId("usa-modal"));
    const headingId = `${computedId.value}-heading`;
    const descriptionId = `${computedId.value}-description`;
    watch(() => isVisible, (currentlyVisible) => {
      if (currentlyVisible.value) {
        document.body.classList.add(modalBodyClass);
        document.querySelectorAll(`body > :not(.${focusTrapClass})`).forEach((element) => element.setAttribute("aria-hidden", true));
        if (props.forceAction) {
          document.body.classList.add(noClickBodyClass);
        }
      } else {
        document.body.classList.remove(modalBodyClass);
        document.querySelectorAll(`body > :not(${focusTrapClass})`).forEach((element) => element.removeAttribute("aria-hidden", true));
        if (props.forceAction) {
          document.body.classList.remove(noClickBodyClass);
        }
      }
    }, {
      immediate: true,
      deep: true
    });
    onBeforeUnmount(() => {
      document.body.classList.remove(modalBodyClass);
      document.querySelectorAll(`body > :not(.${focusTrapClass})`).forEach((element) => element.removeAttribute("aria-hidden", true));
      if (props.forceAction) {
        document.body.classList.remove(noClickBodyClass);
      }
    });
    onKeyStroke("Escape", () => {
      if (isVisible.value && !props.forceAction) {
        isVisible.value = false;
      }
    });
    onClickOutside(modal, () => {
      if (isVisible.value && !props.forceAction) {
        isVisible.value = false;
      }
    });
    return (_ctx, _cache) => {
      var _a2;
      return openBlock(), createBlock(Teleport, { to: "body" }, [
        isVisible.value ? (openBlock(), createBlock(unref(UseFocusTrap), {
          key: 0,
          class: normalizeClass([`${focusTrapClass}`, (_a2 = __props.customClasses) == null ? void 0 : _a2.focusTrap])
        }, {
          default: withCtx(() => {
            var _a3, _b, _c, _d, _e, _f;
            return [
              createBaseVNode("div", mergeProps(_ctx.$attrs, {
                id: `${computedId.value}-modal`,
                class: ["usa-modal-wrapper", classes.value],
                role: "dialog",
                "aria-labelledby": _ctx.$slots.heading || __props.heading ? headingId : null,
                "aria-describedby": _ctx.$slots.default ? descriptionId : null
              }), [
                createBaseVNode("div", {
                  class: normalizeClass(["usa-modal-overlay", (_a3 = __props.customClasses) == null ? void 0 : _a3.overlay])
                }, [
                  createBaseVNode("div", {
                    ref_key: "modal",
                    ref: modal,
                    class: normalizeClass(["usa-modal", modalClasses.value]),
                    tabindex: "-1"
                  }, [
                    createBaseVNode("div", {
                      class: normalizeClass(["usa-modal__content", (_b = __props.customClasses) == null ? void 0 : _b.content])
                    }, [
                      createBaseVNode("div", {
                        class: normalizeClass(["usa-modal__main", (_c = __props.customClasses) == null ? void 0 : _c.main])
                      }, [
                        _ctx.$slots.heading || __props.heading ? (openBlock(), createBlock(unref(_sfc_main$1z), {
                          key: 0,
                          id: headingId,
                          tag: __props.headingTag,
                          class: normalizeClass(["usa-modal__heading", (_d = __props.customClasses) == null ? void 0 : _d.heading])
                        }, {
                          default: withCtx(() => [
                            renderSlot(_ctx.$slots, "heading", {}, () => [
                              createTextVNode(toDisplayString(__props.heading), 1)
                            ])
                          ]),
                          _: 3
                        }, 8, ["tag", "class"])) : createCommentVNode("", true),
                        _ctx.$slots.default ? (openBlock(), createElementBlock("div", {
                          key: 1,
                          id: descriptionId,
                          class: normalizeClass((_e = __props.customClasses) == null ? void 0 : _e.description)
                        }, [
                          renderSlot(_ctx.$slots, "default")
                        ], 2)) : createCommentVNode("", true),
                        _ctx.$slots.footer ? (openBlock(), createElementBlock("div", {
                          key: 2,
                          class: normalizeClass(["usa-modal__footer", (_f = __props.customClasses) == null ? void 0 : _f.footer])
                        }, [
                          renderSlot(_ctx.$slots, "footer")
                        ], 2)) : createCommentVNode("", true)
                      ], 2),
                      _ctx.$slots["close-button"] ? renderSlot(_ctx.$slots, "close-button", { key: 0 }) : _ctx.$slots.closeButton ? renderSlot(_ctx.$slots, "closeButton", { key: 1 }) : (openBlock(), createElementBlock(Fragment, { key: 2 }, [
                        !__props.forceAction ? (openBlock(), createBlock(unref(_sfc_main$B), {
                          key: 0,
                          "aria-label": __props.closeButtonLabel,
                          onClick: _cache[0] || (_cache[0] = ($event) => isVisible.value = false)
                        }, null, 8, ["aria-label"])) : createCommentVNode("", true)
                      ], 64))
                    ], 2)
                  ], 2)
                ], 2)
              ], 16, _hoisted_1$u)
            ];
          }),
          _: 3
        }, 8, ["class"])) : createCommentVNode("", true)
      ]);
    };
  }
};
var _sfc_main$z = {
  __name: "UsaOverlay",
  props: {
    visible: {
      type: Boolean,
      default: false
    }
  },
  setup(__props) {
    const props = __props;
    const classes = computed(() => [{ "is-visible": props.visible }]);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(["usa-overlay", classes.value])
      }, null, 2);
    };
  }
};
var _hoisted_1$t = ["id", "aria-label"];
var _hoisted_2$d = ["src", "alt"];
var _sfc_main$y = {
  __name: "UsaNav",
  props: {
    ariaLabel: {
      type: String,
      default: "Primary navigation"
    },
    closeButtonLabel: {
      type: String,
      default: "Close"
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          button: []
        };
      }
    }
  },
  setup(__props) {
    const imagePath = inject("vueUswds.imagePath", IMAGE_PATH);
    const mobileMenuBreakpoint = inject("vueUswds.mobileMenuBreakpoint", MOBILE_MENU_BREAKPOINT);
    const isExtendedHeader = inject("isExtendedHeader", ref(false));
    const isMobileMenuOpen2 = inject("isMobileMenuOpen", ref(false));
    const mobileMenuId = inject("mobileMenuId");
    const closeMobileMenu = inject("closeMobileMenu");
    const nav = ref(null);
    const { activate, deactivate } = useFocusTrap(nav);
    const largeScreen = useMediaQuery(`(min-width: ${mobileMenuBreakpoint})`);
    watch(isMobileMenuOpen2, async (isMenuOpen) => {
      if (isMenuOpen) {
        await nextTick;
        activate();
      } else {
        await nextTick;
        deactivate();
      }
    });
    watch(largeScreen, (isLargeScreen) => {
      if (isLargeScreen) {
        closeMobileMenu();
      }
    });
    onBeforeUnmount(() => {
      if (isMobileMenuOpen2.value) {
        closeMobileMenu();
      }
    });
    onKeyStroke("Escape", () => {
      if (isMobileMenuOpen2.value) {
        closeMobileMenu();
      }
    });
    onClickOutside(nav, () => {
      if (isMobileMenuOpen2.value) {
        closeMobileMenu();
      }
    });
    const classes = computed(() => [
      {
        "is-visible": isMobileMenuOpen2.value
      }
    ]);
    const UsaNavInnerComponent = {
      name: "UsaNavInner",
      props: {
        wrap: {
          type: Boolean,
          default: false
        }
      },
      setup({ wrap }, { slots }) {
        return () => wrap ? h("div", { class: "usa-nav__inner" }, slots.default()) : slots.default();
      }
    };
    return (_ctx, _cache) => {
      return openBlock(), createBlock(Teleport, {
        to: "body",
        disabled: !unref(isMobileMenuOpen2)
      }, [
        createVNode(unref(_sfc_main$z), { visible: unref(isMobileMenuOpen2) }, null, 8, ["visible"]),
        createBaseVNode("nav", {
          id: unref(mobileMenuId),
          ref_key: "nav",
          ref: nav,
          "aria-label": __props.ariaLabel,
          class: normalizeClass(["usa-nav", classes.value])
        }, [
          createVNode(UsaNavInnerComponent, { wrap: unref(isExtendedHeader) }, {
            default: withCtx(() => {
              var _a2;
              return [
                createBaseVNode("button", {
                  type: "button",
                  class: normalizeClass(["usa-nav__close", (_a2 = __props.customClasses) == null ? void 0 : _a2.button]),
                  onClick: _cache[0] || (_cache[0] = (...args) => unref(closeMobileMenu) && unref(closeMobileMenu)(...args))
                }, [
                  renderSlot(_ctx.$slots, "close-button", { closeButtonLabel: __props.closeButtonLabel }, () => [
                    createBaseVNode("img", {
                      src: `${unref(imagePath)}/usa-icons/close.svg`,
                      role: "img",
                      alt: __props.closeButtonLabel
                    }, null, 8, _hoisted_2$d)
                  ])
                ], 2),
                unref(largeScreen) ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                  renderSlot(_ctx.$slots, "primary"),
                  renderSlot(_ctx.$slots, "secondary")
                ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                  renderSlot(_ctx.$slots, "secondary"),
                  renderSlot(_ctx.$slots, "primary")
                ], 64))
              ];
            }),
            _: 3
          }, 8, ["wrap"])
        ], 10, _hoisted_1$t)
      ], 8, ["disabled"]);
    };
  }
};
var _hoisted_1$s = { class: "usa-nav__primary-item" };
var _sfc_main$x = {
  __name: "UsaNavDropdown",
  props: {
    id: {
      type: String,
      default: ""
    },
    open: {
      type: Boolean,
      default: false
    }
  },
  setup(__props) {
    const props = __props;
    const registerDropdown = inject("registerDropdown");
    const unregisterDropdown = inject("unregisterDropdown");
    const dropdownId = computed(() => props.id || nextId("usa-nav-dropdown"));
    registerDropdown(dropdownId.value, props.open);
    provide("dropdownId", dropdownId);
    onBeforeUnmount(() => {
      unregisterDropdown(dropdownId.value);
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", _hoisted_1$s, [
        renderSlot(_ctx.$slots, "default")
      ]);
    };
  }
};
var _hoisted_1$r = ["aria-expanded", "aria-controls"];
var _hoisted_2$c = ["aria-expanded", "aria-controls"];
var __default__$8 = {
  inheritAttrs: false
};
var _sfc_main$w = Object.assign(__default__$8, {
  __name: "UsaNavDropdownButton",
  setup(__props) {
    const routerComponentName = inject("vueUswds.routerComponentName", ROUTER_COMPONENT_NAME);
    const dropdownId = inject("dropdownId");
    const toggleDropdown = inject("toggleDropdown");
    const dropdownItems = inject("dropdownItems");
    const isOpen = toRef(dropdownItems, dropdownId.value);
    return (_ctx, _cache) => {
      return unref(routerComponentName) ? (openBlock(), createBlock(resolveDynamicComponent(unref(routerComponentName)), {
        key: 0,
        custom: ""
      }, {
        default: withCtx(({ isActive, isExactActive }) => [
          createBaseVNode("button", mergeProps(_ctx.$attrs, {
            type: "button",
            class: ["usa-accordion__button usa-nav__link", [{ "usa-current": isActive || isExactActive }]],
            "aria-expanded": isOpen.value,
            "aria-controls": unref(dropdownId),
            onClick: _cache[0] || (_cache[0] = ($event) => unref(toggleDropdown)(unref(dropdownId)))
          }), [
            createBaseVNode("span", null, [
              renderSlot(_ctx.$slots, "default")
            ])
          ], 16, _hoisted_1$r)
        ]),
        _: 3
      })) : (openBlock(), createElementBlock("button", mergeProps({ key: 1 }, _ctx.$attrs, {
        type: "button",
        class: "usa-accordion__button usa-nav__link",
        "aria-expanded": isOpen.value,
        "aria-controls": unref(dropdownId),
        onClick: _cache[1] || (_cache[1] = ($event) => unref(toggleDropdown)(unref(dropdownId)))
      }), [
        createBaseVNode("span", null, [
          renderSlot(_ctx.$slots, "default")
        ])
      ], 16, _hoisted_2$c));
    };
  }
});
var _hoisted_1$q = { class: "usa-nav__primary-item" };
var __default__$7 = {
  inheritAttrs: false
};
var _sfc_main$v = Object.assign(__default__$7, {
  __name: "UsaNavPrimaryItem",
  props: {
    href: {
      type: String,
      default: ""
    },
    to: {
      type: [String, Object],
      default: ""
    },
    routerComponentName: {
      type: String,
      default: ""
    }
  },
  setup(__props) {
    const closeAllDropdowns = inject("closeAllDropdowns");
    const closeMobileMenu = inject("closeMobileMenu");
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", _hoisted_1$q, [
        createVNode(unref(BaseLink), mergeProps(_ctx.$attrs, {
          class: "usa-nav__link",
          href: __props.href,
          to: __props.to,
          "router-component-name": __props.routerComponentName,
          onClick: _cache[0] || (_cache[0] = ($event) => (unref(closeAllDropdowns)(), unref(closeMobileMenu)()))
        }), {
          default: withCtx(() => [
            createBaseVNode("span", null, [
              renderSlot(_ctx.$slots, "default")
            ])
          ]),
          _: 3
        }, 16, ["href", "to", "router-component-name"])
      ]);
    };
  }
});
var _hoisted_1$p = ["id", "hidden"];
var _hoisted_2$b = { class: "usa-nav__submenu-list" };
var _hoisted_3$6 = { class: "usa-nav__submenu-list" };
var _hoisted_4$2 = ["id", "hidden"];
var _sfc_main$u = {
  __name: "UsaNavSubmenu",
  props: {
    cols: {
      type: Number,
      default: 1,
      validator(columnCount) {
        const isValidColumnCount = columnCount >= 1;
        if (!isValidColumnCount) {
          console.warn("Column count must be greater than or equal to 1");
        }
        return isValidColumnCount;
      }
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          gridRow: [],
          gridCol: []
        };
      }
    }
  },
  setup(__props) {
    const props = __props;
    const gridNamespace = inject("vueUswds.gridNamespace", GRID_NAMESPACE);
    const isMegamenu = inject("isMegamenu", ref(false));
    const dropdownId = inject("dropdownId");
    const dropdownItems = inject("dropdownItems");
    const classes = computed(() => [{ "usa-megamenu": isMegamenu.value }]);
    const gridClasses = computed(() => {
      var _a2;
      return [
        `${gridNamespace}row`,
        `${gridNamespace}gap-4`,
        ...((_a2 = props.customClasses) == null ? void 0 : _a2.gridRow) || []
      ];
    });
    const isOpen = toRef(dropdownItems, dropdownId.value);
    return (_ctx, _cache) => {
      var _a2;
      return unref(isMegamenu) ? (openBlock(), createElementBlock("div", {
        key: 0,
        id: unref(dropdownId),
        class: normalizeClass(["usa-nav__submenu", classes.value]),
        hidden: !isOpen.value
      }, [
        createBaseVNode("div", {
          class: normalizeClass(gridClasses.value)
        }, [
          __props.cols > 1 ? (openBlock(true), createElementBlock(Fragment, { key: 0 }, renderList(__props.cols, (col) => {
            var _a3;
            return openBlock(), createElementBlock("div", {
              key: col,
              class: normalizeClass(["usa-col", (_a3 = __props.customClasses) == null ? void 0 : _a3.gridCol])
            }, [
              createBaseVNode("ul", _hoisted_2$b, [
                renderSlot(_ctx.$slots, `col-${col}`)
              ])
            ], 2);
          }), 128)) : (openBlock(), createElementBlock("div", {
            key: 1,
            class: normalizeClass(["usa-col", (_a2 = __props.customClasses) == null ? void 0 : _a2.gridCol])
          }, [
            createBaseVNode("ul", _hoisted_3$6, [
              renderSlot(_ctx.$slots, "default")
            ])
          ], 2))
        ], 2)
      ], 10, _hoisted_1$p)) : (openBlock(), createElementBlock("ul", {
        key: 1,
        id: unref(dropdownId),
        class: normalizeClass(["usa-nav__submenu", classes.value]),
        hidden: !isOpen.value
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 10, _hoisted_4$2));
    };
  }
};
var _hoisted_1$o = { class: "usa-nav__submenu-item" };
var __default__$6 = {
  inheritAttrs: false
};
var _sfc_main$t = Object.assign(__default__$6, {
  __name: "UsaNavSubmenuItem",
  props: {
    href: {
      type: String,
      default: ""
    },
    to: {
      type: [String, Object],
      default: ""
    },
    routerComponentName: {
      type: String,
      default: ""
    }
  },
  setup(__props) {
    const dropdownId = inject("dropdownId");
    const closeDropdown = inject("closeDropdown");
    const closeMobileMenu = inject("closeMobileMenu");
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", _hoisted_1$o, [
        createVNode(unref(BaseLink), mergeProps(_ctx.$attrs, {
          href: __props.href,
          to: __props.to,
          "router-component-name": __props.routerComponentName,
          onClick: _cache[0] || (_cache[0] = ($event) => (unref(closeDropdown)(unref(dropdownId)), unref(closeMobileMenu)()))
        }), {
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "default")
          ]),
          _: 3
        }, 16, ["href", "to", "router-component-name"])
      ]);
    };
  }
});
var _sfc_main$s = {
  __name: "UsaNavPrimary",
  props: {
    items: {
      type: Array,
      default: () => []
    }
  },
  emits: ["update:items"],
  setup(__props, { emit }) {
    const mobileMenuBreakpoint = inject("vueUswds.mobileMenuBreakpoint", MOBILE_MENU_BREAKPOINT);
    const isMegamenu = inject("isMegamenu", ref(false));
    const nav = ref(null);
    const largeScreen = useMediaQuery(`(min-width: ${mobileMenuBreakpoint})`);
    const isMultiSelectable = computed(() => !largeScreen.value);
    const dropdownItems = reactive({});
    const {
      registerAccordionItem,
      unregisterAccordionItem,
      closeItem,
      toggleItem,
      closeAllItems
    } = useAccordion(dropdownItems, isMultiSelectable);
    watch(dropdownItems, () => {
      emit("update:items", dropdownItems);
    });
    watch(largeScreen, closeAllItems);
    provide("registerDropdown", registerAccordionItem);
    provide("unregisterDropdown", unregisterAccordionItem);
    provide("toggleDropdown", toggleItem);
    provide("closeDropdown", closeItem);
    provide("closeAllDropdowns", closeAllItems);
    provide("dropdownItems", dropdownItems);
    onKeyStroke("Escape", closeAllItems);
    onClickOutside(nav, closeAllItems);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("ul", {
        ref_key: "nav",
        ref: nav,
        class: "usa-nav__primary usa-accordion"
      }, [
        renderSlot(_ctx.$slots, "default", { items: __props.items }, () => [
          (openBlock(true), createElementBlock(Fragment, null, renderList(__props.items, (item) => {
            var _a2;
            return openBlock(), createElementBlock(Fragment, null, [
              ((_a2 = item == null ? void 0 : item.children) == null ? void 0 : _a2.length) ? (openBlock(), createBlock(unref(_sfc_main$x), {
                key: (item == null ? void 0 : item.id) || item.text
              }, {
                default: withCtx(() => [
                  createVNode(unref(_sfc_main$w), normalizeProps(guardReactiveProps(item == null ? void 0 : item.attrs)), {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(item.text), 1)
                    ]),
                    _: 2
                  }, 1040),
                  (item == null ? void 0 : item.cols) > 1 && unref(isMegamenu) ? (openBlock(), createBlock(unref(_sfc_main$u), {
                    key: item.children.map((item2) => (item2 == null ? void 0 : item2.id) || item2.text),
                    cols: item.cols
                  }, createSlots({ _: 2 }, [
                    renderList(item.cols, (n) => {
                      return {
                        name: `col-${n}`,
                        fn: withCtx(() => [
                          (openBlock(true), createElementBlock(Fragment, null, renderList(item.children, (submenuItem) => {
                            return openBlock(), createElementBlock(Fragment, null, [
                              (submenuItem == null ? void 0 : submenuItem.col) === n ? (openBlock(), createBlock(unref(_sfc_main$t), mergeProps({ key: 0 }, submenuItem == null ? void 0 : submenuItem.attrs, {
                                key: (submenuItem == null ? void 0 : submenuItem.id) || submenuItem.text,
                                href: submenuItem == null ? void 0 : submenuItem.href,
                                to: submenuItem == null ? void 0 : submenuItem.to,
                                "router-component-name": submenuItem == null ? void 0 : submenuItem.routerComponentName
                              }), {
                                default: withCtx(() => [
                                  createTextVNode(toDisplayString(submenuItem.text), 1)
                                ]),
                                _: 2
                              }, 1040, ["href", "to", "router-component-name"])) : createCommentVNode("", true)
                            ], 64);
                          }), 256))
                        ])
                      };
                    })
                  ]), 1032, ["cols"])) : (openBlock(), createBlock(unref(_sfc_main$u), {
                    key: item.children.map((item2) => (item2 == null ? void 0 : item2.id) || item2.text)
                  }, {
                    default: withCtx(() => [
                      (openBlock(true), createElementBlock(Fragment, null, renderList(item.children, (submenuItem) => {
                        return openBlock(), createBlock(unref(_sfc_main$t), mergeProps(submenuItem == null ? void 0 : submenuItem.attrs, {
                          key: (submenuItem == null ? void 0 : submenuItem.id) || submenuItem.text,
                          href: submenuItem == null ? void 0 : submenuItem.href,
                          to: submenuItem == null ? void 0 : submenuItem.to,
                          "router-component-name": submenuItem == null ? void 0 : submenuItem.routerComponentName
                        }), {
                          default: withCtx(() => [
                            createTextVNode(toDisplayString(submenuItem.text), 1)
                          ]),
                          _: 2
                        }, 1040, ["href", "to", "router-component-name"]);
                      }), 128))
                    ]),
                    _: 2
                  }, 1024))
                ]),
                _: 2
              }, 1024)) : (openBlock(), createBlock(unref(_sfc_main$v), mergeProps({
                key: (item == null ? void 0 : item.id) || item.text
              }, item == null ? void 0 : item.attrs, {
                href: item == null ? void 0 : item.href,
                to: item == null ? void 0 : item.to,
                "router-component-name": item == null ? void 0 : item.routerComponentName
              }), {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(item.text), 1)
                ]),
                _: 2
              }, 1040, ["href", "to", "router-component-name"]))
            ], 64);
          }), 256))
        ])
      ], 512);
    };
  }
};
var _hoisted_1$n = {
  key: 0,
  class: "usa-nav__secondary"
};
var _hoisted_2$a = { class: "usa-nav__secondary-links" };
var _sfc_main$r = {
  __name: "UsaNavSecondary",
  props: {
    items: {
      type: Array,
      default: () => []
    }
  },
  setup(__props) {
    const isExtendedHeader = inject("isExtendedHeader", false);
    return (_ctx, _cache) => {
      return unref(isExtendedHeader) ? (openBlock(), createElementBlock("div", _hoisted_1$n, [
        createBaseVNode("ul", _hoisted_2$a, [
          renderSlot(_ctx.$slots, "default", { items: __props.items }, () => [
            (openBlock(true), createElementBlock(Fragment, null, renderList(__props.items, (item) => {
              return openBlock(), createElementBlock("li", {
                key: (item == null ? void 0 : item.id) || item.text,
                class: "usa-nav__secondary-item"
              }, [
                createVNode(unref(BaseLink), {
                  to: item.to,
                  href: item.href,
                  "router-component-name": item.routerComponentName
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(item.text), 1)
                  ]),
                  _: 2
                }, 1032, ["to", "href", "router-component-name"])
              ]);
            }), 128))
          ])
        ]),
        renderSlot(_ctx.$slots, "search")
      ])) : renderSlot(_ctx.$slots, "search", { key: 1 });
    };
  }
};
var isMobileMenuOpen = ref(false);
var menuId = ref("__vuswds-id-global-mobile-header-menu");
var useMobileMenu = (emit) => {
  const mobileMenuOpenClass = "usa-js-mobile-nav--active";
  const closeMobileMenu = () => {
    isMobileMenuOpen.value = false;
    if (emit) {
      emit("mobileMenuOpen", false);
    }
    document.body.classList.remove(mobileMenuOpenClass);
    document.querySelectorAll("body > :not(.usa-nav)").forEach((element) => element.removeAttribute("aria-hidden", true));
  };
  const openMobileMenu = () => {
    isMobileMenuOpen.value = true;
    if (emit) {
      emit("mobileMenuOpen", true);
    }
    document.body.classList.add(mobileMenuOpenClass);
    document.querySelectorAll("body > :not(.usa-nav)").forEach((element) => element.setAttribute("aria-hidden", true));
  };
  const toggleMobileMenu = () => {
    if (isMobileMenuOpen.value) {
      closeMobileMenu();
    } else {
      openMobileMenu();
    }
  };
  return {
    isMobileMenuOpen: readonly(isMobileMenuOpen),
    mobileMenuId: readonly(menuId),
    closeMobileMenu,
    openMobileMenu,
    toggleMobileMenu
  };
};
var _hoisted_1$m = { class: "usa-navbar" };
var _hoisted_2$9 = ["aria-controls"];
var _sfc_main$q = {
  __name: "UsaNavbar",
  props: {
    menuButtonLabel: {
      type: String,
      default: "Menu"
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          button: []
        };
      }
    }
  },
  emits: ["mobileMenuOpen"],
  setup(__props, { emit }) {
    const {
      isMobileMenuOpen: isMobileMenuOpen2,
      mobileMenuId,
      closeMobileMenu,
      openMobileMenu,
      toggleMobileMenu
    } = useMobileMenu(emit);
    provide("isMobileMenuOpen", isMobileMenuOpen2);
    provide("mobileMenuId", mobileMenuId);
    provide("closeMobileMenu", closeMobileMenu);
    provide("openMobileMenu", openMobileMenu);
    provide("toggleMobileMenu", toggleMobileMenu);
    return (_ctx, _cache) => {
      var _a2;
      return openBlock(), createElementBlock("div", _hoisted_1$m, [
        renderSlot(_ctx.$slots, "default"),
        createBaseVNode("button", {
          type: "button",
          class: normalizeClass(["usa-menu-btn", (_a2 = __props.customClasses) == null ? void 0 : _a2.button]),
          "aria-controls": unref(mobileMenuId),
          onClick: _cache[0] || (_cache[0] = (...args) => unref(toggleMobileMenu) && unref(toggleMobileMenu)(...args))
        }, [
          renderSlot(_ctx.$slots, "menu-button", { menuButtonLabel: __props.menuButtonLabel }, () => [
            createTextVNode(toDisplayString(__props.menuButtonLabel), 1)
          ])
        ], 10, _hoisted_2$9)
      ]);
    };
  }
};
var usePagination = (_currentPage, totalPages, _unbounded, emit) => {
  const currentPage = ref(_currentPage);
  const unbounded = ref(_unbounded);
  const pageRange = computed(() => {
    const range = [];
    for (let i = 1; i <= totalPages.value; i++) {
      range.push(i);
    }
    return range;
  });
  const visiblePageRange = computed(() => {
    if (totalPages.value <= 7) {
      return pageRange.value;
    }
    if (currentPage.value - 3 <= 1) {
      const range2 = pageRange.value.slice(0, 7);
      range2[range2.length - 1] = totalPages.value;
      return range2;
    }
    if (currentPage.value + 3 >= totalPages.value) {
      const range2 = pageRange.value.slice(totalPages.value - 7, totalPages.value);
      range2[0] = 1;
      return range2;
    }
    const range = pageRange.value.slice(currentPage.value - 4, currentPage.value + 3);
    if (!unbounded.value) {
      range[range.length - 1] = totalPages.value;
    }
    range[0] = 1;
    return range;
  });
  const isFirstPage = computed(() => {
    return currentPage.value === 1;
  });
  const isLastPage = computed(() => {
    return currentPage.value === totalPages.value;
  });
  const isOverflowSlot = (index) => {
    if (totalPages.value <= 7) {
      return false;
    }
    if (index === 1 && currentPage.value > 4 || !unbounded.value && index === 5 && totalPages.value - currentPage.value > 3 || unbounded.value && index === 6 && currentPage.value !== totalPages.value) {
      return true;
    }
  };
  const updateCurrentPage = (number) => {
    emit("update:currentPage", number);
  };
  const toFirstPage = () => {
    updateCurrentPage(1);
  };
  const toPreviousPage = () => {
    updateCurrentPage(currentPage.value - 1);
  };
  const toNextPage = () => {
    updateCurrentPage(currentPage.value + 1);
  };
  const toLastPage = () => {
    updateCurrentPage(totalPages.value);
  };
  return {
    currentPage: readonly(currentPage),
    unbounded: readonly(unbounded),
    totalPages,
    isFirstPage,
    isLastPage,
    isOverflowSlot,
    toFirstPage,
    toLastPage,
    toNextPage,
    toPreviousPage,
    updateCurrentPage,
    visiblePageRange
  };
};
var _hoisted_1$l = { class: "usa-pagination__item usa-pagination__arrow" };
var _hoisted_2$8 = {
  key: 0,
  class: "usa-icon",
  "aria-hidden": "true",
  role: "img"
};
var _hoisted_3$5 = {
  key: 0,
  class: "usa-icon",
  "aria-hidden": "true",
  role: "img"
};
var _sfc_main$p = {
  __name: "UsaPaginationArrow",
  props: {
    direction: {
      type: String,
      default: "previous",
      validator(direction) {
        return ["previous", "next"].includes(direction);
      }
    },
    label: {
      type: String,
      default: ""
    },
    ariaLabel: {
      type: String,
      required: true
    },
    href: {
      type: String,
      default: void 0
    },
    to: {
      type: [String, Object],
      default: void 0
    },
    routerComponentName: {
      type: String,
      default: void 0
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          link: [],
          text: []
        };
      }
    }
  },
  setup(__props) {
    const props = __props;
    const svgSpritePath = inject("vueUswds.svgSpritePath", SVG_SPRITE_PATH);
    const componentTag = computed(() => props.routerComponentName || props.to || props.href ? BaseLink : "button");
    const classes = computed(() => [
      {
        "usa-pagination__previous-page": props.direction === "previous",
        "usa-pagination__next-page": props.direction === "next",
        "usa-button--unstyled": componentTag.value === "button"
      },
      props.customClasses.link
    ]);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", _hoisted_1$l, [
        (openBlock(), createBlock(resolveDynamicComponent(componentTag.value), {
          href: __props.href,
          to: __props.to,
          "router-component-name": __props.routerComponentName,
          "aria-label": __props.ariaLabel,
          class: normalizeClass([classes.value, "usa-pagination__link"])
        }, {
          default: withCtx(() => {
            var _a2;
            return [
              __props.direction === "previous" ? renderSlot(_ctx.$slots, "before", {
                key: 0,
                svgSpritePath: unref(svgSpritePath)
              }, () => [
                unref(svgSpritePath) ? (openBlock(), createElementBlock("svg", _hoisted_2$8, [
                  createBaseVNode("use", normalizeProps(guardReactiveProps({ "xlink:href": `${unref(svgSpritePath)}#navigate_before` })), null, 16)
                ])) : createCommentVNode("", true)
              ]) : createCommentVNode("", true),
              createBaseVNode("span", {
                class: normalizeClass(["usa-pagination__link-text", (_a2 = __props.customClasses) == null ? void 0 : _a2.text])
              }, [
                renderSlot(_ctx.$slots, "default", {}, () => [
                  createTextVNode(toDisplayString(__props.label), 1)
                ])
              ], 2),
              __props.direction === "next" ? renderSlot(_ctx.$slots, "after", {
                key: 1,
                svgSpritePath: unref(svgSpritePath)
              }, () => [
                unref(svgSpritePath) ? (openBlock(), createElementBlock("svg", _hoisted_3$5, [
                  createBaseVNode("use", normalizeProps(guardReactiveProps({ "xlink:href": `${unref(svgSpritePath)}#navigate_next` })), null, 16)
                ])) : createCommentVNode("", true)
              ]) : createCommentVNode("", true)
            ];
          }),
          _: 3
        }, 8, ["href", "to", "router-component-name", "aria-label", "class"]))
      ]);
    };
  }
};
var _hoisted_1$k = { class: "usa-pagination__item usa-pagination__page-no" };
var _sfc_main$o = {
  __name: "UsaPaginationItem",
  props: {
    pageNumber: {
      type: Number,
      required: true,
      validator(pageNumber) {
        return pageNumber > 0;
      }
    },
    isCurrentPage: {
      type: Boolean,
      default: false
    },
    ariaLabel: {
      type: String,
      required: true
    },
    href: {
      type: String,
      default: void 0
    },
    to: {
      type: [String, Object],
      default: void 0
    },
    routerComponentName: {
      type: String,
      default: void 0
    }
  },
  setup(__props) {
    const props = __props;
    const componentTag = computed(() => props.routerComponentName || props.to || props.href ? BaseLink : "button");
    const ariaCurrent = computed(() => props.isCurrentPage ? "page" : null);
    const classes = computed(() => [
      {
        "usa-current": props.isCurrentPage,
        "usa-button--unstyled": componentTag.value === "button"
      }
    ]);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", _hoisted_1$k, [
        (openBlock(), createBlock(resolveDynamicComponent(componentTag.value), {
          href: __props.href,
          to: __props.to,
          "router-component-name": __props.routerComponentName,
          "aria-label": __props.ariaLabel,
          "aria-current": ariaCurrent.value,
          class: normalizeClass([classes.value, "usa-pagination__button"])
        }, {
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "default", {}, () => [
              createTextVNode(toDisplayString(__props.pageNumber), 1)
            ])
          ]),
          _: 3
        }, 8, ["href", "to", "router-component-name", "aria-label", "aria-current", "class"]))
      ]);
    };
  }
};
var _hoisted_1$j = ["aria-label"];
var _hoisted_2$7 = {
  key: 0,
  class: "usa-icon",
  "aria-hidden": "true",
  role: "img"
};
var _hoisted_3$4 = ["aria-label"];
var _hoisted_4$1 = createBaseVNode("span", null, "…", -1);
var _hoisted_5 = [
  _hoisted_4$1
];
var _hoisted_6 = {
  key: 0,
  class: "usa-icon",
  "aria-hidden": "true",
  role: "img"
};
var _sfc_main$n = {
  __name: "UsaPagination",
  props: {
    items: {
      type: Array,
      default: () => []
    },
    unbounded: {
      type: Boolean,
      default: false
    },
    currentPage: {
      type: Number,
      default: 1,
      validator(currentPage) {
        return currentPage > 0;
      }
    },
    ariaLabel: {
      type: String,
      default: "Pagination"
    },
    previousLinkText: {
      type: String,
      default: "Previous"
    },
    nextLinkText: {
      type: String,
      default: "Next"
    },
    firstPageAriaLabel: {
      type: String,
      default: "First page, page %s"
    },
    previousPageAriaLabel: {
      type: String,
      default: "Previous page"
    },
    numberPageAriaLabel: {
      type: String,
      default: "Page %s"
    },
    nextPageAriaLabel: {
      type: String,
      default: "Next page"
    },
    lastPageAriaLabel: {
      type: String,
      default: "Last page, page %s"
    },
    overflowAriaLabel: {
      type: String,
      default: "ellipsis indicating non-visible pages"
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          list: []
        };
      }
    }
  },
  emits: ["update:currentPage"],
  setup(__props, { emit }) {
    const props = __props;
    const slots = useSlots();
    if (slots == null ? void 0 : slots.previousIcon) {
      console.warn(`The 'previousIcon' slot is deprecated, use 'previous-icon' instead.`);
    }
    if (slots == null ? void 0 : slots.previousLabel) {
      console.warn(`The 'previousLabel' slot is deprecated, use 'previous-label' instead.`);
    }
    if (slots == null ? void 0 : slots.nextIcon) {
      console.warn(`The 'nextIcon' slot is deprecated, use 'next-icon' instead.`);
    }
    if (slots == null ? void 0 : slots.nextLabel) {
      console.warn(`The 'nextLabel' slot is deprecated, use 'next-label' instead.`);
    }
    const totalItems = computed(() => {
      return props.items.length;
    });
    const {
      currentPage,
      totalPages,
      isFirstPage,
      isLastPage,
      isOverflowSlot,
      visiblePageRange,
      toPreviousPage,
      toNextPage,
      updateCurrentPage
    } = usePagination(toRef(props, "currentPage"), totalItems, toRef(props, "unbounded"), emit);
    function getAriaLabel(pageNumber) {
      if (pageNumber === 1) {
        if (props.firstPageAriaLabel.includes("#")) {
          console.warn(`The '#' placeholder is deprecated, use '%s' instead.`);
          return props.firstPageAriaLabel.replaceAll("#", pageNumber);
        }
        return props.firstPageAriaLabel.replaceAll("%s", pageNumber);
      }
      if (pageNumber === totalPages.value) {
        if (props.lastPageAriaLabel.includes("#")) {
          console.warn(`The '#' placeholder is deprecated, use '%s' instead.`);
          return props.lastPageAriaLabel.replaceAll("#", pageNumber);
        }
        return props.lastPageAriaLabel.replaceAll("%s", pageNumber);
      }
      if (props.numberPageAriaLabel.includes("#")) {
        console.warn(`The '#' placeholder is deprecated, use '%s' instead.`);
        return props.numberPageAriaLabel.replaceAll("#", pageNumber);
      }
      return props.numberPageAriaLabel.replaceAll("%s", pageNumber);
    }
    return (_ctx, _cache) => {
      var _a2;
      return openBlock(), createElementBlock("nav", {
        "aria-label": __props.ariaLabel,
        class: "usa-pagination"
      }, [
        createBaseVNode("ul", {
          class: normalizeClass(["usa-pagination__list", (_a2 = __props.customClasses) == null ? void 0 : _a2.list])
        }, [
          renderSlot(_ctx.$slots, "previous", {
            isFirstPage: unref(isFirstPage),
            toPreviousPage: unref(toPreviousPage)
          }, () => {
            var _a3, _b, _c, _d, _e, _f;
            return [
              withDirectives(createVNode(unref(_sfc_main$p), {
                direction: "previous",
                class: normalizeClass({ "usa-pagination__item--hidden": unref(isFirstPage) }),
                "aria-label": __props.previousPageAriaLabel,
                href: ((_b = (_a3 = __props.items) == null ? void 0 : _a3[unref(currentPage) - 2]) == null ? void 0 : _b.href) || null,
                to: ((_d = (_c = __props.items) == null ? void 0 : _c[unref(currentPage) - 2]) == null ? void 0 : _d.to) || null,
                "router-component-name": ((_f = (_e = __props.items) == null ? void 0 : _e[unref(currentPage) - 2]) == null ? void 0 : _f.routerComponentName) || null,
                onClick: _cache[0] || (_cache[0] = ($event) => unref(toPreviousPage)())
              }, {
                before: withCtx(({ svgSpritePath }) => [
                  _ctx.$slots["previous-icon"] ? renderSlot(_ctx.$slots, "previous-icon", { key: 0 }) : _ctx.$slots.previousIcon ? renderSlot(_ctx.$slots, "previousIcon", { key: 1 }) : (openBlock(), createElementBlock(Fragment, { key: 2 }, [
                    svgSpritePath ? (openBlock(), createElementBlock("svg", _hoisted_2$7, [
                      createBaseVNode("use", normalizeProps(guardReactiveProps({ "xlink:href": `${svgSpritePath}#navigate_before}` })), null, 16)
                    ])) : createCommentVNode("", true)
                  ], 64))
                ]),
                default: withCtx(() => [
                  _ctx.$slots["previous-label"] ? renderSlot(_ctx.$slots, "previous-label", { key: 0 }) : _ctx.$slots.previousLabel ? renderSlot(_ctx.$slots, "previousLabel", { key: 1 }) : (openBlock(), createElementBlock(Fragment, { key: 2 }, [
                    createTextVNode(toDisplayString(__props.previousLinkText), 1)
                  ], 64))
                ]),
                _: 3
              }, 8, ["class", "aria-label", "href", "to", "router-component-name"]), [
                [vShow, !unref(isFirstPage)]
              ])
            ];
          }),
          (openBlock(true), createElementBlock(Fragment, null, renderList(unref(visiblePageRange), (pageNumber, index) => {
            var _a3, _b, _c, _d, _e, _f;
            return openBlock(), createElementBlock(Fragment, { key: pageNumber }, [
              unref(isOverflowSlot)(index) ? (openBlock(), createElementBlock("li", {
                key: 0,
                class: "usa-pagination__item usa-pagination__overflow",
                "aria-label": __props.overflowAriaLabel
              }, _hoisted_5, 8, _hoisted_3$4)) : (openBlock(), createBlock(unref(_sfc_main$o), {
                key: 1,
                "page-number": pageNumber,
                "is-current-page": pageNumber === unref(currentPage),
                "aria-label": getAriaLabel(pageNumber),
                href: ((_b = (_a3 = __props.items) == null ? void 0 : _a3[index]) == null ? void 0 : _b.href) || null,
                to: ((_d = (_c = __props.items) == null ? void 0 : _c[index]) == null ? void 0 : _d.to) || null,
                "router-component-name": ((_f = (_e = __props.items) == null ? void 0 : _e[index]) == null ? void 0 : _f.routerComponentName) || null,
                onClick: ($event) => unref(updateCurrentPage)(pageNumber)
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(pageNumber), 1)
                ]),
                _: 2
              }, 1032, ["page-number", "is-current-page", "aria-label", "href", "to", "router-component-name", "onClick"]))
            ], 64);
          }), 128)),
          renderSlot(_ctx.$slots, "next", {
            isLastPage: unref(isLastPage),
            toNextPage: unref(toNextPage)
          }, () => {
            var _a3, _b, _c, _d, _e, _f;
            return [
              withDirectives(createVNode(unref(_sfc_main$p), {
                direction: "next",
                class: normalizeClass({ "usa-pagination__item--hidden": unref(isLastPage) }),
                "aria-label": __props.nextPageAriaLabel,
                href: ((_b = (_a3 = __props.items) == null ? void 0 : _a3[unref(currentPage)]) == null ? void 0 : _b.href) || null,
                to: ((_d = (_c = __props.items) == null ? void 0 : _c[unref(currentPage)]) == null ? void 0 : _d.to) || null,
                "router-component-name": ((_f = (_e = __props.items) == null ? void 0 : _e[unref(currentPage)]) == null ? void 0 : _f.routerComponentName) || null,
                onClick: _cache[1] || (_cache[1] = ($event) => unref(toNextPage)())
              }, {
                after: withCtx(({ svgSpritePath }) => [
                  _ctx.$slots["next-icon"] ? renderSlot(_ctx.$slots, "next-icon", { key: 0 }) : _ctx.$slots.nextIcon ? renderSlot(_ctx.$slots, "nextIcon", { key: 1 }) : (openBlock(), createElementBlock(Fragment, { key: 2 }, [
                    svgSpritePath ? (openBlock(), createElementBlock("svg", _hoisted_6, [
                      createBaseVNode("use", normalizeProps(guardReactiveProps({ "xlink:href": `${svgSpritePath}#navigate_next}` })), null, 16)
                    ])) : createCommentVNode("", true)
                  ], 64))
                ]),
                default: withCtx(() => [
                  _ctx.$slots["next-label"] ? renderSlot(_ctx.$slots, "next-label", { key: 0 }) : _ctx.$slots.nextLabel ? renderSlot(_ctx.$slots, "nextLabel", { key: 1 }) : (openBlock(), createElementBlock(Fragment, { key: 2 }, [
                    createTextVNode(toDisplayString(__props.nextLinkText), 1)
                  ], 64))
                ]),
                _: 3
              }, 8, ["class", "aria-label", "href", "to", "router-component-name"]), [
                [vShow, !unref(isLastPage)]
              ])
            ];
          })
        ], 2)
      ], 8, _hoisted_1$j);
    };
  }
};
var _hoisted_1$i = ["aria-controls", "aria-pressed"];
var __default__$5 = {
  inheritAttrs: false
};
var _sfc_main$m = Object.assign(__default__$5, {
  __name: "UsaPasswordMask",
  props: {
    showText: {
      type: String,
      default: "Show password"
    },
    hideText: {
      type: String,
      default: "Hide password"
    }
  },
  setup(__props) {
    const props = __props;
    const isVisible = ref(false);
    const inputIds = ref({});
    const currentInputType = computed(() => {
      return isVisible.value ? "text" : "password";
    });
    const currentLabel = computed(() => {
      return isVisible.value ? props.hideText : props.showText;
    });
    const ariaControls = computed(() => {
      if (Object.keys(inputIds.value).length) {
        return Object.keys(inputIds.value).join(" ");
      }
      return "";
    });
    const registerInput = (id) => {
      if (!inputIds.value[id]) {
        inputIds.value[id] = true;
      }
    };
    const unregisterInput = (id) => {
      if (inputIds.value[id]) {
        delete inputIds.value[id];
      }
    };
    provide("registerInput", registerInput);
    provide("unregisterInput", unregisterInput);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(Fragment, null, [
        renderSlot(_ctx.$slots, "default", { type: currentInputType.value }),
        createBaseVNode("button", mergeProps(_ctx.$attrs, {
          type: "button",
          class: "usa-show-password usa-button usa-button--unstyled",
          "aria-controls": ariaControls.value,
          "aria-pressed": isVisible.value,
          onClick: _cache[0] || (_cache[0] = ($event) => isVisible.value = !isVisible.value)
        }), toDisplayString(currentLabel.value), 17, _hoisted_1$i)
      ], 64);
    };
  }
});
var _hoisted_1$h = { class: "usa-process-list" };
var _sfc_main$l = {
  __name: "UsaProcessList",
  props: {
    headingTag: {
      type: String,
      default: ""
    }
  },
  setup(__props) {
    const props = __props;
    provide("listHeadingTag", computed(() => props.headingTag));
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("ol", _hoisted_1$h, [
        renderSlot(_ctx.$slots, "default")
      ]);
    };
  }
};
var _hoisted_1$g = { class: "usa-process-list__item" };
var _sfc_main$k = {
  __name: "UsaProcessListItem",
  props: {
    heading: {
      type: String,
      default: ""
    },
    headingTag: {
      type: String,
      default: "h2"
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          heading: []
        };
      }
    }
  },
  setup(__props) {
    const props = __props;
    const listHeadingTag = inject("listHeadingTag");
    const computedHeadingTag = computed(() => listHeadingTag.value || props.headingTag);
    return (_ctx, _cache) => {
      var _a2;
      return openBlock(), createElementBlock("li", _hoisted_1$g, [
        __props.heading || _ctx.$slots.heading ? (openBlock(), createBlock(unref(_sfc_main$1z), {
          key: 0,
          class: normalizeClass(["usa-process-list__heading", (_a2 = __props.customClasses) == null ? void 0 : _a2.heading]),
          tag: computedHeadingTag.value
        }, {
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "heading", {}, () => [
              createTextVNode(toDisplayString(__props.heading), 1)
            ])
          ]),
          _: 3
        }, 8, ["class", "tag"])) : createCommentVNode("", true),
        renderSlot(_ctx.$slots, "default")
      ]);
    };
  }
};
var _hoisted_1$f = ["id"];
var _hoisted_2$6 = ["htmlFor"];
var __default__$4 = {
  inheritAttrs: false
};
var _sfc_main$j = Object.assign(__default__$4, {
  __name: "UsaRadio",
  props: {
    tile: {
      type: Boolean,
      default: false
    },
    modelValue: {
      type: void 0,
      default: ""
    },
    label: {
      type: String,
      default: ""
    },
    description: {
      type: String,
      default: ""
    },
    id: {
      type: String,
      default: ""
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          component: [],
          label: [],
          description: []
        };
      }
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit }) {
    const props = __props;
    const computedId = computed(() => props.id || nextId("usa-radio"));
    const radioValue = computed({
      get() {
        return props.modelValue;
      },
      set(value) {
        emit("update:modelValue", value);
      }
    });
    const classes = computed(() => [
      {
        "usa-radio__input--tile": props.tile
      }
    ]);
    return (_ctx, _cache) => {
      var _a2, _b, _c;
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(["usa-radio", (_a2 = __props.customClasses) == null ? void 0 : _a2.component])
      }, [
        withDirectives(createBaseVNode("input", mergeProps(_ctx.$attrs, {
          id: computedId.value,
          "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => radioValue.value = $event),
          class: ["usa-radio__input", classes.value],
          type: "radio"
        }), null, 16, _hoisted_1$f), [
          [vModelRadio, radioValue.value]
        ]),
        createBaseVNode("label", {
          htmlFor: computedId.value,
          class: normalizeClass(["usa-radio__label", (_b = __props.customClasses) == null ? void 0 : _b.label])
        }, [
          renderSlot(_ctx.$slots, "default", {}, () => [
            createTextVNode(toDisplayString(__props.label), 1)
          ]),
          __props.description || _ctx.$slots.description ? (openBlock(), createElementBlock("span", {
            key: 0,
            class: normalizeClass(["usa-radio__label-description", (_c = __props.customClasses) == null ? void 0 : _c.description])
          }, [
            renderSlot(_ctx.$slots, "description", {}, () => [
              createTextVNode(toDisplayString(__props.description), 1)
            ])
          ], 2)) : createCommentVNode("", true)
        ], 10, _hoisted_2$6)
      ], 2);
    };
  }
});
var _hoisted_1$e = ["id"];
var _hoisted_2$5 = ["id"];
var _hoisted_3$3 = ["id", "min", "max", "aria-valuemin", "aria-valuemax", "aria-valuenow", "required", "aria-describedby"];
var __default__$3 = {
  inheritAttrs: false
};
var _sfc_main$i = Object.assign(__default__$3, {
  __name: "UsaRange",
  props: {
    min: {
      type: Number,
      default: 0
    },
    max: {
      type: Number,
      default: 100
    },
    modelValue: {
      type: [String, Number],
      default: ""
    },
    label: {
      type: String,
      default: ""
    },
    required: {
      type: Boolean,
      default: false
    },
    error: {
      type: Boolean,
      default: false
    },
    id: {
      type: String,
      default: ""
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          component: [],
          label: []
        };
      }
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit }) {
    const props = __props;
    const slots = useSlots();
    const computedId = computed(() => props.id || nextId("usa-range"));
    const computedErrorMessageId = computed(() => `${computedId.value}-error-message`);
    const computedHintId = computed(() => `${computedId.value}-hint`);
    const rangeValue = computed({
      get() {
        return props.modelValue;
      },
      set(value) {
        emit("update:modelValue", value);
      }
    });
    const classes = computed(() => [{ "usa-input--error": props.error }]);
    const ariaDescribedby = computed(() => {
      const ids = [];
      if (slots.hint) {
        ids.push(computedHintId.value);
      }
      if (props.error && slots["error-message"]) {
        ids.push(computedErrorMessageId.value);
      }
      return ids.length ? ids.join(" ") : null;
    });
    return (_ctx, _cache) => {
      var _a2;
      return openBlock(), createBlock(unref(_sfc_main$1c), {
        group: !!_ctx.$slots.hint || __props.error && !!_ctx.$slots["error-message"],
        error: __props.error,
        class: normalizeClass((_a2 = props.customClasses) == null ? void 0 : _a2.component)
      }, {
        default: withCtx(() => {
          var _a3;
          return [
            __props.label || _ctx.$slots.label ? (openBlock(), createBlock(unref(_sfc_main$1b), {
              key: 0,
              for: computedId.value,
              required: __props.required,
              error: __props.error,
              class: normalizeClass((_a3 = __props.customClasses) == null ? void 0 : _a3.label)
            }, {
              default: withCtx(() => [
                renderSlot(_ctx.$slots, "label", {}, () => [
                  createTextVNode(toDisplayString(__props.label), 1)
                ])
              ]),
              _: 3
            }, 8, ["for", "required", "error", "class"])) : createCommentVNode("", true),
            _ctx.$slots.hint ? (openBlock(), createElementBlock("span", {
              key: 1,
              id: computedHintId.value,
              class: "usa-hint"
            }, [
              renderSlot(_ctx.$slots, "hint")
            ], 8, _hoisted_1$e)) : createCommentVNode("", true),
            __props.error && _ctx.$slots["error-message"] ? (openBlock(), createElementBlock("span", {
              key: 2,
              id: computedErrorMessageId.value,
              class: "usa-error-message"
            }, [
              renderSlot(_ctx.$slots, "error-message")
            ], 8, _hoisted_2$5)) : createCommentVNode("", true),
            withDirectives(createBaseVNode("input", mergeProps(_ctx.$attrs, {
              id: computedId.value,
              "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => rangeValue.value = $event),
              class: ["usa-range", classes.value],
              type: "range",
              role: "slider",
              min: __props.min,
              max: __props.max,
              "aria-valuemin": __props.min,
              "aria-valuemax": __props.max,
              "aria-valuenow": rangeValue.value,
              required: __props.required,
              "aria-describedby": ariaDescribedby.value
            }), null, 16, _hoisted_3$3), [
              [vModelText, rangeValue.value]
            ])
          ];
        }),
        _: 3
      }, 8, ["group", "error", "class"]);
    };
  }
});
var _hoisted_1$d = {
  key: 0,
  class: "usa-search__submit-text"
};
var _hoisted_2$4 = ["src", "alt"];
var _sfc_main$h = {
  __name: "UsaSearch",
  props: {
    variant: {
      type: String,
      default: "medium",
      validator(variant) {
        const isValidVariantSize = ["small", "medium", "big"].includes(variant);
        if (!isValidVariantSize) {
          console.warn(`'${variant}' is not a valid search variant`);
        }
        return isValidVariantSize;
      }
    },
    modelValue: {
      type: String,
      default: ""
    },
    label: {
      type: String,
      default: "Search"
    },
    buttonLabel: {
      type: String,
      default: "Search"
    },
    inputAttrs: {
      type: Object,
      default: () => {
      }
    },
    id: {
      type: String,
      default: ""
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          label: ["usa-sr-only"],
          input: [],
          button: [],
          icon: []
        };
      }
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit }) {
    const props = __props;
    const imagePath = inject("vueUswds.imagePath", IMAGE_PATH);
    const computedId = computed(() => props.id || nextId("usa-search"));
    const classes = computed(() => [
      {
        "usa-search--small": props.variant === "small",
        "usa-search--medium": props.variant === "medium",
        "usa-search--big": props.variant === "big"
      }
    ]);
    const searchValue = computed({
      get() {
        return props.modelValue;
      },
      set(value) {
        emit("update:modelValue", value);
      }
    });
    return (_ctx, _cache) => {
      var _a2, _b;
      return openBlock(), createElementBlock("form", {
        class: normalizeClass(["usa-search", classes.value]),
        role: "search"
      }, [
        createVNode(unref(_sfc_main$19), mergeProps(__props.inputAttrs, {
          id: computedId.value,
          modelValue: searchValue.value,
          "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => searchValue.value = $event),
          name: "search",
          type: "search",
          label: __props.label,
          class: (_a2 = __props.customClasses) == null ? void 0 : _a2.input,
          "custom-classes": __props.customClasses
        }), null, 16, ["id", "modelValue", "label", "class", "custom-classes"]),
        createVNode(unref(_sfc_main$1q), {
          type: "submit",
          class: normalizeClass((_b = __props.customClasses) == null ? void 0 : _b.button)
        }, {
          default: withCtx(() => [
            __props.variant === "medium" || __props.variant === "big" ? (openBlock(), createElementBlock("span", _hoisted_1$d, toDisplayString(__props.buttonLabel), 1)) : createCommentVNode("", true),
            renderSlot(_ctx.$slots, "icon", {}, () => {
              var _a3;
              return [
                createBaseVNode("img", {
                  src: `${unref(imagePath)}/usa-icons-bg/search--white.svg`,
                  class: normalizeClass(["usa-search__submit-icon", (_a3 = __props.customClasses) == null ? void 0 : _a3.icon]),
                  alt: __props.buttonLabel
                }, null, 10, _hoisted_2$4)
              ];
            })
          ]),
          _: 3
        }, 8, ["class"])
      ], 2);
    };
  }
};
var _sfc_main$g = {
  __name: "UsaSidenavItem",
  props: {
    item: {
      type: Object,
      required: true
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          item: [],
          link: [],
          sublist: []
        };
      }
    }
  },
  setup(__props) {
    return (_ctx, _cache) => {
      var _a2, _b, _c, _d, _e, _f, _g, _h, _i;
      const _component_UsaSidenavItem = resolveComponent("UsaSidenavItem", true);
      return openBlock(), createElementBlock("li", {
        class: normalizeClass(["usa-sidenav__item", (_a2 = __props.customClasses) == null ? void 0 : _a2.item])
      }, [
        createVNode(unref(BaseLink), mergeProps({
          href: (_b = __props.item) == null ? void 0 : _b.href,
          to: (_c = __props.item) == null ? void 0 : _c.to,
          "router-component-name": (_d = __props.item) == null ? void 0 : _d.routerComponentName,
          class: (_e = __props.customClasses) == null ? void 0 : _e.link
        }, (_f = __props.item) == null ? void 0 : _f.attrs), {
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "default", { item: __props.item }, () => {
              var _a3;
              return [
                createTextVNode(toDisplayString((_a3 = __props.item) == null ? void 0 : _a3.text), 1)
              ];
            })
          ]),
          _: 3
        }, 16, ["href", "to", "router-component-name", "class"]),
        ((_h = (_g = __props.item) == null ? void 0 : _g.children) == null ? void 0 : _h.length) ? (openBlock(), createElementBlock("ul", {
          key: 0,
          class: normalizeClass(["usa-sidenav__sublist", (_i = __props.customClasses) == null ? void 0 : _i.sublist])
        }, [
          (openBlock(true), createElementBlock(Fragment, null, renderList(__props.item.children, (subItem) => {
            return openBlock(), createBlock(_component_UsaSidenavItem, {
              key: (subItem == null ? void 0 : subItem.id) || subItem.text,
              item: subItem,
              "custom-classes": __props.customClasses
            }, {
              default: withCtx(() => [
                createTextVNode(toDisplayString(subItem.text), 1)
              ]),
              _: 2
            }, 1032, ["item", "custom-classes"]);
          }), 128))
        ], 2)) : createCommentVNode("", true)
      ], 2);
    };
  }
};
var _hoisted_1$c = ["aria-label"];
var _sfc_main$f = {
  __name: "UsaSidenav",
  props: {
    ariaLabel: {
      type: String,
      default: "Secondary navigation"
    },
    items: {
      type: Array,
      default: () => []
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          list: [],
          item: [],
          link: [],
          sublist: []
        };
      }
    }
  },
  setup(__props) {
    return (_ctx, _cache) => {
      var _a2;
      return openBlock(), createElementBlock("nav", { "aria-label": __props.ariaLabel }, [
        renderSlot(_ctx.$slots, "before"),
        createBaseVNode("ul", {
          class: normalizeClass(["usa-sidenav", (_a2 = __props.customClasses) == null ? void 0 : _a2.list])
        }, [
          renderSlot(_ctx.$slots, "default", { items: __props.items }, () => [
            (openBlock(true), createElementBlock(Fragment, null, renderList(__props.items, (item) => {
              return openBlock(), createBlock(unref(_sfc_main$g), {
                key: (item == null ? void 0 : item.id) || item.text,
                item,
                "custom-classes": __props.customClasses
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(item.text), 1)
                ]),
                _: 2
              }, 1032, ["item", "custom-classes"]);
            }), 128))
          ])
        ], 2),
        renderSlot(_ctx.$slots, "after")
      ], 8, _hoisted_1$c);
    };
  }
};
var _hoisted_1$b = { class: "usa-sign-up" };
var _sfc_main$e = {
  __name: "UsaSignUp",
  props: {
    heading: {
      type: String,
      default: "Sign up"
    },
    headingTag: {
      type: String,
      default: "h2"
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          heading: []
        };
      }
    }
  },
  setup(__props) {
    return (_ctx, _cache) => {
      var _a2;
      return openBlock(), createElementBlock("div", _hoisted_1$b, [
        createVNode(unref(_sfc_main$1z), {
          tag: __props.headingTag,
          class: normalizeClass(["usa-sign-up__heading", (_a2 = __props.customClasses) == null ? void 0 : _a2.heading])
        }, {
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "heading", {}, () => [
              createTextVNode(toDisplayString(__props.heading), 1)
            ])
          ]),
          _: 3
        }, 8, ["tag", "class"]),
        renderSlot(_ctx.$slots, "default")
      ]);
    };
  }
};
var _hoisted_1$a = ["aria-label"];
var _sfc_main$d = {
  __name: "UsaSiteAlert",
  props: {
    variant: {
      type: String,
      default: "emergency",
      validator(variant) {
        const isValidVariant = ["info", "emergency"].includes(variant);
        if (!isValidVariant) {
          console.warn(`'${variant}' is not a valid site alert variant`);
        }
        return isValidVariant;
      }
    },
    slim: {
      type: Boolean,
      default: false
    },
    noIcon: {
      type: Boolean,
      default: false
    },
    role: {
      type: String,
      default: ""
    },
    heading: {
      type: String,
      default: ""
    },
    headingTag: {
      type: String,
      default: "h2"
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          root: [],
          body: [],
          heading: []
        };
      }
    },
    ariaLabel: {
      type: String,
      default: "Site alert"
    }
  },
  setup(__props) {
    const props = __props;
    const classes = computed(() => [
      {
        "usa-site-alert--slim": props.slim,
        "usa-site-alert--no-icon": props.noIcon,
        "usa-site-alert--info": props.variant === "info",
        "usa-site-alert--emergency": props.variant === "emergency"
      }
    ]);
    return (_ctx, _cache) => {
      var _a2;
      return openBlock(), createElementBlock("section", {
        class: normalizeClass(["usa-site-alert", classes.value]),
        "aria-label": __props.ariaLabel
      }, [
        createVNode(unref(_sfc_main$1v), {
          class: normalizeClass((_a2 = __props.customClasses) == null ? void 0 : _a2.root),
          slim: __props.slim,
          role: __props.role,
          heading: __props.heading,
          "heading-tag": __props.headingTag,
          "custom-classes": __props.customClasses
        }, createSlots({ _: 2 }, [
          _ctx.$slots.heading ? {
            name: "heading",
            fn: withCtx(() => [
              renderSlot(_ctx.$slots, "heading", {}, () => [
                createTextVNode(toDisplayString(__props.heading), 1)
              ])
            ]),
            key: "0"
          } : void 0,
          _ctx.$slots.message ? {
            name: "message",
            fn: withCtx(() => [
              renderSlot(_ctx.$slots, "message")
            ]),
            key: "1"
          } : {
            name: "default",
            fn: withCtx(() => [
              renderSlot(_ctx.$slots, "default")
            ]),
            key: "2"
          }
        ]), 1032, ["class", "slim", "role", "heading", "heading-tag", "custom-classes"])
      ], 10, _hoisted_1$a);
    };
  }
};
var _sfc_main$c = {
  __name: "UsaSkipnav",
  props: {
    anchor: {
      type: String,
      required: true,
      validator(anchor) {
        const isValidAnchor = anchor.startsWith("#");
        if (!isValidAnchor) {
          console.warn(`The anchor prop is required and must start with a "#" symbol`);
        }
        return isValidAnchor;
      }
    }
  },
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(BaseLink), {
        href: __props.anchor,
        class: "usa-skipnav"
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default", {}, () => [
            createTextVNode("Skip to main content")
          ])
        ]),
        _: 3
      }, 8, ["href"]);
    };
  }
};
var _hoisted_1$9 = ["aria-current"];
var _hoisted_2$3 = { class: "usa-step-indicator__segment-label" };
var _hoisted_3$2 = {
  key: 0,
  class: "usa-sr-only"
};
var _sfc_main$b = {
  __name: "UsaStepIndicatorSegment",
  props: {
    status: {
      type: String,
      default: "",
      validator(status) {
        return ["current", "completed", ""].includes(status);
      }
    },
    label: {
      type: String,
      required: true
    }
  },
  setup(__props) {
    const props = __props;
    const statusLabel = computed(() => {
      if (props.status === "current") {
        return null;
      }
      return props.status === "completed" ? props.status : "not completed";
    });
    const classes = computed(() => [
      {
        "usa-step-indicator__segment--complete": props.status === "completed",
        "usa-step-indicator__segment--current": props.status === "current"
      }
    ]);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", {
        class: normalizeClass(["usa-step-indicator__segment", classes.value]),
        "aria-current": __props.status === "current" || null
      }, [
        createBaseVNode("span", _hoisted_2$3, [
          createTextVNode(toDisplayString(__props.label) + " ", 1),
          statusLabel.value ? (openBlock(), createElementBlock("span", _hoisted_3$2, toDisplayString(statusLabel.value), 1)) : createCommentVNode("", true)
        ])
      ], 10, _hoisted_1$9);
    };
  }
};
var _hoisted_1$8 = { class: "usa-step-indicator__header" };
var _hoisted_2$2 = createBaseVNode("span", { class: "usa-sr-only" }, "Step", -1);
var _hoisted_3$1 = { class: "usa-step-indicator__current-step" };
var _hoisted_4 = { class: "usa-step-indicator__total-steps" };
var _sfc_main$a = {
  __name: "UsaStepIndicatorHeader",
  props: {
    currentStepNumber: {
      type: Number,
      required: true,
      validator(currentStepNumber) {
        return currentStepNumber > 0;
      }
    },
    currentStepLabel: {
      type: String,
      required: true
    },
    totalSteps: {
      type: Number,
      required: true,
      validator(currentStepNumber) {
        return currentStepNumber > 0;
      }
    },
    headingTag: {
      type: String,
      default: "h2"
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          heading: [],
          counter: [],
          label: []
        };
      }
    }
  },
  setup(__props) {
    const props = __props;
    const calculatedStepNumber = computed(() => props.currentStepNumber > 0 ? Math.min(props.currentStepNumber, props.totalSteps) : 1);
    return (_ctx, _cache) => {
      var _a2;
      return openBlock(), createElementBlock("div", _hoisted_1$8, [
        createVNode(unref(_sfc_main$1z), {
          class: normalizeClass(["usa-step-indicator__heading", (_a2 = __props.customClasses) == null ? void 0 : _a2.heading]),
          tag: __props.headingTag
        }, {
          default: withCtx(() => {
            var _a3, _b;
            return [
              createBaseVNode("span", {
                class: normalizeClass(["usa-step-indicator__heading-counter", (_a3 = __props.customClasses) == null ? void 0 : _a3.counter])
              }, [
                _hoisted_2$2,
                createBaseVNode("span", _hoisted_3$1, toDisplayString(calculatedStepNumber.value), 1),
                createBaseVNode("span", _hoisted_4, " of " + toDisplayString(__props.totalSteps), 1)
              ], 2),
              createBaseVNode("span", {
                class: normalizeClass(["usa-step-indicator__heading-text", (_b = __props.customClasses) == null ? void 0 : _b.label])
              }, [
                renderSlot(_ctx.$slots, "default", {}, () => [
                  createTextVNode(toDisplayString(__props.currentStepLabel), 1)
                ])
              ], 2)
            ];
          }),
          _: 3
        }, 8, ["class", "tag"])
      ]);
    };
  }
};
var _hoisted_1$7 = ["aria-hidden"];
var _sfc_main$9 = {
  __name: "UsaStepIndicator",
  props: {
    steps: {
      type: Array,
      default: () => []
    },
    currentStepNumber: {
      type: Number,
      default: 1,
      validator(currentStepNumber) {
        return currentStepNumber > 0;
      }
    },
    counters: {
      type: Boolean,
      default: false
    },
    smallCounters: {
      type: Boolean,
      default: false
    },
    center: {
      type: Boolean,
      default: false
    },
    noLabels: {
      type: Boolean,
      default: false
    },
    headingTag: {
      type: String,
      default: "h2"
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          list: [],
          segment: [],
          header: []
        };
      }
    }
  },
  setup(__props) {
    const props = __props;
    const totalSteps = computed(() => props.steps.length);
    const currentStepLabel = computed(() => {
      if (props.currentStepNumber > totalSteps.value) {
        return props.steps[totalSteps.value - 1];
      }
      if (props.steps[props.currentStepNumber - 1]) {
        return props.steps[props.currentStepNumber - 1];
      }
      return "";
    });
    const classes = computed(() => [
      {
        "usa-step-indicator--counters": props.counters,
        "usa-step-indicator--counters-sm": props.smallCounters,
        "usa-step-indicator--center": props.center,
        "usa-step-indicator--no-labels": props.noLabels
      }
    ]);
    function stepStatus(label) {
      const stepNumber = props.steps.indexOf(label) + 1;
      if (stepNumber < props.currentStepNumber) {
        return "completed";
      }
      if (stepNumber === props.currentStepNumber) {
        return "current";
      }
      return "";
    }
    return (_ctx, _cache) => {
      var _a2;
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(["usa-step-indicator", classes.value]),
        "aria-label": "progress"
      }, [
        createBaseVNode("ol", {
          class: normalizeClass(["usa-step-indicator__segments", (_a2 = __props.customClasses) == null ? void 0 : _a2.list]),
          "aria-hidden": __props.noLabels || null
        }, [
          renderSlot(_ctx.$slots, "default", {}, () => [
            (openBlock(true), createElementBlock(Fragment, null, renderList(__props.steps, (label) => {
              var _a3;
              return openBlock(), createBlock(unref(_sfc_main$b), {
                key: label,
                class: normalizeClass((_a3 = __props.customClasses) == null ? void 0 : _a3.segment),
                status: stepStatus(label),
                label
              }, null, 8, ["class", "status", "label"]);
            }), 128))
          ])
        ], 10, _hoisted_1$7),
        renderSlot(_ctx.$slots, "header", {}, () => {
          var _a3;
          return [
            createVNode(unref(_sfc_main$a), {
              class: normalizeClass((_a3 = __props.customClasses) == null ? void 0 : _a3.header),
              "heading-tag": __props.headingTag,
              "current-step-number": __props.currentStepNumber,
              "current-step-label": currentStepLabel.value,
              "total-steps": totalSteps.value
            }, null, 8, ["class", "heading-tag", "current-step-number", "current-step-label", "total-steps"])
          ];
        })
      ], 2);
    };
  }
};
var _hoisted_1$6 = ["aria-labelledby"];
var _sfc_main$8 = {
  __name: "UsaSummaryBox",
  props: {
    id: {
      type: String,
      default: ""
    },
    heading: {
      type: String,
      default: "Key information",
      validator(heading) {
        return heading !== "";
      }
    },
    headingTag: {
      type: String,
      default: "h2"
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          body: [],
          heading: [],
          text: []
        };
      }
    }
  },
  setup(__props) {
    const props = __props;
    const computedId = computed(() => props.id || nextId("usa-summary-box"));
    return (_ctx, _cache) => {
      var _a2, _b, _c;
      return openBlock(), createElementBlock("div", {
        class: "usa-summary-box",
        role: "region",
        "aria-labelledby": computedId.value
      }, [
        createBaseVNode("div", {
          class: normalizeClass(["usa-summary-box__body", [(_a2 = __props.customClasses) == null ? void 0 : _a2.body]])
        }, [
          createVNode(unref(_sfc_main$1z), {
            id: computedId.value,
            class: normalizeClass(["usa-summary-box__heading", (_b = __props.customClasses) == null ? void 0 : _b.heading]),
            tag: __props.headingTag
          }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "heading", {}, () => [
                createTextVNode(toDisplayString(__props.heading), 1)
              ])
            ]),
            _: 3
          }, 8, ["id", "class", "tag"]),
          createBaseVNode("div", {
            class: normalizeClass(["usa-summary-box__text", (_c = __props.customClasses) == null ? void 0 : _c.text])
          }, [
            renderSlot(_ctx.$slots, "default")
          ], 2)
        ], 2)
      ], 8, _hoisted_1$6);
    };
  }
};
var castComparer = function(comparer) {
  return function(a, b, order) {
    return comparer(a, b, order) * order;
  };
};
var throwInvalidConfigErrorIfTrue = function(condition, context) {
  if (condition)
    throw Error("Invalid sort config: " + context);
};
var unpackObjectSorter = function(sortByObj) {
  var _a2 = sortByObj || {}, asc = _a2.asc, desc = _a2.desc;
  var order = asc ? 1 : -1;
  var sortBy = asc || desc;
  throwInvalidConfigErrorIfTrue(!sortBy, "Expected `asc` or `desc` property");
  throwInvalidConfigErrorIfTrue(asc && desc, "Ambiguous object with `asc` and `desc` config properties");
  var comparer = sortByObj.comparer && castComparer(sortByObj.comparer);
  return { order, sortBy, comparer };
};
var multiPropertySorterProvider = function(defaultComparer2) {
  return function multiPropertySorter(sortBy, sortByArr, depth, order, comparer, a, b) {
    var valA;
    var valB;
    if (typeof sortBy === "string") {
      valA = a[sortBy];
      valB = b[sortBy];
    } else if (typeof sortBy === "function") {
      valA = sortBy(a);
      valB = sortBy(b);
    } else {
      var objectSorterConfig = unpackObjectSorter(sortBy);
      return multiPropertySorter(objectSorterConfig.sortBy, sortByArr, depth, objectSorterConfig.order, objectSorterConfig.comparer || defaultComparer2, a, b);
    }
    var equality = comparer(valA, valB, order);
    if ((equality === 0 || valA == null && valB == null) && sortByArr.length > depth) {
      return multiPropertySorter(sortByArr[depth], sortByArr, depth + 1, order, comparer, a, b);
    }
    return equality;
  };
};
function getSortStrategy(sortBy, comparer, order) {
  if (sortBy === void 0 || sortBy === true) {
    return function(a, b) {
      return comparer(a, b, order);
    };
  }
  if (typeof sortBy === "string") {
    throwInvalidConfigErrorIfTrue(sortBy.includes("."), "String syntax not allowed for nested properties.");
    return function(a, b) {
      return comparer(a[sortBy], b[sortBy], order);
    };
  }
  if (typeof sortBy === "function") {
    return function(a, b) {
      return comparer(sortBy(a), sortBy(b), order);
    };
  }
  if (Array.isArray(sortBy)) {
    var multiPropSorter_1 = multiPropertySorterProvider(comparer);
    return function(a, b) {
      return multiPropSorter_1(sortBy[0], sortBy, 1, order, comparer, a, b);
    };
  }
  var objectSorterConfig = unpackObjectSorter(sortBy);
  return getSortStrategy(objectSorterConfig.sortBy, objectSorterConfig.comparer || comparer, objectSorterConfig.order);
}
var sortArray = function(order, ctx, sortBy, comparer) {
  var _a2;
  if (!Array.isArray(ctx)) {
    return ctx;
  }
  if (Array.isArray(sortBy) && sortBy.length < 2) {
    _a2 = sortBy, sortBy = _a2[0];
  }
  return ctx.sort(getSortStrategy(sortBy, comparer, order));
};
function createNewSortInstance(opts) {
  var comparer = castComparer(opts.comparer);
  return function(arrayToSort) {
    var ctx = Array.isArray(arrayToSort) && !opts.inPlaceSorting ? arrayToSort.slice() : arrayToSort;
    return {
      asc: function(sortBy) {
        return sortArray(1, ctx, sortBy, comparer);
      },
      desc: function(sortBy) {
        return sortArray(-1, ctx, sortBy, comparer);
      },
      by: function(sortBy) {
        return sortArray(1, ctx, sortBy, comparer);
      }
    };
  };
}
var defaultComparer = function(a, b, order) {
  if (a == null)
    return order;
  if (b == null)
    return -order;
  if (typeof a !== typeof b) {
    return typeof a < typeof b ? -1 : 1;
  }
  if (a < b)
    return -1;
  if (a > b)
    return 1;
  return 0;
};
createNewSortInstance({
  comparer: defaultComparer
});
createNewSortInstance({
  comparer: defaultComparer,
  inPlaceSorting: true
});
var naturalSort = createNewSortInstance({
  comparer: new Intl.Collator(void 0, {
    numeric: true,
    sensitivity: "base"
  }).compare
});
var useTableSort = (_headers = [], _rows = [], _defaultSortHeader = "", _defaultSortDirection = "") => {
  const currentSortedHeader = ref(_defaultSortHeader);
  const currentSortDirection = ref(_defaultSortDirection);
  const headers = computed(() => {
    return _headers.value.map((header) => {
      if (typeof header === "string") {
        return {
          id: kebabCase(header),
          label: header,
          sortable: false,
          headerRow: false
        };
      }
      const headerCell = __spreadValues({}, header);
      if (!(header == null ? void 0 : header.id)) {
        headerCell.id = kebabCase(header.label);
      }
      if (!objectHasKey(header, "sortable")) {
        headerCell.sortable = false;
      } else {
        headerCell.sortable = header.sortable;
      }
      if (!objectHasKey(header, "headerRow")) {
        headerCell.headerRow = false;
      } else {
        headerCell.headerRow = header.headerRow;
      }
      return headerCell;
    });
  });
  const currentSortedHeaderLabel = computed(() => {
    if (!currentSortedHeader.value) {
      return null;
    }
    const [sortedHeader] = headers.value.filter((header) => header.id === currentSortedHeader.value);
    return sortedHeader.label;
  });
  const hasSortableHeaders = computed(() => {
    return headers.value.some((header) => header.sortable);
  });
  const normalizedRows = computed(() => {
    const rows2 = _rows.value.map((row) => {
      return Object.entries(row).reduce((acc, [columnName, columnValue]) => {
        if (typeof columnValue !== "object") {
          acc[columnName] = {
            displayValue: columnValue,
            sortValue: columnValue
          };
          return acc;
        }
        acc[columnName] = __spreadValues({}, row[columnName]);
        if (!objectHasKey(columnValue, "sortValue")) {
          acc[columnName].sortValue = columnValue.displayValue;
        }
        return acc;
      }, {});
    });
    return rows2;
  });
  const rows = computed(() => {
    if (currentSortDirection.value === "ascending") {
      return naturalSort(normalizedRows.value).asc((row) => row[currentSortedHeader.value].sortValue);
    } else if (currentSortDirection.value === "descending") {
      return naturalSort(normalizedRows.value).desc((row) => row[currentSortedHeader.value].sortValue);
    }
    return normalizedRows.value;
  });
  const toggleSortDirection = () => {
    if (!currentSortDirection.value || currentSortDirection.value === "unsorted") {
      currentSortDirection.value = "ascending";
    } else {
      currentSortDirection.value = currentSortDirection.value === "ascending" ? "descending" : "ascending";
    }
  };
  const updateCurrentSortedHeader = (headerId) => currentSortedHeader.value = headerId;
  return {
    headers,
    rows,
    hasSortableHeaders: readonly(hasSortableHeaders),
    currentSortedHeader: readonly(currentSortedHeader),
    currentSortedHeaderLabel: readonly(currentSortedHeaderLabel),
    currentSortDirection: readonly(currentSortDirection),
    toggleSortDirection,
    updateCurrentSortedHeader
  };
};
var _hoisted_1$5 = ["title"];
var _hoisted_2$1 = createStaticVNode('<svg class="usa-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><g class="descending" fill="transparent"><path d="M17 17L15.59 15.59L12.9999 18.17V2H10.9999V18.17L8.41 15.58L7 17L11.9999 22L17 17Z"></path></g><g class="ascending" fill="transparent"><path transform="rotate(180, 12, 12)" d="M17 17L15.59 15.59L12.9999 18.17V2H10.9999V18.17L8.41 15.58L7 17L11.9999 22L17 17Z"></path></g><g class="unsorted" fill="transparent"><polygon points="15.17 15 13 17.17 13 6.83 15.17 9 16.58 7.59 12 3 7.41 7.59 8.83 9 11 6.83 11 17.17 8.83 15 7.42 16.41 12 21 16.59 16.41 15.17 15"></polygon></g></svg>', 1);
var _sfc_main$7 = {
  __name: "UsaTableSortButton",
  props: {
    headerId: {
      type: [String, Number],
      required: true
    },
    headerLabel: {
      type: String,
      required: true
    },
    currentSortDirection: {
      type: String,
      default: ""
    }
  },
  emits: ["update:tableSort"],
  setup(__props, { emit }) {
    const props = __props;
    const reverseSortDirection = computed(() => {
      const reverseDirections = {
        ascending: "descending",
        descending: "ascending"
      };
      return reverseDirections[props.currentSortDirection] || "ascending";
    });
    const title = computed(() => `Click to sort by ${props.headerLabel} in ${reverseSortDirection.value} order.`);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("button", {
        type: "button",
        tabindex: "0",
        class: "usa-table__header__button",
        title: title.value,
        onClick: _cache[0] || (_cache[0] = ($event) => emit("update:tableSort", __props.headerId))
      }, [
        renderSlot(_ctx.$slots, "default", {}, () => [
          _hoisted_2$1
        ])
      ], 8, _hoisted_1$5);
    };
  }
};
var _hoisted_1$4 = ["data-sortable", "role", "aria-label", "aria-sort"];
var _sfc_main$6 = {
  __name: "UsaTableHeaderCell",
  props: {
    id: {
      type: [String, Number],
      required: true
    },
    label: {
      type: String,
      required: true
    },
    sortable: {
      type: Boolean,
      default: false
    },
    currentSortedHeader: {
      type: String,
      default: ""
    },
    currentSortDirection: {
      type: String,
      default: ""
    }
  },
  setup(__props) {
    const props = __props;
    const updateCurrentSortedHeader = inject("updateCurrentSortedHeader");
    const toggleSortDirection = inject("toggleSortDirection");
    const ariaLabel = computed(() => !props.sortable ? null : `${props.label}, sortable column, currently ${props.currentSortDirection ? `sorted ${props.currentSortDirection}` : "unsorted"}`);
    const ariaSort = computed(() => {
      if (props.currentSortedHeader !== props.id) {
        return null;
      }
      if (props.currentSortDirection === "ascending" || props.currentSortDirection === "descending") {
        return props.currentSortDirection;
      }
      return null;
    });
    const toggleTableSort = (headerId) => {
      updateCurrentSortedHeader(headerId);
      toggleSortDirection();
    };
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("th", {
        scope: "col",
        "data-sortable": __props.sortable ? true : null,
        role: __props.sortable ? "columnheader" : null,
        "aria-label": ariaLabel.value,
        "aria-sort": ariaSort.value
      }, [
        renderSlot(_ctx.$slots, "default", {}, () => [
          createTextVNode(toDisplayString(__props.label), 1)
        ]),
        __props.sortable ? (openBlock(), createBlock(unref(_sfc_main$7), {
          key: 0,
          "current-sort-direction": __props.currentSortDirection,
          "header-id": __props.id,
          "header-label": __props.label,
          "onUpdate:tableSort": toggleTableSort
        }, null, 8, ["current-sort-direction", "header-id", "header-label"])) : createCommentVNode("", true)
      ], 8, _hoisted_1$4);
    };
  }
};
var _hoisted_1$3 = {
  key: 0,
  class: "usa-sr-only usa-table__announcement-region",
  "aria-live": "polite"
};
var __default__$2 = {
  name: "UsaTable",
  inheritAttrs: false
};
var _sfc_main$5 = Object.assign(__default__$2, {
  props: {
    caption: {
      type: String,
      default: ""
    },
    borderless: {
      type: Boolean,
      default: false
    },
    striped: {
      type: Boolean,
      default: false
    },
    compact: {
      type: Boolean,
      default: false
    },
    scrollable: {
      type: Boolean,
      default: false
    },
    stacked: {
      type: Boolean,
      default: false
    },
    stackedHeader: {
      type: Boolean,
      default: false
    },
    headers: {
      type: Array,
      default: () => []
    },
    rows: {
      type: Array,
      default: () => []
    },
    defaultSortDirection: {
      type: String,
      default: ""
    },
    defaultSortHeader: {
      type: String,
      default: ""
    }
  },
  setup(__props) {
    const props = __props;
    const slots = useSlots();
    const captionRef = ref(null);
    const {
      headers,
      rows,
      hasSortableHeaders,
      currentSortedHeader,
      currentSortedHeaderLabel,
      currentSortDirection,
      toggleSortDirection,
      updateCurrentSortedHeader
    } = useTableSort(toRef(props, "headers"), toRef(props, "rows"), props.defaultSortHeader, props.defaultSortDirection);
    const classes = computed(() => [
      {
        "usa-table--borderless": props.borderless,
        "usa-table--striped": props.striped,
        "usa-table--compact": props.compact,
        "usa-table--stacked": props.stacked,
        "usa-table--stacked-header": props.stackedHeader
      }
    ]);
    const tableIsSortable = computed(() => hasSortableHeaders.value && !(slots == null ? void 0 : slots.default) && !(slots == null ? void 0 : slots.headers));
    const tableCaption = computed(() => {
      if (props.caption) {
        return props.caption;
      }
      if (captionRef.value) {
        return captionRef.value.textContent;
      }
      return null;
    });
    const UsaTableContainerComponent = {
      name: "UsaTableContainer",
      props: {
        isScrollable: {
          type: Boolean,
          default: false
        }
      },
      setup({ isScrollable }, { slots: slots2 }) {
        return () => isScrollable ? h("div", { class: "usa-table-container--scrollable", tabindex: 0 }, slots2.default()) : slots2.default();
      }
    };
    provide("toggleSortDirection", toggleSortDirection);
    provide("updateCurrentSortedHeader", updateCurrentSortedHeader);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(UsaTableContainerComponent, { "is-scrollable": __props.scrollable }, {
        default: withCtx(() => [
          createBaseVNode("table", mergeProps(_ctx.$attrs, {
            class: ["usa-table", classes.value]
          }), [
            __props.caption || _ctx.$slots.caption ? (openBlock(), createElementBlock("caption", {
              key: 0,
              ref_key: "captionRef",
              ref: captionRef
            }, [
              renderSlot(_ctx.$slots, "caption", {}, () => [
                createTextVNode(toDisplayString(__props.caption), 1)
              ])
            ], 512)) : createCommentVNode("", true),
            createBaseVNode("thead", null, [
              _ctx.$slots.headers ? renderSlot(_ctx.$slots, "headers", { key: 0 }) : unref(headers).length ? renderSlot(_ctx.$slots, "headers", {
                key: 1,
                headers: unref(headers)
              }, () => [
                createBaseVNode("tr", null, [
                  (openBlock(true), createElementBlock(Fragment, null, renderList(unref(headers), (header) => {
                    return openBlock(), createBlock(unref(_sfc_main$6), {
                      id: header.id,
                      key: header.id,
                      label: header.label,
                      sortable: tableIsSortable.value && header.sortable,
                      "current-sorted-header": unref(currentSortedHeader),
                      "current-sort-direction": unref(currentSortedHeader) === header.id ? unref(currentSortDirection) : ""
                    }, {
                      default: withCtx(() => [
                        renderSlot(_ctx.$slots, `header-${header.id}`, { header }, () => [
                          createTextVNode(toDisplayString(header.label), 1)
                        ])
                      ]),
                      _: 2
                    }, 1032, ["id", "label", "sortable", "current-sorted-header", "current-sort-direction"]);
                  }), 128))
                ])
              ]) : createCommentVNode("", true)
            ]),
            createBaseVNode("tbody", null, [
              _ctx.$slots.default ? renderSlot(_ctx.$slots, "default", { key: 0 }) : unref(rows).length ? renderSlot(_ctx.$slots, "default", {
                key: 1,
                rows: unref(rows)
              }, () => [
                (openBlock(true), createElementBlock(Fragment, null, renderList(unref(rows), (row, index) => {
                  return openBlock(), createElementBlock("tr", { key: index }, [
                    (openBlock(true), createElementBlock(Fragment, null, renderList(unref(headers), (header) => {
                      return openBlock(), createBlock(resolveDynamicComponent(header.headerRow ? "th" : "td"), {
                        key: `${header.id}-${index}`,
                        scope: header.headerRow ? "row" : null,
                        role: header.headerRow ? "rowheader" : null,
                        "data-label": header.label,
                        "data-sort-active": unref(currentSortedHeader) === header.id ? true : null,
                        "data-sort-value": row[header.id].sortValue
                      }, {
                        default: withCtx(() => [
                          renderSlot(_ctx.$slots, `cell-${header.id}`, {
                            header,
                            row,
                            cell: row[header.id]
                          }, () => [
                            createTextVNode(toDisplayString(row[header.id].displayValue), 1)
                          ])
                        ]),
                        _: 2
                      }, 1032, ["scope", "role", "data-label", "data-sort-active", "data-sort-value"]);
                    }), 128))
                  ]);
                }), 128))
              ]) : createCommentVNode("", true)
            ])
          ], 16),
          tableIsSortable.value ? (openBlock(), createElementBlock("div", _hoisted_1$3, [
            renderSlot(_ctx.$slots, "table-announcement", {
              currentSortedHeader: unref(currentSortedHeader),
              currentSortDirection: unref(currentSortDirection),
              currentSortedHeaderLabel: unref(currentSortedHeaderLabel),
              tableCaption: tableCaption.value
            }, () => [
              unref(currentSortedHeader) ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                createTextVNode("The table "),
                tableCaption.value ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                  createTextVNode('named "' + toDisplayString(tableCaption.value) + '"', 1)
                ], 64)) : createCommentVNode("", true),
                createTextVNode(' is now sorted by "' + toDisplayString(unref(currentSortedHeaderLabel)) + '" in ' + toDisplayString(unref(currentSortDirection)) + " order.", 1)
              ], 64)) : createCommentVNode("", true)
            ])
          ])) : createCommentVNode("", true)
        ]),
        _: 3
      }, 8, ["is-scrollable"]);
    };
  }
});
var _sfc_main$4 = {
  __name: "UsaTag",
  props: {
    size: {
      type: String,
      default: "",
      validator(size) {
        const isValidSize = size === "" || size === "big";
        if (!isValidSize) {
          console.warn(`'${size}' is not a valid tag size`);
        }
        return isValidSize;
      }
    },
    tag: {
      type: String,
      default: "span"
    }
  },
  setup(__props) {
    const props = __props;
    const classes = computed(() => [{ "usa-tag--big": props.size === "big" }]);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(__props.tag), {
        class: normalizeClass(["usa-tag", classes.value])
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 3
      }, 8, ["class"]);
    };
  }
};
var _hoisted_1$2 = ["id"];
var _hoisted_2 = ["id"];
var _hoisted_3 = ["id", "required", "maxlength", "aria-describedby"];
var __default__$1 = {
  inheritAttrs: false
};
var _sfc_main$3 = Object.assign(__default__$1, {
  __name: "UsaTextarea",
  props: {
    width: {
      type: String,
      default: "",
      validator(width) {
        const isValidWidth = [
          "",
          "2xs",
          "xs",
          "sm",
          "small",
          "md",
          "medium",
          "lg",
          "xl",
          "2xl"
        ].includes(width);
        if (!isValidWidth) {
          console.warn(`'${width}' is not a valid textarea width`);
        }
        return isValidWidth;
      }
    },
    modelValue: {
      type: [String, Number],
      default: ""
    },
    label: {
      type: String,
      default: ""
    },
    required: {
      type: Boolean,
      default: false
    },
    error: {
      type: Boolean,
      default: false
    },
    id: {
      type: String,
      default: ""
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          component: [],
          label: []
        };
      }
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit }) {
    const props = __props;
    const slots = useSlots();
    const updateCharacterCount = inject("updateCharacterCount", null);
    const characterCountMaxlength = inject("characterCountMaxlength", null);
    const characterCountMessageId = inject("characterCountMessageId", null);
    const computedId = computed(() => props.id || nextId("usa-textarea"));
    const computedErrorMessageId = computed(() => `${computedId.value}-error-message`);
    const computedHintId = computed(() => `${computedId.value}-hint`);
    const textareaValue = computed({
      get() {
        return props.modelValue;
      },
      set(value) {
        emit("update:modelValue", value);
        if (updateCharacterCount) {
          updateCharacterCount(value);
        }
      }
    });
    onMounted(() => {
      if (updateCharacterCount) {
        updateCharacterCount(props.modelValue);
      }
    });
    const classes = computed(() => [
      {
        "usa-input--error": props.error,
        "usa-input--2xs": props.width === "2xs",
        "usa-input--xs": props.width === "xs",
        "usa-input--sm": props.width === "sm",
        "usa-input--small": props.width === "small",
        "usa-input--md": props.width === "md",
        "usa-input--medium": props.width === "medium",
        "usa-input--lg": props.width === "lg",
        "usa-input--xl": props.width === "xl",
        "usa-input--2xl": props.width === "2xl",
        "usa-character-count__field": updateCharacterCount
      }
    ]);
    const ariaDescribedby = computed(() => {
      const ids = [];
      if (characterCountMessageId) {
        ids.push(characterCountMessageId.value);
      }
      if (slots.hint) {
        ids.push(computedHintId.value);
      }
      if (props.error && slots["error-message"]) {
        ids.push(computedErrorMessageId.value);
      }
      return ids.length ? ids.join(" ") : null;
    });
    return (_ctx, _cache) => {
      var _a2;
      return openBlock(), createBlock(unref(_sfc_main$1c), {
        group: !!_ctx.$slots.hint || __props.error && !!_ctx.$slots["error-message"],
        error: __props.error,
        class: normalizeClass((_a2 = props.customClasses) == null ? void 0 : _a2.component)
      }, {
        default: withCtx(() => {
          var _a3;
          return [
            __props.label || _ctx.$slots.label ? (openBlock(), createBlock(unref(_sfc_main$1b), {
              key: 0,
              for: computedId.value,
              required: __props.required,
              error: __props.error,
              class: normalizeClass((_a3 = __props.customClasses) == null ? void 0 : _a3.label)
            }, {
              default: withCtx(() => [
                renderSlot(_ctx.$slots, "label", {}, () => [
                  createTextVNode(toDisplayString(__props.label), 1)
                ])
              ]),
              _: 3
            }, 8, ["for", "required", "error", "class"])) : createCommentVNode("", true),
            _ctx.$slots.hint ? (openBlock(), createElementBlock("span", {
              key: 1,
              id: computedHintId.value,
              class: "usa-hint"
            }, [
              renderSlot(_ctx.$slots, "hint")
            ], 8, _hoisted_1$2)) : createCommentVNode("", true),
            __props.error && _ctx.$slots["error-message"] ? (openBlock(), createElementBlock("span", {
              key: 2,
              id: computedErrorMessageId.value,
              class: "usa-error-message"
            }, [
              renderSlot(_ctx.$slots, "error-message")
            ], 8, _hoisted_2)) : createCommentVNode("", true),
            withDirectives(createBaseVNode("textarea", mergeProps(_ctx.$attrs, {
              id: computedId.value,
              "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => textareaValue.value = $event),
              class: ["usa-textarea", classes.value],
              required: __props.required,
              maxlength: unref(characterCountMaxlength) || _ctx.$attrs.maxlength,
              "aria-describedby": ariaDescribedby.value
            }), null, 16, _hoisted_3), [
              [vModelText, textareaValue.value]
            ])
          ];
        }),
        _: 3
      }, 8, ["group", "error", "class"]);
    };
  }
});
var _sfc_main$2 = {
  __name: "UsaTimePicker",
  props: {
    minTime: {
      type: String,
      default: "00:00",
      validator(minTime) {
        let isValidTime = validateTimeString(minTime);
        if (!isValidTime) {
          console.warn(`'${minTime}' is not a valid minimum time. It must be a string in the HH:MM 24 hour format.`);
        }
        return isValidTime;
      }
    },
    maxTime: {
      type: String,
      default: "23:59",
      validator(maxTime) {
        let isValidTime = validateTimeString(maxTime);
        if (!isValidTime) {
          console.warn(`'${maxTime}' is not a valid maximum time. It must be a string in the HH:MM 24 hour format.`);
        }
        return isValidTime;
      }
    },
    step: {
      type: [String, Number],
      default: 30,
      validator(step) {
        const isValidStep = parseInt(step, 10) > 0;
        if (!isValidStep) {
          console.warn(`'${step}' is not a valid time step increment.`);
        }
        return isValidStep;
      }
    },
    modelValue: {
      type: String,
      default: ""
    },
    label: {
      type: String,
      default: ""
    },
    required: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    readonly: {
      type: Boolean,
      default: false
    },
    error: {
      type: Boolean,
      default: false
    },
    id: {
      type: String,
      default: ""
    },
    clearButtonAriaLabel: {
      type: String,
      default: "Clear the select contents"
    },
    toggleButtonAriaLabel: {
      type: String,
      default: "Toggle the dropdown list"
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          formGroup: [],
          component: [],
          label: [],
          input: [],
          list: []
        };
      }
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit }) {
    const props = __props;
    const computedId = computed(() => props.id || nextId("usa-time-picker"));
    const selectedOption = computed({
      get() {
        return props.modelValue;
      },
      set(value) {
        emit("update:modelValue", value);
      }
    });
    const timeStringToMinutes = (timeString) => {
      const [hours, minutes] = timeString.split(":").map((segment) => parseInt(segment, 10));
      return hours * 60 + minutes;
    };
    const timeRangeOptions = computed(() => {
      const timeRange = [];
      const minTime = timeStringToMinutes(props.minTime);
      const maxTime = timeStringToMinutes(props.maxTime);
      const step = parseInt(props.step, 10);
      if (minTime === maxTime) {
        return timeRange;
      }
      for (let time = minTime; time <= maxTime; time += step) {
        const minute = time % 60;
        const hour24 = Math.floor(time / 60);
        const hour12 = hour24 % 12 || 12;
        const ampm = hour24 < 12 ? "am" : "pm";
        const formattedMinute = `${minute}`.padStart(2, "0");
        const formattedHour24 = `${hour24}`.padStart(2, "0");
        timeRange.push({
          value: `${formattedHour24}:${formattedMinute}`,
          label: `${hour12}:${formattedMinute}${ampm}`
        });
      }
      return timeRange;
    });
    const classes = computed(() => {
      var _a2;
      const customClasses = props.customClasses;
      if (!((_a2 = customClasses == null ? void 0 : customClasses.component) == null ? void 0 : _a2.length)) {
        customClasses.component = ["usa-time-picker"];
      } else if (!customClasses.component.includes("usa-time-picker")) {
        customClasses.component.push("usa-time-picker");
      }
      return customClasses;
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(_sfc_main$1a), {
        id: computedId.value,
        modelValue: selectedOption.value,
        "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => selectedOption.value = $event),
        options: timeRangeOptions.value,
        label: __props.label,
        required: __props.required,
        disabled: __props.disabled,
        readonly: __props.readonly,
        error: __props.error,
        "clear-button-aria-label": __props.clearButtonAriaLabel,
        "toggle-button-aria-label": __props.toggleButtonAriaLabel,
        "custom-classes": classes.value
      }, createSlots({ _: 2 }, [
        _ctx.$slots.label ? {
          name: "label",
          fn: withCtx(() => [
            renderSlot(_ctx.$slots, "label")
          ]),
          key: "0"
        } : void 0,
        _ctx.$slots.hint ? {
          name: "hint",
          fn: withCtx(() => [
            renderSlot(_ctx.$slots, "hint")
          ]),
          key: "1"
        } : void 0,
        _ctx.$slots["error-message"] ? {
          name: "error-message",
          fn: withCtx(() => [
            renderSlot(_ctx.$slots, "error-message")
          ]),
          key: "2"
        } : void 0,
        _ctx.$slots["no-results"] ? {
          name: "no-results",
          fn: withCtx(() => [
            renderSlot(_ctx.$slots, "no-results")
          ]),
          key: "3"
        } : void 0,
        _ctx.$slots.status ? {
          name: "status",
          fn: withCtx(({ filteredOptions }) => [
            renderSlot(_ctx.$slots, "status", { filteredOptions })
          ]),
          key: "4"
        } : void 0,
        _ctx.$slots["assistive-hint"] ? {
          name: "assistive-hint",
          fn: withCtx(() => [
            renderSlot(_ctx.$slots, "assistive-hint")
          ]),
          key: "5"
        } : void 0
      ]), 1032, ["id", "modelValue", "options", "label", "required", "disabled", "readonly", "error", "clear-button-aria-label", "toggle-button-aria-label", "custom-classes"]);
    };
  }
};
var min = Math.min;
var max = Math.max;
var round = Math.round;
var floor = Math.floor;
var createCoords = (v) => ({
  x: v,
  y: v
});
var oppositeSideMap = {
  left: "right",
  right: "left",
  bottom: "top",
  top: "bottom"
};
var oppositeAlignmentMap = {
  start: "end",
  end: "start"
};
function evaluate(value, param) {
  return typeof value === "function" ? value(param) : value;
}
function getSide(placement) {
  return placement.split("-")[0];
}
function getAlignment(placement) {
  return placement.split("-")[1];
}
function getOppositeAxis(axis) {
  return axis === "x" ? "y" : "x";
}
function getAxisLength(axis) {
  return axis === "y" ? "height" : "width";
}
function getSideAxis(placement) {
  return ["top", "bottom"].includes(getSide(placement)) ? "y" : "x";
}
function getAlignmentAxis(placement) {
  return getOppositeAxis(getSideAxis(placement));
}
function getAlignmentSides(placement, rects, rtl) {
  if (rtl === void 0) {
    rtl = false;
  }
  const alignment = getAlignment(placement);
  const alignmentAxis = getAlignmentAxis(placement);
  const length = getAxisLength(alignmentAxis);
  let mainAlignmentSide = alignmentAxis === "x" ? alignment === (rtl ? "end" : "start") ? "right" : "left" : alignment === "start" ? "bottom" : "top";
  if (rects.reference[length] > rects.floating[length]) {
    mainAlignmentSide = getOppositePlacement(mainAlignmentSide);
  }
  return [mainAlignmentSide, getOppositePlacement(mainAlignmentSide)];
}
function getExpandedPlacements(placement) {
  const oppositePlacement = getOppositePlacement(placement);
  return [getOppositeAlignmentPlacement(placement), oppositePlacement, getOppositeAlignmentPlacement(oppositePlacement)];
}
function getOppositeAlignmentPlacement(placement) {
  return placement.replace(/start|end/g, (alignment) => oppositeAlignmentMap[alignment]);
}
function getSideList(side, isStart, rtl) {
  const lr = ["left", "right"];
  const rl = ["right", "left"];
  const tb = ["top", "bottom"];
  const bt = ["bottom", "top"];
  switch (side) {
    case "top":
    case "bottom":
      if (rtl)
        return isStart ? rl : lr;
      return isStart ? lr : rl;
    case "left":
    case "right":
      return isStart ? tb : bt;
    default:
      return [];
  }
}
function getOppositeAxisPlacements(placement, flipAlignment, direction, rtl) {
  const alignment = getAlignment(placement);
  let list = getSideList(getSide(placement), direction === "start", rtl);
  if (alignment) {
    list = list.map((side) => side + "-" + alignment);
    if (flipAlignment) {
      list = list.concat(list.map(getOppositeAlignmentPlacement));
    }
  }
  return list;
}
function getOppositePlacement(placement) {
  return placement.replace(/left|right|bottom|top/g, (side) => oppositeSideMap[side]);
}
function expandPaddingObject(padding) {
  return __spreadValues({
    top: 0,
    right: 0,
    bottom: 0,
    left: 0
  }, padding);
}
function getPaddingObject(padding) {
  return typeof padding !== "number" ? expandPaddingObject(padding) : {
    top: padding,
    right: padding,
    bottom: padding,
    left: padding
  };
}
function rectToClientRect(rect) {
  return __spreadProps(__spreadValues({}, rect), {
    top: rect.y,
    left: rect.x,
    right: rect.x + rect.width,
    bottom: rect.y + rect.height
  });
}
function computeCoordsFromPlacement(_ref, placement, rtl) {
  let {
    reference,
    floating
  } = _ref;
  const sideAxis = getSideAxis(placement);
  const alignmentAxis = getAlignmentAxis(placement);
  const alignLength = getAxisLength(alignmentAxis);
  const side = getSide(placement);
  const isVertical = sideAxis === "y";
  const commonX = reference.x + reference.width / 2 - floating.width / 2;
  const commonY = reference.y + reference.height / 2 - floating.height / 2;
  const commonAlign = reference[alignLength] / 2 - floating[alignLength] / 2;
  let coords;
  switch (side) {
    case "top":
      coords = {
        x: commonX,
        y: reference.y - floating.height
      };
      break;
    case "bottom":
      coords = {
        x: commonX,
        y: reference.y + reference.height
      };
      break;
    case "right":
      coords = {
        x: reference.x + reference.width,
        y: commonY
      };
      break;
    case "left":
      coords = {
        x: reference.x - floating.width,
        y: commonY
      };
      break;
    default:
      coords = {
        x: reference.x,
        y: reference.y
      };
  }
  switch (getAlignment(placement)) {
    case "start":
      coords[alignmentAxis] -= commonAlign * (rtl && isVertical ? -1 : 1);
      break;
    case "end":
      coords[alignmentAxis] += commonAlign * (rtl && isVertical ? -1 : 1);
      break;
  }
  return coords;
}
var computePosition$1 = async (reference, floating, config) => {
  const {
    placement = "bottom",
    strategy = "absolute",
    middleware = [],
    platform: platform2
  } = config;
  const validMiddleware = middleware.filter(Boolean);
  const rtl = await (platform2.isRTL == null ? void 0 : platform2.isRTL(floating));
  let rects = await platform2.getElementRects({
    reference,
    floating,
    strategy
  });
  let {
    x,
    y
  } = computeCoordsFromPlacement(rects, placement, rtl);
  let statefulPlacement = placement;
  let middlewareData = {};
  let resetCount = 0;
  for (let i = 0; i < validMiddleware.length; i++) {
    const {
      name,
      fn
    } = validMiddleware[i];
    const {
      x: nextX,
      y: nextY,
      data,
      reset
    } = await fn({
      x,
      y,
      initialPlacement: placement,
      placement: statefulPlacement,
      strategy,
      middlewareData,
      rects,
      platform: platform2,
      elements: {
        reference,
        floating
      }
    });
    x = nextX != null ? nextX : x;
    y = nextY != null ? nextY : y;
    middlewareData = __spreadProps(__spreadValues({}, middlewareData), {
      [name]: __spreadValues(__spreadValues({}, middlewareData[name]), data)
    });
    if (reset && resetCount <= 50) {
      resetCount++;
      if (typeof reset === "object") {
        if (reset.placement) {
          statefulPlacement = reset.placement;
        }
        if (reset.rects) {
          rects = reset.rects === true ? await platform2.getElementRects({
            reference,
            floating,
            strategy
          }) : reset.rects;
        }
        ({
          x,
          y
        } = computeCoordsFromPlacement(rects, statefulPlacement, rtl));
      }
      i = -1;
      continue;
    }
  }
  return {
    x,
    y,
    placement: statefulPlacement,
    strategy,
    middlewareData
  };
};
async function detectOverflow(state, options) {
  var _await$platform$isEle;
  if (options === void 0) {
    options = {};
  }
  const {
    x,
    y,
    platform: platform2,
    rects,
    elements,
    strategy
  } = state;
  const {
    boundary = "clippingAncestors",
    rootBoundary = "viewport",
    elementContext = "floating",
    altBoundary = false,
    padding = 0
  } = evaluate(options, state);
  const paddingObject = getPaddingObject(padding);
  const altContext = elementContext === "floating" ? "reference" : "floating";
  const element = elements[altBoundary ? altContext : elementContext];
  const clippingClientRect = rectToClientRect(await platform2.getClippingRect({
    element: ((_await$platform$isEle = await (platform2.isElement == null ? void 0 : platform2.isElement(element))) != null ? _await$platform$isEle : true) ? element : element.contextElement || await (platform2.getDocumentElement == null ? void 0 : platform2.getDocumentElement(elements.floating)),
    boundary,
    rootBoundary,
    strategy
  }));
  const rect = elementContext === "floating" ? __spreadProps(__spreadValues({}, rects.floating), {
    x,
    y
  }) : rects.reference;
  const offsetParent = await (platform2.getOffsetParent == null ? void 0 : platform2.getOffsetParent(elements.floating));
  const offsetScale = await (platform2.isElement == null ? void 0 : platform2.isElement(offsetParent)) ? await (platform2.getScale == null ? void 0 : platform2.getScale(offsetParent)) || {
    x: 1,
    y: 1
  } : {
    x: 1,
    y: 1
  };
  const elementClientRect = rectToClientRect(platform2.convertOffsetParentRelativeRectToViewportRelativeRect ? await platform2.convertOffsetParentRelativeRectToViewportRelativeRect({
    rect,
    offsetParent,
    strategy
  }) : rect);
  return {
    top: (clippingClientRect.top - elementClientRect.top + paddingObject.top) / offsetScale.y,
    bottom: (elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom) / offsetScale.y,
    left: (clippingClientRect.left - elementClientRect.left + paddingObject.left) / offsetScale.x,
    right: (elementClientRect.right - clippingClientRect.right + paddingObject.right) / offsetScale.x
  };
}
var flip = function(options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: "flip",
    options,
    async fn(state) {
      var _middlewareData$arrow, _middlewareData$flip;
      const {
        placement,
        middlewareData,
        rects,
        initialPlacement,
        platform: platform2,
        elements
      } = state;
      const _a2 = evaluate(options, state), {
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = true,
        fallbackPlacements: specifiedFallbackPlacements,
        fallbackStrategy = "bestFit",
        fallbackAxisSideDirection = "none",
        flipAlignment = true
      } = _a2, detectOverflowOptions = __objRest(_a2, [
        "mainAxis",
        "crossAxis",
        "fallbackPlacements",
        "fallbackStrategy",
        "fallbackAxisSideDirection",
        "flipAlignment"
      ]);
      if ((_middlewareData$arrow = middlewareData.arrow) != null && _middlewareData$arrow.alignmentOffset) {
        return {};
      }
      const side = getSide(placement);
      const isBasePlacement = getSide(initialPlacement) === initialPlacement;
      const rtl = await (platform2.isRTL == null ? void 0 : platform2.isRTL(elements.floating));
      const fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipAlignment ? [getOppositePlacement(initialPlacement)] : getExpandedPlacements(initialPlacement));
      if (!specifiedFallbackPlacements && fallbackAxisSideDirection !== "none") {
        fallbackPlacements.push(...getOppositeAxisPlacements(initialPlacement, flipAlignment, fallbackAxisSideDirection, rtl));
      }
      const placements = [initialPlacement, ...fallbackPlacements];
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const overflows = [];
      let overflowsData = ((_middlewareData$flip = middlewareData.flip) == null ? void 0 : _middlewareData$flip.overflows) || [];
      if (checkMainAxis) {
        overflows.push(overflow[side]);
      }
      if (checkCrossAxis) {
        const sides = getAlignmentSides(placement, rects, rtl);
        overflows.push(overflow[sides[0]], overflow[sides[1]]);
      }
      overflowsData = [...overflowsData, {
        placement,
        overflows
      }];
      if (!overflows.every((side2) => side2 <= 0)) {
        var _middlewareData$flip2, _overflowsData$filter;
        const nextIndex = (((_middlewareData$flip2 = middlewareData.flip) == null ? void 0 : _middlewareData$flip2.index) || 0) + 1;
        const nextPlacement = placements[nextIndex];
        if (nextPlacement) {
          return {
            data: {
              index: nextIndex,
              overflows: overflowsData
            },
            reset: {
              placement: nextPlacement
            }
          };
        }
        let resetPlacement = (_overflowsData$filter = overflowsData.filter((d) => d.overflows[0] <= 0).sort((a, b) => a.overflows[1] - b.overflows[1])[0]) == null ? void 0 : _overflowsData$filter.placement;
        if (!resetPlacement) {
          switch (fallbackStrategy) {
            case "bestFit": {
              var _overflowsData$map$so;
              const placement2 = (_overflowsData$map$so = overflowsData.map((d) => [d.placement, d.overflows.filter((overflow2) => overflow2 > 0).reduce((acc, overflow2) => acc + overflow2, 0)]).sort((a, b) => a[1] - b[1])[0]) == null ? void 0 : _overflowsData$map$so[0];
              if (placement2) {
                resetPlacement = placement2;
              }
              break;
            }
            case "initialPlacement":
              resetPlacement = initialPlacement;
              break;
          }
        }
        if (placement !== resetPlacement) {
          return {
            reset: {
              placement: resetPlacement
            }
          };
        }
      }
      return {};
    }
  };
};
function getBoundingRect(rects) {
  const minX = min(...rects.map((rect) => rect.left));
  const minY = min(...rects.map((rect) => rect.top));
  const maxX = max(...rects.map((rect) => rect.right));
  const maxY = max(...rects.map((rect) => rect.bottom));
  return {
    x: minX,
    y: minY,
    width: maxX - minX,
    height: maxY - minY
  };
}
function getRectsByLine(rects) {
  const sortedRects = rects.slice().sort((a, b) => a.y - b.y);
  const groups = [];
  let prevRect = null;
  for (let i = 0; i < sortedRects.length; i++) {
    const rect = sortedRects[i];
    if (!prevRect || rect.y - prevRect.y > prevRect.height / 2) {
      groups.push([rect]);
    } else {
      groups[groups.length - 1].push(rect);
    }
    prevRect = rect;
  }
  return groups.map((rect) => rectToClientRect(getBoundingRect(rect)));
}
var inline = function(options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: "inline",
    options,
    async fn(state) {
      const {
        placement,
        elements,
        rects,
        platform: platform2,
        strategy
      } = state;
      const {
        padding = 2,
        x,
        y
      } = evaluate(options, state);
      const nativeClientRects = Array.from(await (platform2.getClientRects == null ? void 0 : platform2.getClientRects(elements.reference)) || []);
      const clientRects = getRectsByLine(nativeClientRects);
      const fallback = rectToClientRect(getBoundingRect(nativeClientRects));
      const paddingObject = getPaddingObject(padding);
      function getBoundingClientRect2() {
        if (clientRects.length === 2 && clientRects[0].left > clientRects[1].right && x != null && y != null) {
          return clientRects.find((rect) => x > rect.left - paddingObject.left && x < rect.right + paddingObject.right && y > rect.top - paddingObject.top && y < rect.bottom + paddingObject.bottom) || fallback;
        }
        if (clientRects.length >= 2) {
          if (getSideAxis(placement) === "y") {
            const firstRect = clientRects[0];
            const lastRect = clientRects[clientRects.length - 1];
            const isTop = getSide(placement) === "top";
            const top2 = firstRect.top;
            const bottom2 = lastRect.bottom;
            const left2 = isTop ? firstRect.left : lastRect.left;
            const right2 = isTop ? firstRect.right : lastRect.right;
            const width2 = right2 - left2;
            const height2 = bottom2 - top2;
            return {
              top: top2,
              bottom: bottom2,
              left: left2,
              right: right2,
              width: width2,
              height: height2,
              x: left2,
              y: top2
            };
          }
          const isLeftSide = getSide(placement) === "left";
          const maxRight = max(...clientRects.map((rect) => rect.right));
          const minLeft = min(...clientRects.map((rect) => rect.left));
          const measureRects = clientRects.filter((rect) => isLeftSide ? rect.left === minLeft : rect.right === maxRight);
          const top = measureRects[0].top;
          const bottom = measureRects[measureRects.length - 1].bottom;
          const left = minLeft;
          const right = maxRight;
          const width = right - left;
          const height = bottom - top;
          return {
            top,
            bottom,
            left,
            right,
            width,
            height,
            x: left,
            y: top
          };
        }
        return fallback;
      }
      const resetRects = await platform2.getElementRects({
        reference: {
          getBoundingClientRect: getBoundingClientRect2
        },
        floating: elements.floating,
        strategy
      });
      if (rects.reference.x !== resetRects.reference.x || rects.reference.y !== resetRects.reference.y || rects.reference.width !== resetRects.reference.width || rects.reference.height !== resetRects.reference.height) {
        return {
          reset: {
            rects: resetRects
          }
        };
      }
      return {};
    }
  };
};
async function convertValueToCoords(state, options) {
  const {
    placement,
    platform: platform2,
    elements
  } = state;
  const rtl = await (platform2.isRTL == null ? void 0 : platform2.isRTL(elements.floating));
  const side = getSide(placement);
  const alignment = getAlignment(placement);
  const isVertical = getSideAxis(placement) === "y";
  const mainAxisMulti = ["left", "top"].includes(side) ? -1 : 1;
  const crossAxisMulti = rtl && isVertical ? -1 : 1;
  const rawValue = evaluate(options, state);
  let {
    mainAxis,
    crossAxis,
    alignmentAxis
  } = typeof rawValue === "number" ? {
    mainAxis: rawValue,
    crossAxis: 0,
    alignmentAxis: null
  } : __spreadValues({
    mainAxis: 0,
    crossAxis: 0,
    alignmentAxis: null
  }, rawValue);
  if (alignment && typeof alignmentAxis === "number") {
    crossAxis = alignment === "end" ? alignmentAxis * -1 : alignmentAxis;
  }
  return isVertical ? {
    x: crossAxis * crossAxisMulti,
    y: mainAxis * mainAxisMulti
  } : {
    x: mainAxis * mainAxisMulti,
    y: crossAxis * crossAxisMulti
  };
}
var offset = function(options) {
  if (options === void 0) {
    options = 0;
  }
  return {
    name: "offset",
    options,
    async fn(state) {
      const {
        x,
        y
      } = state;
      const diffCoords = await convertValueToCoords(state, options);
      return {
        x: x + diffCoords.x,
        y: y + diffCoords.y,
        data: diffCoords
      };
    }
  };
};
function getNodeName(node) {
  if (isNode(node)) {
    return (node.nodeName || "").toLowerCase();
  }
  return "#document";
}
function getWindow(node) {
  var _node$ownerDocument;
  return (node == null ? void 0 : (_node$ownerDocument = node.ownerDocument) == null ? void 0 : _node$ownerDocument.defaultView) || window;
}
function getDocumentElement(node) {
  var _ref;
  return (_ref = (isNode(node) ? node.ownerDocument : node.document) || window.document) == null ? void 0 : _ref.documentElement;
}
function isNode(value) {
  return value instanceof Node || value instanceof getWindow(value).Node;
}
function isElement(value) {
  return value instanceof Element || value instanceof getWindow(value).Element;
}
function isHTMLElement(value) {
  return value instanceof HTMLElement || value instanceof getWindow(value).HTMLElement;
}
function isShadowRoot(value) {
  if (typeof ShadowRoot === "undefined") {
    return false;
  }
  return value instanceof ShadowRoot || value instanceof getWindow(value).ShadowRoot;
}
function isOverflowElement(element) {
  const {
    overflow,
    overflowX,
    overflowY,
    display
  } = getComputedStyle$1(element);
  return /auto|scroll|overlay|hidden|clip/.test(overflow + overflowY + overflowX) && !["inline", "contents"].includes(display);
}
function isTableElement(element) {
  return ["table", "td", "th"].includes(getNodeName(element));
}
function isContainingBlock(element) {
  const webkit = isWebKit();
  const css = getComputedStyle$1(element);
  return css.transform !== "none" || css.perspective !== "none" || (css.containerType ? css.containerType !== "normal" : false) || !webkit && (css.backdropFilter ? css.backdropFilter !== "none" : false) || !webkit && (css.filter ? css.filter !== "none" : false) || ["transform", "perspective", "filter"].some((value) => (css.willChange || "").includes(value)) || ["paint", "layout", "strict", "content"].some((value) => (css.contain || "").includes(value));
}
function getContainingBlock(element) {
  let currentNode = getParentNode(element);
  while (isHTMLElement(currentNode) && !isLastTraversableNode(currentNode)) {
    if (isContainingBlock(currentNode)) {
      return currentNode;
    } else {
      currentNode = getParentNode(currentNode);
    }
  }
  return null;
}
function isWebKit() {
  if (typeof CSS === "undefined" || !CSS.supports)
    return false;
  return CSS.supports("-webkit-backdrop-filter", "none");
}
function isLastTraversableNode(node) {
  return ["html", "body", "#document"].includes(getNodeName(node));
}
function getComputedStyle$1(element) {
  return getWindow(element).getComputedStyle(element);
}
function getNodeScroll(element) {
  if (isElement(element)) {
    return {
      scrollLeft: element.scrollLeft,
      scrollTop: element.scrollTop
    };
  }
  return {
    scrollLeft: element.pageXOffset,
    scrollTop: element.pageYOffset
  };
}
function getParentNode(node) {
  if (getNodeName(node) === "html") {
    return node;
  }
  const result = node.assignedSlot || node.parentNode || isShadowRoot(node) && node.host || getDocumentElement(node);
  return isShadowRoot(result) ? result.host : result;
}
function getNearestOverflowAncestor(node) {
  const parentNode = getParentNode(node);
  if (isLastTraversableNode(parentNode)) {
    return node.ownerDocument ? node.ownerDocument.body : node.body;
  }
  if (isHTMLElement(parentNode) && isOverflowElement(parentNode)) {
    return parentNode;
  }
  return getNearestOverflowAncestor(parentNode);
}
function getOverflowAncestors(node, list, traverseIframes) {
  var _node$ownerDocument2;
  if (list === void 0) {
    list = [];
  }
  if (traverseIframes === void 0) {
    traverseIframes = true;
  }
  const scrollableAncestor = getNearestOverflowAncestor(node);
  const isBody = scrollableAncestor === ((_node$ownerDocument2 = node.ownerDocument) == null ? void 0 : _node$ownerDocument2.body);
  const win = getWindow(scrollableAncestor);
  if (isBody) {
    return list.concat(win, win.visualViewport || [], isOverflowElement(scrollableAncestor) ? scrollableAncestor : [], win.frameElement && traverseIframes ? getOverflowAncestors(win.frameElement) : []);
  }
  return list.concat(scrollableAncestor, getOverflowAncestors(scrollableAncestor, [], traverseIframes));
}
function getCssDimensions(element) {
  const css = getComputedStyle$1(element);
  let width = parseFloat(css.width) || 0;
  let height = parseFloat(css.height) || 0;
  const hasOffset = isHTMLElement(element);
  const offsetWidth = hasOffset ? element.offsetWidth : width;
  const offsetHeight = hasOffset ? element.offsetHeight : height;
  const shouldFallback = round(width) !== offsetWidth || round(height) !== offsetHeight;
  if (shouldFallback) {
    width = offsetWidth;
    height = offsetHeight;
  }
  return {
    width,
    height,
    $: shouldFallback
  };
}
function unwrapElement(element) {
  return !isElement(element) ? element.contextElement : element;
}
function getScale(element) {
  const domElement = unwrapElement(element);
  if (!isHTMLElement(domElement)) {
    return createCoords(1);
  }
  const rect = domElement.getBoundingClientRect();
  const {
    width,
    height,
    $
  } = getCssDimensions(domElement);
  let x = ($ ? round(rect.width) : rect.width) / width;
  let y = ($ ? round(rect.height) : rect.height) / height;
  if (!x || !Number.isFinite(x)) {
    x = 1;
  }
  if (!y || !Number.isFinite(y)) {
    y = 1;
  }
  return {
    x,
    y
  };
}
var noOffsets = createCoords(0);
function getVisualOffsets(element) {
  const win = getWindow(element);
  if (!isWebKit() || !win.visualViewport) {
    return noOffsets;
  }
  return {
    x: win.visualViewport.offsetLeft,
    y: win.visualViewport.offsetTop
  };
}
function shouldAddVisualOffsets(element, isFixed, floatingOffsetParent) {
  if (isFixed === void 0) {
    isFixed = false;
  }
  if (!floatingOffsetParent || isFixed && floatingOffsetParent !== getWindow(element)) {
    return false;
  }
  return isFixed;
}
function getBoundingClientRect(element, includeScale, isFixedStrategy, offsetParent) {
  if (includeScale === void 0) {
    includeScale = false;
  }
  if (isFixedStrategy === void 0) {
    isFixedStrategy = false;
  }
  const clientRect = element.getBoundingClientRect();
  const domElement = unwrapElement(element);
  let scale = createCoords(1);
  if (includeScale) {
    if (offsetParent) {
      if (isElement(offsetParent)) {
        scale = getScale(offsetParent);
      }
    } else {
      scale = getScale(element);
    }
  }
  const visualOffsets = shouldAddVisualOffsets(domElement, isFixedStrategy, offsetParent) ? getVisualOffsets(domElement) : createCoords(0);
  let x = (clientRect.left + visualOffsets.x) / scale.x;
  let y = (clientRect.top + visualOffsets.y) / scale.y;
  let width = clientRect.width / scale.x;
  let height = clientRect.height / scale.y;
  if (domElement) {
    const win = getWindow(domElement);
    const offsetWin = offsetParent && isElement(offsetParent) ? getWindow(offsetParent) : offsetParent;
    let currentIFrame = win.frameElement;
    while (currentIFrame && offsetParent && offsetWin !== win) {
      const iframeScale = getScale(currentIFrame);
      const iframeRect = currentIFrame.getBoundingClientRect();
      const css = getComputedStyle$1(currentIFrame);
      const left = iframeRect.left + (currentIFrame.clientLeft + parseFloat(css.paddingLeft)) * iframeScale.x;
      const top = iframeRect.top + (currentIFrame.clientTop + parseFloat(css.paddingTop)) * iframeScale.y;
      x *= iframeScale.x;
      y *= iframeScale.y;
      width *= iframeScale.x;
      height *= iframeScale.y;
      x += left;
      y += top;
      currentIFrame = getWindow(currentIFrame).frameElement;
    }
  }
  return rectToClientRect({
    width,
    height,
    x,
    y
  });
}
function convertOffsetParentRelativeRectToViewportRelativeRect(_ref) {
  let {
    rect,
    offsetParent,
    strategy
  } = _ref;
  const isOffsetParentAnElement = isHTMLElement(offsetParent);
  const documentElement = getDocumentElement(offsetParent);
  if (offsetParent === documentElement) {
    return rect;
  }
  let scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  let scale = createCoords(1);
  const offsets = createCoords(0);
  if (isOffsetParentAnElement || !isOffsetParentAnElement && strategy !== "fixed") {
    if (getNodeName(offsetParent) !== "body" || isOverflowElement(documentElement)) {
      scroll = getNodeScroll(offsetParent);
    }
    if (isHTMLElement(offsetParent)) {
      const offsetRect = getBoundingClientRect(offsetParent);
      scale = getScale(offsetParent);
      offsets.x = offsetRect.x + offsetParent.clientLeft;
      offsets.y = offsetRect.y + offsetParent.clientTop;
    }
  }
  return {
    width: rect.width * scale.x,
    height: rect.height * scale.y,
    x: rect.x * scale.x - scroll.scrollLeft * scale.x + offsets.x,
    y: rect.y * scale.y - scroll.scrollTop * scale.y + offsets.y
  };
}
function getClientRects(element) {
  return Array.from(element.getClientRects());
}
function getWindowScrollBarX(element) {
  return getBoundingClientRect(getDocumentElement(element)).left + getNodeScroll(element).scrollLeft;
}
function getDocumentRect(element) {
  const html = getDocumentElement(element);
  const scroll = getNodeScroll(element);
  const body = element.ownerDocument.body;
  const width = max(html.scrollWidth, html.clientWidth, body.scrollWidth, body.clientWidth);
  const height = max(html.scrollHeight, html.clientHeight, body.scrollHeight, body.clientHeight);
  let x = -scroll.scrollLeft + getWindowScrollBarX(element);
  const y = -scroll.scrollTop;
  if (getComputedStyle$1(body).direction === "rtl") {
    x += max(html.clientWidth, body.clientWidth) - width;
  }
  return {
    width,
    height,
    x,
    y
  };
}
function getViewportRect(element, strategy) {
  const win = getWindow(element);
  const html = getDocumentElement(element);
  const visualViewport = win.visualViewport;
  let width = html.clientWidth;
  let height = html.clientHeight;
  let x = 0;
  let y = 0;
  if (visualViewport) {
    width = visualViewport.width;
    height = visualViewport.height;
    const visualViewportBased = isWebKit();
    if (!visualViewportBased || visualViewportBased && strategy === "fixed") {
      x = visualViewport.offsetLeft;
      y = visualViewport.offsetTop;
    }
  }
  return {
    width,
    height,
    x,
    y
  };
}
function getInnerBoundingClientRect(element, strategy) {
  const clientRect = getBoundingClientRect(element, true, strategy === "fixed");
  const top = clientRect.top + element.clientTop;
  const left = clientRect.left + element.clientLeft;
  const scale = isHTMLElement(element) ? getScale(element) : createCoords(1);
  const width = element.clientWidth * scale.x;
  const height = element.clientHeight * scale.y;
  const x = left * scale.x;
  const y = top * scale.y;
  return {
    width,
    height,
    x,
    y
  };
}
function getClientRectFromClippingAncestor(element, clippingAncestor, strategy) {
  let rect;
  if (clippingAncestor === "viewport") {
    rect = getViewportRect(element, strategy);
  } else if (clippingAncestor === "document") {
    rect = getDocumentRect(getDocumentElement(element));
  } else if (isElement(clippingAncestor)) {
    rect = getInnerBoundingClientRect(clippingAncestor, strategy);
  } else {
    const visualOffsets = getVisualOffsets(element);
    rect = __spreadProps(__spreadValues({}, clippingAncestor), {
      x: clippingAncestor.x - visualOffsets.x,
      y: clippingAncestor.y - visualOffsets.y
    });
  }
  return rectToClientRect(rect);
}
function hasFixedPositionAncestor(element, stopNode) {
  const parentNode = getParentNode(element);
  if (parentNode === stopNode || !isElement(parentNode) || isLastTraversableNode(parentNode)) {
    return false;
  }
  return getComputedStyle$1(parentNode).position === "fixed" || hasFixedPositionAncestor(parentNode, stopNode);
}
function getClippingElementAncestors(element, cache) {
  const cachedResult = cache.get(element);
  if (cachedResult) {
    return cachedResult;
  }
  let result = getOverflowAncestors(element, [], false).filter((el) => isElement(el) && getNodeName(el) !== "body");
  let currentContainingBlockComputedStyle = null;
  const elementIsFixed = getComputedStyle$1(element).position === "fixed";
  let currentNode = elementIsFixed ? getParentNode(element) : element;
  while (isElement(currentNode) && !isLastTraversableNode(currentNode)) {
    const computedStyle = getComputedStyle$1(currentNode);
    const currentNodeIsContaining = isContainingBlock(currentNode);
    if (!currentNodeIsContaining && computedStyle.position === "fixed") {
      currentContainingBlockComputedStyle = null;
    }
    const shouldDropCurrentNode = elementIsFixed ? !currentNodeIsContaining && !currentContainingBlockComputedStyle : !currentNodeIsContaining && computedStyle.position === "static" && !!currentContainingBlockComputedStyle && ["absolute", "fixed"].includes(currentContainingBlockComputedStyle.position) || isOverflowElement(currentNode) && !currentNodeIsContaining && hasFixedPositionAncestor(element, currentNode);
    if (shouldDropCurrentNode) {
      result = result.filter((ancestor) => ancestor !== currentNode);
    } else {
      currentContainingBlockComputedStyle = computedStyle;
    }
    currentNode = getParentNode(currentNode);
  }
  cache.set(element, result);
  return result;
}
function getClippingRect(_ref) {
  let {
    element,
    boundary,
    rootBoundary,
    strategy
  } = _ref;
  const elementClippingAncestors = boundary === "clippingAncestors" ? getClippingElementAncestors(element, this._c) : [].concat(boundary);
  const clippingAncestors = [...elementClippingAncestors, rootBoundary];
  const firstClippingAncestor = clippingAncestors[0];
  const clippingRect = clippingAncestors.reduce((accRect, clippingAncestor) => {
    const rect = getClientRectFromClippingAncestor(element, clippingAncestor, strategy);
    accRect.top = max(rect.top, accRect.top);
    accRect.right = min(rect.right, accRect.right);
    accRect.bottom = min(rect.bottom, accRect.bottom);
    accRect.left = max(rect.left, accRect.left);
    return accRect;
  }, getClientRectFromClippingAncestor(element, firstClippingAncestor, strategy));
  return {
    width: clippingRect.right - clippingRect.left,
    height: clippingRect.bottom - clippingRect.top,
    x: clippingRect.left,
    y: clippingRect.top
  };
}
function getDimensions(element) {
  return getCssDimensions(element);
}
function getRectRelativeToOffsetParent(element, offsetParent, strategy) {
  const isOffsetParentAnElement = isHTMLElement(offsetParent);
  const documentElement = getDocumentElement(offsetParent);
  const isFixed = strategy === "fixed";
  const rect = getBoundingClientRect(element, true, isFixed, offsetParent);
  let scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  const offsets = createCoords(0);
  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
    if (getNodeName(offsetParent) !== "body" || isOverflowElement(documentElement)) {
      scroll = getNodeScroll(offsetParent);
    }
    if (isOffsetParentAnElement) {
      const offsetRect = getBoundingClientRect(offsetParent, true, isFixed, offsetParent);
      offsets.x = offsetRect.x + offsetParent.clientLeft;
      offsets.y = offsetRect.y + offsetParent.clientTop;
    } else if (documentElement) {
      offsets.x = getWindowScrollBarX(documentElement);
    }
  }
  return {
    x: rect.left + scroll.scrollLeft - offsets.x,
    y: rect.top + scroll.scrollTop - offsets.y,
    width: rect.width,
    height: rect.height
  };
}
function getTrueOffsetParent(element, polyfill) {
  if (!isHTMLElement(element) || getComputedStyle$1(element).position === "fixed") {
    return null;
  }
  if (polyfill) {
    return polyfill(element);
  }
  return element.offsetParent;
}
function getOffsetParent(element, polyfill) {
  const window2 = getWindow(element);
  if (!isHTMLElement(element)) {
    return window2;
  }
  let offsetParent = getTrueOffsetParent(element, polyfill);
  while (offsetParent && isTableElement(offsetParent) && getComputedStyle$1(offsetParent).position === "static") {
    offsetParent = getTrueOffsetParent(offsetParent, polyfill);
  }
  if (offsetParent && (getNodeName(offsetParent) === "html" || getNodeName(offsetParent) === "body" && getComputedStyle$1(offsetParent).position === "static" && !isContainingBlock(offsetParent))) {
    return window2;
  }
  return offsetParent || getContainingBlock(element) || window2;
}
var getElementRects = async function(_ref) {
  let {
    reference,
    floating,
    strategy
  } = _ref;
  const getOffsetParentFn = this.getOffsetParent || getOffsetParent;
  const getDimensionsFn = this.getDimensions;
  return {
    reference: getRectRelativeToOffsetParent(reference, await getOffsetParentFn(floating), strategy),
    floating: __spreadValues({
      x: 0,
      y: 0
    }, await getDimensionsFn(floating))
  };
};
function isRTL(element) {
  return getComputedStyle$1(element).direction === "rtl";
}
var platform = {
  convertOffsetParentRelativeRectToViewportRelativeRect,
  getDocumentElement,
  getClippingRect,
  getOffsetParent,
  getElementRects,
  getClientRects,
  getDimensions,
  getScale,
  isElement,
  isRTL
};
function observeMove(element, onMove) {
  let io = null;
  let timeoutId;
  const root = getDocumentElement(element);
  function cleanup() {
    clearTimeout(timeoutId);
    io && io.disconnect();
    io = null;
  }
  function refresh(skip, threshold) {
    if (skip === void 0) {
      skip = false;
    }
    if (threshold === void 0) {
      threshold = 1;
    }
    cleanup();
    const {
      left,
      top,
      width,
      height
    } = element.getBoundingClientRect();
    if (!skip) {
      onMove();
    }
    if (!width || !height) {
      return;
    }
    const insetTop = floor(top);
    const insetRight = floor(root.clientWidth - (left + width));
    const insetBottom = floor(root.clientHeight - (top + height));
    const insetLeft = floor(left);
    const rootMargin = -insetTop + "px " + -insetRight + "px " + -insetBottom + "px " + -insetLeft + "px";
    const options = {
      rootMargin,
      threshold: max(0, min(1, threshold)) || 1
    };
    let isFirstUpdate = true;
    function handleObserve(entries) {
      const ratio = entries[0].intersectionRatio;
      if (ratio !== threshold) {
        if (!isFirstUpdate) {
          return refresh();
        }
        if (!ratio) {
          timeoutId = setTimeout(() => {
            refresh(false, 1e-7);
          }, 100);
        } else {
          refresh(false, ratio);
        }
      }
      isFirstUpdate = false;
    }
    try {
      io = new IntersectionObserver(handleObserve, __spreadProps(__spreadValues({}, options), {
        root: root.ownerDocument
      }));
    } catch (e) {
      io = new IntersectionObserver(handleObserve, options);
    }
    io.observe(element);
  }
  refresh(true);
  return cleanup;
}
function autoUpdate(reference, floating, update, options) {
  if (options === void 0) {
    options = {};
  }
  const {
    ancestorScroll = true,
    ancestorResize = true,
    elementResize = typeof ResizeObserver === "function",
    layoutShift = typeof IntersectionObserver === "function",
    animationFrame = false
  } = options;
  const referenceEl = unwrapElement(reference);
  const ancestors = ancestorScroll || ancestorResize ? [...referenceEl ? getOverflowAncestors(referenceEl) : [], ...getOverflowAncestors(floating)] : [];
  ancestors.forEach((ancestor) => {
    ancestorScroll && ancestor.addEventListener("scroll", update, {
      passive: true
    });
    ancestorResize && ancestor.addEventListener("resize", update);
  });
  const cleanupIo = referenceEl && layoutShift ? observeMove(referenceEl, update) : null;
  let reobserveFrame = -1;
  let resizeObserver = null;
  if (elementResize) {
    resizeObserver = new ResizeObserver((_ref) => {
      let [firstEntry] = _ref;
      if (firstEntry && firstEntry.target === referenceEl && resizeObserver) {
        resizeObserver.unobserve(floating);
        cancelAnimationFrame(reobserveFrame);
        reobserveFrame = requestAnimationFrame(() => {
          resizeObserver && resizeObserver.observe(floating);
        });
      }
      update();
    });
    if (referenceEl && !animationFrame) {
      resizeObserver.observe(referenceEl);
    }
    resizeObserver.observe(floating);
  }
  let frameId;
  let prevRefRect = animationFrame ? getBoundingClientRect(reference) : null;
  if (animationFrame) {
    frameLoop();
  }
  function frameLoop() {
    const nextRefRect = getBoundingClientRect(reference);
    if (prevRefRect && (nextRefRect.x !== prevRefRect.x || nextRefRect.y !== prevRefRect.y || nextRefRect.width !== prevRefRect.width || nextRefRect.height !== prevRefRect.height)) {
      update();
    }
    prevRefRect = nextRefRect;
    frameId = requestAnimationFrame(frameLoop);
  }
  update();
  return () => {
    ancestors.forEach((ancestor) => {
      ancestorScroll && ancestor.removeEventListener("scroll", update);
      ancestorResize && ancestor.removeEventListener("resize", update);
    });
    cleanupIo && cleanupIo();
    resizeObserver && resizeObserver.disconnect();
    resizeObserver = null;
    if (animationFrame) {
      cancelAnimationFrame(frameId);
    }
  };
}
var computePosition = (reference, floating, options) => {
  const cache = /* @__PURE__ */ new Map();
  const mergedOptions = __spreadValues({
    platform
  }, options);
  const platformWithCache = __spreadProps(__spreadValues({}, mergedOptions.platform), {
    _c: cache
  });
  return computePosition$1(reference, floating, __spreadProps(__spreadValues({}, mergedOptions), {
    platform: platformWithCache
  }));
};
var _hoisted_1$1 = ["id", "aria-hidden"];
var __default__ = {
  inheritAttrs: false
};
var _sfc_main$1 = Object.assign(__default__, {
  __name: "UsaTooltip",
  props: {
    label: {
      type: String,
      default: ""
    },
    id: {
      type: String,
      default: ""
    },
    wrapperTag: {
      type: String,
      default: "span"
    },
    tag: {
      type: String,
      default: "span"
    },
    position: {
      type: String,
      default: "top",
      validator(position) {
        const isValidPosition = ["top", "bottom", "left", "right"].includes(position);
        if (!isValidPosition) {
          console.warn(`'${position}' is not a valid tooltip position`);
        }
        return isValidPosition;
      }
    },
    customClasses: {
      type: Object,
      default: () => {
        return {
          component: [],
          label: []
        };
      }
    }
  },
  setup(__props) {
    const props = __props;
    const referenceElement = ref(null);
    const floatingElement = ref(null);
    const isSet = ref(false);
    const isVisible = ref(isSet.value);
    const currentPosition = ref(props.position);
    const currentCoordinates = ref({ left: 0, top: 0, opacity: 0 });
    const computedId = computed(() => props.id || nextId("usa-tooltip"));
    const labelClasses = computed(() => {
      var _a2;
      return [
        {
          "usa-tooltip__body--top": currentPosition.value === "top",
          "usa-tooltip__body--bottom": currentPosition.value === "bottom",
          "usa-tooltip__body--left": currentPosition.value === "left",
          "usa-tooltip__body--right": currentPosition.value === "right",
          "is-set": isSet.value,
          "is-visible": isVisible.value
        },
        ...((_a2 = props.customClasses) == null ? void 0 : _a2.label) || []
      ];
    });
    let cleanupFloatingUi;
    const updatePosition = () => {
      computePosition(referenceElement.value, floatingElement.value, {
        placement: props.position,
        middleware: [
          offset(5),
          inline(),
          flip({
            flipAlignment: false,
            fallbackPlacements: ["top", "bottom", "left", "right"]
          })
        ]
      }).then(({ x, y, placement }) => {
        currentPosition.value = placement;
        currentCoordinates.value.left = `${x}px`;
        currentCoordinates.value.top = `${y}px`;
      });
    };
    watch(isSet, (currentlySet) => {
      nextTick(() => {
        requestAnimationFrame(() => {
          isVisible.value = currentlySet;
          currentCoordinates.value.opacity = currentlySet ? 1 : 0;
        });
      });
    });
    onMounted(() => {
      isSet.value = true;
      cleanupFloatingUi = autoUpdate(referenceElement.value, floatingElement.value, updatePosition);
      nextTick(() => {
        requestAnimationFrame(() => {
          isSet.value = false;
        });
      });
    });
    onBeforeUnmount(() => {
      cleanupFloatingUi();
    });
    return (_ctx, _cache) => {
      var _a2;
      return openBlock(), createBlock(resolveDynamicComponent(__props.wrapperTag), {
        class: normalizeClass(["usa-tooltip", (_a2 = __props.customClasses) == null ? void 0 : _a2.component])
      }, {
        default: withCtx(() => [
          (openBlock(), createBlock(resolveDynamicComponent(__props.tag), mergeProps({
            ref_key: "referenceElement",
            ref: referenceElement
          }, _ctx.$attrs, {
            class: "usa-tooltip__trigger",
            tabindex: "0",
            "aria-describedby": computedId.value,
            onMouseenter: _cache[0] || (_cache[0] = ($event) => isSet.value = true),
            onMouseover: _cache[1] || (_cache[1] = ($event) => isSet.value = true),
            onMouseout: _cache[2] || (_cache[2] = ($event) => isSet.value = false),
            onFocus: _cache[3] || (_cache[3] = ($event) => isSet.value = true),
            onBlur: _cache[4] || (_cache[4] = ($event) => isSet.value = false),
            onKeydown: _cache[5] || (_cache[5] = ($event) => isSet.value = false)
          }), {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "default")
            ]),
            _: 3
          }, 16, ["aria-describedby"])),
          createBaseVNode("span", {
            id: computedId.value,
            ref_key: "floatingElement",
            ref: floatingElement,
            role: "tooltip",
            class: normalizeClass(["usa-tooltip__body", labelClasses.value]),
            "aria-hidden": !isVisible.value,
            style: normalizeStyle(currentCoordinates.value)
          }, [
            renderSlot(_ctx.$slots, "label", {}, () => [
              createTextVNode(toDisplayString(__props.label), 1)
            ])
          ], 14, _hoisted_1$1)
        ]),
        _: 3
      }, 8, ["class"]);
    };
  }
});
var _hoisted_1 = ["id"];
var _sfc_main = {
  __name: "UsaValidation",
  props: {
    validations: {
      type: Array,
      default: () => []
    },
    validationValue: {
      type: [String, Number],
      default: ""
    },
    heading: {
      type: String,
      default: ""
    },
    headingTag: {
      type: String,
      default: "h2"
    },
    validLabel: {
      type: String,
      default: "%s status complete"
    },
    invalidLabel: {
      type: String,
      default: "%s status incomplete"
    },
    id: {
      type: String,
      default: ""
    },
    customClasses: {
      type: Object,
      default: () => ({
        body: [],
        heading: [],
        checklist: []
      })
    }
  },
  emits: ["update:validationId", "update:statusMessageId"],
  setup(__props, { emit }) {
    const props = __props;
    const computedId = computed(() => props.id || nextId("usa-validation"));
    const computedStatusMessageId = computed(() => `${computedId.value}-status-message`);
    const validatedItems = computed(() => props.validations.reduce((acc, item) => {
      const validatedItem = {
        id: (item == null ? void 0 : item.id) && !!`${item.id}` ? item.id : item.text,
        text: item.text
      };
      if (objectHasKey(item, "checked")) {
        validatedItem.checked = item.checked;
      } else if (typeof (item == null ? void 0 : item.validator) === "string") {
        const regex = new RegExp(item.validator, "g");
        validatedItem.checked = regex.test(`${props.validationValue}`);
      } else if (typeof (item == null ? void 0 : item.validator) === "object" && item.validator instanceof RegExp) {
        validatedItem.checked = item.validator.test(`${props.validationValue}`);
      } else if (typeof (item == null ? void 0 : item.validator) === "function") {
        validatedItem.checked = item.validator(props.validationValue) === true;
      } else {
        validatedItem.checked = false;
      }
      validatedItem.ariaLabel = validatedItem.checked === true ? props.validLabel.replaceAll("%s", validatedItem.text) : props.invalidLabel.replaceAll("%s", validatedItem.text);
      acc.push(validatedItem);
      return acc;
    }, []));
    const statusMessage = refDebounced(computed(() => validatedItems.value.map((item) => `${item.ariaLabel}.`).join(" ")), 1e3);
    watch(computedId, () => emit("update:validationId", computedId), {
      immediate: true
    });
    watch(computedStatusMessageId, () => emit("update:statusMessageId", computedStatusMessageId), { immediate: true });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(Fragment, null, [
        createVNode(unref(_sfc_main$1v), mergeProps(_ctx.$attrs, {
          variant: "validation",
          heading: __props.heading,
          "heading-tag": __props.headingTag,
          "custom-classes": __props.customClasses
        }), {
          message: withCtx(() => {
            var _a2, _b;
            return [
              ((_a2 = validatedItems.value) == null ? void 0 : _a2.length) ? (openBlock(), createBlock(unref(_sfc_main$1j), {
                key: 0,
                id: computedId.value,
                items: validatedItems.value,
                class: normalizeClass((_b = __props.customClasses) == null ? void 0 : _b.checklist)
              }, null, 8, ["id", "items", "class"])) : createCommentVNode("", true)
            ];
          }),
          _: 1
        }, 16, ["heading", "heading-tag", "custom-classes"]),
        createBaseVNode("span", {
          id: computedStatusMessageId.value,
          "data-validation-status": "",
          class: "usa-sr-only",
          "aria-live": "polite",
          "aria-atomic": "true"
        }, toDisplayString(unref(statusMessage)), 9, _hoisted_1)
      ], 64);
    };
  }
};
var components = Object.freeze(Object.defineProperty({
  __proto__: null,
  BaseHeading: _sfc_main$1z,
  BaseLink,
  UsaAccordion: _sfc_main$1x,
  UsaAccordionItem: _sfc_main$1w,
  UsaAlert: _sfc_main$1v,
  UsaBanner: _sfc_main$1t,
  UsaBannerContent: _sfc_main$1u,
  UsaBreadcrumb: _sfc_main$1r,
  UsaBreadcrumbItem: _sfc_main$1s,
  UsaButton: _sfc_main$1q,
  UsaButtonGroup: _sfc_main$1p,
  UsaButtonGroupItem,
  UsaCard: _sfc_main$1n,
  UsaCharacterCount: _sfc_main$1m,
  UsaCheckbox: _sfc_main$1l,
  UsaChecklist: _sfc_main$1j,
  UsaChecklistItem: _sfc_main$1k,
  UsaCollection: _sfc_main$1i,
  UsaCollectionCalendar: _sfc_main$1h,
  UsaCollectionHeading: _sfc_main$1g,
  UsaCollectionItem: _sfc_main$1f,
  UsaCollectionMeta: _sfc_main$1e,
  UsaCollectionMetaItem,
  UsaComboBox: _sfc_main$1a,
  UsaDateInput: _sfc_main$17,
  UsaDatePicker: _sfc_main$12,
  UsaDatePickerCalendar: _sfc_main$13,
  UsaDatePickerCalendarDay: _sfc_main$16,
  UsaDatePickerCalendarMonth: _sfc_main$15,
  UsaDatePickerCalendarYear: _sfc_main$14,
  UsaDateRangePicker: _sfc_main$11,
  UsaFileInput: _sfc_main$10,
  UsaFooter: _sfc_main$$,
  UsaFooterAddress: _sfc_main$_,
  UsaFooterCollapsibleMenu: _sfc_main$Y,
  UsaFooterCollapsibleMenuSection: _sfc_main$Z,
  UsaFooterLogo: _sfc_main$X,
  UsaFooterMenu: _sfc_main$W,
  UsaFooterNav: _sfc_main$V,
  UsaFooterPrimarySection,
  UsaFooterSecondarySection: _sfc_main$T,
  UsaFooterSocialLinks: _sfc_main$S,
  UsaFormGroup: _sfc_main$1c,
  UsaGraphicList: _sfc_main$R,
  UsaGraphicListRow,
  UsaHeader: _sfc_main$P,
  UsaHero: _sfc_main$O,
  UsaHeroCallout: _sfc_main$N,
  UsaIcon: _sfc_main$M,
  UsaIconList: _sfc_main$L,
  UsaIconListItem: _sfc_main$K,
  UsaIdentiferMoreInfo: _sfc_main$J,
  UsaIdentifier,
  UsaIdentifierLogo: _sfc_main$H,
  UsaIdentifierMasthead: _sfc_main$G,
  UsaIdentifierRequiredLinks: _sfc_main$F,
  UsaLabel: _sfc_main$1b,
  UsaLink: _sfc_main$E,
  UsaLogo: _sfc_main$D,
  UsaMediaBlock: _sfc_main$C,
  UsaModal: _sfc_main$A,
  UsaModalCloseButton: _sfc_main$B,
  UsaNav: _sfc_main$y,
  UsaNavDropdown: _sfc_main$x,
  UsaNavDropdownButton: _sfc_main$w,
  UsaNavPrimary: _sfc_main$s,
  UsaNavPrimaryItem: _sfc_main$v,
  UsaNavSecondary: _sfc_main$r,
  UsaNavSubmenu: _sfc_main$u,
  UsaNavSubmenuItem: _sfc_main$t,
  UsaNavbar: _sfc_main$q,
  UsaOverlay: _sfc_main$z,
  UsaPagination: _sfc_main$n,
  UsaPaginationArrow: _sfc_main$p,
  UsaPaginationItem: _sfc_main$o,
  UsaPasswordMask: _sfc_main$m,
  UsaProcessList: _sfc_main$l,
  UsaProcessListItem: _sfc_main$k,
  UsaRadio: _sfc_main$j,
  UsaRange: _sfc_main$i,
  UsaSearch: _sfc_main$h,
  UsaSelect: _sfc_main$18,
  UsaSidenav: _sfc_main$f,
  UsaSidenavItem: _sfc_main$g,
  UsaSignUp: _sfc_main$e,
  UsaSiteAlert: _sfc_main$d,
  UsaSkipnav: _sfc_main$c,
  UsaStepIndicator: _sfc_main$9,
  UsaStepIndicatorHeader: _sfc_main$a,
  UsaStepIndicatorSegment: _sfc_main$b,
  UsaSummaryBox: _sfc_main$8,
  UsaTable: _sfc_main$5,
  UsaTableHeaderCell: _sfc_main$6,
  UsaTableSortButton: _sfc_main$7,
  UsaTag: _sfc_main$4,
  UsaTextInput: _sfc_main$19,
  UsaTextarea: _sfc_main$3,
  UsaTimePicker: _sfc_main$2,
  UsaTooltip: _sfc_main$1,
  UsaValidation: _sfc_main
}, Symbol.toStringTag, { value: "Module" }));
function install(app, options) {
  core.install(app, options);
  Object.keys(components).forEach((componentName) => {
    app.component(componentName, components[componentName]);
  });
}
export {
  install as default
};
/*! Bundled license information:

vue-uswds/dist/vue-uswds.es.js:
  (*!
  * tabbable 6.2.0
  * @license MIT, https://github.com/focus-trap/tabbable/blob/master/LICENSE
  *)
  (*!
  * focus-trap 7.5.3
  * @license MIT, https://github.com/focus-trap/focus-trap/blob/master/LICENSE
  *)
*/
//# sourceMappingURL=vue-uswds.js.map
