import type { CookieStore } from './cookie_store.js';
import { NetlifyRequest } from './request.js';
declare const getContext: (req: NetlifyRequest, cookies: CookieStore) => {
    account: {
        id: string;
    };
    cookies: import("./cookie_store.js").Cookies;
    deploy: {
        id: string;
    };
    geo: import("./geo.js").Geo;
    ip: string;
    json: (input: unknown) => Response;
    log: {
        (...data: any[]): void;
        (message?: any, ...optionalParams: any[]): void;
    };
    next: () => never;
    params: Record<string, string>;
    requestId: string;
    rewrite: (input: string | URL) => Promise<Response>;
    server: import("./server.js").Server;
    site: import("./site.js").Site;
};
type Context = ReturnType<typeof getContext>;
export { Context, getContext };
