"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __reExport = (target, mod, secondTarget) => (__copyProps(target, mod, "default"), secondTarget && __copyProps(secondTarget, mod, "default"));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  DEFINE_EMIT: () => DEFINE_EMIT,
  DEFINE_EMITS: () => DEFINE_EMITS,
  DEFINE_MODELS: () => DEFINE_MODELS,
  DEFINE_MODELS_DOLLAR: () => DEFINE_MODELS_DOLLAR,
  DEFINE_OPTIONS: () => DEFINE_OPTIONS,
  DEFINE_PROP: () => DEFINE_PROP,
  DEFINE_PROPS: () => DEFINE_PROPS,
  DEFINE_PROPS_DOLLAR: () => DEFINE_PROPS_DOLLAR,
  DEFINE_PROPS_REFS: () => DEFINE_PROPS_REFS,
  DEFINE_RENDER: () => DEFINE_RENDER,
  DEFINE_SETUP_COMPONENT: () => DEFINE_SETUP_COMPONENT,
  DEFINE_SLOTS: () => DEFINE_SLOTS,
  HELPER_PREFIX: () => HELPER_PREFIX,
  REGEX_NODE_MODULES: () => REGEX_NODE_MODULES,
  REGEX_SETUP_SFC: () => REGEX_SETUP_SFC,
  REGEX_SETUP_SFC_SUB: () => REGEX_SETUP_SFC_SUB,
  REGEX_SRC_FILE: () => REGEX_SRC_FILE,
  REGEX_SUPPORTED_EXT: () => REGEX_SUPPORTED_EXT,
  REGEX_VUE_SFC: () => REGEX_VUE_SFC,
  REGEX_VUE_SUB: () => REGEX_VUE_SUB,
  REPO_ISSUE_URL: () => REPO_ISSUE_URL,
  VIRTUAL_ID_PREFIX: () => VIRTUAL_ID_PREFIX,
  WITH_DEFAULTS: () => WITH_DEFAULTS,
  addNormalScript: () => addNormalScript,
  checkInvalidScopeReference: () => checkInvalidScopeReference,
  createFilter: () => createFilter,
  detectVueVersion: () => detectVueVersion,
  getFileCodeAndLang: () => getFileCodeAndLang,
  getTransformResult: () => getTransformResult,
  getVuePluginApi: () => getVuePluginApi,
  importHelperFn: () => importHelperFn,
  isStaticExpression: () => isStaticExpression,
  isStaticObjectKey: () => isStaticObjectKey,
  normalizePath: () => import_pluginutils2.normalizePath,
  parseSFC: () => parseSFC,
  removeMacroImport: () => removeMacroImport,
  resolveObjectExpression: () => resolveObjectExpression
});
module.exports = __toCommonJS(src_exports);
__reExport(src_exports, require("magic-string-ast"), module.exports);
__reExport(src_exports, require("ast-kit"), module.exports);

// src/ast.ts
var import_compiler_sfc = require("@vue/compiler-sfc");
var import_ast_kit = require("ast-kit");
function checkInvalidScopeReference(node, method, setupBindings) {
  if (!node)
    return;
  (0, import_compiler_sfc.walkIdentifiers)(node, (id) => {
    if (setupBindings.includes(id.name))
      throw new SyntaxError(
        `\`${method}()\` in <script setup> cannot reference locally declared variables (${id.name}) because it will be hoisted outside of the setup() function.`
      );
  });
}
function isStaticExpression(node, options = {}) {
  const { magicComment, fn, object, objectMethod, array, unary, regex } = options;
  if (magicComment && node.leadingComments?.some(
    (comment) => comment.value.trim() === magicComment
  ))
    return true;
  else if (fn && (0, import_ast_kit.isFunctionType)(node))
    return true;
  switch (node.type) {
    case "UnaryExpression":
      return !!unary && isStaticExpression(node.argument, options);
    case "LogicalExpression":
    case "BinaryExpression":
      return isStaticExpression(node.left, options) && isStaticExpression(node.right, options);
    case "ConditionalExpression":
      return isStaticExpression(node.test, options) && isStaticExpression(node.consequent, options) && isStaticExpression(node.alternate, options);
    case "SequenceExpression":
    case "TemplateLiteral":
      return node.expressions.every((expr) => isStaticExpression(expr, options));
    case "ArrayExpression":
      return !!array && node.elements.every(
        (element) => element && isStaticExpression(element, options)
      );
    case "ObjectExpression":
      return !!object && node.properties.every((prop) => {
        if (prop.type === "SpreadElement") {
          return prop.argument.type === "ObjectExpression" && isStaticExpression(prop.argument, options);
        } else if (!(0, import_ast_kit.isLiteralType)(prop.key) && prop.computed) {
          return false;
        } else if (prop.type === "ObjectProperty" && !isStaticExpression(prop.value, options)) {
          return false;
        }
        if (prop.type === "ObjectMethod" && !objectMethod) {
          return false;
        }
        return true;
      });
    case "ParenthesizedExpression":
    case "TSNonNullExpression":
    case "TSAsExpression":
    case "TSTypeAssertion":
    case "TSSatisfiesExpression":
      return isStaticExpression(node.expression, options);
    case "RegExpLiteral":
      return !!regex;
  }
  if ((0, import_ast_kit.isLiteralType)(node))
    return true;
  return false;
}
function isStaticObjectKey(node) {
  return node.properties.every((prop) => {
    if (prop.type === "SpreadElement") {
      return prop.argument.type === "ObjectExpression" && isStaticObjectKey(prop.argument);
    }
    return !prop.computed || (0, import_ast_kit.isLiteralType)(prop.key);
  });
}
function resolveObjectExpression(node) {
  const maps = /* @__PURE__ */ Object.create(null);
  for (const property of node.properties) {
    if (property.type === "SpreadElement") {
      if (property.argument.type !== "ObjectExpression")
        return void 0;
      Object.assign(maps, resolveObjectExpression(property.argument));
    } else {
      const key = (0, import_ast_kit.resolveObjectKey)(property);
      maps[key] = property;
    }
  }
  return maps;
}
var importedMap = /* @__PURE__ */ new WeakMap();
var HELPER_PREFIX = "__MACROS_";
function importHelperFn(s, offset, local, from = "vue", isDefault = false) {
  const imported = isDefault ? "default" : local;
  const cacheKey = `${from}@${imported}`;
  if (!importedMap.get(s)?.has(cacheKey)) {
    s.appendLeft(
      offset,
      `
import ${isDefault ? HELPER_PREFIX + local : `{ ${imported} as ${HELPER_PREFIX + local} }`} from ${JSON.stringify(from)};`
    );
    if (!importedMap.has(s)) {
      importedMap.set(s, /* @__PURE__ */ new Set([cacheKey]));
    } else {
      importedMap.get(s).add(cacheKey);
    }
  }
  return `${HELPER_PREFIX}${local}`;
}

// src/constants.ts
var DEFINE_PROPS = "defineProps";
var DEFINE_PROPS_DOLLAR = "$defineProps";
var DEFINE_PROPS_REFS = "definePropsRefs";
var DEFINE_EMITS = "defineEmits";
var WITH_DEFAULTS = "withDefaults";
var DEFINE_OPTIONS = "defineOptions";
var DEFINE_MODELS = "defineModels";
var DEFINE_MODELS_DOLLAR = "$defineModels";
var DEFINE_SETUP_COMPONENT = "defineSetupComponent";
var DEFINE_RENDER = "defineRender";
var DEFINE_SLOTS = "defineSlots";
var DEFINE_PROP = "defineProp";
var DEFINE_EMIT = "defineEmit";
var REPO_ISSUE_URL = "https://github.com/vue-macros/vue-macros/issues";
var REGEX_SRC_FILE = /\.[cm]?[jt]sx?$/;
var REGEX_SETUP_SFC = /\.setup\.[cm]?[jt]sx?$/;
var REGEX_SETUP_SFC_SUB = /\.setup\.[cm]?[jt]sx?((?!vue&).)*$/;
var REGEX_VUE_SFC = /\.vue$/;
var REGEX_VUE_SUB = /\.vue\?vue&type=script/;
var REGEX_NODE_MODULES = /node_modules/;
var REGEX_SUPPORTED_EXT = /\.([cm]?[jt]sx?|vue)$/;
var VIRTUAL_ID_PREFIX = "/vue-macros";

// src/dep.ts
var import_local_pkg = require("local-pkg");
function detectVueVersion(root = process.cwd()) {
  const vuePkg = (0, import_local_pkg.getPackageInfoSync)("vue", { paths: [root] });
  if (vuePkg && vuePkg.version) {
    const version = Number.parseFloat(vuePkg.version);
    return version >= 2 && version < 3 ? Math.trunc(version) : version;
  } else {
    return 3;
  }
}

// src/unplugin.ts
var import_pluginutils = require("@rollup/pluginutils");
var import_magic_string_ast = require("magic-string-ast");
var import_pluginutils2 = require("@rollup/pluginutils");
var getTransformResult = import_magic_string_ast.generateTransform;
function createFilter(options) {
  return (0, import_pluginutils.createFilter)(options.include, options.exclude);
}
var VUE3_PLUGINS = ["vite:vue", "unplugin-vue"];
var VUE2_PLUGINS = ["vite:vue2", "unplugin-vue2"];
function getVuePluginApi(plugins) {
  const vuePlugin = (plugins || []).find(
    (p) => [...VUE3_PLUGINS, ...VUE2_PLUGINS].includes(p.name)
  );
  if (!vuePlugin)
    throw new Error(
      "Cannot find Vue plugin (@vitejs/plugin-vue or unplugin-vue). Please make sure to add it before using Vue Macros."
    );
  if (VUE2_PLUGINS.includes(vuePlugin.name)) {
    return null;
  }
  const api = vuePlugin.api;
  if (!api?.version) {
    throw new Error(
      "The Vue plugin is not supported (@vitejs/plugin-vue or unplugin-vue). Please make sure version > 4.3.4."
    );
  }
  return api;
}

// src/vue.ts
var import_compiler_sfc2 = require("@vue/compiler-sfc");
var import_ast_kit2 = require("ast-kit");
function parseSFC(code, id) {
  const sfc = (0, import_compiler_sfc2.parse)(code, {
    filename: id
  });
  const { descriptor, errors } = sfc;
  const scriptLang = sfc.descriptor.script?.lang;
  const scriptSetupLang = sfc.descriptor.scriptSetup?.lang;
  if (sfc.descriptor.script && sfc.descriptor.scriptSetup && (scriptLang || "js") !== (scriptSetupLang || "js")) {
    throw new Error(
      `[unplugin-vue-macros] <script> and <script setup> must have the same language type.`
    );
  }
  const lang = scriptLang || scriptSetupLang;
  return {
    sfc,
    ...descriptor,
    lang,
    errors,
    offset: descriptor.scriptSetup?.loc.start.offset ?? 0,
    getSetupAst() {
      if (!descriptor.scriptSetup)
        return;
      return (0, import_ast_kit2.babelParse)(descriptor.scriptSetup.content, lang, {
        plugins: [["importAttributes", { deprecatedAssertSyntax: true }]]
      });
    },
    getScriptAst() {
      if (!descriptor.script)
        return;
      return (0, import_ast_kit2.babelParse)(descriptor.script.content, lang, {
        plugins: [["importAttributes", { deprecatedAssertSyntax: true }]]
      });
    }
  };
}
function getFileCodeAndLang(code, id) {
  if (!REGEX_VUE_SFC.test(id)) {
    return {
      code,
      lang: (0, import_ast_kit2.getLang)(id)
    };
  }
  const sfc = parseSFC(code, id);
  const scriptCode = sfc.script?.content ?? "";
  return {
    code: sfc.scriptSetup ? `${scriptCode}
;
${sfc.scriptSetup.content}` : scriptCode,
    lang: sfc.lang ?? "js"
  };
}
function addNormalScript({ script, lang }, s) {
  return {
    start() {
      if (script)
        return script.loc.end.offset;
      const attrs = lang ? ` lang="${lang}"` : "";
      s.prependLeft(0, `<script${attrs}>`);
      return 0;
    },
    end() {
      if (!script)
        s.appendRight(0, `
</script>
`);
    }
  };
}
function removeMacroImport(node, s, offset) {
  if (node.type === "ImportDeclaration" && node.attributes?.some(
    (attr) => (0, import_ast_kit2.resolveString)(attr.key) === "type" && attr.value.value === "macro"
  )) {
    s.removeNode(node, { offset });
    return true;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  DEFINE_EMIT,
  DEFINE_EMITS,
  DEFINE_MODELS,
  DEFINE_MODELS_DOLLAR,
  DEFINE_OPTIONS,
  DEFINE_PROP,
  DEFINE_PROPS,
  DEFINE_PROPS_DOLLAR,
  DEFINE_PROPS_REFS,
  DEFINE_RENDER,
  DEFINE_SETUP_COMPONENT,
  DEFINE_SLOTS,
  HELPER_PREFIX,
  REGEX_NODE_MODULES,
  REGEX_SETUP_SFC,
  REGEX_SETUP_SFC_SUB,
  REGEX_SRC_FILE,
  REGEX_SUPPORTED_EXT,
  REGEX_VUE_SFC,
  REGEX_VUE_SUB,
  REPO_ISSUE_URL,
  VIRTUAL_ID_PREFIX,
  WITH_DEFAULTS,
  addNormalScript,
  checkInvalidScopeReference,
  createFilter,
  detectVueVersion,
  getFileCodeAndLang,
  getTransformResult,
  getVuePluginApi,
  importHelperFn,
  isStaticExpression,
  isStaticObjectKey,
  normalizePath,
  parseSFC,
  removeMacroImport,
  resolveObjectExpression,
  ...require("magic-string-ast"),
  ...require("ast-kit")
});
