import { MaybeComputedRef } from '@vueuse/shared';
import { ValidateError, ValidateOption, Rules } from 'async-validator';
import { Ref } from 'vue-demi';

type AsyncValidatorError = Error & {
    errors: ValidateError[];
    fields: Record<string, ValidateError[]>;
};
interface UseAsyncValidatorReturn {
    pass: Ref<boolean>;
    errorInfo: Ref<AsyncValidatorError | null>;
    isFinished: Ref<boolean>;
    errors: Ref<AsyncValidatorError['errors'] | undefined>;
    errorFields: Ref<AsyncValidatorError['fields'] | undefined>;
}
interface UseAsyncValidatorOptions {
    /**
     * @see https://github.com/yiminghe/async-validator#options
     */
    validateOption?: ValidateOption;
}
/**
 * Wrapper for async-validator.
 *
 * @see https://vueuse.org/useAsyncValidator
 * @see https://github.com/yiminghe/async-validator
 */
declare function useAsyncValidator(value: MaybeComputedRef<Record<string, any>>, rules: MaybeComputedRef<Rules>, options?: UseAsyncValidatorOptions): UseAsyncValidatorReturn & PromiseLike<UseAsyncValidatorReturn>;

export { AsyncValidatorError, UseAsyncValidatorOptions, UseAsyncValidatorReturn, useAsyncValidator };
