'use strict';

var vueDemi = require('vue-demi');
var shared = require('@vueuse/shared');
var axios = require('axios');

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
function useAxios(...args) {
  const url = typeof args[0] === "string" ? args[0] : void 0;
  const argsPlaceholder = shared.isString(url) ? 1 : 0;
  let defaultConfig = {};
  let instance = axios;
  let options = { immediate: !!argsPlaceholder, shallow: true };
  const isAxiosInstance = (val) => !!(val == null ? void 0 : val.request);
  if (args.length > 0 + argsPlaceholder) {
    if (isAxiosInstance(args[0 + argsPlaceholder]))
      instance = args[0 + argsPlaceholder];
    else
      defaultConfig = args[0 + argsPlaceholder];
  }
  if (args.length > 1 + argsPlaceholder) {
    if (isAxiosInstance(args[1 + argsPlaceholder]))
      instance = args[1 + argsPlaceholder];
  }
  if (args.length === 2 + argsPlaceholder && !isAxiosInstance(args[1 + argsPlaceholder]) || args.length === 3 + argsPlaceholder)
    options = args[args.length - 1];
  const response = vueDemi.shallowRef();
  const data = options.shallow ? vueDemi.shallowRef() : vueDemi.ref();
  const isFinished = vueDemi.ref(false);
  const isLoading = vueDemi.ref(false);
  const isAborted = vueDemi.ref(false);
  const error = vueDemi.shallowRef();
  const cancelTokenSource = axios.CancelToken.source;
  let cancelToken = cancelTokenSource();
  const abort = (message) => {
    if (isFinished.value || !isLoading.value)
      return;
    cancelToken.cancel(message);
    cancelToken = cancelTokenSource();
    isAborted.value = true;
    isLoading.value = false;
    isFinished.value = false;
  };
  const loading = (loading2) => {
    isLoading.value = loading2;
    isFinished.value = !loading2;
  };
  const waitUntilFinished = () => new Promise((resolve, reject) => {
    shared.until(isFinished).toBe(true).then(() => resolve(result)).catch(reject);
  });
  const then = (onFulfilled, onRejected) => waitUntilFinished().then(onFulfilled, onRejected);
  const execute = (executeUrl = url, config = {}) => {
    error.value = void 0;
    const _url = typeof executeUrl === "string" ? executeUrl : url != null ? url : config.url;
    if (_url === void 0) {
      error.value = new axios.AxiosError(axios.AxiosError.ERR_INVALID_URL);
      isFinished.value = true;
      return { then };
    }
    abort();
    loading(true);
    instance(_url, __spreadProps(__spreadValues(__spreadValues({}, defaultConfig), typeof executeUrl === "object" ? executeUrl : config), { cancelToken: cancelToken.token })).then((r) => {
      var _a;
      response.value = r;
      const result2 = r.data;
      data.value = result2;
      (_a = options.onSuccess) == null ? void 0 : _a.call(options, result2);
    }).catch((e) => {
      var _a;
      error.value = e;
      (_a = options.onError) == null ? void 0 : _a.call(options, e);
    }).finally(() => loading(false));
    return { then };
  };
  if (options.immediate && url)
    execute();
  const result = {
    response,
    data,
    error,
    finished: isFinished,
    loading: isLoading,
    isFinished,
    isLoading,
    cancel: abort,
    isAborted,
    canceled: isAborted,
    aborted: isAborted,
    isCanceled: isAborted,
    abort,
    execute
  };
  return __spreadProps(__spreadValues({}, result), {
    then
  });
}

exports.useAxios = useAxios;
