import { ConfigurableFlush, MaybeComputedRef, RemovableRef } from '@vueuse/shared';

interface UseIDBOptions extends ConfigurableFlush {
    /**
     * Watch for deep changes
     *
     * @default true
     */
    deep?: boolean;
    /**
     * On error callback
     *
     * Default log error to `console.error`
     */
    onError?: (error: unknown) => void;
    /**
     * Use shallow ref as reference
     *
     * @default false
     */
    shallow?: boolean;
}
/**
 *
 * @param key
 * @param initialValue
 * @param options
 */
declare function useIDBKeyval<T>(key: IDBValidKey, initialValue: MaybeComputedRef<T>, options?: UseIDBOptions): RemovableRef<T>;

export { UseIDBOptions, useIDBKeyval };
