import * as vue_demi from 'vue-demi';
import nprogress, { NProgressOptions } from 'nprogress';
import { MaybeComputedRef } from '@vueuse/shared';

type UseNProgressOptions = Partial<NProgressOptions>;
/**
 * Reactive progress bar.
 *
 * @see https://vueuse.org/useNProgress
 */
declare function useNProgress(currentProgress?: MaybeComputedRef<number | null | undefined>, options?: UseNProgressOptions): {
    isLoading: vue_demi.WritableComputedRef<boolean>;
    progress: vue_demi.Ref<number | (() => number | null | undefined) | null | undefined>;
    start: () => nprogress.NProgress;
    done: (force?: boolean | undefined) => nprogress.NProgress;
    remove: () => void;
};
type UseNProgressReturn = ReturnType<typeof useNProgress>;

export { UseNProgressOptions, UseNProgressReturn, useNProgress };
