# git-config-path [![NPM version](https://img.shields.io/npm/v/git-config-path.svg?style=flat)](https://www.npmjs.com/package/git-config-path) [![NPM monthly downloads](https://img.shields.io/npm/dm/git-config-path.svg?style=flat)](https://npmjs.org/package/git-config-path) [![NPM total downloads](https://img.shields.io/npm/dt/git-config-path.svg?style=flat)](https://npmjs.org/package/git-config-path) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/git-config-path.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/git-config-path)

> Resolve the path to the user's local or global .gitconfig.

Please consider following this project's author, [Jon Schlinkert](https://github.com/jonschlinkert), and consider starring the project to show your :heart: and support.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save git-config-path
```

## Usage

Automatically gets the nearest `.git` config path, starting with the current working directory, then looking in the user's `home` directory.

```js
var gitConfigPath = require('git-config-path')();
//=> '/Users/jonschlinkert/dev/git-config-path/.git/config'
```

To force `git-config-path` to only look for a global config path, pass `global`:

```js
var gitConfigPath = require('git-config-path')('global');
//=> '/Users/jonschlinkert/.gitconfig'
```

## About

<details>
<summary><strong>Contributing</strong></summary>

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

</details>

<details>
<summary><strong>Running Tests</strong></summary>

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

</details>

<details>
<summary><strong>Building docs</strong></summary>

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

</details>

### Related projects

You might also be interested in these projects:

* [git-branch](https://www.npmjs.com/package/git-branch): Get the current branch from the local git repository. | [homepage](https://github.com/jonschlinkert/git-branch "Get the current branch from the local git repository.")
* [git-repo-name](https://www.npmjs.com/package/git-repo-name): Get the repository name from the git remote origin URL. | [homepage](https://github.com/jonschlinkert/git-repo-name "Get the repository name from the git remote origin URL.")
* [git-user-name](https://www.npmjs.com/package/git-user-name): Get a user's name from git config at the project or global scope, depending on… [more](https://github.com/jonschlinkert/git-user-name) | [homepage](https://github.com/jonschlinkert/git-user-name "Get a user's name from git config at the project or global scope, depending on what git uses in the current context.")
* [git-username](https://www.npmjs.com/package/git-username): Get the username (or 'owner' name) from a git/GitHub remote origin URL. | [homepage](https://github.com/jonschlinkert/git-username "Get the username (or 'owner' name) from a git/GitHub remote origin URL.")
* [is-git-url](https://www.npmjs.com/package/is-git-url): Regex to validate that a URL is a git url. | [homepage](https://github.com/jonschlinkert/is-git-url "Regex to validate that a URL is a git url.")
* [parse-git-config](https://www.npmjs.com/package/parse-git-config): Parse `.git/config` into a JavaScript object. sync or async. | [homepage](https://github.com/jonschlinkert/parse-git-config "Parse `.git/config` into a JavaScript object. sync or async.")

### Author

**Jon Schlinkert**

* [GitHub Profile](https://github.com/jonschlinkert)
* [Twitter Profile](https://twitter.com/jonschlinkert)
* [LinkedIn Profile](https://linkedin.com/in/jonschlinkert)

### License

Copyright © 2018, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.8.0, on November 18, 2018._