import type { H3Event, AppOptions } from "h3";
import type { RenderResponse } from "./renderer";
export type { NitroApp } from "./app";
export type { CacheEntry, CacheOptions, ResponseCacheEntry, CachedEventHandlerOptions, } from "./cache";
export type { NitroAppPlugin } from "./plugin";
export type { RenderResponse, RenderHandler } from "./renderer";
export type CapturedErrorContext = {
    event?: H3Event;
    [key: string]: unknown;
};
export type CaptureError = (error: Error, context: CapturedErrorContext) => void;
export interface NitroRuntimeHooks {
    close: () => void;
    error: CaptureError;
    request: AppOptions["onRequest"];
    beforeResponse: AppOptions["onBeforeResponse"];
    afterResponse: AppOptions["onAfterResponse"];
    "render:response": (response: Partial<RenderResponse>, context: {
        event: H3Event;
    }) => void;
}
