import { parse } from "cookie-es";
import { splitCookiesString } from "h3";
import { joinHeaders } from "./utils.mjs";
export function getAzureParsedCookiesFromHeaders(headers) {
  const c = String(headers["set-cookie"]);
  if (!c || c.length === 0) {
    return [];
  }
  const cookies = splitCookiesString(joinHeaders(c)).map(
    (cookie) => parse(cookie)
  );
  return cookies;
}
