export function normalizeLambdaIncomingHeaders(headers) {
  return Object.fromEntries(
    Object.entries(headers || {}).map(([key, value]) => [
      key.toLowerCase(),
      value
    ])
  );
}
export function normalizeLambdaOutgoingHeaders(headers, stripCookies = false) {
  const entries = stripCookies ? Object.entries(headers).filter(([key]) => !["set-cookie"].includes(key)) : Object.entries(headers);
  return Object.fromEntries(
    entries.map(([k, v]) => [k, Array.isArray(v) ? v.join(",") : String(v)])
  );
}
export async function normalizeLambdaOutgoingBody(body, headers) {
  if (typeof body === "string") {
    return { type: "text", body };
  }
  if (!body) {
    return { type: "text", body: "" };
  }
  const buffer = await _toBuffer(body);
  const contentType = headers["content-type"] || "";
  return isTextType(contentType) ? { type: "text", body: buffer.toString("utf8") } : { type: "binary", body: buffer.toString("base64") };
}
function _toBuffer(data) {
  if ("pipeTo" in data && typeof data.pipeTo === "function") {
    return new Promise((resolve, reject) => {
      const chunks = [];
      data.pipeTo(
        new WritableStream({
          write(chunk) {
            chunks.push(chunk);
          },
          close() {
            resolve(Buffer.concat(chunks));
          },
          abort(reason) {
            reject(reason);
          }
        })
      ).catch(reject);
    });
  }
  if ("pipe" in data && typeof data.pipe === "function") {
    return new Promise((resolve, reject) => {
      const chunks = [];
      data.on("data", (chunk) => {
        chunks.push(chunk);
      }).on("end", () => {
        resolve(Buffer.concat(chunks));
      }).on("error", reject);
    });
  }
  return Buffer.from(data);
}
const TEXT_TYPE_RE = /^text\/|\/(json|xml)|utf-?8/;
function isTextType(contentType = "") {
  return TEXT_TYPE_RE.test(contentType);
}
