import { c as cleanupNuxtDirs } from '../shared/nuxi.f51a69f9.mjs';
import { d as defineCommand } from '../shared/nuxi.9d864d83.mjs';
import { s as sharedArgs, l as legacyRootDirArgs, r as resolve } from '../shared/nuxi.3f4caf85.mjs';
import 'node:fs';
import 'node:util';
import 'node:path';
import 'node:process';
import 'node:tty';
import '../shared/nuxi.c6c42c8d.mjs';
import 'node:url';

const cleanup = defineCommand({
  meta: {
    name: "cleanup",
    description: "Cleanup generated nuxt files and caches"
  },
  args: {
    ...sharedArgs,
    ...legacyRootDirArgs
  },
  async run(ctx) {
    const cwd = resolve(ctx.args.cwd || ctx.args.rootDir || ".");
    await cleanupNuxtDirs(cwd);
  }
});

export { cleanup as default };
