import { d as defineCommand, c as consola } from '../shared/nuxi.9d864d83.mjs';
import 'node:util';
import 'node:path';
import 'node:process';
import 'node:tty';
import { l as loadKit, w as writeTypes } from '../shared/nuxi.bf5ca6d6.mjs';
import { a as clearBuildDir } from '../shared/nuxi.c6c42c8d.mjs';
import { s as sharedArgs, l as legacyRootDirArgs, r as resolve, a as relative } from '../shared/nuxi.3f4caf85.mjs';
import 'node:url';
import '../shared/nuxi.c0869f34.mjs';
import '../shared/nuxi.4456790d.mjs';
import 'node:module';
import 'node:fs';
import '../shared/nuxi.ae708cae.mjs';
import 'node:assert';
import 'node:v8';
import 'node:perf_hooks';
import '../shared/nuxi.a685c563.mjs';
import './satisfies.mjs';
import '../shared/nuxi.2155838d.mjs';
import '../shared/nuxi.cc8dd4a9.mjs';
import '../shared/nuxi.a3ec6487.mjs';
import 'crypto';
import 'fs';
import 'module';
import 'path';
import 'perf_hooks';
import 'os';
import 'vm';
import 'url';
import 'assert';
import 'process';
import 'v8';
import 'util';
import 'tty';
import 'stream';
import 'events';
import 'node:stream';
import '../shared/nuxi.d499a257.mjs';

const prepare = defineCommand({
  meta: {
    name: "prepare",
    description: "Prepare nuxt for development/build"
  },
  args: {
    ...sharedArgs,
    ...legacyRootDirArgs
  },
  async run(ctx) {
    process.env.NODE_ENV = process.env.NODE_ENV || "production";
    const cwd = resolve(ctx.args.cwd || ctx.args.rootDir || ".");
    const {
      loadNuxt,
      buildNuxt,
      writeTypes: writeTypes$1 = writeTypes
    } = await loadKit(cwd);
    const nuxt = await loadNuxt({
      rootDir: cwd,
      overrides: {
        _prepare: true,
        logLevel: ctx.args.logLevel,
        ...ctx.data?.overrides
      }
    });
    await clearBuildDir(nuxt.options.buildDir);
    await buildNuxt(nuxt);
    await writeTypes$1(nuxt);
    consola.success(
      "Types generated in",
      relative(process.cwd(), nuxt.options.buildDir)
    );
  }
});

export { prepare as default };
