import { existsSync, promises } from 'node:fs';
import { dirname, relative } from 'node:path';
import { execa } from './index3.mjs';
import { s as setupDotenv } from '../shared/nuxi.387694bc.mjs';
import { d as defineCommand, c as consola, e as box, b as colors } from '../shared/nuxi.9d864d83.mjs';
import 'node:util';
import 'node:process';
import 'node:tty';
import { l as loadKit } from '../shared/nuxi.bf5ca6d6.mjs';
import { s as sharedArgs, l as legacyRootDirArgs, r as resolve } from '../shared/nuxi.3f4caf85.mjs';
import 'node:buffer';
import 'node:child_process';
import '../shared/nuxi.d83de558.mjs';
import '../shared/nuxi.2155838d.mjs';
import 'child_process';
import 'path';
import 'fs';
import 'stream';
import 'node:url';
import 'node:os';
import 'node:timers/promises';
import 'os';
import 'crypto';
import 'node:fs/promises';
import 'module';
import 'perf_hooks';
import 'vm';
import 'url';
import 'assert';
import 'process';
import 'v8';
import 'util';
import 'tty';
import '../shared/nuxi.43704707.mjs';
import 'events';
import '../shared/nuxi.c0869f34.mjs';
import '../shared/nuxi.4456790d.mjs';
import 'node:module';
import '../shared/nuxi.ae708cae.mjs';
import 'node:assert';
import 'node:v8';
import 'node:perf_hooks';
import '../shared/nuxi.a685c563.mjs';
import './satisfies.mjs';
import '../shared/nuxi.cc8dd4a9.mjs';
import '../shared/nuxi.a3ec6487.mjs';
import 'node:stream';
import '../shared/nuxi.d499a257.mjs';

const preview = defineCommand({
  meta: {
    name: "preview",
    description: "Launches nitro server for local testing after `nuxi build`."
  },
  args: {
    ...sharedArgs,
    ...legacyRootDirArgs,
    dotenv: {
      type: "string",
      description: "Path to .env file"
    }
  },
  async run(ctx) {
    process.env.NODE_ENV = process.env.NODE_ENV || "production";
    const cwd = resolve(ctx.args.cwd || ctx.args.rootDir || ".");
    const { loadNuxtConfig } = await loadKit(cwd);
    const config = await loadNuxtConfig({
      cwd,
      overrides: (
        /*ctx.options?.overrides || */
        {}
      )
    });
    const resolvedOutputDir = resolve(
      config.srcDir || cwd,
      config.nitro.srcDir || "server",
      config.nitro.output?.dir || ".output",
      "nitro.json"
    );
    const defaultOutput = resolve(cwd, ".output", "nitro.json");
    const nitroJSONPaths = [resolvedOutputDir, defaultOutput];
    const nitroJSONPath = nitroJSONPaths.find((p) => existsSync(p));
    if (!nitroJSONPath) {
      consola.error(
        "Cannot find `nitro.json`. Did you run `nuxi build` first? Search path:\n",
        nitroJSONPaths
      );
      process.exit(1);
    }
    const outputPath = dirname(nitroJSONPath);
    const nitroJSON = JSON.parse(await promises.readFile(nitroJSONPath, "utf-8"));
    if (!nitroJSON.commands.preview) {
      consola.error("Preview is not supported for this build.");
      process.exit(1);
    }
    const info = [
      ["Node.js:", `v${process.versions.node}`],
      ["Nitro Preset:", nitroJSON.preset],
      ["Working directory:", relative(process.cwd(), outputPath)]
    ];
    const _infoKeyLen = Math.max(...info.map(([label]) => label.length));
    consola.log(
      box(
        [
          "You are running Nuxt production build in preview mode.",
          `For production deployments, please directly use ${colors.cyan(
            nitroJSON.commands.preview
          )} command.`,
          "",
          ...info.map(
            ([label, value]) => `${label.padEnd(_infoKeyLen, " ")} ${colors.cyan(value)}`
          )
        ].join("\n"),
        {
          title: colors.yellow("Preview Mode"),
          style: {
            borderColor: "yellow"
          }
        }
      )
    );
    const envExists = ctx.args.dotenv ? existsSync(resolve(cwd, ctx.args.dotenv)) : existsSync(cwd);
    if (envExists) {
      consola.info(
        "Loading `.env`. This will not be loaded when running the server in production."
      );
      await setupDotenv({ cwd, fileName: ctx.args.dotenv });
    }
    consola.info(`Starting preview command: \`${nitroJSON.commands.preview}\``);
    const [command, ...commandArgs] = nitroJSON.commands.preview.split(" ");
    consola.log("");
    await execa(command, commandArgs, { stdio: "inherit", cwd: outputPath });
  }
});

export { preview as default };
