import { g as gray, a as green, b as bold } from './nuxi.cb18516a.mjs';
import { t as tryRequireModule } from './nuxi.7484ed5e.mjs';

function showVersions(cwd) {
  const getPkgVersion = (pkg) => {
    return tryRequireModule(`${pkg}/package.json`, cwd)?.version || "";
  };
  const nuxtVersion = getPkgVersion("nuxt") || getPkgVersion("nuxt-edge");
  const nitroVersion = getPkgVersion("nitropack");
  console.log(
    gray(
      green(`Nuxt ${bold(nuxtVersion)}`) + (nitroVersion ? ` with Nitro ${bold(nitroVersion)}` : "")
    )
  );
}

export { showVersions as s };
