"use strict";
// Copyright 2021 Google LLC. Use of this source code is governed by an
// MIT-style license that can be found in the LICENSE file or at
// https://opensource.org/licenses/MIT.
Object.defineProperty(exports, "__esModule", { value: true });
exports.deprotofySourceSpan = void 0;
const url_1 = require("url");
const utils_1 = require("./utils");
// Creates a SourceSpan from the given protocol `buffer`. Throws if the buffer
// has invalid fields.
function deprotofySourceSpan(buffer) {
    const text = buffer.getText();
    if (buffer.getStart() === undefined) {
        throw (0, utils_1.compilerError)('Expected SourceSpan to have start.');
    }
    const start = deprotofySourceLocation(buffer.getStart());
    let end;
    if (buffer.getEnd() === undefined) {
        if (text !== '') {
            throw (0, utils_1.compilerError)('Expected SourceSpan text to be empty.');
        }
        else {
            end = start;
        }
    }
    else {
        end = deprotofySourceLocation(buffer.getEnd());
        if (end.offset < start.offset) {
            throw (0, utils_1.compilerError)('Expected SourceSpan end to be after start.');
        }
    }
    const url = buffer.getUrl() === '' ? undefined : new url_1.URL(buffer.getUrl());
    const context = buffer.getContext() === '' ? undefined : buffer.getContext();
    return {
        text,
        start,
        end,
        url,
        context,
    };
}
exports.deprotofySourceSpan = deprotofySourceSpan;
// Creates a SourceLocation from the given protocol `buffer`.
function deprotofySourceLocation(buffer) {
    return {
        offset: buffer.getOffset(),
        line: buffer.getLine(),
        column: buffer.getColumn(),
    };
}
//# sourceMappingURL=deprotofy-span.js.map