"use strict";
// Copyright 2020 Google Inc. Use of this source code is governed by an
// MIT-style license that can be found in the LICENSE file or at
// https://opensource.org/licenses/MIT.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Exception = void 0;
const deprotofy_span_1 = require("./deprotofy-span");
class Exception extends Error {
    constructor(failure) {
        super(failure.getFormatted());
        this.sassMessage = failure.getMessage();
        this.sassStack = failure.getStackTrace();
        this.span = (0, deprotofy_span_1.deprotofySourceSpan)(failure.getSpan());
    }
    toString() {
        return this.message;
    }
}
exports.Exception = Exception;
//# sourceMappingURL=exception.js.map