"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const yargs_1 = require("yargs");
const utils_1 = require("./utils");
const pkg = require("../package.json");
const argv = (0, yargs_1.default)(process.argv.slice(2))
    .option('package', {
    type: 'string',
    description: 'Directory name under `npm` directory that contains optional dependencies.',
    demandOption: true,
    choices: Object.keys(pkg.optionalDependencies).map(name => name.split('sass-embedded-')[1]),
})
    .parseSync();
(async () => {
    try {
        const [platform, arch] = argv.package.split('-');
        await (0, utils_1.getDartSassEmbedded)(`npm/${argv.package}`, (0, utils_1.nodePlatformToDartPlatform)(platform), (0, utils_1.nodeArchToDartArch)(arch));
    }
    catch (error) {
        console.error(error);
        process.exitCode = 1;
    }
})();
//# sourceMappingURL=prepare-optional-release.js.map