"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.webcrypto = exports.verify = exports.timingSafeEqual = exports.sign = exports.setFips = exports.setEngine = exports.secureHeapUsed = exports.scryptSync = exports.scrypt = exports.randomInt = exports.randomFillSync = exports.randomFill = exports.randomBytes = exports.publicEncrypt = exports.publicDecrypt = exports.pseudoRandomBytes = exports.privateEncrypt = exports.privateDecrypt = exports.pbkdf2Sync = exports.pbkdf2 = exports.hkdfSync = exports.hkdf = exports.getHashes = exports.getFips = exports.getDiffieHellman = exports.getCurves = exports.getCiphers = exports.getCipherInfo = exports.generatePrimeSync = exports.generatePrime = exports.generateKeySync = exports.generateKeyPairSync = exports.generateKeyPair = exports.generateKey = exports.fips = exports.diffieHellman = exports.createVerify = exports.createSign = exports.createSecretKey = exports.createPublicKey = exports.createPrivateKey = exports.createHmac = exports.createHash = exports.createECDH = exports.createDiffieHellmanGroup = exports.createDiffieHellman = exports.createDecipheriv = exports.createDecipher = exports.createCipheriv = exports.createCipher = exports.constants = exports.checkPrimeSync = exports.checkPrime = exports.X509Certificate = exports.Verify = exports.Sign = exports.KeyObject = exports.Hmac = exports.Hash = exports.ECDH = exports.DiffieHellmanGroup = exports.DiffieHellman = exports.Decipheriv = exports.Decipher = exports.Cipheriv = exports.Cipher = exports.Certificate = void 0;
var _utils = require("../../_internal/utils.cjs");
var _web = require("./web.cjs");
const MAX_RANDOM_VALUE_BYTES = 65536;
const webcrypto = new Proxy(globalThis.crypto, {
  get(_, key) {
    if (key === "CryptoKey") {
      return globalThis.CryptoKey;
    }
    if (typeof globalThis.crypto[key] === "function") {
      return globalThis.crypto[key].bind(globalThis.crypto);
    }
    return globalThis.crypto[key];
  }
});
exports.webcrypto = webcrypto;
const randomBytes = (size, cb) => {
  const bytes = Buffer.alloc(size, 0, void 0);
  for (let generated = 0; generated < size; generated += MAX_RANDOM_VALUE_BYTES) {
    (0, _web.getRandomValues)(Uint8Array.prototype.slice.call(bytes, generated, generated + MAX_RANDOM_VALUE_BYTES));
  }
  if (typeof cb === "function") {
    cb(null, bytes);
    return void 0;
  }
  return bytes;
};
exports.randomBytes = randomBytes;
const fips = false;
exports.fips = fips;
const constants = {};
exports.constants = constants;
const checkPrime = (0, _utils.notImplemented)("crypto.checkPrime");
exports.checkPrime = checkPrime;
const checkPrimeSync = (0, _utils.notImplemented)("crypto.checkPrimeSync");
exports.checkPrimeSync = checkPrimeSync;
const createCipher = (0, _utils.notImplemented)("crypto.createCipher");
exports.createCipher = createCipher;
const createDecipher = (0, _utils.notImplemented)("crypto.createDecipher");
exports.createDecipher = createDecipher;
const pseudoRandomBytes = (0, _utils.notImplemented)("crypto.pseudoRandomBytes");
exports.pseudoRandomBytes = pseudoRandomBytes;
const createCipheriv = (0, _utils.notImplemented)("crypto.createCipheriv");
exports.createCipheriv = createCipheriv;
const createDecipheriv = (0, _utils.notImplemented)("crypto.createDecipheriv");
exports.createDecipheriv = createDecipheriv;
const createDiffieHellman = (0, _utils.notImplemented)("crypto.createDiffieHellman");
exports.createDiffieHellman = createDiffieHellman;
const createDiffieHellmanGroup = (0, _utils.notImplemented)("crypto.createDiffieHellmanGroup");
exports.createDiffieHellmanGroup = createDiffieHellmanGroup;
const createECDH = (0, _utils.notImplemented)("crypto.createECDH");
exports.createECDH = createECDH;
const createHash = (0, _utils.notImplemented)("crypto.createHash");
exports.createHash = createHash;
const createHmac = (0, _utils.notImplemented)("crypto.createHmac");
exports.createHmac = createHmac;
const createPrivateKey = (0, _utils.notImplemented)("crypto.createPrivateKey");
exports.createPrivateKey = createPrivateKey;
const createPublicKey = (0, _utils.notImplemented)("crypto.createPublicKey");
exports.createPublicKey = createPublicKey;
const createSecretKey = (0, _utils.notImplemented)("crypto.createSecretKey");
exports.createSecretKey = createSecretKey;
const createSign = (0, _utils.notImplemented)("crypto.createSign");
exports.createSign = createSign;
const createVerify = (0, _utils.notImplemented)("crypto.createVerify");
exports.createVerify = createVerify;
const diffieHellman = (0, _utils.notImplemented)("crypto.diffieHellman");
exports.diffieHellman = diffieHellman;
const generatePrime = (0, _utils.notImplemented)("crypto.generatePrime");
exports.generatePrime = generatePrime;
const generatePrimeSync = (0, _utils.notImplemented)("crypto.generatePrimeSync");
exports.generatePrimeSync = generatePrimeSync;
const getCiphers = (0, _utils.notImplemented)("crypto.getCiphers");
exports.getCiphers = getCiphers;
const getCipherInfo = (0, _utils.notImplemented)("crypto.getCipherInfo");
exports.getCipherInfo = getCipherInfo;
const getCurves = (0, _utils.notImplemented)("crypto.getCurves");
exports.getCurves = getCurves;
const getDiffieHellman = (0, _utils.notImplemented)("crypto.getDiffieHellman");
exports.getDiffieHellman = getDiffieHellman;
const getHashes = (0, _utils.notImplemented)("crypto.getHashes");
exports.getHashes = getHashes;
const hkdf = (0, _utils.notImplemented)("crypto.hkdf");
exports.hkdf = hkdf;
const hkdfSync = (0, _utils.notImplemented)("crypto.hkdfSync");
exports.hkdfSync = hkdfSync;
const pbkdf2 = (0, _utils.notImplemented)("crypto.pbkdf2");
exports.pbkdf2 = pbkdf2;
const pbkdf2Sync = (0, _utils.notImplemented)("crypto.pbkdf2Sync");
exports.pbkdf2Sync = pbkdf2Sync;
const generateKeyPair = (0, _utils.notImplemented)("crypto.generateKeyPair");
exports.generateKeyPair = generateKeyPair;
const generateKeyPairSync = (0, _utils.notImplemented)("crypto.generateKeyPairSync");
exports.generateKeyPairSync = generateKeyPairSync;
const generateKey = (0, _utils.notImplemented)("crypto.generateKey");
exports.generateKey = generateKey;
const generateKeySync = (0, _utils.notImplemented)("crypto.generateKeySync");
exports.generateKeySync = generateKeySync;
const privateDecrypt = (0, _utils.notImplemented)("crypto.privateDecrypt");
exports.privateDecrypt = privateDecrypt;
const privateEncrypt = (0, _utils.notImplemented)("crypto.privateEncrypt");
exports.privateEncrypt = privateEncrypt;
const publicDecrypt = (0, _utils.notImplemented)("crypto.publicDecrypt");
exports.publicDecrypt = publicDecrypt;
const publicEncrypt = (0, _utils.notImplemented)("crypto.publicEncrypt");
exports.publicEncrypt = publicEncrypt;
const randomFill = (0, _utils.notImplemented)("crypto.randomFill");
exports.randomFill = randomFill;
const randomFillSync = (0, _utils.notImplemented)("crypto.randomFillSync");
exports.randomFillSync = randomFillSync;
const randomInt = (0, _utils.notImplemented)("crypto.randomInt");
exports.randomInt = randomInt;
const scrypt = (0, _utils.notImplemented)("crypto.scrypt");
exports.scrypt = scrypt;
const scryptSync = (0, _utils.notImplemented)("crypto.scryptSync");
exports.scryptSync = scryptSync;
const sign = (0, _utils.notImplemented)("crypto.sign");
exports.sign = sign;
const setEngine = (0, _utils.notImplemented)("crypto.setEngine");
exports.setEngine = setEngine;
const timingSafeEqual = (0, _utils.notImplemented)("crypto.timingSafeEqual");
exports.timingSafeEqual = timingSafeEqual;
const getFips = (0, _utils.notImplemented)("crypto.getFips");
exports.getFips = getFips;
const setFips = (0, _utils.notImplemented)("crypto.setFips");
exports.setFips = setFips;
const verify = (0, _utils.notImplemented)("crypto.verify");
exports.verify = verify;
const secureHeapUsed = (0, _utils.notImplemented)("crypto.secureHeapUsed");
exports.secureHeapUsed = secureHeapUsed;
const Certificate = (0, _utils.notImplementedClass)("crypto.Certificate");
exports.Certificate = Certificate;
const Cipher = (0, _utils.notImplementedClass)("crypto.Cipher");
exports.Cipher = Cipher;
const Cipheriv = (0, _utils.notImplementedClass)("crypto.Cipheriv"
// @ts-expect-error not typed yet
);
exports.Cipheriv = Cipheriv;
const Decipher = (0, _utils.notImplementedClass)("crypto.Decipher");
exports.Decipher = Decipher;
const Decipheriv = (0, _utils.notImplementedClass)("crypto.Decipheriv"
// @ts-expect-error not typed yet
);
exports.Decipheriv = Decipheriv;
const DiffieHellman = (0, _utils.notImplementedClass)("crypto.DiffieHellman");
exports.DiffieHellman = DiffieHellman;
const DiffieHellmanGroup = (0, _utils.notImplementedClass)("crypto.DiffieHellmanGroup");
exports.DiffieHellmanGroup = DiffieHellmanGroup;
const ECDH = (0, _utils.notImplementedClass)("crypto.ECDH");
exports.ECDH = ECDH;
const Hash = (0, _utils.notImplementedClass)("crypto.Hash");
exports.Hash = Hash;
const Hmac = (0, _utils.notImplementedClass)("crypto.Hmac");
exports.Hmac = Hmac;
const KeyObject = (0, _utils.notImplementedClass)("crypto.KeyObject");
exports.KeyObject = KeyObject;
const Sign = (0, _utils.notImplementedClass)("crypto.Sign");
exports.Sign = Sign;
const Verify = (0, _utils.notImplementedClass)("crypto.Verify");
exports.Verify = Verify;
const X509Certificate = (0, _utils.notImplementedClass)("crypto.X509Certificate");
exports.X509Certificate = X509Certificate;