"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Server = exports.BlockList = void 0;
Object.defineProperty(exports, "Socket", {
  enumerable: true,
  get: function () {
    return _socket.Socket;
  }
});
Object.defineProperty(exports, "SocketAddress", {
  enumerable: true,
  get: function () {
    return _socket.SocketAddress;
  }
});
exports.isIPv6 = exports.isIPv4 = exports.isIP = exports.exports = exports.default = exports.createServer = exports.createConnection = exports.connect = void 0;
var _utils = require("../../_internal/utils.cjs");
var _socket = require("./socket.cjs");
const createServer = (0, _utils.notImplemented)("net.createServer");
exports.createServer = createServer;
const Server = (0, _utils.notImplementedClass)("net.Server");
exports.Server = Server;
const BlockList = (0, _utils.notImplementedClass)("net.BlockList");
exports.BlockList = BlockList;
const connect = (0, _utils.notImplemented)("net.connect");
exports.connect = connect;
const createConnection = (0, _utils.notImplemented)("net.createConnection");
exports.createConnection = createConnection;
const IPV4Regex = /^(?:\d{1,3}\.){3}\d{1,3}$/;
const isIPv4 = host => IPV4Regex.test(host);
exports.isIPv4 = isIPv4;
const IPV6Regex = /^([\dA-Fa-f]{1,4}:){7}[\dA-Fa-f]{1,4}$/;
const isIPv6 = host => IPV6Regex.test(host);
exports.isIPv6 = isIPv6;
const isIP = host => {
  if (isIPv4(host)) {
    return 4;
  }
  if (isIPv6(host)) {
    return 6;
  }
  return 0;
};
exports.isIP = isIP;
const _exports = {
  Socket: _socket.Socket,
  // TODO
  Server,
  BlockList,
  SocketAddress: _socket.SocketAddress,
  createServer,
  connect,
  createConnection,
  isIPv4,
  isIPv6,
  isIP
};
exports.exports = _exports;
var _default = _exports;
module.exports = _default;