import * as _unhead_schema from '@unhead/schema';
import { Head, CreateHeadOptions, Unhead, HeadEntryOptions, ActiveHeadEntry, HeadSafe, UseSeoMetaInput } from '@unhead/schema';
export { composableNames } from '@unhead/shared';

declare function createHead<T extends {} = Head>(options?: CreateHeadOptions): Unhead<T>;
declare function createServerHead<T extends {} = Head>(options?: CreateHeadOptions): Unhead<T>;
/**
 * Creates a core instance of unhead. Does not provide a global ctx for composables to work
 * and does not register DOM plugins.
 *
 * @param options
 */
declare function createHeadCore<T extends {} = Head>(options?: CreateHeadOptions): Unhead<T>;

/**
 * @deprecated Hash hydration is no longer supported. Please remove this plugin.
 */
declare function HashHydrationPlugin(): _unhead_schema.HeadPlugin;

declare function CapoPlugin(options: {
    track?: boolean;
}): _unhead_schema.HeadPlugin;

declare const unheadComposablesImports: {
    from: string;
    imports: string[];
}[];

declare function getActiveHead(): _unhead_schema.Unhead<any> | undefined;

declare function useHead<T extends Head>(input: T, options?: HeadEntryOptions): ActiveHeadEntry<T> | void;

declare function useHeadSafe(input: HeadSafe, options?: HeadEntryOptions): ActiveHeadEntry<HeadSafe> | void;

declare function useServerHead<T extends Head>(input: T, options?: HeadEntryOptions): ActiveHeadEntry<T> | void;

declare function useServerHeadSafe<T extends HeadSafe>(input: T, options?: HeadEntryOptions): ActiveHeadEntry<T> | void;

declare function useSeoMeta(input: UseSeoMetaInput, options?: HeadEntryOptions): ActiveHeadEntry<any> | void;

declare function useServerSeoMeta(input: UseSeoMetaInput, options?: HeadEntryOptions): ActiveHeadEntry<any> | void;

export { CapoPlugin, HashHydrationPlugin, createHead, createHeadCore, createServerHead, getActiveHead, unheadComposablesImports, useHead, useHeadSafe, useSeoMeta, useServerHead, useServerHeadSafe, useServerSeoMeta };
