declare module 'vue-router/auto/routes' {
  import type { RouteRecordRaw } from 'vue-router'
  export const routes: RouteRecordRaw[]
}

declare module 'vue-router/auto' {
  import type { RouterOptions, Router, RouteRecordRaw } from 'vue-router'
  export * from 'vue-router'

  /**
   * unplugin-vue-router version of `RouterOptions`.
   */
  export interface _RouterOptions extends Omit<RouterOptions, 'routes'> {
    /**
     * Allows modifying the routes before they are passed to the router. You can modify the existing array or return a
     * new one.
     *
     * @param routes - The routes generated by this plugin and exposed by `vue-router/auto/routes`
     */
    extendRoutes?: (routes: RouteRecordRaw[]) => RouteRecordRaw[] | void
  }
  export function createRouter(options: _RouterOptions): Router
}
