<!-- markdownlint-disable-next-line -->
<img width="300" src="media/logo.svg" alt="Vue-USWDS logo">

# Vue USWDS

[![Tests](https://github.com/patrickcate/vue-uswds/actions/workflows/tests.yml/badge.svg)](https://github.com/patrickcate/vue-uswds/actions/workflows/tests.yml) [![Docs](https://github.com/patrickcate/vue-uswds/actions/workflows/docs.yml/badge.svg)](https://github.com/patrickcate/vue-uswds/actions/workflows/docs.yml) [![codecov](https://codecov.io/gh/patrickcate/vue-uswds/branch/develop/graph/badge.svg?token=3R49R79IKK)](https://codecov.io/gh/patrickcate/vue-uswds) ![GitHub package.json dependency version (dev dep on branch)](https://img.shields.io/github/package-json/dependency-version/patrickcate/vue-uswds/dev/@uswds/uswds) [![semantic-release](https://img.shields.io/badge/semantic--release-e10079?logo=semantic-release&labelColor=494949&color=d90f7c)](https://github.com/semantic-release/semantic-release)

A Vue 3 implementation of the [USWDS](https://designsystem.digital.gov). If you need Vue 2 support, check out the [USWDS-Vue](https://github.com/thepipster/uswds-vue) library.

## [Documentation](https://patrickcate.github.io/vue-uswds/)

## Installation

**Note:** You will need to install the [USWDS](https://designsystem.digital.gov) CSS separately.

Vue USWDS can be installed either by including it with a simple `script` tag or using NPM and a build system.

### Script Tag

The easiest way to include the library with a script tag is to use a CDN such as [jsDelivr](https://www.jsdelivr.com) or [unpkg](https://unpkg.com). You can also load the library locally on your server.

When using with a script tag all components will be imported.

```html
<script src="https://unpkg.com/vue@3"></script>
<script src="https://unpkg.com/vue-uswds"></script>
```

### NPM (Node Package Manager)

```shell
npm install vue-uswds

// or

yarn install vue-uswds
```

## Usage

When importing the library via NPM you can import all components or use the _À La Carte_ method to import only specific components. The _À La Carte_ method makes it easier to reduce the final bundle size of your application by only including components you are using.

### All Components

```javascript
import Vue from 'vue'
import VueUswds from 'vue-uswds'

const app = Vue.createApp({})

app.use(VueUswds, {
  // ...options
})

app.mount('#app')
```

### À La Carte

```javascript
// App.vue
import Vue from 'vue'
import VueUswds/core from 'vue-uswds' // Import only the core library.

const app = Vue.createApp({})

app.use(VueUswds, {
  // ...options
})

app.mount('#app')
```

```js
// MyComponent.vue
<script>
import { UsaTag } from 'vue-uswds'

export default {
  components: { UsaTag },
}
</script>

<template>
  <UsaTag>My Custom Tag</UsaTag>
</template>
```

If there are components you wish to use anywhere in your app without first importing them, you can register them globally.

```javascript
// App.vue
import Vue from 'vue'
import VueUswds/core from 'vue-uswds' // Import only the core library.
import { UsaTag } from 'vue-uswds'

const app = Vue.createApp({})

app.use(VueUswds, {
  // ...options
})

// Register any global components...
app.component('UsaTag', UsaTag)

app.mount('#app')
```

## Recommended IDE Setup

- [VSCode](https://code.visualstudio.com)
- [Volar](https://marketplace.visualstudio.com/items?itemName=vue.volar)

## Contributing Guidelines

- Create an issue for any bugs or feature requests before doing any work.
- This project follows [Conventional Commits](https://www.conventionalcommits.org) naming conventions for all git commits.
  - The git commit format can be easily generated by running `npm run commit` which will use [Comittizen](https://github.com/commitizen/cz-cli) to walk you through the formatting options of your commit.
- This project uses `npm`, not `yarn` or `pnpm`.
- [Prettier](https://prettier.io) and [ESLint](https://eslint.org) are run as pre-commit hooks to help maintain a consistent code style. They are also run with any PR's submitted.
- [Cypress](https://www.cypress.io) is used for all component tests.
  - _All components must have tests_.
  - Cypress can be run locally, but will also run with all PR's.
  - Tests must pass in order for PR's to be merged.
  - See the "Tests" section of this README for commands to run tests locally.
- [Storybook](https://storybook.js.org/) is used for documentation.
  - _All components must have a story_.
  - You can preview Storybook locally by running `npm run storybook`.
- Vue's [composition API](https://vuejs.org/guide/introduction.html#composition-api) is preferred over the [options API](https://vuejs.org/guide/introduction.html#options-api).

## Testing Github Actions Locally

Use [act](https://github.com/nektos/act) to test Github actions locally.

**Note:** Because the [act](https://github.com/nektos/act) docker containers do not have the XVFB dependency installed, you must use a custom docker container from Cypress by adding:

```yaml
container:
  image: cypress/browsers:node14.17.0-chrome91-ff89
```

The specific container can be one of [Cypress's docker images](https://github.com/cypress-io/cypress-docker-images).

You may also need to temporarily adjust the node matrix versions to use the provided by the Cypress container.

# Tests

Specific Cypress component tests:

```shell
node_modules/.bin/cypress run-ct  --spec="src/components/UsaDatePickerCalendar/UsaDatePickerCalendar.test.js" --headed --no-exit
```

All Cypress component tests headless:

```shell
npm run test:component
```

Headed Cypress interactive component tests:

```shell
npm run cypress:open-ct
```
