var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
import { getCurrentInstance } from "vue";
const version = "1.3.0";
var stringKebabCase = kebabCase$1;
var wordSeparators = /[\s\u2000-\u206F\u2E00-\u2E7F\\'!"#$%&()*+,\-.\/:;<=>?@\[\]^_`{|}~]+/;
var capital_plus_lower = /[A-ZÀ-Ý\u00C0-\u00D6\u00D9-\u00DD][a-zà-ÿ]/g;
var capitals = /[A-ZÀ-Ý\u00C0-\u00D6\u00D9-\u00DD]+/g;
function kebabCase$1(str) {
  str = str.replace(capital_plus_lower, function(match) {
    return " " + (match[0].toLowerCase() || match[0]) + match[1];
  });
  str = str.replace(capitals, function(match) {
    return " " + match.toLowerCase();
  });
  return str.trim().split(wordSeparators).join("-").replace(/^-/, "").replace(/-\s*$/, "");
}
const kebabCase = (value) => stringKebabCase(value);
const idPrefix = "vuswds-id-";
const idRegistry = {};
function nextId(componentName = "") {
  var _a;
  const vm = getCurrentInstance();
  const route = (_a = vm.appContext.config.globalProperties) == null ? void 0 : _a.$route;
  const pathPrefix = (route == null ? void 0 : route.path) ? kebabCase(route.path) : "global";
  if (!idRegistry[pathPrefix]) {
    idRegistry[pathPrefix] = 0;
  }
  return `${idPrefix}${pathPrefix}-${kebabCase(componentName)}-${++idRegistry[pathPrefix]}`;
}
const PREFIX_SEPARATOR = ":";
const GRID_NAMESPACE = "grid-";
const UTILITY_NAMESPACE = "u-";
const IMAGE_PATH = "/assets/img";
const SVG_SPRITE_PATH = "/assets/img/sprite.svg";
const ROUTER_COMPONENT_NAME = null;
const MOBILE_MENU_BREAKPOINT = "64em";
const FOOTER_NAV_COLLAPSIBLE_BREAKPOINT = "30em";
var core = {
  install: (app, options) => {
    const customOptions = options || {};
    const vueUswdsOptions = __spreadProps(__spreadValues({
      prefixSeparator: PREFIX_SEPARATOR,
      gridNamespace: GRID_NAMESPACE,
      utilityNamespace: UTILITY_NAMESPACE,
      imagePath: IMAGE_PATH,
      svgSpritePath: SVG_SPRITE_PATH,
      routerComponentName: ROUTER_COMPONENT_NAME,
      mobileMenuBreakpoint: MOBILE_MENU_BREAKPOINT,
      footerNavBigBreakpoint: FOOTER_NAV_COLLAPSIBLE_BREAKPOINT
    }, customOptions), {
      version
    });
    if (!app.config.globalProperties.$vueUswds) {
      app.config.globalProperties.$vueUswds = vueUswdsOptions;
    }
    app.provide("vueUswds", vueUswdsOptions);
    app.provide("nextId", nextId);
  }
};
export { core as default };
//# sourceMappingURL=vue-uswds.core.es.js.map
