# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from ..core.pydantic_utilities import pydantic_v1
from .message import Message
from .summary import Summary


class Memory(pydantic_v1.BaseModel):
    facts: typing.Optional[typing.List[str]] = pydantic_v1.Field(default=None)
    """
    Most recent list of facts derived from the session. Included only with perpetual memory type.
    """

    messages: typing.Optional[typing.List[Message]] = pydantic_v1.Field(default=None)
    """
    A list of message objects, where each message contains a role and content.
    """

    metadata: typing.Optional[typing.Dict[str, typing.Any]] = pydantic_v1.Field(default=None)
    """
    A dictionary containing metadata associated with the memory.
    """

    summary: typing.Optional[Summary] = pydantic_v1.Field(default=None)
    """
    A Summary object.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
