# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from ..core.pydantic_utilities import pydantic_v1


class Summary(pydantic_v1.BaseModel):
    content: typing.Optional[str] = pydantic_v1.Field(default=None)
    """
    The content of the summary.
    """

    created_at: typing.Optional[str] = pydantic_v1.Field(default=None)
    """
    The timestamp of when the summary was created.
    """

    metadata: typing.Optional[typing.Dict[str, typing.Any]] = None
    related_message_uuids: typing.Optional[typing.List[str]] = None
    token_count: typing.Optional[int] = pydantic_v1.Field(default=None)
    """
    The number of tokens in the summary.
    """

    uuid_: typing.Optional[str] = pydantic_v1.Field(alias="uuid", default=None)
    """
    The unique identifier of the summary.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
