"use strict";
const lib_1 = require("../lib");
const util_1 = require("./util");
const template = {
    Parameters: {
        MyParam: {
            Type: 'String',
            Default: 'Hello'
        }
    },
    Resources: {
        MyResource1: {
            Type: 'ResourceType1',
            Properties: {
                P1: 1,
                P2: 2,
            }
        },
        MyResource2: {
            Type: 'ResourceType2'
        }
    }
};
/**
 * @param obj an object to clone
 * @returns a deep clone of ``obj`.
 */
function clone(obj) {
    switch (typeof obj) {
        case 'object':
            if (Array.isArray(obj)) {
                return obj.map(elt => clone(elt));
            }
            else {
                const cloned = {};
                for (const key of Object.keys(obj)) {
                    cloned[key] = clone(obj[key]);
                }
                return cloned;
            }
        default:
            return obj;
    }
}
module.exports = {
    'the Include construct can be used to embed an existing template as-is into a stack'(test) {
        const stack = new lib_1.Stack();
        new lib_1.CfnInclude(stack, 'T1', { template: clone(template) });
        test.deepEqual(util_1.toCloudFormation(stack), {
            Parameters: { MyParam: { Type: 'String', Default: 'Hello' } },
            Resources: {
                MyResource1: { Type: 'ResourceType1', Properties: { P1: 1, P2: 2 } },
                MyResource2: { Type: 'ResourceType2' }
            }
        });
        test.done();
    },
    'included templates can co-exist with elements created programmatically'(test) {
        const stack = new lib_1.Stack();
        new lib_1.CfnInclude(stack, 'T1', { template: clone(template) });
        new lib_1.CfnResource(stack, 'MyResource3', { type: 'ResourceType3', properties: { P3: 'Hello' } });
        new lib_1.CfnOutput(stack, 'MyOutput', { description: 'Out!', value: 'hey' });
        new lib_1.CfnParameter(stack, 'MyParam2', { type: 'Integer' });
        test.deepEqual(util_1.toCloudFormation(stack), {
            Parameters: {
                MyParam: { Type: 'String', Default: 'Hello' },
                MyParam2: { Type: 'Integer' }
            },
            Resources: {
                MyResource1: { Type: 'ResourceType1', Properties: { P1: 1, P2: 2 } },
                MyResource2: { Type: 'ResourceType2' },
                MyResource3: { Type: 'ResourceType3', Properties: { P3: 'Hello' } }
            },
            Outputs: {
                MyOutput: { Description: 'Out!', Value: 'hey' }
            }
        });
        test.done();
    },
    'exception is thrown in construction if an entity from an included template has the same id as a programmatic entity'(test) {
        const stack = new lib_1.Stack();
        new lib_1.CfnInclude(stack, 'T1', { template });
        new lib_1.CfnResource(stack, 'MyResource3', { type: 'ResourceType3', properties: { P3: 'Hello' } });
        new lib_1.CfnOutput(stack, 'MyOutput', { description: 'Out!', value: 'in' });
        new lib_1.CfnParameter(stack, 'MyParam', { type: 'Integer' }); // duplicate!
        test.throws(() => util_1.toCloudFormation(stack));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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