# ruff: noqa: E501, F401

from enum import Enum
from typing import Any, NamedTuple, Optional, Sequence, MutableSequence, Type, TypeVar
from typing_extensions import Literal, Required, TypedDict
from pydantic import BaseModel

T = TypeVar("T", bound=BaseModel)

class ImageFragment(TypedDict, total=False):
    type: Required[Literal["image"]]
    url: Required[str]

class TextFragment(TypedDict, total=False):
    type: Required[Literal["text"]]
    text: Required[str]

Fragment = ImageFragment | TextFragment

class EvalSample:
    interaction: EvalSampleInteraction
    grades: MutableSequence[Grade]
    dataset_key: str
    id: str
    def __new__(
        cls, interaction: EvalSampleInteraction, grades: MutableSequence[Grade], dataset_key: str
    ) -> EvalSample: ...
    def __repr__(self) -> str: ...

class EvalSampleInteraction:
    thread: StringThread
    source: Optional[str]
    def __new__(cls, thread: StringThread, source: Optional[str] = None) -> EvalSampleInteraction: ...
    def __repr__(self) -> str: ...

class EvaluationArtifactBase:
    artifact: JobArtifact
    id: str
    name: str
    kind: str
    uri: Optional[str]
    def __new__(cls, name: str, uri: str, id: str, **py_kwargs) -> EvaluationArtifactBase: ...
    def samples_to_adaptive_json(self, samples: MutableSequence[EvalSample]) -> list[str]: ...
    def __repr__(self) -> str: ...

class Grade:
    value: float
    grader_key: str
    reasoning: Optional[str]
    def __new__(cls, value: float, grader_key: str, reasoning: Optional[str] = None) -> Grade: ...
    def __repr__(self) -> str: ...

class JobArtifact:
    id: str
    name: str
    kind: str
    uri: Optional[str]
    def __new__(
        cls,
        id: str,
        name: str,
        kind: str,
        uri: Optional[str] = None,
        **py_kwargs,
    ) -> JobArtifact: ...
    def __repr__(self) -> str: ...

class StringTurn(NamedTuple):
    role: str
    content: str

class TokenizedTurn(NamedTuple):
    role: str
    content: list[int]

class HarmonyClient:
    def model(self, path: str, kv_cache_len: int = 131072, tokens_to_generate: int = 2048) -> ModelBuilder: ...
    def session_id(self) -> str: ...

class InferenceModel:
    def is_scalar(self) -> bool: ...
    async def dealloc(self) -> None: ...
    async def generate(self, thread: StringThread) -> StringThread: ...
    async def generate_tokens(self, thread: StringThread) -> TokenizedThread: ...
    async def generate_and_validate(
        self, thread: StringThread, pydantic_model: Type[T], max_parsing_retries: int = 1
    ) -> tuple[str, T]: ...
    async def tokenize_thread(self, thread: StringThread) -> TokenizedThread: ...
    async def detokenize_thread(self, thread: TokenizedThread) -> StringThread: ...
    async def serialize_thread(self, thread: StringThread) -> tuple[list[int], list[float]]: ...
    async def serialize_tokenized_thread(self, thread: TokenizedThread) -> tuple[list[int], list[float]]: ...
    async def logprobs(self, thread: StringThread) -> float: ...
    async def logprobs_per_token(self, thread: TokenizedThread) -> list[float]: ...
    async def score(self, thread: TokenizedThread) -> list[float]: ...
    async def score_last_token(self, thread: StringThread) -> float: ...
    async def raw_string_create(self, prompt: str) -> str: ...
    async def raw_token_create(self, prompt: Sequence[int]) -> list[int]: ...
    async def tokenize(self, data: str) -> list[int]: ...
    async def detokenize(self, data: Sequence[int]) -> str: ...
    async def char_to_token_rewards(self, text: str, char_rewards: Sequence[float]) -> list[float]: ...
    async def raw_logprobs(self, tokens: Sequence[int]) -> list[float]: ...
    @staticmethod
    def render_schema(pydantic_model: type[BaseModel], with_field_descriptions: bool = True) -> str: ...
    @staticmethod
    def render_pydantic_model(pydantic_model: BaseModel) -> str: ...
    def get_builder_args(self) -> dict[str, Any]: ...
    def top_p(self, top_p: float) -> InferenceModel: ...
    def temperature(self, temperature: float) -> InferenceModel: ...
    def max_gen_len(self, max_num_tokens: int) -> InferenceModel: ...

class InferenceSettings:
    def __new__(cls, kv_cache_len: int, tokens_to_generate: int) -> InferenceSettings: ...
    def to_python_dict(self) -> dict[str, Any]: ...

class ModelBuilder:
    async def spawn_train(self, name: str, max_batch_size: int) -> TrainingModel: ...
    async def spawn_inference(self, name: str) -> InferenceModel: ...
    def tp(self, tp: int) -> ModelBuilder: ...
    def api_key(self, api_key: str) -> ModelBuilder: ...
    def into_scoring_model(self) -> ModelBuilder: ...
    def with_adapter(self) -> ModelBuilder: ...
    def to_python_dict(self) -> dict[str, Any]: ...
    def extra_params(self, **params) -> ModelBuilder: ...

class SerializedThread: ...

class StatDuration:
    duration_sec: float
    num_input_tokens: int
    num_output_tokens: int
    num_trained_tokens: int
    num_input_tokens_per_s: float
    num_output_tokens_per_s: float
    num_trained_tokens_per_s: float
    def combine(self, other: StatDuration) -> StatDuration: ...

class StatInstant:
    def stats_since(self, other: StatInstant) -> StatDuration: ...

class StringThread:
    metadata: Any
    def __new__(cls, turns: Optional[Sequence[tuple[str, str]]] = None) -> StringThread: ...
    @staticmethod
    async def from_fragments(raw_turns: Sequence[tuple[str, Sequence[Fragment]]], metadata: Any) -> StringThread: ...
    @classmethod
    def with_metadata(cls, turns: Sequence[tuple[str, str]], metadata: Any) -> StringThread: ...
    def user(self, content: str) -> StringThread: ...
    def system(self, content: str) -> StringThread: ...
    def assistant(self, content: str) -> StringThread: ...
    def last_content(self) -> str: ...
    def get_turns(self) -> list[StringTurn]: ...
    def get_fragments(self) -> list[tuple[str, list[Fragment]]]: ...
    @staticmethod
    def from_json(json_str) -> StringThread: ...
    def to_json(self) -> str: ...
    def with_weight_all_assistant_turns(self) -> StringThread: ...
    def with_weight_last_assistant_turn(self) -> StringThread: ...
    def uuid(self) -> str | None: ...
    def __repr__(self) -> str: ...

class TokenizedThread:
    metadata: Any
    def __new__(cls, turns: Optional[Sequence[tuple[str, Sequence[int]]]] = None) -> TokenizedThread: ...
    @classmethod
    def with_metadata(
        cls,
        turns: Sequence[tuple[str, Sequence[int]]],
        metadata: Any,
    ) -> TokenizedThread: ...
    def user(self, content: Sequence[int]) -> TokenizedThread: ...
    def assistant(self, content: Sequence[int]) -> TokenizedThread: ...
    def last_content(self) -> Optional[list[int]]: ...
    def len_last_turn(self) -> int: ...
    def get_turns(self) -> list[TokenizedTurn]: ...
    def with_weight_all_assistant_turns(self) -> TokenizedThread: ...
    def with_weight_last_assistant_turn(self) -> TokenizedThread: ...
    def uuid(self) -> str | None: ...
    def __repr__(self) -> str: ...

class TrainingModel(InferenceModel):
    async def clone_inf(self) -> InferenceModel: ...
    def get_builder_args(self) -> dict[str, Any]: ...
    async def optim_step(self, lr: float, wd: float, max_grad_norm: float) -> dict[str, float]: ...
    async def save(self, model_name: str) -> None: ...
    def inf(self) -> InferenceModel: ...
    async def train_language_modelling(self, thread: StringThread) -> None: ...
    async def train_ppo(
        self,
        thread: TokenizedThread,
        trajectory_logprobs: Sequence[float],
        advantages: Sequence[float],
        clip_range: float,
    ) -> None: ...
    async def train_grpo(
        self,
        thread: TokenizedThread,
        trajectory_logprobs: Sequence[float],
        reference_logprobs: Sequence[float],
        advantages: Sequence[float],
        clip_range: float,
        kl_beta: float,
    ) -> None: ...
    async def train_trust_region_mse(
        self,
        thread: TokenizedThread,
        targets: Sequence[float],
        clip_center: Sequence[float],
        clip_range: float,
    ) -> None: ...
    async def train_mse(self, thread: StringThread, target: float) -> None: ...
    async def train_mse_per_token(self, thread: TokenizedThread, targets: Sequence[float]) -> None: ...
    async def train_ranking(self, pos_thread: StringThread, neg_thread: StringThread) -> None: ...
    async def train_dpo(
        self,
        sample_pos: StringThread,
        sample_neg: StringThread,
        ref_logprobs_pos: float,
        ref_logprobs_neg: float,
        beta: float,
    ) -> None: ...
    def top_p(self, top_p: float) -> TrainingModel: ...
    def temperature(self, temperature: float) -> TrainingModel: ...
    def max_gen_len(self, max_num_tokens: int) -> TrainingModel: ...

class Thread(Enum):
    StringThread = ...
    TokenizedThread = ...
    SerializedThread = ...

class JobNotifier:
    """Helper class to report job progress.
    By default it will log to stdout. To report progress to harmony, use HarmonyJobNotifier"""

    def __new__(cls) -> JobNotifier: ...
    def set_monitoring_link(self, monitoring_link: str) -> None: ...
    def register_stages(self, stages: Sequence[str]) -> None: ...
    def register_artifact(self, artifact: JobArtifact) -> None: ...
    def report_error(self, error: str) -> None: ...
    def report_progress(
        self,
        stage: str,
        tot_num_samples: Optional[int] = None,
        processed_num_samples: Optional[int] = None,
        monitoring_link: Optional[str] = None,
        checkpoints: Optional[Sequence[str]] = None,
    ) -> None: ...
    def stage_notifier(self, stage: str) -> StageNotifier: ...
    def __repr__(self) -> str: ...

class HarmonyJobNotifier(JobNotifier):
    def __new__(cls, client: HarmonyClient, job_id: str) -> HarmonyJobNotifier: ...
    def set_monitoring_link(self, monitoring_link: str) -> None: ...

class StageNotifier:
    """Helper class to report job progress.
    Get access to an instance using a JobNotifier.stage_notifier function"""

    def set_monitoring_link(self, monitoring_link: str) -> None: ...
    def report_progress(
        self,
        tot_num_samples: Optional[int] = None,
        processed_num_samples: Optional[int] = None,
        monitoring_link: Optional[str] = None,
        checkpoints: Optional[Sequence[str]] = None,
    ) -> None: ...

async def get_client(
    addr: str,
    num_gpus: int | None = None,
    api_key: str | None = None,
    use_case: str | None = None,
    compute_pool: str | None = None,
    default_headers: dict[str, str] | None = None,
) -> HarmonyClient: ...
