"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Storage class to move an object to
 */
class StorageClass {
    constructor(value) {
        this.value = value;
    }
    toString() { return this.value; }
}
/**
 * Storage class for data that is accessed less frequently, but requires rapid
 * access when needed.
 *
 * Has lower availability than Standard storage.
 */
StorageClass.InfrequentAccess = new StorageClass('STANDARD_IA');
/**
 * Infrequent Access that's only stored in one availability zone.
 *
 * Has lower availability than standard InfrequentAccess.
 */
StorageClass.OneZoneInfrequentAccess = new StorageClass('ONEZONE_IA');
/**
 * Storage class for long-term archival that can take between minutes and
 * hours to access.
 *
 * Use for archives where portions of the data might need to be retrieved in
 * minutes. Data stored in the GLACIER storage class has a minimum storage
 * duration period of 90 days and can be accessed in as little as 1-5 minutes
 * using expedited retrieval. If you delete an object before the 90-day
 * minimum, you are charged for 90 days.
 */
StorageClass.Glacier = new StorageClass('GLACIER');
/**
 * Use for archiving data that rarely needs to be accessed. Data stored in the
 * DEEP_ARCHIVE storage class has a minimum storage duration period of 180
 * days and a default retrieval time of 12 hours. If you delete an object
 * before the 180-day minimum, you are charged for 180 days. For pricing
 * information, see Amazon S3 Pricing.
 */
StorageClass.DeepArchive = new StorageClass('DEEP_ARCHIVE');
/**
 * The INTELLIGENT_TIERING storage class is designed to optimize storage costs
 * by automatically moving data to the most cost-effective storage access
 * tier, without performance impact or operational overhead.
 * INTELLIGENT_TIERING delivers automatic cost savings by moving data on a
 * granular object level between two access tiers, a frequent access tier and
 * a lower-cost infrequent access tier, when access patterns change. The
 * INTELLIGENT_TIERING storage class is ideal if you want to optimize storage
 * costs automatically for long-lived data when access patterns are unknown or
 * unpredictable.
 */
StorageClass.IntelligentTiering = new StorageClass('INTELLIGENT_TIERING');
exports.StorageClass = StorageClass;
//# sourceMappingURL=data:application/json;base64,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