"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk_1 = require("@aws-cdk/cdk");
function parseBucketArn(construct, props) {
    // if we have an explicit bucket ARN, use it.
    if (props.bucketArn) {
        return props.bucketArn;
    }
    if (props.bucketName) {
        return cdk_1.Stack.of(construct).formatArn({
            // S3 Bucket names are globally unique in a partition,
            // and so their ARNs have empty region and account components
            region: '',
            account: '',
            service: 's3',
            resource: props.bucketName
        });
    }
    throw new Error('Cannot determine bucket ARN. At least `bucketArn` or `bucketName` is needed');
}
exports.parseBucketArn = parseBucketArn;
function parseBucketName(construct, props) {
    // if we have an explicit bucket name, use it.
    if (props.bucketName) {
        return props.bucketName;
    }
    // extract bucket name from bucket arn
    if (props.bucketArn) {
        return cdk_1.Stack.of(construct).parseArn(props.bucketArn).resource;
    }
    // no bucket name is okay since it's optional.
    return undefined;
}
exports.parseBucketName = parseBucketName;
//# sourceMappingURL=data:application/json;base64,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