"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/cdk");
const s3 = require("../lib");
const app = new cdk.App();
/// !show
/**
 * Stack that defines the bucket
 */
class Producer extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const bucket = new s3.Bucket(this, 'MyBucket', {
            removalPolicy: cdk.RemovalPolicy.Destroy
        });
        this.myBucket = bucket;
    }
}
/**
 * Stack that consumes the bucket
 */
class Consumer extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const user = new iam.User(this, 'MyUser');
        props.userBucket.grantReadWrite(user);
    }
}
const producer = new Producer(app, 'ProducerStack');
new Consumer(app, 'ConsumerStack', { userBucket: producer.myBucket });
/// !hide
app.synth();
//# sourceMappingURL=data:application/json;base64,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