"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
module.exports = {
    'Can use addCors() to add a CORS configuration'(test) {
        // GIVEN
        const stack = new cdk_1.Stack();
        // WHEN
        const bucket = new lib_1.Bucket(stack, 'Bucket');
        bucket.addCorsRule({
            allowedMethods: [lib_1.HttpMethods.GET, lib_1.HttpMethods.HEAD],
            allowedOrigins: ["https://example.com"]
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::S3::Bucket', {
            CorsConfiguration: {
                CorsRules: [{
                        AllowedMethods: ["GET", "HEAD"],
                        AllowedOrigins: ["https://example.com"]
                    }]
            }
        }));
        test.done();
    },
    'Bucket with multiple cors configurations'(test) {
        // GIVEN
        const stack = new cdk_1.Stack();
        // WHEN
        new lib_1.Bucket(stack, 'Bucket', {
            cors: [
                {
                    allowedHeaders: [
                        "*"
                    ],
                    allowedMethods: [
                        lib_1.HttpMethods.GET
                    ],
                    allowedOrigins: [
                        "*"
                    ],
                    exposedHeaders: [
                        "Date"
                    ],
                    id: "myCORSRuleId1",
                    maxAge: 3600
                },
                {
                    allowedHeaders: [
                        "x-amz-*"
                    ],
                    allowedMethods: [
                        lib_1.HttpMethods.DELETE
                    ],
                    allowedOrigins: [
                        "http://www.example1.com",
                        "http://www.example2.com"
                    ],
                    exposedHeaders: [
                        "Connection",
                        "Server",
                        "Date"
                    ],
                    id: "myCORSRuleId2",
                    maxAge: 1800
                }
            ]
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::S3::Bucket', {
            CorsConfiguration: {
                CorsRules: [
                    {
                        AllowedHeaders: [
                            "*"
                        ],
                        AllowedMethods: [
                            "GET"
                        ],
                        AllowedOrigins: [
                            "*"
                        ],
                        ExposedHeaders: [
                            "Date"
                        ],
                        Id: "myCORSRuleId1",
                        MaxAge: 3600
                    },
                    {
                        AllowedHeaders: [
                            "x-amz-*"
                        ],
                        AllowedMethods: [
                            "DELETE"
                        ],
                        AllowedOrigins: [
                            "http://www.example1.com",
                            "http://www.example2.com"
                        ],
                        ExposedHeaders: [
                            "Connection",
                            "Server",
                            "Date"
                        ],
                        Id: "myCORSRuleId2",
                        MaxAge: 1800
                    }
                ]
            }
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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