"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
module.exports = {
    'Can use addMetrics() to add a metric configuration'(test) {
        // GIVEN
        const stack = new cdk_1.Stack();
        // WHEN
        const bucket = new lib_1.Bucket(stack, 'Bucket');
        bucket.addMetric({
            id: "test"
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::S3::Bucket', {
            MetricsConfigurations: [{
                    Id: "test"
                }]
        }));
        test.done();
    },
    'Bucket with metrics on prefix'(test) {
        // GIVEN
        const stack = new cdk_1.Stack();
        // WHEN
        new lib_1.Bucket(stack, 'Bucket', {
            metrics: [{
                    id: "test",
                    prefix: "prefix"
                }]
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::S3::Bucket', {
            MetricsConfigurations: [{
                    Id: "test",
                    Prefix: "prefix"
                }]
        }));
        test.done();
    },
    'Bucket with metrics on tag filter'(test) {
        // GIVEN
        const stack = new cdk_1.Stack();
        // WHEN
        new lib_1.Bucket(stack, 'Bucket', {
            metrics: [{
                    id: "test",
                    tagFilters: { tagname1: "tagvalue1", tagname2: "tagvalue2" }
                }]
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::S3::Bucket', {
            MetricsConfigurations: [{
                    Id: "test",
                    TagFilters: [
                        { Key: "tagname1", Value: "tagvalue1" },
                        { Key: "tagname2", Value: "tagvalue2" },
                    ]
                }]
        }));
        test.done();
    },
    'Bucket with multiple metric configurations'(test) {
        // GIVEN
        const stack = new cdk_1.Stack();
        // WHEN
        new lib_1.Bucket(stack, 'Bucket', {
            metrics: [
                {
                    id: "test",
                    tagFilters: { tagname1: "tagvalue1", tagname2: "tagvalue2" }
                },
                {
                    id: "test2",
                    prefix: "prefix"
                },
            ]
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::S3::Bucket', {
            MetricsConfigurations: [{
                    Id: "test",
                    TagFilters: [
                        { Key: "tagname1", Value: "tagvalue1" },
                        { Key: "tagname2", Value: "tagvalue2" },
                    ]
                },
                {
                    Id: "test2",
                    Prefix: "prefix"
                }]
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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