from typing import List, Optional

import pydantic

# This file is based on autogenerated code from: https://static.ionq.co/schemas/circuit-v0.json using
# https://pydantic-docs.helpmanual.io/datamodel_code_generator/
# Run: datamodel-codegen --url https://static.ionq.co/schemas/circuit-v0.json


class Gate(pydantic.BaseModel):
    gate: pydantic.constr(regex=r"^\w+$", min_length=1)  # noqa: F722
    target: Optional[int] = None
    control: Optional[int] = None
    targets: Optional[List[int]] = None
    controls: Optional[List[int]] = None


class IonqQuantumCircuit(pydantic.BaseModel):
    qubits: int
    circuit: List[Gate]
