# coding: utf-8

"""
    Load Balancer API

    This API offers an interface to provision and manage load balancing servers in your STACKIT project. It also has the possibility of pooling target servers for load balancing purposes.  For each load balancer provided, two VMs are deployed in your OpenStack project subject to a fee.

    The version of the OpenAPI document: 1.7.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501 docstring might be too long

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing_extensions import Annotated, Self

from stackit.loadbalancer.models.options_tcp import OptionsTCP
from stackit.loadbalancer.models.options_udp import OptionsUDP
from stackit.loadbalancer.models.server_name_indicator import ServerNameIndicator


class Listener(BaseModel):
    """
    Listener
    """

    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    name: Optional[StrictStr] = Field(
        default=None,
        description="Will be used to reference a listener and will replace display name in the future. Currently uses <protocol>-<port> as the name if no display name is given.",
    )
    port: Optional[Annotated[int, Field(le=65535, strict=True, ge=1)]] = Field(
        default=None, description="Port number where we listen for traffic"
    )
    protocol: Optional[StrictStr] = Field(
        default=None,
        description="Protocol is the highest network protocol we understand to load balance. Currently only PROTOCOL_TCP, PROTOCOL_TCP_PROXY and PROTOCOL_TLS_PASSTHROUGH are supported.",
    )
    server_name_indicators: Optional[List[ServerNameIndicator]] = Field(
        default=None,
        description="Server Name Idicators config for domains to be routed to the desired target pool for this listener.",
        alias="serverNameIndicators",
    )
    target_pool: Optional[StrictStr] = Field(
        default=None, description="Reference target pool by target pool name.", alias="targetPool"
    )
    tcp: Optional[OptionsTCP] = None
    udp: Optional[OptionsUDP] = None
    __properties: ClassVar[List[str]] = [
        "displayName",
        "name",
        "port",
        "protocol",
        "serverNameIndicators",
        "targetPool",
        "tcp",
        "udp",
    ]

    @field_validator("protocol")
    def protocol_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(
            ["PROTOCOL_UNSPECIFIED", "PROTOCOL_TCP", "PROTOCOL_UDP", "PROTOCOL_TCP_PROXY", "PROTOCOL_TLS_PASSTHROUGH"]
        ):
            raise ValueError(
                "must be one of enum values ('PROTOCOL_UNSPECIFIED', 'PROTOCOL_TCP', 'PROTOCOL_UDP', 'PROTOCOL_TCP_PROXY', 'PROTOCOL_TLS_PASSTHROUGH')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Listener from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "name",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in server_name_indicators (list)
        _items = []
        if self.server_name_indicators:
            for _item in self.server_name_indicators:
                if _item:
                    _items.append(_item.to_dict())
            _dict["serverNameIndicators"] = _items
        # override the default output from pydantic by calling `to_dict()` of tcp
        if self.tcp:
            _dict["tcp"] = self.tcp.to_dict()
        # override the default output from pydantic by calling `to_dict()` of udp
        if self.udp:
            _dict["udp"] = self.udp.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Listener from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "displayName": obj.get("displayName"),
                "name": obj.get("name"),
                "port": obj.get("port"),
                "protocol": obj.get("protocol"),
                "serverNameIndicators": (
                    [ServerNameIndicator.from_dict(_item) for _item in obj["serverNameIndicators"]]
                    if obj.get("serverNameIndicators") is not None
                    else None
                ),
                "targetPool": obj.get("targetPool"),
                "tcp": OptionsTCP.from_dict(obj["tcp"]) if obj.get("tcp") is not None else None,
                "udp": OptionsUDP.from_dict(obj["udp"]) if obj.get("udp") is not None else None,
            }
        )
        return _obj
