from concurrent.futures import Future
from typing import (
    Any,
    Dict,
    List,
    Optional,
    Union,
)

from .utils.data_types import *


class Browser:
    def __init__(self, timeout = '10s', enable_playwright_debug: bool = False, auto_closing_level: AutoClosingLevel = AutoClosingLevel.TEST, assertion_polling_enabled: bool = True): ...
    def add_cookie(self, name: str, value: str, url: Optional[str] = None, domain: Optional[str] = None, path: Optional[str] = None, expires: Optional[str] = None, httpOnly: Optional[bool] = None, secure: Optional[bool] = None, sameSite: Optional[str] = None): ...
    def add_style_tag(self, content: str): ...
    def auto_activate_pages(self): ...
    def check_checkbox(self, selector: str): ...
    def clear_text(self, selector: str): ...
    def click(self, selector: str): ...
    def click_with_options(self, selector: str, button: MouseButton = MouseButton.left, click_count: int = 1, delay: Optional[str] = None, position_x: Optional[int] = None, position_y: Optional[int] = None, force: bool = False, *modifiers: KeyboardModifier): ...
    def close_all_browsers(self): ...
    def close_browser(self, browser: str = 'CURRENT'): ...
    def close_context(self, context: str = 'CURRENT', browser: str = 'CURRENT'): ...
    def close_page(self, page: str = 'CURRENT', context: str = 'CURRENT', browser: str = 'CURRENT'): ...
    def delete_all_cookies(self): ...
    def deselect_options(self, selector: str): ...
    def download(self, url: str): ...
    def eat_all_cookies(self): ...
    def execute_javascript(self, function: str, selector: str = ''): ...
    def fill_secret(self, selector: str, secret: str): ...
    def fill_text(self, selector: str, text: str): ...
    def focus(self, selector: str): ...
    def get_attribute(self, selector: str, attribute: str, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None): ...
    def get_boundingbox(self, selector: str, *keys: BoundingBoxFields): ...
    def get_browser_catalog(self): ...
    def get_checkbox_state(self, selector: str, assertion_operator: Optional[AssertionOperator] = None, expected_state: str = 'Unchecked'): ...
    def get_cookie(self, cookie: str, return_type: CookieType = CookieType.dictionary): ...
    def get_cookies(self, return_type: CookieType = CookieType.dictionary): ...
    def get_device(self, name: str): ...
    def get_devices(self): ...
    def get_element(self, selector: str): ...
    def get_element_count(self, selector: str, assertion_operator: Optional[AssertionOperator] = None, expected_value: Union[int, str] = 0): ...
    def get_elements(self, selector: str): ...
    def get_page_source(self, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None): ...
    def get_page_state(self, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None): ...
    def get_selected_options(self, selector: str, option_attribute: SelectAttribute = SelectAttribute.label, assertion_operator: Optional[AssertionOperator] = None, *assertion_expected): ...
    def get_style(self, selector: str, key: str = 'ALL', assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None): ...
    def get_text(self, selector: str, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None): ...
    def get_textfield_value(self, selector: str, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None): ...
    def get_title(self, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None): ...
    def get_url(self, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None): ...
    def get_viewport_size(self, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Dict[str, int]] = None): ...
    def go_back(self): ...
    def go_forward(self): ...
    def go_to(self, url: str): ...
    def handle_alert(self, action: AlertAction, prompt_input: str = ''): ...
    def highlight_elements(self, selector: str, duration: str = '5s', width: str = '2px', style: str = 'dotted', color: str = 'blue'): ...
    def http(self, url: str, method: RequestMethod = RequestMethod.GET, body: Optional[str] = None, headers: Optional[dict] = None): ...
    def keyboard_input(self, action: KeyboardInputAction, input: str, delay = 0): ...
    def keyboard_key(self, action: KeyAction, key: str): ...
    def local_storage_clear(self): ...
    def local_storage_get_item(self, key: str, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None): ...
    def local_storage_remove_item(self, key: str): ...
    def local_storage_set_item(self, key: str, value: str): ...
    def mouse_button(self, action: MouseButtonAction, x: Optional[float] = None, y: Optional[float] = None, button: MouseButton = MouseButton.left, clickCount: int = 1, delay: int = 0): ...
    def mouse_move(self, x: float, y: float, steps: int = 1): ...
    def new_browser(self, browser: SupportedBrowsers = SupportedBrowsers.chromium, headless: bool = True, executablePath: Optional[str] = None, args: Optional[List[str]] = None, ignoreDefaultArgs: Optional[List[str]] = None, proxy: Optional[Dict] = None, downloadsPath: Optional[str] = None, handleSIGINT: bool = True, handleSIGTERM: bool = True, handleSIGHUP: bool = True, timeout: str = '30 seconds', env: Optional[Dict] = None, devtools: bool = False, slowMo: str = '0 seconds'): ...
    def new_context(self, hideRfBrowser: bool = False, acceptDownloads: bool = False, ignoreHTTPSErrors: bool = False, bypassCSP: bool = False, viewport: Optional[ViewportDimensions] = None, userAgent: Optional[str] = None, deviceScaleFactor: float = 1.0, isMobile: bool = False, hasTouch: bool = False, javaScriptEnabled: bool = True, timezoneId: Optional[str] = None, geolocation: Optional[Dict] = None, locale: Optional[str] = None, permissions: Optional[List[str]] = None, extraHTTPHeaders: Optional[Dict[str, str]] = None, offline: bool = False, httpCredentials: Optional[Dict] = None, colorScheme: Optional[ColorScheme] = None): ...
    def new_page(self, url: Optional[str] = None): ...
    def open_browser(self, url: Optional[str] = None, browser: SupportedBrowsers = SupportedBrowsers.chromium, headless: bool = True): ...
    def press_keys(self, selector: str, *keys: str): ...
    def promise_to(self, kw: str, *args): ...
    def select_options_by(self, selector: str, attribute: SelectAttribute, *values): ...
    def session_storage_clear(self): ...
    def session_storage_get_item(self, key: str, assertion_operator: Optional[AssertionOperator] = None, assertion_expected: Optional[Any] = None): ...
    def session_storage_remove_item(self, key: str): ...
    def session_storage_set_item(self, key: str, value: str): ...
    def set_browser_timeout(self, timeout: str): ...
    def set_offline(self, offline: bool = True): ...
    def set_viewport_size(self, width: int, height: int): ...
    def switch_browser(self, index: int): ...
    def switch_context(self, index: int, browser: str = 'CURRENT'): ...
    def switch_page(self, index: int, context: str = 'CURRENT', browser: str = 'CURRENT'): ...
    def take_screenshot(self, filename: str = '', selector: str = ''): ...
    def type_secret(self, selector: str, secret: str, delay: str = '0 ms', clear: bool = True): ...
    def type_text(self, selector: str, text: str, delay: str = '0 ms', clear: bool = True): ...
    def uncheck_checkbox(self, selector: str): ...
    def upload_file(self, path: str): ...
    def wait_for(self, *promises: Future): ...
    def wait_for_all_promises(self): ...
    def wait_for_download(self, saveAs: str = ''): ...
    def wait_for_elements_state(self, selector: str, state: ElementState = ElementState.visible, timeout: str = ''): ...
    def wait_for_function(self, function: str, selector: str = '', polling: str = 'raf', timeout: str = ''): ...
    def wait_for_request(self, matcher: str = '', timeout: str = ''): ...
    def wait_for_response(self, matcher: str = '', timeout: str = ''): ...
    def wait_until_network_is_idle(self, timeout: str = ''): ...
