from hermessplitter.main import HermesSplitter
import unittest


class MainTest(unittest.TestCase):
    def __init__(self, *args, **kwargs):
        super(MainTest, self).__init__(*args, **kwargs)
        self.hs = HermesSplitter('0.0.0.0', 2295, 'hermes', 'watchman', 'hect0r1337',
                            '192.168.100.109', 'wdb_one', 'watchman', 'hect0r1337',
                            '192.168.100.109', debug=True)

    def test_a(self):
        self.hs.activate(carnum='Н266ХО102', client=346)
        all_data = ['0', '-50', '10', '40', '100', '500', '1000', '6660', '15000']
        magic_data = []
        for data in all_data:
            response = self.hs.make_magic(data)
            magic_data.append(response)
        print("MAGIC DATA", dict(zip(all_data, magic_data)))


if __name__ == '__main__':
    unittest.main()