"""
MAVLink protocol implementation (auto-generated by mavgen.py)

Generated from: ('common_minimal.xml',)

Note: this file has been auto-generated. DO NOT EDIT
"""
import hashlib
import json
import logging
import os
import struct
import sys
import time
from builtins import object, range


def cast(type_str, arg):
    """
    No-op for Python2 used instead of typing.cast()
    """
    return arg


WIRE_PROTOCOL_VERSION = "1.0"
DIALECT = "common_minimal"

PROTOCOL_MARKER_V1 = 0xFE
PROTOCOL_MARKER_V2 = 0xFD
HEADER_LEN_V1 = 6
HEADER_LEN_V2 = 10

MAVLINK_SIGNATURE_BLOCK_LEN = 13

MAVLINK_IFLAG_SIGNED = 0x01

if sys.version_info[0] == 2:
    logging.basicConfig()

logger = logging.getLogger(__name__)

# allow MAV_IGNORE_CRC=1 to ignore CRC, allowing some
# corrupted msgs to be seen
MAVLINK_IGNORE_CRC = os.environ.get("MAV_IGNORE_CRC", 0)

# some base types from mavlink_types.h
MAVLINK_TYPE_CHAR = 0
MAVLINK_TYPE_UINT8_T = 1
MAVLINK_TYPE_INT8_T = 2
MAVLINK_TYPE_UINT16_T = 3
MAVLINK_TYPE_INT16_T = 4
MAVLINK_TYPE_UINT32_T = 5
MAVLINK_TYPE_INT32_T = 6
MAVLINK_TYPE_UINT64_T = 7
MAVLINK_TYPE_INT64_T = 8
MAVLINK_TYPE_FLOAT = 9
MAVLINK_TYPE_DOUBLE = 10


class x25crc(object):
    """CRC-16/MCRF4XX - based on checksum.h from mavlink library"""

    def __init__(self, buf=None):
        self.crc = 0xFFFF
        if buf is not None:
            self.accumulate(buf)

    def accumulate(self, buf):
        """add in some more bytes (it also accepts python2 strings)"""
        if sys.version_info[0] == 2 and type(buf) is str:
            buf = bytearray(buf)

        accum = self.crc
        for b in buf:
            tmp = b ^ (accum & 0xFF)
            tmp = (tmp ^ (tmp << 4)) & 0xFF
            accum = (accum >> 8) ^ (tmp << 8) ^ (tmp << 3) ^ (tmp >> 4)
        self.crc = accum


class MAVLink_header(object):
    """MAVLink message header"""

    def __init__(self, msgId, incompat_flags=0, compat_flags=0, mlen=0, seq=0, srcSystem=0, srcComponent=0):
        self.mlen = mlen
        self.seq = seq
        self.srcSystem = srcSystem
        self.srcComponent = srcComponent
        self.msgId = msgId
        self.incompat_flags = incompat_flags
        self.compat_flags = compat_flags

    def pack(self, force_mavlink1=False):
        if float(WIRE_PROTOCOL_VERSION) == 2.0 and not force_mavlink1:
            return struct.pack(
                "<BBBBBBBHB",
                254,
                self.mlen,
                self.incompat_flags,
                self.compat_flags,
                self.seq,
                self.srcSystem,
                self.srcComponent,
                self.msgId & 0xFFFF,
                self.msgId >> 16,
            )
        return struct.pack(
            "<BBBBBB",
            PROTOCOL_MARKER_V1,
            self.mlen,
            self.seq,
            self.srcSystem,
            self.srcComponent,
            self.msgId,
        )


class MAVLink_message(object):
    """base MAVLink message class"""

    id = 0
    msgname = ""
    fieldnames = []
    ordered_fieldnames = []
    fieldtypes = []
    fielddisplays_by_name = {}
    fieldenums_by_name = {}
    fieldunits_by_name = {}
    native_format = bytearray(b"")
    orders = []
    lengths = []
    array_lengths = []
    crc_extra = 0
    unpacker = struct.Struct("")
    instance_field = None
    instance_offset = -1

    def __init__(self, msgId, name):
        self._header = MAVLink_header(msgId)
        self._payload = None
        self._msgbuf = bytearray(b"")
        self._crc = None
        self._fieldnames = []
        self._type = name
        self._signed = False
        self._link_id = None
        self._instances = None
        self._instance_field = None

    def format_attr(self, field):
        """override field getter"""
        raw_attr = cast("Union[bytes, float, int]", getattr(self, field))
        if isinstance(raw_attr, bytes):
            if sys.version_info[0] == 2:
                return raw_attr.rstrip(b"\x00")
            return raw_attr.decode(errors="backslashreplace").rstrip("\x00")
        return raw_attr

    def get_msgbuf(self):
        return self._msgbuf

    def get_header(self):
        return self._header

    def get_payload(self):
        return self._payload

    def get_crc(self):
        return self._crc

    def get_fieldnames(self):
        return self._fieldnames

    def get_type(self):
        return self._type

    def get_msgId(self):
        return self._header.msgId

    def get_srcSystem(self):
        return self._header.srcSystem

    def get_srcComponent(self):
        return self._header.srcComponent

    def get_seq(self):
        return self._header.seq

    def get_signed(self):
        return self._signed

    def get_link_id(self):
        return self._link_id

    def __str__(self):
        ret = "%s {" % self._type
        for a in self._fieldnames:
            v = self.format_attr(a)
            ret += "%s : %s, " % (a, v)
        ret = ret[0:-2] + "}"
        return ret

    def __ne__(self, other):
        return not self.__eq__(other)

    def __eq__(self, other):
        if other is None:
            return False

        if not isinstance(other, MAVLink_message):
            return False

        if self.get_type() != other.get_type():
            return False

        if self.get_crc() != other.get_crc():
            return False

        if self.get_seq() != other.get_seq():
            return False

        if self.get_srcSystem() != other.get_srcSystem():
            return False

        if self.get_srcComponent() != other.get_srcComponent():
            return False

        for a in self._fieldnames:
            if self.format_attr(a) != other.format_attr(a):
                return False

        return True

    def to_dict(self):
        d = {}
        d["mavpackettype"] = self._type
        for a in self._fieldnames:
            d[a] = self.format_attr(a)
        return d

    def to_json(self):
        return json.dumps(self.to_dict())

    def sign_packet(self, mav):
        assert mav.signing.secret_key is not None

        h = hashlib.new("sha256")
        self._msgbuf += struct.pack("<BQ", mav.signing.link_id, mav.signing.timestamp)[:7]
        h.update(mav.signing.secret_key)
        h.update(self._msgbuf)
        sig = h.digest()[:6]
        self._msgbuf += sig
        mav.signing.timestamp += 1

    def _pack(self, mav, crc_extra, payload, force_mavlink1=False):
        plen = len(payload)
        if float(WIRE_PROTOCOL_VERSION) == 2.0 and not force_mavlink1:
            # in MAVLink2 we can strip trailing zeros off payloads. This allows for simple
            # variable length arrays and smaller packets
            if sys.version_info[0] == 2:
                nullbyte = chr(0)
            else:
                nullbyte = 0
            while plen > 1 and payload[plen - 1] == nullbyte:
                plen -= 1
        self._payload = payload[:plen]
        incompat_flags = 0
        if mav.signing.sign_outgoing:
            incompat_flags |= MAVLINK_IFLAG_SIGNED
        self._header = MAVLink_header(
            self._header.msgId,
            incompat_flags=incompat_flags,
            compat_flags=0,
            mlen=len(self._payload),
            seq=mav.seq,
            srcSystem=mav.srcSystem,
            srcComponent=mav.srcComponent,
        )
        self._msgbuf = bytearray(self._header.pack(force_mavlink1=force_mavlink1))
        self._msgbuf += self._payload
        crc = x25crc(self._msgbuf[1:])
        if True:
            # we are using CRC extra
            crc.accumulate(struct.pack("B", crc_extra))
        self._crc = crc.crc
        self._msgbuf += struct.pack("<H", self._crc)
        if mav.signing.sign_outgoing and not force_mavlink1:
            self.sign_packet(mav)
        return bytes(self._msgbuf)

    def pack(self, mav, force_mavlink1=False):
        raise NotImplementedError("MAVLink_message cannot be serialized directly")

    def __getitem__(self, key):
        """support indexing, allowing for multi-instance sensors in one message"""
        if self._instances is None:
            raise IndexError()
        if key not in self._instances:
            raise IndexError()
        return self._instances[key]


class mavlink_msg_deprecated_name_property(object):
    """
    This handles the class variable name change from name to msgname for
    subclasses of MAVLink_message during a transition period.

    This is used by setting the class variable to
    `mavlink_msg_deprecated_name_property()`.
    """

    def __get__(self, instance, owner):
        if instance is not None:
            logger.error("Using .name on a MAVLink_message is not supported, use .get_type() instead.")
            raise AttributeError("Class {} has no attribute 'name'".format(owner.__name__))
        logger.warning(
            """Using .name on a MAVLink_message class is deprecated, consider using .msgname instead.
Note that if compatibility with pymavlink 2.4.30 and earlier is desired, use something like this:

msg_name =  msg.msgname if hasattr(msg, "msgname") else msg.name"""
        )
        return owner.msgname


# enums


class EnumEntry(object):
    def __init__(self, name, description):
        self.name = name
        self.description = description
        self.param = {}
        self.has_location = False


enums = {}

# MAV_AUTOPILOT
enums["MAV_AUTOPILOT"] = {}
MAV_AUTOPILOT_GENERIC = 0
enums["MAV_AUTOPILOT"][0] = EnumEntry("MAV_AUTOPILOT_GENERIC", """Generic autopilot, full support for everything""")
MAV_AUTOPILOT_INVALID = 8
enums["MAV_AUTOPILOT"][8] = EnumEntry("MAV_AUTOPILOT_INVALID", """No valid autopilot, e.g. a GCS or other MAVLink component""")
MAV_AUTOPILOT_ENUM_END = 9
enums["MAV_AUTOPILOT"][9] = EnumEntry("MAV_AUTOPILOT_ENUM_END", """""")

# MAV_FTP_ERR
enums["MAV_FTP_ERR"] = {}
MAV_FTP_ERR_NONE = 0
enums["MAV_FTP_ERR"][0] = EnumEntry("MAV_FTP_ERR_NONE", """None: No error""")
MAV_FTP_ERR_FAIL = 1
enums["MAV_FTP_ERR"][1] = EnumEntry("MAV_FTP_ERR_FAIL", """Fail: Unknown failure""")
MAV_FTP_ERR_FAILERRNO = 2
enums["MAV_FTP_ERR"][2] = EnumEntry(
    "MAV_FTP_ERR_FAILERRNO",
    """FailErrno: Command failed, Err number sent back in PayloadHeader.data[1].
        This is a file-system error number understood by the server operating system.""",
)
MAV_FTP_ERR_INVALIDDATASIZE = 3
enums["MAV_FTP_ERR"][3] = EnumEntry("MAV_FTP_ERR_INVALIDDATASIZE", """InvalidDataSize: Payload size is invalid""")
MAV_FTP_ERR_INVALIDSESSION = 4
enums["MAV_FTP_ERR"][4] = EnumEntry("MAV_FTP_ERR_INVALIDSESSION", """InvalidSession: Session is not currently open""")
MAV_FTP_ERR_NOSESSIONSAVAILABLE = 5
enums["MAV_FTP_ERR"][5] = EnumEntry("MAV_FTP_ERR_NOSESSIONSAVAILABLE", """NoSessionsAvailable: All available sessions are already in use""")
MAV_FTP_ERR_EOF = 6
enums["MAV_FTP_ERR"][6] = EnumEntry("MAV_FTP_ERR_EOF", """EOF: Offset past end of file for ListDirectory and ReadFile commands""")
MAV_FTP_ERR_UNKNOWNCOMMAND = 7
enums["MAV_FTP_ERR"][7] = EnumEntry("MAV_FTP_ERR_UNKNOWNCOMMAND", """UnknownCommand: Unknown command / opcode""")
MAV_FTP_ERR_FILEEXISTS = 8
enums["MAV_FTP_ERR"][8] = EnumEntry("MAV_FTP_ERR_FILEEXISTS", """FileExists: File/directory already exists""")
MAV_FTP_ERR_FILEPROTECTED = 9
enums["MAV_FTP_ERR"][9] = EnumEntry("MAV_FTP_ERR_FILEPROTECTED", """FileProtected: File/directory is write protected""")
MAV_FTP_ERR_FILENOTFOUND = 10
enums["MAV_FTP_ERR"][10] = EnumEntry("MAV_FTP_ERR_FILENOTFOUND", """FileNotFound: File/directory not found""")
MAV_FTP_ERR_ENUM_END = 11
enums["MAV_FTP_ERR"][11] = EnumEntry("MAV_FTP_ERR_ENUM_END", """""")

# MAV_FTP_OPCODE
enums["MAV_FTP_OPCODE"] = {}
MAV_FTP_OPCODE_NONE = 0
enums["MAV_FTP_OPCODE"][0] = EnumEntry("MAV_FTP_OPCODE_NONE", """None. Ignored, always ACKed""")
MAV_FTP_OPCODE_TERMINATESESSION = 1
enums["MAV_FTP_OPCODE"][1] = EnumEntry("MAV_FTP_OPCODE_TERMINATESESSION", """TerminateSession: Terminates open Read session""")
MAV_FTP_OPCODE_RESETSESSION = 2
enums["MAV_FTP_OPCODE"][2] = EnumEntry("MAV_FTP_OPCODE_RESETSESSION", """ResetSessions: Terminates all open read sessions""")
MAV_FTP_OPCODE_LISTDIRECTORY = 3
enums["MAV_FTP_OPCODE"][3] = EnumEntry("MAV_FTP_OPCODE_LISTDIRECTORY", """ListDirectory. List files and directories in path from offset""")
MAV_FTP_OPCODE_OPENFILERO = 4
enums["MAV_FTP_OPCODE"][4] = EnumEntry("MAV_FTP_OPCODE_OPENFILERO", """OpenFileRO: Opens file at path for reading, returns session""")
MAV_FTP_OPCODE_READFILE = 5
enums["MAV_FTP_OPCODE"][5] = EnumEntry("MAV_FTP_OPCODE_READFILE", """ReadFile: Reads size bytes from offset in session""")
MAV_FTP_OPCODE_CREATEFILE = 6
enums["MAV_FTP_OPCODE"][6] = EnumEntry("MAV_FTP_OPCODE_CREATEFILE", """CreateFile: Creates file at path for writing, returns session""")
MAV_FTP_OPCODE_WRITEFILE = 7
enums["MAV_FTP_OPCODE"][7] = EnumEntry("MAV_FTP_OPCODE_WRITEFILE", """WriteFile: Writes size bytes to offset in session""")
MAV_FTP_OPCODE_REMOVEFILE = 8
enums["MAV_FTP_OPCODE"][8] = EnumEntry("MAV_FTP_OPCODE_REMOVEFILE", """RemoveFile: Remove file at path""")
MAV_FTP_OPCODE_CREATEDIRECTORY = 9
enums["MAV_FTP_OPCODE"][9] = EnumEntry("MAV_FTP_OPCODE_CREATEDIRECTORY", """CreateDirectory: Creates directory at path""")
MAV_FTP_OPCODE_REMOVEDIRECTORY = 10
enums["MAV_FTP_OPCODE"][10] = EnumEntry("MAV_FTP_OPCODE_REMOVEDIRECTORY", """RemoveDirectory: Removes directory at path. The directory must be empty.""")
MAV_FTP_OPCODE_OPENFILEWO = 11
enums["MAV_FTP_OPCODE"][11] = EnumEntry("MAV_FTP_OPCODE_OPENFILEWO", """OpenFileWO: Opens file at path for writing, returns session""")
MAV_FTP_OPCODE_TRUNCATEFILE = 12
enums["MAV_FTP_OPCODE"][12] = EnumEntry("MAV_FTP_OPCODE_TRUNCATEFILE", """TruncateFile: Truncate file at path to offset length""")
MAV_FTP_OPCODE_RENAME = 13
enums["MAV_FTP_OPCODE"][13] = EnumEntry("MAV_FTP_OPCODE_RENAME", """Rename: Rename path1 to path2""")
MAV_FTP_OPCODE_CALCFILECRC = 14
enums["MAV_FTP_OPCODE"][14] = EnumEntry("MAV_FTP_OPCODE_CALCFILECRC", """CalcFileCRC32: Calculate CRC32 for file at path""")
MAV_FTP_OPCODE_BURSTREADFILE = 15
enums["MAV_FTP_OPCODE"][15] = EnumEntry("MAV_FTP_OPCODE_BURSTREADFILE", """BurstReadFile: Burst download session file""")
MAV_FTP_OPCODE_ACK = 128
enums["MAV_FTP_OPCODE"][128] = EnumEntry("MAV_FTP_OPCODE_ACK", """ACK: ACK response""")
MAV_FTP_OPCODE_NAK = 129
enums["MAV_FTP_OPCODE"][129] = EnumEntry("MAV_FTP_OPCODE_NAK", """NAK: NAK response""")
MAV_FTP_OPCODE_ENUM_END = 130
enums["MAV_FTP_OPCODE"][130] = EnumEntry("MAV_FTP_OPCODE_ENUM_END", """""")

# MAV_TYPE
enums["MAV_TYPE"] = {}
MAV_TYPE_GENERIC = 0
enums["MAV_TYPE"][0] = EnumEntry("MAV_TYPE_GENERIC", """Generic micro air vehicle""")
MAV_TYPE_FIXED_WING = 1
enums["MAV_TYPE"][1] = EnumEntry("MAV_TYPE_FIXED_WING", """Fixed wing aircraft.""")
MAV_TYPE_GCS = 6
enums["MAV_TYPE"][6] = EnumEntry("MAV_TYPE_GCS", """Operator control unit / ground control station""")
MAV_AUTOPILOT_PX4 = 12
enums["MAV_TYPE"][12] = EnumEntry("MAV_AUTOPILOT_PX4", """PX4 Autopilot - http://px4.io/""")
MAV_TYPE_ONBOARD_CONTROLLER = 18
enums["MAV_TYPE"][18] = EnumEntry("MAV_TYPE_ONBOARD_CONTROLLER", """Onboard companion controller""")
MAV_TYPE_GIMBAL = 26
enums["MAV_TYPE"][26] = EnumEntry("MAV_TYPE_GIMBAL", """Gimbal""")
MAV_TYPE_ADSB = 27
enums["MAV_TYPE"][27] = EnumEntry("MAV_TYPE_ADSB", """ADSB system""")
MAV_TYPE_CAMERA = 30
enums["MAV_TYPE"][30] = EnumEntry("MAV_TYPE_CAMERA", """Camera""")
MAV_TYPE_ENUM_END = 31
enums["MAV_TYPE"][31] = EnumEntry("MAV_TYPE_ENUM_END", """""")

# MAV_SEVERITY
enums["MAV_SEVERITY"] = {}
MAV_SEVERITY_EMERGENCY = 0
enums["MAV_SEVERITY"][0] = EnumEntry("MAV_SEVERITY_EMERGENCY", """System is unusable. This is a "panic" condition.""")
MAV_SEVERITY_ALERT = 1
enums["MAV_SEVERITY"][1] = EnumEntry("MAV_SEVERITY_ALERT", """Action should be taken immediately. Indicates error in non-critical systems.""")
MAV_SEVERITY_CRITICAL = 2
enums["MAV_SEVERITY"][2] = EnumEntry("MAV_SEVERITY_CRITICAL", """Action must be taken immediately. Indicates failure in a primary system.""")
MAV_SEVERITY_ERROR = 3
enums["MAV_SEVERITY"][3] = EnumEntry("MAV_SEVERITY_ERROR", """Indicates an error in secondary/redundant systems.""")
MAV_SEVERITY_WARNING = 4
enums["MAV_SEVERITY"][4] = EnumEntry("MAV_SEVERITY_WARNING", """Indicates about a possible future error if this is not resolved within a given timeframe. Example would be a low battery warning.""")
MAV_SEVERITY_NOTICE = 5
enums["MAV_SEVERITY"][5] = EnumEntry("MAV_SEVERITY_NOTICE", """An unusual event has occurred, though not an error condition. This should be investigated for the root cause.""")
MAV_SEVERITY_INFO = 6
enums["MAV_SEVERITY"][6] = EnumEntry("MAV_SEVERITY_INFO", """Normal operational messages. Useful for logging. No action is required for these messages.""")
MAV_SEVERITY_DEBUG = 7
enums["MAV_SEVERITY"][7] = EnumEntry("MAV_SEVERITY_DEBUG", """Useful non-operational messages that can assist in debugging. These should not occur during normal operation.""")
MAV_SEVERITY_ENUM_END = 8
enums["MAV_SEVERITY"][8] = EnumEntry("MAV_SEVERITY_ENUM_END", """""")

# MAV_CMD
enums["MAV_CMD"] = {}
MAV_CMD_SET_MESSAGE_INTERVAL = 511
enums["MAV_CMD"][511] = EnumEntry("MAV_CMD_SET_MESSAGE_INTERVAL", """Set the interval between messages for a particular MAVLink message ID. This interface replaces REQUEST_DATA_STREAM.""")
enums["MAV_CMD"][511].param[1] = """The MAVLink message ID"""
enums["MAV_CMD"][511].param[2] = """The interval between two messages. -1: disable. 0: request default rate (which may be zero)."""
enums["MAV_CMD"][511].param[3] = """Reserved (default:0)"""
enums["MAV_CMD"][511].param[4] = """Reserved (default:0)"""
enums["MAV_CMD"][511].param[5] = """Reserved (default:0)"""
enums["MAV_CMD"][511].param[6] = """Reserved (default:0)"""
enums["MAV_CMD"][511].param[7] = """Target address of message stream (if message has target address fields). 0: Flight-stack default (recommended), 1: address of requestor, 2: broadcast."""
MAV_CMD_REQUEST_MESSAGE = 512
enums["MAV_CMD"][512] = EnumEntry("MAV_CMD_REQUEST_MESSAGE", """Request the target system(s) emit a single instance of a specified message (i.e. a "one-shot" version of MAV_CMD_SET_MESSAGE_INTERVAL).""")
enums["MAV_CMD"][512].param[1] = """The MAVLink message ID of the requested message."""
enums["MAV_CMD"][512].param[2] = """Use for index ID, if required. Otherwise, the use of this parameter (if any) must be defined in the requested message. By default assumed not used (0)."""
enums["MAV_CMD"][512].param[3] = """The use of this parameter (if any), must be defined in the requested message. By default assumed not used (0)."""
enums["MAV_CMD"][512].param[4] = """The use of this parameter (if any), must be defined in the requested message. By default assumed not used (0)."""
enums["MAV_CMD"][512].param[5] = """The use of this parameter (if any), must be defined in the requested message. By default assumed not used (0)."""
enums["MAV_CMD"][512].param[6] = """The use of this parameter (if any), must be defined in the requested message. By default assumed not used (0)."""
enums["MAV_CMD"][512].param[7] = """Target address for requested message (if message has target address fields). 0: Flight-stack default, 1: address of requestor, 2: broadcast."""
MAV_CMD_ENUM_END = 513
enums["MAV_CMD"][513] = EnumEntry("MAV_CMD_ENUM_END", """""")

# MAV_MODE_FLAG
enums["MAV_MODE_FLAG"] = {}
MAV_MODE_FLAG_CUSTOM_MODE_ENABLED = 1
enums["MAV_MODE_FLAG"][1] = EnumEntry("MAV_MODE_FLAG_CUSTOM_MODE_ENABLED", """0b00000001 Reserved for future use.""")
MAV_MODE_FLAG_TEST_ENABLED = 2
enums["MAV_MODE_FLAG"][2] = EnumEntry("MAV_MODE_FLAG_TEST_ENABLED", """0b00000010 system has a test mode enabled. This flag is intended for temporary system tests and should not be used for stable implementations.""")
MAV_MODE_FLAG_AUTO_ENABLED = 4
enums["MAV_MODE_FLAG"][4] = EnumEntry("MAV_MODE_FLAG_AUTO_ENABLED", """0b00000100 autonomous mode enabled, system finds its own goal positions. Guided flag can be set or not, depends on the actual implementation.""")
MAV_MODE_FLAG_GUIDED_ENABLED = 8
enums["MAV_MODE_FLAG"][8] = EnumEntry("MAV_MODE_FLAG_GUIDED_ENABLED", """0b00001000 guided mode enabled, system flies waypoints / mission items.""")
MAV_MODE_FLAG_STABILIZE_ENABLED = 16
enums["MAV_MODE_FLAG"][16] = EnumEntry("MAV_MODE_FLAG_STABILIZE_ENABLED", """0b00010000 system stabilizes electronically its attitude (and optionally position). It needs however further control inputs to move around.""")
MAV_MODE_FLAG_HIL_ENABLED = 32
enums["MAV_MODE_FLAG"][32] = EnumEntry("MAV_MODE_FLAG_HIL_ENABLED", """0b00100000 hardware in the loop simulation. All motors / actuators are blocked, but internal software is full operational.""")
MAV_MODE_FLAG_MANUAL_INPUT_ENABLED = 64
enums["MAV_MODE_FLAG"][64] = EnumEntry("MAV_MODE_FLAG_MANUAL_INPUT_ENABLED", """0b01000000 remote control input is enabled.""")
MAV_MODE_FLAG_SAFETY_ARMED = 128
enums["MAV_MODE_FLAG"][128] = EnumEntry("MAV_MODE_FLAG_SAFETY_ARMED", """0b10000000 MAV safety set to armed. Motors are enabled / running / can start. Ready to fly. Additional note: this flag is to be ignore when sent in the command MAV_CMD_DO_SET_MODE and MAV_CMD_COMPONENT_ARM_DISARM shall be used instead. The flag can still be used to report the armed state.""")
MAV_MODE_FLAG_ENUM_END = 129
enums["MAV_MODE_FLAG"][129] = EnumEntry("MAV_MODE_FLAG_ENUM_END", """""")

# MAV_MODE_FLAG_DECODE_POSITION
enums["MAV_MODE_FLAG_DECODE_POSITION"] = {}
MAV_MODE_FLAG_DECODE_POSITION_CUSTOM_MODE = 1
enums["MAV_MODE_FLAG_DECODE_POSITION"][1] = EnumEntry("MAV_MODE_FLAG_DECODE_POSITION_CUSTOM_MODE", """Eighth bit: 00000001""")
MAV_MODE_FLAG_DECODE_POSITION_TEST = 2
enums["MAV_MODE_FLAG_DECODE_POSITION"][2] = EnumEntry("MAV_MODE_FLAG_DECODE_POSITION_TEST", """Seventh bit: 00000010""")
MAV_MODE_FLAG_DECODE_POSITION_AUTO = 4
enums["MAV_MODE_FLAG_DECODE_POSITION"][4] = EnumEntry("MAV_MODE_FLAG_DECODE_POSITION_AUTO", """Sixth bit:   00000100""")
MAV_MODE_FLAG_DECODE_POSITION_GUIDED = 8
enums["MAV_MODE_FLAG_DECODE_POSITION"][8] = EnumEntry("MAV_MODE_FLAG_DECODE_POSITION_GUIDED", """Fifth bit:  00001000""")
MAV_MODE_FLAG_DECODE_POSITION_STABILIZE = 16
enums["MAV_MODE_FLAG_DECODE_POSITION"][16] = EnumEntry("MAV_MODE_FLAG_DECODE_POSITION_STABILIZE", """Fourth bit: 00010000""")
MAV_MODE_FLAG_DECODE_POSITION_HIL = 32
enums["MAV_MODE_FLAG_DECODE_POSITION"][32] = EnumEntry("MAV_MODE_FLAG_DECODE_POSITION_HIL", """Third bit:  00100000""")
MAV_MODE_FLAG_DECODE_POSITION_MANUAL = 64
enums["MAV_MODE_FLAG_DECODE_POSITION"][64] = EnumEntry("MAV_MODE_FLAG_DECODE_POSITION_MANUAL", """Second bit: 01000000""")
MAV_MODE_FLAG_DECODE_POSITION_SAFETY = 128
enums["MAV_MODE_FLAG_DECODE_POSITION"][128] = EnumEntry("MAV_MODE_FLAG_DECODE_POSITION_SAFETY", """First bit:  10000000""")
MAV_MODE_FLAG_DECODE_POSITION_ENUM_END = 129
enums["MAV_MODE_FLAG_DECODE_POSITION"][129] = EnumEntry("MAV_MODE_FLAG_DECODE_POSITION_ENUM_END", """""")

# MAV_STATE
enums["MAV_STATE"] = {}
MAV_STATE_UNINIT = 0
enums["MAV_STATE"][0] = EnumEntry("MAV_STATE_UNINIT", """Uninitialized system, state is unknown.""")
MAV_STATE_BOOT = 1
enums["MAV_STATE"][1] = EnumEntry("MAV_STATE_BOOT", """System is booting up.""")
MAV_STATE_CALIBRATING = 2
enums["MAV_STATE"][2] = EnumEntry("MAV_STATE_CALIBRATING", """System is calibrating and not flight-ready.""")
MAV_STATE_STANDBY = 3
enums["MAV_STATE"][3] = EnumEntry("MAV_STATE_STANDBY", """System is grounded and on standby. It can be launched any time.""")
MAV_STATE_ACTIVE = 4
enums["MAV_STATE"][4] = EnumEntry("MAV_STATE_ACTIVE", """System is active and might be already airborne. Motors are engaged.""")
MAV_STATE_CRITICAL = 5
enums["MAV_STATE"][5] = EnumEntry("MAV_STATE_CRITICAL", """System is in a non-normal flight mode (failsafe). It can however still navigate.""")
MAV_STATE_EMERGENCY = 6
enums["MAV_STATE"][6] = EnumEntry("MAV_STATE_EMERGENCY", """System is in a non-normal flight mode (failsafe). It lost control over parts or over the whole airframe. It is in mayday and going down.""")
MAV_STATE_POWEROFF = 7
enums["MAV_STATE"][7] = EnumEntry("MAV_STATE_POWEROFF", """System just initialized its power-down sequence, will shut down now.""")
MAV_STATE_FLIGHT_TERMINATION = 8
enums["MAV_STATE"][8] = EnumEntry("MAV_STATE_FLIGHT_TERMINATION", """System is terminating itself (failsafe or commanded).""")
MAV_STATE_ENUM_END = 9
enums["MAV_STATE"][9] = EnumEntry("MAV_STATE_ENUM_END", """""")

# MAV_COMPONENT
enums["MAV_COMPONENT"] = {}
MAV_COMP_ID_ALL = 0
enums["MAV_COMPONENT"][0] = EnumEntry("MAV_COMP_ID_ALL", """Target id (target_component) used to broadcast messages to all components of the receiving system. Components should attempt to process messages with this component ID and forward to components on any other interfaces. Note: This is not a valid *source* component id for a message.""")
MAV_COMP_ID_AUTOPILOT1 = 1
enums["MAV_COMPONENT"][1] = EnumEntry("MAV_COMP_ID_AUTOPILOT1", """System flight controller component ("autopilot"). Only one autopilot is expected in a particular system.""")
MAV_COMP_ID_GIMBAL = 154
enums["MAV_COMPONENT"][154] = EnumEntry("MAV_COMP_ID_GIMBAL", """Gimbal #1.""")
MAV_COMPONENT_ENUM_END = 155
enums["MAV_COMPONENT"][155] = EnumEntry("MAV_COMPONENT_ENUM_END", """""")

# MAV_MISSION_TYPE
enums["MAV_MISSION_TYPE"] = {}
MAV_MISSION_TYPE_MISSION = 0
enums["MAV_MISSION_TYPE"][0] = EnumEntry("MAV_MISSION_TYPE_MISSION", """Items are mission commands for main mission.""")
MAV_MISSION_TYPE_FENCE = 1
enums["MAV_MISSION_TYPE"][1] = EnumEntry("MAV_MISSION_TYPE_FENCE", """Specifies GeoFence area(s). Items are MAV_CMD_NAV_FENCE_ GeoFence items.""")
MAV_MISSION_TYPE_RALLY = 2
enums["MAV_MISSION_TYPE"][2] = EnumEntry("MAV_MISSION_TYPE_RALLY", """Specifies the rally points for the vehicle. Rally points are alternative RTL points. Items are MAV_CMD_NAV_RALLY_POINT rally point items.""")
MAV_MISSION_TYPE_ALL = 255
enums["MAV_MISSION_TYPE"][255] = EnumEntry("MAV_MISSION_TYPE_ALL", """Only used in MISSION_CLEAR_ALL to clear all mission types.""")
MAV_MISSION_TYPE_ENUM_END = 256
enums["MAV_MISSION_TYPE"][256] = EnumEntry("MAV_MISSION_TYPE_ENUM_END", """""")

# MAV_RESULT
enums["MAV_RESULT"] = {}
MAV_RESULT_ACCEPTED = 0
enums["MAV_RESULT"][0] = EnumEntry(
    "MAV_RESULT_ACCEPTED",
    """Command is valid (is supported and has valid parameters), and was
              executed.""",
)
MAV_RESULT_TEMPORARILY_REJECTED = 1
enums["MAV_RESULT"][1] = EnumEntry(
    "MAV_RESULT_TEMPORARILY_REJECTED",
    """Command is valid, but cannot be executed at this time. This is used to
              indicate a problem that should be fixed just by waiting (e.g. a state machine is
              busy, can't arm because have not got GPS lock, etc.). Retrying later should
              work.""",
)
MAV_RESULT_DENIED = 2
enums["MAV_RESULT"][2] = EnumEntry(
    "MAV_RESULT_DENIED",
    """Command is invalid (is supported but has invalid parameters). Retrying
              same command and parameters will not work.""",
)
MAV_RESULT_UNSUPPORTED = 3
enums["MAV_RESULT"][3] = EnumEntry("MAV_RESULT_UNSUPPORTED", """Command is not supported (unknown).""")
MAV_RESULT_FAILED = 4
enums["MAV_RESULT"][4] = EnumEntry(
    "MAV_RESULT_FAILED",
    """Command is valid, but execution has failed. This is used to indicate
              any non-temporary or unexpected problem, i.e. any problem that must be fixed
              before the command can succeed/be retried. For example, attempting to write a
              file when out of memory, attempting to arm when sensors are not calibrated, etc.""",
)
MAV_RESULT_IN_PROGRESS = 5
enums["MAV_RESULT"][5] = EnumEntry(
    "MAV_RESULT_IN_PROGRESS",
    """Command is valid and is being executed. This will be followed by
              further progress updates, i.e. the component may send further COMMAND_ACK
              messages with result MAV_RESULT_IN_PROGRESS (at a rate decided by the
              implementation), and must terminate by sending a COMMAND_ACK message with final
              result of the operation. The COMMAND_ACK.progress field can be used to indicate
              the progress of the operation.""",
)
MAV_RESULT_CANCELLED = 6
enums["MAV_RESULT"][6] = EnumEntry(
    "MAV_RESULT_CANCELLED",
    """Command has been cancelled (as a result of receiving a COMMAND_CANCEL
              message).""",
)
MAV_RESULT_ENUM_END = 7
enums["MAV_RESULT"][7] = EnumEntry("MAV_RESULT_ENUM_END", """""")

# MAV_FRAME
enums["MAV_FRAME"] = {}
MAV_FRAME_GLOBAL = 0
enums["MAV_FRAME"][0] = EnumEntry(
    "MAV_FRAME_GLOBAL",
    """Global (WGS84) coordinate frame + altitude relative to mean sea level
            (MSL).""",
)
MAV_FRAME_LOCAL_NED = 1
enums["MAV_FRAME"][1] = EnumEntry(
    "MAV_FRAME_LOCAL_NED",
    """NED local tangent frame (x: North, y: East, z: Down) with origin fixed
            relative to earth.""",
)
MAV_FRAME_ENUM_END = 2
enums["MAV_FRAME"][2] = EnumEntry("MAV_FRAME_ENUM_END", """""")

# GPS_FIX_TYPE
enums["GPS_FIX_TYPE"] = {}
GPS_FIX_TYPE_NO_GPS = 0
enums["GPS_FIX_TYPE"][0] = EnumEntry("GPS_FIX_TYPE_NO_GPS", """No GPS connected""")
GPS_FIX_TYPE_NO_FIX = 1
enums["GPS_FIX_TYPE"][1] = EnumEntry("GPS_FIX_TYPE_NO_FIX", """No position information, GPS is connected""")
GPS_FIX_TYPE_2D_FIX = 2
enums["GPS_FIX_TYPE"][2] = EnumEntry("GPS_FIX_TYPE_2D_FIX", """2D position""")
GPS_FIX_TYPE_3D_FIX = 3
enums["GPS_FIX_TYPE"][3] = EnumEntry("GPS_FIX_TYPE_3D_FIX", """3D position""")
GPS_FIX_TYPE_DGPS = 4
enums["GPS_FIX_TYPE"][4] = EnumEntry("GPS_FIX_TYPE_DGPS", """DGPS/SBAS aided 3D position""")
GPS_FIX_TYPE_RTK_FLOAT = 5
enums["GPS_FIX_TYPE"][5] = EnumEntry("GPS_FIX_TYPE_RTK_FLOAT", """RTK float, 3D position""")
GPS_FIX_TYPE_RTK_FIXED = 6
enums["GPS_FIX_TYPE"][6] = EnumEntry("GPS_FIX_TYPE_RTK_FIXED", """RTK Fixed, 3D position""")
GPS_FIX_TYPE_STATIC = 7
enums["GPS_FIX_TYPE"][7] = EnumEntry("GPS_FIX_TYPE_STATIC", """Static fixed, typically used for base stations""")
GPS_FIX_TYPE_PPP = 8
enums["GPS_FIX_TYPE"][8] = EnumEntry("GPS_FIX_TYPE_PPP", """PPP, 3D position.""")
GPS_FIX_TYPE_ENUM_END = 9
enums["GPS_FIX_TYPE"][9] = EnumEntry("GPS_FIX_TYPE_ENUM_END", """""")

# message IDs
MAVLINK_MSG_ID_BAD_DATA = -1
MAVLINK_MSG_ID_UNKNOWN = -2
MAVLINK_MSG_ID_HEARTBEAT = 0
MAVLINK_MSG_ID_CHANGE_OPERATOR_CONTROL = 5
MAVLINK_MSG_ID_CHANGE_OPERATOR_CONTROL_ACK = 6
MAVLINK_MSG_ID_GPS_RAW_INT = 24
MAVLINK_MSG_ID_MISSION_ITEM = 39
MAVLINK_MSG_ID_COMMAND_INT = 75
MAVLINK_MSG_ID_COMMAND_LONG = 76
MAVLINK_MSG_ID_COMMAND_ACK = 77
MAVLINK_MSG_ID_COMMAND_CANCEL = 80
MAVLINK_MSG_ID_FILE_TRANSFER_PROTOCOL = 110
MAVLINK_MSG_ID_TIMESYNC = 111
MAVLINK_MSG_ID_MESSAGE_INTERVAL = 244
MAVLINK_MSG_ID_NAMED_VALUE_FLOAT = 251
MAVLINK_MSG_ID_NAMED_VALUE_INT = 252
MAVLINK_MSG_ID_STATUSTEXT = 253


class MAVLink_heartbeat_message(MAVLink_message):
    """
    The heartbeat message shows that a system or component is present
    and responding. The type and autopilot fields (along with the
    message component id), allow the receiving system to treat further
    messages from this system appropriately (e.g. by laying out the
    user interface based on the autopilot). This microservice is
    documented at https://mavlink.io/en/services/heartbeat.html
    """

    id = MAVLINK_MSG_ID_HEARTBEAT
    msgname = "HEARTBEAT"
    fieldnames = ["type", "autopilot", "base_mode", "custom_mode", "system_status", "mavlink_version"]
    ordered_fieldnames = ["custom_mode", "type", "autopilot", "base_mode", "system_status", "mavlink_version"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint32_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name = {"base_mode": "bitmask"}
    fieldenums_by_name = {"type": "MAV_TYPE", "autopilot": "MAV_AUTOPILOT", "base_mode": "MAV_MODE_FLAG", "system_status": "MAV_STATE"}
    fieldunits_by_name = {}
    native_format = bytearray(b"<IBBBBB")
    orders = [1, 2, 3, 0, 4, 5]
    lengths = [1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0]
    crc_extra = 50
    unpacker = struct.Struct("<IBBBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, type, autopilot, base_mode, custom_mode, system_status, mavlink_version):
        MAVLink_message.__init__(self, MAVLink_heartbeat_message.id, MAVLink_heartbeat_message.msgname)
        self._fieldnames = MAVLink_heartbeat_message.fieldnames
        self._instance_field = MAVLink_heartbeat_message.instance_field
        self._instance_offset = MAVLink_heartbeat_message.instance_offset
        self.type = type
        self.autopilot = autopilot
        self.base_mode = base_mode
        self.custom_mode = custom_mode
        self.system_status = system_status
        self.mavlink_version = mavlink_version

    def pack(self, mav, force_mavlink1=False):
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.custom_mode, self.type, self.autopilot, self.base_mode, self.system_status, self.mavlink_version), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_heartbeat_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_change_operator_control_message(MAVLink_message):
    """
    Request to control this MAV
    """

    id = MAVLINK_MSG_ID_CHANGE_OPERATOR_CONTROL
    msgname = "CHANGE_OPERATOR_CONTROL"
    fieldnames = ["target_system", "control_request", "version", "passkey"]
    ordered_fieldnames = ["target_system", "control_request", "version", "passkey"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "char"]
    fielddisplays_by_name = {}
    fieldenums_by_name = {}
    fieldunits_by_name = {"version": "rad"}
    native_format = bytearray(b"<BBBc")
    orders = [0, 1, 2, 3]
    lengths = [1, 1, 1, 1]
    array_lengths = [0, 0, 0, 25]
    crc_extra = 217
    unpacker = struct.Struct("<BBB25s")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system, control_request, version, passkey):
        MAVLink_message.__init__(self, MAVLink_change_operator_control_message.id, MAVLink_change_operator_control_message.msgname)
        self._fieldnames = MAVLink_change_operator_control_message.fieldnames
        self._instance_field = MAVLink_change_operator_control_message.instance_field
        self._instance_offset = MAVLink_change_operator_control_message.instance_offset
        self.target_system = target_system
        self.control_request = control_request
        self.version = version
        self._passkey_raw = passkey
        self.passkey = passkey.split(b"\x00", 1)[0].decode("ascii", errors="replace")

    def pack(self, mav, force_mavlink1=False):
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.target_system, self.control_request, self.version, self._passkey_raw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_change_operator_control_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_change_operator_control_ack_message(MAVLink_message):
    """
    Accept / deny control of this MAV
    """

    id = MAVLINK_MSG_ID_CHANGE_OPERATOR_CONTROL_ACK
    msgname = "CHANGE_OPERATOR_CONTROL_ACK"
    fieldnames = ["gcs_system_id", "control_request", "ack"]
    ordered_fieldnames = ["gcs_system_id", "control_request", "ack"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name = {}
    fieldenums_by_name = {}
    fieldunits_by_name = {}
    native_format = bytearray(b"<BBB")
    orders = [0, 1, 2]
    lengths = [1, 1, 1]
    array_lengths = [0, 0, 0]
    crc_extra = 104
    unpacker = struct.Struct("<BBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, gcs_system_id, control_request, ack):
        MAVLink_message.__init__(self, MAVLink_change_operator_control_ack_message.id, MAVLink_change_operator_control_ack_message.msgname)
        self._fieldnames = MAVLink_change_operator_control_ack_message.fieldnames
        self._instance_field = MAVLink_change_operator_control_ack_message.instance_field
        self._instance_offset = MAVLink_change_operator_control_ack_message.instance_offset
        self.gcs_system_id = gcs_system_id
        self.control_request = control_request
        self.ack = ack

    def pack(self, mav, force_mavlink1=False):
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.gcs_system_id, self.control_request, self.ack), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_change_operator_control_ack_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_gps_raw_int_message(MAVLink_message):
    """
    The global position, as returned by the Global Positioning System
    (GPS).           This is           NOT the global position
    estimate of the system, but rather a RAW sensor value. See
    message GLOBAL_POSITION_INT for the global position estimate.
    """

    id = MAVLINK_MSG_ID_GPS_RAW_INT
    msgname = "GPS_RAW_INT"
    fieldnames = ["time_usec", "fix_type", "lat", "lon", "alt", "eph", "epv", "vel", "cog", "satellites_visible"]
    ordered_fieldnames = ["time_usec", "lat", "lon", "alt", "eph", "epv", "vel", "cog", "fix_type", "satellites_visible"]
    fieldtypes = ["uint64_t", "uint8_t", "int32_t", "int32_t", "int32_t", "uint16_t", "uint16_t", "uint16_t", "uint16_t", "uint8_t"]
    fielddisplays_by_name = {}
    fieldenums_by_name = {"fix_type": "GPS_FIX_TYPE"}
    fieldunits_by_name = {"time_usec": "us", "lat": "degE7", "lon": "degE7", "alt": "mm", "vel": "cm/s", "cog": "cdeg"}
    native_format = bytearray(b"<QiiiHHHHBB")
    orders = [0, 8, 1, 2, 3, 4, 5, 6, 7, 9]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 24
    unpacker = struct.Struct("<QiiiHHHHBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, time_usec, fix_type, lat, lon, alt, eph, epv, vel, cog, satellites_visible):
        MAVLink_message.__init__(self, MAVLink_gps_raw_int_message.id, MAVLink_gps_raw_int_message.msgname)
        self._fieldnames = MAVLink_gps_raw_int_message.fieldnames
        self._instance_field = MAVLink_gps_raw_int_message.instance_field
        self._instance_offset = MAVLink_gps_raw_int_message.instance_offset
        self.time_usec = time_usec
        self.fix_type = fix_type
        self.lat = lat
        self.lon = lon
        self.alt = alt
        self.eph = eph
        self.epv = epv
        self.vel = vel
        self.cog = cog
        self.satellites_visible = satellites_visible

    def pack(self, mav, force_mavlink1=False):
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_usec, self.lat, self.lon, self.alt, self.eph, self.epv, self.vel, self.cog, self.fix_type, self.satellites_visible), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_gps_raw_int_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_mission_item_message(MAVLink_message):
    """
    Message encoding a mission item. This message is emitted to
    announce           the presence of a mission item and to set a
    mission item on the system. The mission           item can be
    either in x, y, z meters (type: LOCAL) or x:lat, y:lon,
    z:altitude.           Local frame is Z-down, right handed (NED),
    global frame is Z-up, right handed (ENU).           NaN may be
    used to indicate an optional/default value (e.g. to use the
    system's           current latitude or yaw rather than a specific
    value). See also
    https://mavlink.io/en/services/mission.html.
    """

    id = MAVLINK_MSG_ID_MISSION_ITEM
    msgname = "MISSION_ITEM"
    fieldnames = ["target_system", "target_component", "seq", "frame", "command", "current", "autocontinue", "param1", "param2", "param3", "param4", "x", "y", "z"]
    ordered_fieldnames = ["param1", "param2", "param3", "param4", "x", "y", "z", "seq", "command", "target_system", "target_component", "frame", "current", "autocontinue"]
    fieldtypes = ["uint8_t", "uint8_t", "uint16_t", "uint8_t", "uint16_t", "uint8_t", "uint8_t", "float", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name = {}
    fieldenums_by_name = {"frame": "MAV_FRAME", "command": "MAV_CMD"}
    fieldunits_by_name = {}
    native_format = bytearray(b"<fffffffHHBBBBB")
    orders = [9, 10, 7, 11, 8, 12, 13, 0, 1, 2, 3, 4, 5, 6]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 254
    unpacker = struct.Struct("<fffffffHHBBBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system, target_component, seq, frame, command, current, autocontinue, param1, param2, param3, param4, x, y, z):
        MAVLink_message.__init__(self, MAVLink_mission_item_message.id, MAVLink_mission_item_message.msgname)
        self._fieldnames = MAVLink_mission_item_message.fieldnames
        self._instance_field = MAVLink_mission_item_message.instance_field
        self._instance_offset = MAVLink_mission_item_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.seq = seq
        self.frame = frame
        self.command = command
        self.current = current
        self.autocontinue = autocontinue
        self.param1 = param1
        self.param2 = param2
        self.param3 = param3
        self.param4 = param4
        self.x = x
        self.y = y
        self.z = z

    def pack(self, mav, force_mavlink1=False):
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.param1, self.param2, self.param3, self.param4, self.x, self.y, self.z, self.seq, self.command, self.target_system, self.target_component, self.frame, self.current, self.autocontinue), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_mission_item_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_command_int_message(MAVLink_message):
    """
    Send a command with up to seven parameters to the MAV, where
    params 5 and 6 are integers and the other values are floats. This
    is preferred over COMMAND_LONG as it allows the MAV_FRAME to be
    specified for interpreting positional information, such as
    altitude. COMMAND_INT is also preferred when sending latitude and
    longitude data in params 5 and 6, as it allows for greater
    precision. Param 5 and 6 encode positional data as scaled
    integers, where the scaling depends on the actual command value.
    NaN or INT32_MAX may be used in float/integer params
    (respectively) to indicate optional/default values (e.g. to use
    the component's current latitude, yaw rather than a specific
    value). The command microservice is documented at
    https://mavlink.io/en/services/command.html
    """

    id = MAVLINK_MSG_ID_COMMAND_INT
    msgname = "COMMAND_INT"
    fieldnames = ["target_system", "target_component", "frame", "command", "current", "autocontinue", "param1", "param2", "param3", "param4", "x", "y", "z"]
    ordered_fieldnames = ["param1", "param2", "param3", "param4", "x", "y", "z", "command", "target_system", "target_component", "frame", "current", "autocontinue"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint16_t", "uint8_t", "uint8_t", "float", "float", "float", "float", "int32_t", "int32_t", "float"]
    fielddisplays_by_name = {}
    fieldenums_by_name = {"frame": "MAV_FRAME", "command": "MAV_CMD"}
    fieldunits_by_name = {}
    native_format = bytearray(b"<ffffiifHBBBBB")
    orders = [8, 9, 10, 7, 11, 12, 0, 1, 2, 3, 4, 5, 6]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 158
    unpacker = struct.Struct("<ffffiifHBBBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system, target_component, frame, command, current, autocontinue, param1, param2, param3, param4, x, y, z):
        MAVLink_message.__init__(self, MAVLink_command_int_message.id, MAVLink_command_int_message.msgname)
        self._fieldnames = MAVLink_command_int_message.fieldnames
        self._instance_field = MAVLink_command_int_message.instance_field
        self._instance_offset = MAVLink_command_int_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.frame = frame
        self.command = command
        self.current = current
        self.autocontinue = autocontinue
        self.param1 = param1
        self.param2 = param2
        self.param3 = param3
        self.param4 = param4
        self.x = x
        self.y = y
        self.z = z

    def pack(self, mav, force_mavlink1=False):
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.param1, self.param2, self.param3, self.param4, self.x, self.y, self.z, self.command, self.target_system, self.target_component, self.frame, self.current, self.autocontinue), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_command_int_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_command_long_message(MAVLink_message):
    """
    Send a command with up to seven parameters to the MAV. COMMAND_INT
    is generally preferred when sending MAV_CMD commands that include
    positional information; it offers higher precision and allows the
    MAV_FRAME to be specified (which may otherwise be ambiguous,
    particularly for altitude). The command microservice is documented
    at https://mavlink.io/en/services/command.html
    """

    id = MAVLINK_MSG_ID_COMMAND_LONG
    msgname = "COMMAND_LONG"
    fieldnames = ["target_system", "target_component", "command", "confirmation", "param1", "param2", "param3", "param4", "param5", "param6", "param7"]
    ordered_fieldnames = ["param1", "param2", "param3", "param4", "param5", "param6", "param7", "command", "target_system", "target_component", "confirmation"]
    fieldtypes = ["uint8_t", "uint8_t", "uint16_t", "uint8_t", "float", "float", "float", "float", "float", "float", "float"]
    fielddisplays_by_name = {}
    fieldenums_by_name = {"command": "MAV_CMD"}
    fieldunits_by_name = {}
    native_format = bytearray(b"<fffffffHBBB")
    orders = [8, 9, 7, 10, 0, 1, 2, 3, 4, 5, 6]
    lengths = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
    array_lengths = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    crc_extra = 152
    unpacker = struct.Struct("<fffffffHBBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system, target_component, command, confirmation, param1, param2, param3, param4, param5, param6, param7):
        MAVLink_message.__init__(self, MAVLink_command_long_message.id, MAVLink_command_long_message.msgname)
        self._fieldnames = MAVLink_command_long_message.fieldnames
        self._instance_field = MAVLink_command_long_message.instance_field
        self._instance_offset = MAVLink_command_long_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.command = command
        self.confirmation = confirmation
        self.param1 = param1
        self.param2 = param2
        self.param3 = param3
        self.param4 = param4
        self.param5 = param5
        self.param6 = param6
        self.param7 = param7

    def pack(self, mav, force_mavlink1=False):
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.param1, self.param2, self.param3, self.param4, self.param5, self.param6, self.param7, self.command, self.target_system, self.target_component, self.confirmation), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_command_long_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_command_ack_message(MAVLink_message):
    """
    Report status of a command. Includes feedback whether the command
    was         executed. The command microservice is documented at
    https://mavlink.io/en/services/command.html
    """

    id = MAVLINK_MSG_ID_COMMAND_ACK
    msgname = "COMMAND_ACK"
    fieldnames = ["command", "result"]
    ordered_fieldnames = ["command", "result"]
    fieldtypes = ["uint16_t", "uint8_t"]
    fielddisplays_by_name = {}
    fieldenums_by_name = {"command": "MAV_CMD", "result": "MAV_RESULT"}
    fieldunits_by_name = {}
    native_format = bytearray(b"<HB")
    orders = [0, 1]
    lengths = [1, 1]
    array_lengths = [0, 0]
    crc_extra = 143
    unpacker = struct.Struct("<HB")
    instance_field = None
    instance_offset = -1

    def __init__(self, command, result):
        MAVLink_message.__init__(self, MAVLink_command_ack_message.id, MAVLink_command_ack_message.msgname)
        self._fieldnames = MAVLink_command_ack_message.fieldnames
        self._instance_field = MAVLink_command_ack_message.instance_field
        self._instance_offset = MAVLink_command_ack_message.instance_offset
        self.command = command
        self.result = result

    def pack(self, mav, force_mavlink1=False):
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.command, self.result), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_command_ack_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_command_cancel_message(MAVLink_message):
    """
    Cancel a long running command. The target system should respond
    with a       COMMAND_ACK to the original command with
    result=MAV_RESULT_CANCELLED if the long       running process was
    cancelled. If it has already completed, the cancel action can be
    ignored. The cancel action can be retried until some sort of
    acknowledgement to the       original command has been received.
    The command microservice is documented at
    https://mavlink.io/en/services/command.html
    """

    id = MAVLINK_MSG_ID_COMMAND_CANCEL
    msgname = "COMMAND_CANCEL"
    fieldnames = ["target_system", "target_component", "command"]
    ordered_fieldnames = ["command", "target_system", "target_component"]
    fieldtypes = ["uint8_t", "uint8_t", "uint16_t"]
    fielddisplays_by_name = {}
    fieldenums_by_name = {"command": "MAV_CMD"}
    fieldunits_by_name = {}
    native_format = bytearray(b"<HBB")
    orders = [1, 2, 0]
    lengths = [1, 1, 1]
    array_lengths = [0, 0, 0]
    crc_extra = 14
    unpacker = struct.Struct("<HBB")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_system, target_component, command):
        MAVLink_message.__init__(self, MAVLink_command_cancel_message.id, MAVLink_command_cancel_message.msgname)
        self._fieldnames = MAVLink_command_cancel_message.fieldnames
        self._instance_field = MAVLink_command_cancel_message.instance_field
        self._instance_offset = MAVLink_command_cancel_message.instance_offset
        self.target_system = target_system
        self.target_component = target_component
        self.command = command

    def pack(self, mav, force_mavlink1=False):
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.command, self.target_system, self.target_component), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_command_cancel_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_file_transfer_protocol_message(MAVLink_message):
    """
    File transfer protocol message:
    https://mavlink.io/en/services/ftp.html.
    """

    id = MAVLINK_MSG_ID_FILE_TRANSFER_PROTOCOL
    msgname = "FILE_TRANSFER_PROTOCOL"
    fieldnames = ["target_network", "target_system", "target_component", "payload"]
    ordered_fieldnames = ["target_network", "target_system", "target_component", "payload"]
    fieldtypes = ["uint8_t", "uint8_t", "uint8_t", "uint8_t"]
    fielddisplays_by_name = {}
    fieldenums_by_name = {}
    fieldunits_by_name = {}
    native_format = bytearray(b"<BBBB")
    orders = [0, 1, 2, 3]
    lengths = [1, 1, 1, 251]
    array_lengths = [0, 0, 0, 251]
    crc_extra = 84
    unpacker = struct.Struct("<BBB251B")
    instance_field = None
    instance_offset = -1

    def __init__(self, target_network, target_system, target_component, payload):
        MAVLink_message.__init__(self, MAVLink_file_transfer_protocol_message.id, MAVLink_file_transfer_protocol_message.msgname)
        self._fieldnames = MAVLink_file_transfer_protocol_message.fieldnames
        self._instance_field = MAVLink_file_transfer_protocol_message.instance_field
        self._instance_offset = MAVLink_file_transfer_protocol_message.instance_offset
        self.target_network = target_network
        self.target_system = target_system
        self.target_component = target_component
        self.payload = payload

    def pack(self, mav, force_mavlink1=False):
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.target_network, self.target_system, self.target_component, self.payload[0], self.payload[1], self.payload[2], self.payload[3], self.payload[4], self.payload[5], self.payload[6], self.payload[7], self.payload[8], self.payload[9], self.payload[10], self.payload[11], self.payload[12], self.payload[13], self.payload[14], self.payload[15], self.payload[16], self.payload[17], self.payload[18], self.payload[19], self.payload[20], self.payload[21], self.payload[22], self.payload[23], self.payload[24], self.payload[25], self.payload[26], self.payload[27], self.payload[28], self.payload[29], self.payload[30], self.payload[31], self.payload[32], self.payload[33], self.payload[34], self.payload[35], self.payload[36], self.payload[37], self.payload[38], self.payload[39], self.payload[40], self.payload[41], self.payload[42], self.payload[43], self.payload[44], self.payload[45], self.payload[46], self.payload[47], self.payload[48], self.payload[49], self.payload[50], self.payload[51], self.payload[52], self.payload[53], self.payload[54], self.payload[55], self.payload[56], self.payload[57], self.payload[58], self.payload[59], self.payload[60], self.payload[61], self.payload[62], self.payload[63], self.payload[64], self.payload[65], self.payload[66], self.payload[67], self.payload[68], self.payload[69], self.payload[70], self.payload[71], self.payload[72], self.payload[73], self.payload[74], self.payload[75], self.payload[76], self.payload[77], self.payload[78], self.payload[79], self.payload[80], self.payload[81], self.payload[82], self.payload[83], self.payload[84], self.payload[85], self.payload[86], self.payload[87], self.payload[88], self.payload[89], self.payload[90], self.payload[91], self.payload[92], self.payload[93], self.payload[94], self.payload[95], self.payload[96], self.payload[97], self.payload[98], self.payload[99], self.payload[100], self.payload[101], self.payload[102], self.payload[103], self.payload[104], self.payload[105], self.payload[106], self.payload[107], self.payload[108], self.payload[109], self.payload[110], self.payload[111], self.payload[112], self.payload[113], self.payload[114], self.payload[115], self.payload[116], self.payload[117], self.payload[118], self.payload[119], self.payload[120], self.payload[121], self.payload[122], self.payload[123], self.payload[124], self.payload[125], self.payload[126], self.payload[127], self.payload[128], self.payload[129], self.payload[130], self.payload[131], self.payload[132], self.payload[133], self.payload[134], self.payload[135], self.payload[136], self.payload[137], self.payload[138], self.payload[139], self.payload[140], self.payload[141], self.payload[142], self.payload[143], self.payload[144], self.payload[145], self.payload[146], self.payload[147], self.payload[148], self.payload[149], self.payload[150], self.payload[151], self.payload[152], self.payload[153], self.payload[154], self.payload[155], self.payload[156], self.payload[157], self.payload[158], self.payload[159], self.payload[160], self.payload[161], self.payload[162], self.payload[163], self.payload[164], self.payload[165], self.payload[166], self.payload[167], self.payload[168], self.payload[169], self.payload[170], self.payload[171], self.payload[172], self.payload[173], self.payload[174], self.payload[175], self.payload[176], self.payload[177], self.payload[178], self.payload[179], self.payload[180], self.payload[181], self.payload[182], self.payload[183], self.payload[184], self.payload[185], self.payload[186], self.payload[187], self.payload[188], self.payload[189], self.payload[190], self.payload[191], self.payload[192], self.payload[193], self.payload[194], self.payload[195], self.payload[196], self.payload[197], self.payload[198], self.payload[199], self.payload[200], self.payload[201], self.payload[202], self.payload[203], self.payload[204], self.payload[205], self.payload[206], self.payload[207], self.payload[208], self.payload[209], self.payload[210], self.payload[211], self.payload[212], self.payload[213], self.payload[214], self.payload[215], self.payload[216], self.payload[217], self.payload[218], self.payload[219], self.payload[220], self.payload[221], self.payload[222], self.payload[223], self.payload[224], self.payload[225], self.payload[226], self.payload[227], self.payload[228], self.payload[229], self.payload[230], self.payload[231], self.payload[232], self.payload[233], self.payload[234], self.payload[235], self.payload[236], self.payload[237], self.payload[238], self.payload[239], self.payload[240], self.payload[241], self.payload[242], self.payload[243], self.payload[244], self.payload[245], self.payload[246], self.payload[247], self.payload[248], self.payload[249], self.payload[250]), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_file_transfer_protocol_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_timesync_message(MAVLink_message):
    """
    Time synchronization message.     The message is used for both
    timesync requests and responses.     The request is sent with
    `ts1=syncing component timestamp` and `tc1=0`, and may be
    broadcast or targeted to a specific system/component.     The
    response is sent with `ts1=syncing component timestamp` (mirror
    back unchanged), and `tc1=responding component timestamp`, with
    the `target_system` and `target_component` set to ids of the
    original request.     Systems can determine if they are receiving
    a request or response based on the value of `tc`.     If the
    response has `target_system==target_component==0` the remote
    system has not been updated to use the component IDs and cannot
    reliably timesync; the requestor may report an error.
    Timestamps are UNIX Epoch time or time since system boot in
    nanoseconds (the timestamp format can be inferred by checking for
    the magnitude of the number; generally it doesn't matter as only
    the offset is used).     The message sequence is repeated numerous
    times with results being filtered/averaged to estimate the offset.
    """

    id = MAVLINK_MSG_ID_TIMESYNC
    msgname = "TIMESYNC"
    fieldnames = ["tc1", "ts1"]
    ordered_fieldnames = ["tc1", "ts1"]
    fieldtypes = ["int64_t", "int64_t"]
    fielddisplays_by_name = {}
    fieldenums_by_name = {}
    fieldunits_by_name = {"tc1": "ns", "ts1": "ns"}
    native_format = bytearray(b"<qq")
    orders = [0, 1]
    lengths = [1, 1]
    array_lengths = [0, 0]
    crc_extra = 34
    unpacker = struct.Struct("<qq")
    instance_field = None
    instance_offset = -1

    def __init__(self, tc1, ts1):
        MAVLink_message.__init__(self, MAVLink_timesync_message.id, MAVLink_timesync_message.msgname)
        self._fieldnames = MAVLink_timesync_message.fieldnames
        self._instance_field = MAVLink_timesync_message.instance_field
        self._instance_offset = MAVLink_timesync_message.instance_offset
        self.tc1 = tc1
        self.ts1 = ts1

    def pack(self, mav, force_mavlink1=False):
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.tc1, self.ts1), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_timesync_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_message_interval_message(MAVLink_message):
    """
    The interval between messages for a particular MAVLink message ID.
    This message is sent in response to the MAV_CMD_REQUEST_MESSAGE
    command with param1=244 (this message) and param2=message_id (the
    id of the message for which the interval is required).         It
    may also be sent in response to MAV_CMD_GET_MESSAGE_INTERVAL.
    This interface replaces DATA_STREAM.
    """

    id = MAVLINK_MSG_ID_MESSAGE_INTERVAL
    msgname = "MESSAGE_INTERVAL"
    fieldnames = ["message_id", "interval_us"]
    ordered_fieldnames = ["interval_us", "message_id"]
    fieldtypes = ["uint16_t", "int32_t"]
    fielddisplays_by_name = {}
    fieldenums_by_name = {}
    fieldunits_by_name = {"interval_us": "us"}
    native_format = bytearray(b"<iH")
    orders = [1, 0]
    lengths = [1, 1]
    array_lengths = [0, 0]
    crc_extra = 95
    unpacker = struct.Struct("<iH")
    instance_field = None
    instance_offset = -1

    def __init__(self, message_id, interval_us):
        MAVLink_message.__init__(self, MAVLink_message_interval_message.id, MAVLink_message_interval_message.msgname)
        self._fieldnames = MAVLink_message_interval_message.fieldnames
        self._instance_field = MAVLink_message_interval_message.instance_field
        self._instance_offset = MAVLink_message_interval_message.instance_offset
        self.message_id = message_id
        self.interval_us = interval_us

    def pack(self, mav, force_mavlink1=False):
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.interval_us, self.message_id), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_message_interval_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_named_value_float_message(MAVLink_message):
    """
    Send a key-value pair as float. The use of this message is
    discouraged for normal packets, but a quite efficient way for
    testing new messages and getting experimental debug output.
    """

    id = MAVLINK_MSG_ID_NAMED_VALUE_FLOAT
    msgname = "NAMED_VALUE_FLOAT"
    fieldnames = ["time_boot_ms", "name", "value"]
    ordered_fieldnames = ["time_boot_ms", "value", "name"]
    fieldtypes = ["uint32_t", "char", "float"]
    fielddisplays_by_name = {}
    fieldenums_by_name = {}
    fieldunits_by_name = {"time_boot_ms": "ms"}
    native_format = bytearray(b"<Ifc")
    orders = [0, 2, 1]
    lengths = [1, 1, 1]
    array_lengths = [0, 0, 10]
    crc_extra = 170
    unpacker = struct.Struct("<If10s")
    instance_field = "name"
    instance_offset = 8

    def __init__(self, time_boot_ms, name, value):
        MAVLink_message.__init__(self, MAVLink_named_value_float_message.id, MAVLink_named_value_float_message.msgname)
        self._fieldnames = MAVLink_named_value_float_message.fieldnames
        self._instance_field = MAVLink_named_value_float_message.instance_field
        self._instance_offset = MAVLink_named_value_float_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self._name_raw = name
        self.name = name.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self.value = value

    def pack(self, mav, force_mavlink1=False):
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.value, self._name_raw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_named_value_float_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_named_value_int_message(MAVLink_message):
    """
    Send a key-value pair as integer. The use of this message is
    discouraged for normal packets, but a quite efficient way for
    testing new messages and getting experimental debug output.
    """

    id = MAVLINK_MSG_ID_NAMED_VALUE_INT
    msgname = "NAMED_VALUE_INT"
    fieldnames = ["time_boot_ms", "name", "value"]
    ordered_fieldnames = ["time_boot_ms", "value", "name"]
    fieldtypes = ["uint32_t", "char", "int32_t"]
    fielddisplays_by_name = {}
    fieldenums_by_name = {}
    fieldunits_by_name = {"time_boot_ms": "ms"}
    native_format = bytearray(b"<Iic")
    orders = [0, 2, 1]
    lengths = [1, 1, 1]
    array_lengths = [0, 0, 10]
    crc_extra = 44
    unpacker = struct.Struct("<Ii10s")
    instance_field = "name"
    instance_offset = 8

    def __init__(self, time_boot_ms, name, value):
        MAVLink_message.__init__(self, MAVLink_named_value_int_message.id, MAVLink_named_value_int_message.msgname)
        self._fieldnames = MAVLink_named_value_int_message.fieldnames
        self._instance_field = MAVLink_named_value_int_message.instance_field
        self._instance_offset = MAVLink_named_value_int_message.instance_offset
        self.time_boot_ms = time_boot_ms
        self._name_raw = name
        self.name = name.split(b"\x00", 1)[0].decode("ascii", errors="replace")
        self.value = value

    def pack(self, mav, force_mavlink1=False):
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.time_boot_ms, self.value, self._name_raw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_named_value_int_message, "name", mavlink_msg_deprecated_name_property())


class MAVLink_statustext_message(MAVLink_message):
    """
    Status text message. These messages are printed in yellow in the
    COMM console of QGroundControl. WARNING: They consume quite some
    bandwidth, so use only for important status and error messages. If
    implemented wisely, these messages are buffered on the MCU and
    sent only at a limited rate (e.g. 10 Hz).
    """

    id = MAVLINK_MSG_ID_STATUSTEXT
    msgname = "STATUSTEXT"
    fieldnames = ["severity", "text"]
    ordered_fieldnames = ["severity", "text"]
    fieldtypes = ["uint8_t", "char"]
    fielddisplays_by_name = {}
    fieldenums_by_name = {"severity": "MAV_SEVERITY"}
    fieldunits_by_name = {}
    native_format = bytearray(b"<Bc")
    orders = [0, 1]
    lengths = [1, 1]
    array_lengths = [0, 50]
    crc_extra = 83
    unpacker = struct.Struct("<B50s")
    instance_field = None
    instance_offset = -1

    def __init__(self, severity, text):
        MAVLink_message.__init__(self, MAVLink_statustext_message.id, MAVLink_statustext_message.msgname)
        self._fieldnames = MAVLink_statustext_message.fieldnames
        self._instance_field = MAVLink_statustext_message.instance_field
        self._instance_offset = MAVLink_statustext_message.instance_offset
        self.severity = severity
        self._text_raw = text
        self.text = text.split(b"\x00", 1)[0].decode("ascii", errors="replace")

    def pack(self, mav, force_mavlink1=False):
        return self._pack(mav, self.crc_extra, self.unpacker.pack(self.severity, self._text_raw), force_mavlink1=force_mavlink1)


# Define name on the class for backwards compatibility (it is now msgname).
# Done with setattr to hide the class variable from mypy.
setattr(MAVLink_statustext_message, "name", mavlink_msg_deprecated_name_property())


mavlink_map = {
    MAVLINK_MSG_ID_HEARTBEAT: MAVLink_heartbeat_message,
    MAVLINK_MSG_ID_CHANGE_OPERATOR_CONTROL: MAVLink_change_operator_control_message,
    MAVLINK_MSG_ID_CHANGE_OPERATOR_CONTROL_ACK: MAVLink_change_operator_control_ack_message,
    MAVLINK_MSG_ID_GPS_RAW_INT: MAVLink_gps_raw_int_message,
    MAVLINK_MSG_ID_MISSION_ITEM: MAVLink_mission_item_message,
    MAVLINK_MSG_ID_COMMAND_INT: MAVLink_command_int_message,
    MAVLINK_MSG_ID_COMMAND_LONG: MAVLink_command_long_message,
    MAVLINK_MSG_ID_COMMAND_ACK: MAVLink_command_ack_message,
    MAVLINK_MSG_ID_COMMAND_CANCEL: MAVLink_command_cancel_message,
    MAVLINK_MSG_ID_FILE_TRANSFER_PROTOCOL: MAVLink_file_transfer_protocol_message,
    MAVLINK_MSG_ID_TIMESYNC: MAVLink_timesync_message,
    MAVLINK_MSG_ID_MESSAGE_INTERVAL: MAVLink_message_interval_message,
    MAVLINK_MSG_ID_NAMED_VALUE_FLOAT: MAVLink_named_value_float_message,
    MAVLINK_MSG_ID_NAMED_VALUE_INT: MAVLink_named_value_int_message,
    MAVLINK_MSG_ID_STATUSTEXT: MAVLink_statustext_message,
}


class MAVError(Exception):
    """MAVLink error class"""

    def __init__(self, msg):
        Exception.__init__(self, msg)
        self.message = msg


class MAVLink_bad_data(MAVLink_message):
    """
    a piece of bad data in a mavlink stream
    """

    def __init__(self, data, reason):
        MAVLink_message.__init__(self, MAVLINK_MSG_ID_BAD_DATA, "BAD_DATA")
        self._fieldnames = ["data", "reason"]
        self.data = data
        self.reason = reason
        self._msgbuf = bytearray(data)
        self._instance_field = None

    def __str__(self):
        """Override the __str__ function from MAVLink_messages because non-printable characters are common in to be the reason for this message to exist."""
        if sys.version_info[0] == 2:
            hexstr = ["{:x}".format(ord(i)) for i in self.data]
        else:
            hexstr = ["{:x}".format(i) for i in self.data]
        return "%s {%s, data:%s}" % (self._type, self.reason, hexstr)


class MAVLink_unknown(MAVLink_message):
    """
    a message that we don't have in the XML used when built
    """

    def __init__(self, msgid, data):
        MAVLink_message.__init__(self, MAVLINK_MSG_ID_UNKNOWN, "UNKNOWN_%u" % msgid)
        self._fieldnames = ["data"]
        self.data = data
        self._msgbuf = bytearray(data)
        self._instance_field = None

    def __str__(self):
        """Override the __str__ function from MAVLink_messages because non-printable characters are common."""
        if sys.version_info[0] == 2:
            hexstr = ["{:x}".format(ord(i)) for i in self.data]
        else:
            hexstr = ["{:x}".format(i) for i in self.data]
        return "%s {data:%s}" % (self._type, hexstr)


class MAVLinkSigning(object):
    """MAVLink signing state class"""

    def __init__(self):
        self.secret_key = None
        self.timestamp = 0
        self.link_id = 0
        self.sign_outgoing = False
        self.allow_unsigned_callback = None
        self.stream_timestamps = {}
        self.sig_count = 0
        self.badsig_count = 0
        self.goodsig_count = 0
        self.unsigned_count = 0
        self.reject_count = 0


class MAVLink(object):
    """MAVLink protocol handling class"""

    def __init__(self, file, srcSystem=0, srcComponent=0, use_native=False):
        self.seq = 0
        self.file = file
        self.srcSystem = srcSystem
        self.srcComponent = srcComponent
        self.callback = None
        self.callback_args = None
        self.callback_kwargs = None
        self.send_callback = None
        self.send_callback_args = None
        self.send_callback_kwargs = None
        self.buf = bytearray()
        self.buf_index = 0
        self.expected_length = HEADER_LEN_V1 + 2
        self.have_prefix_error = False
        self.robust_parsing = False
        self.protocol_marker = 254
        self.little_endian = True
        self.crc_extra = True
        self.sort_fields = True
        self.total_packets_sent = 0
        self.total_bytes_sent = 0
        self.total_packets_received = 0
        self.total_bytes_received = 0
        self.total_receive_errors = 0
        self.startup_time = time.time()
        self.signing = MAVLinkSigning()
        self.mav20_unpacker = struct.Struct("<cBBBBBBHB")
        self.mav10_unpacker = struct.Struct("<cBBBBB")
        self.mav20_h3_unpacker = struct.Struct("BBB")
        self.mav_csum_unpacker = struct.Struct("<H")
        self.mav_sign_unpacker = struct.Struct("<IH")

    def set_callback(self, callback, *args, **kwargs):
        self.callback = callback
        self.callback_args = args
        self.callback_kwargs = kwargs

    def set_send_callback(self, callback, *args, **kwargs):
        self.send_callback = callback
        self.send_callback_args = args
        self.send_callback_kwargs = kwargs

    def send(self, mavmsg, force_mavlink1=False):
        """send a MAVLink message"""
        buf = mavmsg.pack(self, force_mavlink1=force_mavlink1)
        self.file.write(buf)
        self.seq = (self.seq + 1) % 256
        self.total_packets_sent += 1
        self.total_bytes_sent += len(buf)
        if self.send_callback is not None and self.send_callback_args is not None and self.send_callback_kwargs is not None:
            self.send_callback(mavmsg, *self.send_callback_args, **self.send_callback_kwargs)

    def buf_len(self):
        return len(self.buf) - self.buf_index

    def bytes_needed(self):
        """return number of bytes needed for next parsing stage"""
        ret = self.expected_length - self.buf_len()

        if ret <= 0:
            return 1
        return ret

    def __callbacks(self, msg):
        """this method exists only to make profiling results easier to read"""
        if self.callback is not None and self.callback_args is not None and self.callback_kwargs is not None:
            self.callback(msg, *self.callback_args, **self.callback_kwargs)

    def parse_char(self, c):
        """input some data bytes, possibly returning a new message"""
        self.buf.extend(c)

        self.total_bytes_received += len(c)

        m = self.__parse_char_legacy()

        if m is not None:
            self.total_packets_received += 1
            self.__callbacks(m)
        else:
            # XXX The idea here is if we've read something and there's nothing left in
            # the buffer, reset it to 0 which frees the memory
            if self.buf_len() == 0 and self.buf_index != 0:
                self.buf = bytearray()
                self.buf_index = 0

        return m

    def __parse_char_legacy(self):
        """input some data bytes, possibly returning a new message"""
        header_len = HEADER_LEN_V1
        if self.buf_len() >= 1 and self.buf[self.buf_index] == PROTOCOL_MARKER_V2:
            header_len = HEADER_LEN_V2

        m = None
        if self.buf_len() >= 1 and self.buf[self.buf_index] != PROTOCOL_MARKER_V1 and self.buf[self.buf_index] != PROTOCOL_MARKER_V2:
            magic = self.buf[self.buf_index]
            self.buf_index += 1
            if self.robust_parsing:
                m = MAVLink_bad_data(bytearray([magic]), "Bad prefix")
                self.expected_length = header_len + 2
                self.total_receive_errors += 1
                return m
            if self.have_prefix_error:
                return None
            self.have_prefix_error = True
            self.total_receive_errors += 1
            raise MAVError("invalid MAVLink prefix '%s'" % magic)
        self.have_prefix_error = False
        if self.buf_len() >= 3:
            sbuf = self.buf[self.buf_index : 3 + self.buf_index]
            (magic, self.expected_length, incompat_flags) = cast(
                "Tuple[int, int, int]",
                self.mav20_h3_unpacker.unpack(sbuf),
            )
            if magic == PROTOCOL_MARKER_V2 and (incompat_flags & MAVLINK_IFLAG_SIGNED):
                self.expected_length += MAVLINK_SIGNATURE_BLOCK_LEN
            self.expected_length += header_len + 2
        if self.expected_length >= (header_len + 2) and self.buf_len() >= self.expected_length:
            mbuf = self.buf[self.buf_index : self.buf_index + self.expected_length]
            self.buf_index += self.expected_length
            self.expected_length = header_len + 2
            if self.robust_parsing:
                try:
                    if magic == PROTOCOL_MARKER_V2 and (incompat_flags & ~MAVLINK_IFLAG_SIGNED) != 0:
                        raise MAVError("invalid incompat_flags 0x%x 0x%x %u" % (incompat_flags, magic, self.expected_length))
                    m = self.decode(mbuf)
                except MAVError as reason:
                    m = MAVLink_bad_data(mbuf, reason.message)
                    self.total_receive_errors += 1
            else:
                if magic == PROTOCOL_MARKER_V2 and (incompat_flags & ~MAVLINK_IFLAG_SIGNED) != 0:
                    raise MAVError("invalid incompat_flags 0x%x 0x%x %u" % (incompat_flags, magic, self.expected_length))
                m = self.decode(mbuf)
            return m
        return None

    def parse_buffer(self, s):
        """input some data bytes, possibly returning a list of new messages"""
        m = self.parse_char(s)
        if m is None:
            return None
        ret = [m]
        while True:
            m = self.parse_char(b"")
            if m is None:
                return ret
            ret.append(m)

    def check_signature(self, msgbuf, srcSystem, srcComponent):
        """check signature on incoming message"""
        assert self.signing.secret_key is not None

        timestamp_buf = msgbuf[-12:-6]
        link_id = msgbuf[-13]
        (tlow, thigh) = cast(
            "Tuple[int, int]",
            self.mav_sign_unpacker.unpack(timestamp_buf),
        )
        timestamp = tlow + (thigh << 32)

        # see if the timestamp is acceptable
        stream_key = (link_id, srcSystem, srcComponent)
        if stream_key in self.signing.stream_timestamps:
            if timestamp <= self.signing.stream_timestamps[stream_key]:
                # reject old timestamp
                logger.info("old timestamp")
                return False
        else:
            # a new stream has appeared. Accept the timestamp if it is at most
            # one minute behind our current timestamp
            if timestamp + 6000 * 1000 < self.signing.timestamp:
                logger.info("bad new stream %s %s", timestamp / (100.0 * 1000 * 60 * 60 * 24 * 365), self.signing.timestamp / (100.0 * 1000 * 60 * 60 * 24 * 365))
                return False
            self.signing.stream_timestamps[stream_key] = timestamp
            logger.info("new stream")

        h = hashlib.new("sha256")
        h.update(self.signing.secret_key)
        h.update(msgbuf[:-6])
        sig1 = h.digest()[:6]
        sig2 = msgbuf[-6:]
        if sig1 != sig2:
            logger.info("sig mismatch")
            return False

        # the timestamp we next send with is the max of the received timestamp and
        # our current timestamp
        self.signing.timestamp = max(self.signing.timestamp, timestamp)
        return True

    def decode(self, msgbuf):
        """decode a buffer as a MAVLink message"""
        # decode the header
        if msgbuf[0] != PROTOCOL_MARKER_V1:
            headerlen = 10
            try:
                magic, mlen, incompat_flags, compat_flags, seq, srcSystem, srcComponent, msgIdlow, msgIdhigh = cast(
                    "Tuple[bytes, int, int, int, int, int, int, int, int]",
                    self.mav20_unpacker.unpack(msgbuf[:headerlen]),
                )
            except struct.error as emsg:
                raise MAVError("Unable to unpack MAVLink header: %s" % emsg)
            msgId = msgIdlow | (msgIdhigh << 16)
            mapkey = msgId
        else:
            headerlen = 6
            try:
                magic, mlen, seq, srcSystem, srcComponent, msgId = cast(
                    "Tuple[bytes, int, int, int, int, int]",
                    self.mav10_unpacker.unpack(msgbuf[:headerlen]),
                )
                incompat_flags = 0
                compat_flags = 0
            except struct.error as emsg:
                raise MAVError("Unable to unpack MAVLink header: %s" % emsg)
            mapkey = msgId
        if (incompat_flags & MAVLINK_IFLAG_SIGNED) != 0:
            signature_len = MAVLINK_SIGNATURE_BLOCK_LEN
        else:
            signature_len = 0

        if ord(magic) != PROTOCOL_MARKER_V1 and ord(magic) != PROTOCOL_MARKER_V2:
            raise MAVError("invalid MAVLink prefix '{}'".format(hex(ord(magic))))
        if mlen != len(msgbuf) - (headerlen + 2 + signature_len):
            raise MAVError("invalid MAVLink message length. Got %u expected %u, msgId=%u headerlen=%u" % (len(msgbuf) - (headerlen + 2 + signature_len), mlen, msgId, headerlen))

        if mapkey not in mavlink_map:
            return MAVLink_unknown(msgId, msgbuf)

        # decode the payload
        msgtype = mavlink_map[mapkey]
        order_map = msgtype.orders
        len_map = msgtype.lengths
        crc_extra = msgtype.crc_extra

        # decode the checksum
        try:
            (crc,) = cast(
                "Tuple[int]",
                self.mav_csum_unpacker.unpack(msgbuf[-(2 + signature_len) :][:2]),
            )
        except struct.error as emsg:
            raise MAVError("Unable to unpack MAVLink CRC: %s" % emsg)
        crcbuf = msgbuf[1 : -(2 + signature_len)]
        if True:
            # using CRC extra
            crcbuf.append(crc_extra)
        crc2 = x25crc(crcbuf)
        if crc != crc2.crc and not MAVLINK_IGNORE_CRC:
            raise MAVError("invalid MAVLink CRC in msgID %u 0x%04x should be 0x%04x" % (msgId, crc, crc2.crc))

        sig_ok = False
        if signature_len == MAVLINK_SIGNATURE_BLOCK_LEN:
            self.signing.sig_count += 1
        if self.signing.secret_key is not None:
            accept_signature = False
            if signature_len == MAVLINK_SIGNATURE_BLOCK_LEN:
                sig_ok = self.check_signature(msgbuf, srcSystem, srcComponent)
                accept_signature = sig_ok
                if sig_ok:
                    self.signing.goodsig_count += 1
                else:
                    self.signing.badsig_count += 1
                if not accept_signature and self.signing.allow_unsigned_callback is not None:
                    accept_signature = self.signing.allow_unsigned_callback(self, msgId)
                    if accept_signature:
                        self.signing.unsigned_count += 1
                    else:
                        self.signing.reject_count += 1
            elif self.signing.allow_unsigned_callback is not None:
                accept_signature = self.signing.allow_unsigned_callback(self, msgId)
                if accept_signature:
                    self.signing.unsigned_count += 1
                else:
                    self.signing.reject_count += 1
            if not accept_signature:
                raise MAVError("Invalid signature")

        csize = msgtype.unpacker.size
        mbuf = msgbuf[headerlen : -(2 + signature_len)]
        if len(mbuf) < csize:
            # zero pad to give right size
            mbuf.extend([0] * (csize - len(mbuf)))
        if len(mbuf) < csize:
            raise MAVError("Bad message of type %s length %u needs %s" % (msgtype, len(mbuf), csize))
        mbuf = mbuf[:csize]
        try:
            t = cast(
                "Tuple[Union[bytes, int, float], ...]",
                msgtype.unpacker.unpack(mbuf),
            )
        except struct.error as emsg:
            raise MAVError("Unable to unpack MAVLink payload type=%s payloadLength=%u: %s" % (msgtype, len(mbuf), emsg))

        tlist = list(t)
        # handle sorted fields
        if True:
            if sum(len_map) == len(len_map):
                # message has no arrays in it
                for i in range(0, len(tlist)):
                    tlist[i] = t[order_map[i]]
            else:
                # message has some arrays
                tlist = []
                for i in range(0, len(order_map)):
                    order = order_map[i]
                    L = len_map[order]
                    tip = sum(len_map[:order])
                    field = t[tip]
                    if L == 1 or isinstance(field, bytes):
                        tlist.append(field)
                    else:
                        tlist.append(cast("Union[Sequence[int], Sequence[float]]", list(t[tip : (tip + L)])))

        # terminate any strings
        for i, elem in enumerate(tlist):
            if isinstance(elem, bytes):
                tlist[i] = elem.rstrip(b"\x00")

        # construct the message object
        try:
            # Note that initializers don't follow the Liskov Substitution Principle
            # therefore it can't be typechecked
            m = msgtype(*tlist)  # type: ignore
        except Exception as emsg:
            raise MAVError("Unable to instantiate MAVLink message of type %s : %s" % (msgtype, emsg))
        m._signed = sig_ok
        if m._signed:
            m._link_id = msgbuf[-13]
        m._msgbuf = msgbuf
        m._payload = msgbuf[6 : -(2 + signature_len)]
        m._crc = crc
        m._header = MAVLink_header(msgId, incompat_flags, compat_flags, mlen, seq, srcSystem, srcComponent)
        return m

    def heartbeat_encode(self, type, autopilot, base_mode, custom_mode, system_status, mavlink_version=2):
        """
        The heartbeat message shows that a system or component is present and
        responding. The type and autopilot fields (along with the
        message component id), allow the receiving system to treat
        further messages from this system appropriately (e.g. by
        laying out the user interface based on the autopilot). This
        microservice is documented at
        https://mavlink.io/en/services/heartbeat.html

        type                      : Vehicle or component type. For a flight controller component the vehicle type (quadrotor, helicopter, etc.). For other components the component type (e.g. camera, gimbal, etc.). This should be used in preference to component id for identifying the component type. (type:uint8_t, values:MAV_TYPE)
        autopilot                 : Autopilot type / class. Use MAV_AUTOPILOT_INVALID for components that are not flight controllers. (type:uint8_t, values:MAV_AUTOPILOT)
        base_mode                 : System mode bitmap. (type:uint8_t, values:MAV_MODE_FLAG)
        custom_mode               : A bitfield for use for autopilot-specific flags (type:uint32_t)
        system_status             : System status flag. (type:uint8_t, values:MAV_STATE)
        mavlink_version           : MAVLink version, not writable by user, gets added by protocol because of magic data type: uint8_t_mavlink_version (type:uint8_t)

        """
        return MAVLink_heartbeat_message(type, autopilot, base_mode, custom_mode, system_status, mavlink_version)

    def heartbeat_send(self, type, autopilot, base_mode, custom_mode, system_status, mavlink_version=2, force_mavlink1=False):
        """
        The heartbeat message shows that a system or component is present and
        responding. The type and autopilot fields (along with the
        message component id), allow the receiving system to treat
        further messages from this system appropriately (e.g. by
        laying out the user interface based on the autopilot). This
        microservice is documented at
        https://mavlink.io/en/services/heartbeat.html

        type                      : Vehicle or component type. For a flight controller component the vehicle type (quadrotor, helicopter, etc.). For other components the component type (e.g. camera, gimbal, etc.). This should be used in preference to component id for identifying the component type. (type:uint8_t, values:MAV_TYPE)
        autopilot                 : Autopilot type / class. Use MAV_AUTOPILOT_INVALID for components that are not flight controllers. (type:uint8_t, values:MAV_AUTOPILOT)
        base_mode                 : System mode bitmap. (type:uint8_t, values:MAV_MODE_FLAG)
        custom_mode               : A bitfield for use for autopilot-specific flags (type:uint32_t)
        system_status             : System status flag. (type:uint8_t, values:MAV_STATE)
        mavlink_version           : MAVLink version, not writable by user, gets added by protocol because of magic data type: uint8_t_mavlink_version (type:uint8_t)

        """
        self.send(self.heartbeat_encode(type, autopilot, base_mode, custom_mode, system_status, mavlink_version), force_mavlink1=force_mavlink1)

    def change_operator_control_encode(self, target_system, control_request, version, passkey):
        """
        Request to control this MAV

        target_system             : System the GCS requests control for (type:uint8_t)
        control_request           : 0: request control of this MAV, 1: Release control of this MAV (type:uint8_t)
        version                   : 0: key as plaintext, 1-255: future, different hashing/encryption variants. The GCS should in general use the safest mode possible initially and then gradually move down the encryption level if it gets a NACK message indicating an encryption mismatch. [rad] (type:uint8_t)
        passkey                   : Password / Key, depending on version plaintext or encrypted. 25 or less characters, NULL terminated. The characters may involve A-Z, a-z, 0-9, and "!?,.-" (type:char)

        """
        return MAVLink_change_operator_control_message(target_system, control_request, version, passkey)

    def change_operator_control_send(self, target_system, control_request, version, passkey, force_mavlink1=False):
        """
        Request to control this MAV

        target_system             : System the GCS requests control for (type:uint8_t)
        control_request           : 0: request control of this MAV, 1: Release control of this MAV (type:uint8_t)
        version                   : 0: key as plaintext, 1-255: future, different hashing/encryption variants. The GCS should in general use the safest mode possible initially and then gradually move down the encryption level if it gets a NACK message indicating an encryption mismatch. [rad] (type:uint8_t)
        passkey                   : Password / Key, depending on version plaintext or encrypted. 25 or less characters, NULL terminated. The characters may involve A-Z, a-z, 0-9, and "!?,.-" (type:char)

        """
        self.send(self.change_operator_control_encode(target_system, control_request, version, passkey), force_mavlink1=force_mavlink1)

    def change_operator_control_ack_encode(self, gcs_system_id, control_request, ack):
        """
        Accept / deny control of this MAV

        gcs_system_id             : ID of the GCS this message (type:uint8_t)
        control_request           : 0: request control of this MAV, 1: Release control of this MAV (type:uint8_t)
        ack                       : 0: ACK, 1: NACK: Wrong passkey, 2: NACK: Unsupported passkey encryption method, 3: NACK: Already under control (type:uint8_t)

        """
        return MAVLink_change_operator_control_ack_message(gcs_system_id, control_request, ack)

    def change_operator_control_ack_send(self, gcs_system_id, control_request, ack, force_mavlink1=False):
        """
        Accept / deny control of this MAV

        gcs_system_id             : ID of the GCS this message (type:uint8_t)
        control_request           : 0: request control of this MAV, 1: Release control of this MAV (type:uint8_t)
        ack                       : 0: ACK, 1: NACK: Wrong passkey, 2: NACK: Unsupported passkey encryption method, 3: NACK: Already under control (type:uint8_t)

        """
        self.send(self.change_operator_control_ack_encode(gcs_system_id, control_request, ack), force_mavlink1=force_mavlink1)

    def gps_raw_int_encode(self, time_usec, fix_type, lat, lon, alt, eph, epv, vel, cog, satellites_visible):
        """
        The global position, as returned by the Global Positioning System
        (GPS).           This is           NOT the global position
        estimate of the system, but rather a RAW sensor value. See
        message GLOBAL_POSITION_INT for the global position estimate.

        time_usec                 : Timestamp (UNIX Epoch time or time
          since system boot). The receiving end can infer timestamp format (since 1.1.1970 or
          since system boot) by checking for the magnitude of the number. [us] (type:uint64_t)
        fix_type                  : GPS fix type. (type:uint8_t, values:GPS_FIX_TYPE)
        lat                       : Latitude (WGS84, EGM96 ellipsoid) [degE7] (type:int32_t)
        lon                       : Longitude (WGS84, EGM96 ellipsoid) [degE7] (type:int32_t)
        alt                       : Altitude (MSL). Positive for up. Note that
          virtually all GPS modules provide the MSL altitude in addition to the WGS84
          altitude. [mm] (type:int32_t)
        eph                       : GPS HDOP
          horizontal dilution of position (unitless * 100). If unknown, set to: UINT16_MAX (type:uint16_t)
        epv                       : GPS VDOP
          vertical dilution of position (unitless * 100). If unknown, set to: UINT16_MAX (type:uint16_t)
        vel                       : GPS ground speed. If
          unknown, set to: UINT16_MAX [cm/s] (type:uint16_t)
        cog                       : Course over ground
          (NOT heading, but direction of movement) in degrees * 100, 0.0..359.99 degrees. If
          unknown, set to: UINT16_MAX [cdeg] (type:uint16_t)
        satellites_visible        : Number of satellites
          visible. If unknown, set to UINT8_MAX (type:uint8_t)

        """
        return MAVLink_gps_raw_int_message(time_usec, fix_type, lat, lon, alt, eph, epv, vel, cog, satellites_visible)

    def gps_raw_int_send(self, time_usec, fix_type, lat, lon, alt, eph, epv, vel, cog, satellites_visible, force_mavlink1=False):
        """
        The global position, as returned by the Global Positioning System
        (GPS).           This is           NOT the global position
        estimate of the system, but rather a RAW sensor value. See
        message GLOBAL_POSITION_INT for the global position estimate.

        time_usec                 : Timestamp (UNIX Epoch time or time
          since system boot). The receiving end can infer timestamp format (since 1.1.1970 or
          since system boot) by checking for the magnitude of the number. [us] (type:uint64_t)
        fix_type                  : GPS fix type. (type:uint8_t, values:GPS_FIX_TYPE)
        lat                       : Latitude (WGS84, EGM96 ellipsoid) [degE7] (type:int32_t)
        lon                       : Longitude (WGS84, EGM96 ellipsoid) [degE7] (type:int32_t)
        alt                       : Altitude (MSL). Positive for up. Note that
          virtually all GPS modules provide the MSL altitude in addition to the WGS84
          altitude. [mm] (type:int32_t)
        eph                       : GPS HDOP
          horizontal dilution of position (unitless * 100). If unknown, set to: UINT16_MAX (type:uint16_t)
        epv                       : GPS VDOP
          vertical dilution of position (unitless * 100). If unknown, set to: UINT16_MAX (type:uint16_t)
        vel                       : GPS ground speed. If
          unknown, set to: UINT16_MAX [cm/s] (type:uint16_t)
        cog                       : Course over ground
          (NOT heading, but direction of movement) in degrees * 100, 0.0..359.99 degrees. If
          unknown, set to: UINT16_MAX [cdeg] (type:uint16_t)
        satellites_visible        : Number of satellites
          visible. If unknown, set to UINT8_MAX (type:uint8_t)

        """
        self.send(self.gps_raw_int_encode(time_usec, fix_type, lat, lon, alt, eph, epv, vel, cog, satellites_visible), force_mavlink1=force_mavlink1)

    def mission_item_encode(self, target_system, target_component, seq, frame, command, current, autocontinue, param1, param2, param3, param4, x, y, z):
        """
        Message encoding a mission item. This message is emitted to announce
        the presence of a mission item and to set a mission item on
        the system. The mission           item can be either in x, y,
        z meters (type: LOCAL) or x:lat, y:lon, z:altitude.
        Local frame is Z-down, right handed (NED), global frame is
        Z-up, right handed (ENU).           NaN may be used to
        indicate an optional/default value (e.g. to use the system's
        current latitude or yaw rather than a specific value). See
        also           https://mavlink.io/en/services/mission.html.

        target_system             : System ID (type:uint8_t)
        target_component          : Component ID (type:uint8_t)
        seq                       : Sequence (type:uint16_t)
        frame                     : The coordinate system of the
          waypoint. (type:uint8_t, values:MAV_FRAME)
        command                   : The scheduled action for the
          waypoint. (type:uint16_t, values:MAV_CMD)
        current                   : false:0, true:1 (type:uint8_t)
        autocontinue              : Autocontinue to next waypoint. 0: false, 1:
          true. Set false to pause mission after the item completes. (type:uint8_t)
        param1                    : PARAM1, see MAV_CMD enum (type:float)
        param2                    : PARAM2, see MAV_CMD enum (type:float)
        param3                    : PARAM3, see MAV_CMD enum (type:float)
        param4                    : PARAM4, see MAV_CMD enum (type:float)
        x                         : PARAM5 / local: X coordinate, global: latitude (type:float)
        y                         : PARAM6 / local: Y coordinate, global: longitude (type:float)
        z                         : PARAM7 / local: Z coordinate, global: altitude (relative or
          absolute, depending on frame). (type:float)

        """
        return MAVLink_mission_item_message(target_system, target_component, seq, frame, command, current, autocontinue, param1, param2, param3, param4, x, y, z)

    def mission_item_send(self, target_system, target_component, seq, frame, command, current, autocontinue, param1, param2, param3, param4, x, y, z, force_mavlink1=False):
        """
        Message encoding a mission item. This message is emitted to announce
        the presence of a mission item and to set a mission item on
        the system. The mission           item can be either in x, y,
        z meters (type: LOCAL) or x:lat, y:lon, z:altitude.
        Local frame is Z-down, right handed (NED), global frame is
        Z-up, right handed (ENU).           NaN may be used to
        indicate an optional/default value (e.g. to use the system's
        current latitude or yaw rather than a specific value). See
        also           https://mavlink.io/en/services/mission.html.

        target_system             : System ID (type:uint8_t)
        target_component          : Component ID (type:uint8_t)
        seq                       : Sequence (type:uint16_t)
        frame                     : The coordinate system of the
          waypoint. (type:uint8_t, values:MAV_FRAME)
        command                   : The scheduled action for the
          waypoint. (type:uint16_t, values:MAV_CMD)
        current                   : false:0, true:1 (type:uint8_t)
        autocontinue              : Autocontinue to next waypoint. 0: false, 1:
          true. Set false to pause mission after the item completes. (type:uint8_t)
        param1                    : PARAM1, see MAV_CMD enum (type:float)
        param2                    : PARAM2, see MAV_CMD enum (type:float)
        param3                    : PARAM3, see MAV_CMD enum (type:float)
        param4                    : PARAM4, see MAV_CMD enum (type:float)
        x                         : PARAM5 / local: X coordinate, global: latitude (type:float)
        y                         : PARAM6 / local: Y coordinate, global: longitude (type:float)
        z                         : PARAM7 / local: Z coordinate, global: altitude (relative or
          absolute, depending on frame). (type:float)

        """
        self.send(self.mission_item_encode(target_system, target_component, seq, frame, command, current, autocontinue, param1, param2, param3, param4, x, y, z), force_mavlink1=force_mavlink1)

    def command_int_encode(self, target_system, target_component, frame, command, current, autocontinue, param1, param2, param3, param4, x, y, z):
        """
        Send a command with up to seven parameters to the MAV, where params 5
        and 6 are integers and the other values are floats. This is
        preferred over COMMAND_LONG as it allows the MAV_FRAME to be
        specified for interpreting positional information, such as
        altitude. COMMAND_INT is also preferred when sending latitude
        and longitude data in params 5 and 6, as it allows for greater
        precision. Param 5 and 6 encode positional data as scaled
        integers, where the scaling depends on the actual command
        value. NaN or INT32_MAX may be used in float/integer params
        (respectively) to indicate optional/default values (e.g. to
        use the component's current latitude, yaw rather than a
        specific value). The command microservice is documented at
        https://mavlink.io/en/services/command.html

        target_system             : System ID (type:uint8_t)
        target_component          : Component ID (type:uint8_t)
        frame                     : The coordinate system of the COMMAND. (type:uint8_t, values:MAV_FRAME)
        command                   : The scheduled action for the mission item. (type:uint16_t, values:MAV_CMD)
        current                   : Not used. (type:uint8_t)
        autocontinue              : Not used (set 0). (type:uint8_t)
        param1                    : PARAM1, see MAV_CMD enum (type:float)
        param2                    : PARAM2, see MAV_CMD enum (type:float)
        param3                    : PARAM3, see MAV_CMD enum (type:float)
        param4                    : PARAM4, see MAV_CMD enum (type:float)
        x                         : PARAM5 / local: x position in meters * 1e4, global: latitude in degrees * 10^7 (type:int32_t)
        y                         : PARAM6 / local: y position in meters * 1e4, global: longitude in degrees * 10^7 (type:int32_t)
        z                         : PARAM7 / z position: global: altitude in meters (relative or absolute, depending on frame). (type:float)

        """
        return MAVLink_command_int_message(target_system, target_component, frame, command, current, autocontinue, param1, param2, param3, param4, x, y, z)

    def command_int_send(self, target_system, target_component, frame, command, current, autocontinue, param1, param2, param3, param4, x, y, z, force_mavlink1=False):
        """
        Send a command with up to seven parameters to the MAV, where params 5
        and 6 are integers and the other values are floats. This is
        preferred over COMMAND_LONG as it allows the MAV_FRAME to be
        specified for interpreting positional information, such as
        altitude. COMMAND_INT is also preferred when sending latitude
        and longitude data in params 5 and 6, as it allows for greater
        precision. Param 5 and 6 encode positional data as scaled
        integers, where the scaling depends on the actual command
        value. NaN or INT32_MAX may be used in float/integer params
        (respectively) to indicate optional/default values (e.g. to
        use the component's current latitude, yaw rather than a
        specific value). The command microservice is documented at
        https://mavlink.io/en/services/command.html

        target_system             : System ID (type:uint8_t)
        target_component          : Component ID (type:uint8_t)
        frame                     : The coordinate system of the COMMAND. (type:uint8_t, values:MAV_FRAME)
        command                   : The scheduled action for the mission item. (type:uint16_t, values:MAV_CMD)
        current                   : Not used. (type:uint8_t)
        autocontinue              : Not used (set 0). (type:uint8_t)
        param1                    : PARAM1, see MAV_CMD enum (type:float)
        param2                    : PARAM2, see MAV_CMD enum (type:float)
        param3                    : PARAM3, see MAV_CMD enum (type:float)
        param4                    : PARAM4, see MAV_CMD enum (type:float)
        x                         : PARAM5 / local: x position in meters * 1e4, global: latitude in degrees * 10^7 (type:int32_t)
        y                         : PARAM6 / local: y position in meters * 1e4, global: longitude in degrees * 10^7 (type:int32_t)
        z                         : PARAM7 / z position: global: altitude in meters (relative or absolute, depending on frame). (type:float)

        """
        self.send(self.command_int_encode(target_system, target_component, frame, command, current, autocontinue, param1, param2, param3, param4, x, y, z), force_mavlink1=force_mavlink1)

    def command_long_encode(self, target_system, target_component, command, confirmation, param1, param2, param3, param4, param5, param6, param7):
        """
        Send a command with up to seven parameters to the MAV. COMMAND_INT is
        generally preferred when sending MAV_CMD commands that include
        positional information; it offers higher precision and allows
        the MAV_FRAME to be specified (which may otherwise be
        ambiguous, particularly for altitude). The command
        microservice is documented at
        https://mavlink.io/en/services/command.html

        target_system             : System which should execute the command (type:uint8_t)
        target_component          : Component which should execute the command, 0 for all components (type:uint8_t)
        command                   : Command ID (of command to send). (type:uint16_t, values:MAV_CMD)
        confirmation              : 0: First transmission of this command. 1-255: Confirmation transmissions (e.g. for kill command) (type:uint8_t)
        param1                    : Parameter 1 (for the specific command). (type:float)
        param2                    : Parameter 2 (for the specific command). (type:float)
        param3                    : Parameter 3 (for the specific command). (type:float)
        param4                    : Parameter 4 (for the specific command). (type:float)
        param5                    : Parameter 5 (for the specific command). (type:float)
        param6                    : Parameter 6 (for the specific command). (type:float)
        param7                    : Parameter 7 (for the specific command). (type:float)

        """
        return MAVLink_command_long_message(target_system, target_component, command, confirmation, param1, param2, param3, param4, param5, param6, param7)

    def command_long_send(self, target_system, target_component, command, confirmation, param1, param2, param3, param4, param5, param6, param7, force_mavlink1=False):
        """
        Send a command with up to seven parameters to the MAV. COMMAND_INT is
        generally preferred when sending MAV_CMD commands that include
        positional information; it offers higher precision and allows
        the MAV_FRAME to be specified (which may otherwise be
        ambiguous, particularly for altitude). The command
        microservice is documented at
        https://mavlink.io/en/services/command.html

        target_system             : System which should execute the command (type:uint8_t)
        target_component          : Component which should execute the command, 0 for all components (type:uint8_t)
        command                   : Command ID (of command to send). (type:uint16_t, values:MAV_CMD)
        confirmation              : 0: First transmission of this command. 1-255: Confirmation transmissions (e.g. for kill command) (type:uint8_t)
        param1                    : Parameter 1 (for the specific command). (type:float)
        param2                    : Parameter 2 (for the specific command). (type:float)
        param3                    : Parameter 3 (for the specific command). (type:float)
        param4                    : Parameter 4 (for the specific command). (type:float)
        param5                    : Parameter 5 (for the specific command). (type:float)
        param6                    : Parameter 6 (for the specific command). (type:float)
        param7                    : Parameter 7 (for the specific command). (type:float)

        """
        self.send(self.command_long_encode(target_system, target_component, command, confirmation, param1, param2, param3, param4, param5, param6, param7), force_mavlink1=force_mavlink1)

    def command_ack_encode(self, command, result):
        """
        Report status of a command. Includes feedback whether the command was
        executed. The command microservice is documented at
        https://mavlink.io/en/services/command.html

        command                   : Command ID (of acknowledged
        command). (type:uint16_t, values:MAV_CMD)
        result                    : Result of command. (type:uint8_t, values:MAV_RESULT)

        """
        return MAVLink_command_ack_message(command, result)

    def command_ack_send(self, command, result, force_mavlink1=False):
        """
        Report status of a command. Includes feedback whether the command was
        executed. The command microservice is documented at
        https://mavlink.io/en/services/command.html

        command                   : Command ID (of acknowledged
        command). (type:uint16_t, values:MAV_CMD)
        result                    : Result of command. (type:uint8_t, values:MAV_RESULT)

        """
        self.send(self.command_ack_encode(command, result), force_mavlink1=force_mavlink1)

    def command_cancel_encode(self, target_system, target_component, command):
        """
        Cancel a long running command. The target system should respond with a
        COMMAND_ACK to the original command with
        result=MAV_RESULT_CANCELLED if the long       running process
        was cancelled. If it has already completed, the cancel action
        can be       ignored. The cancel action can be retried until
        some sort of acknowledgement to the       original command has
        been received. The command microservice is documented at
        https://mavlink.io/en/services/command.html

        target_system             : System executing long running command. Should
      not be broadcast (0). (type:uint8_t)
        target_component          : Component executing long running command. (type:uint8_t)
        command                   : Command ID (of command to cancel). (type:uint16_t, values:MAV_CMD)

        """
        return MAVLink_command_cancel_message(target_system, target_component, command)

    def command_cancel_send(self, target_system, target_component, command, force_mavlink1=False):
        """
        Cancel a long running command. The target system should respond with a
        COMMAND_ACK to the original command with
        result=MAV_RESULT_CANCELLED if the long       running process
        was cancelled. If it has already completed, the cancel action
        can be       ignored. The cancel action can be retried until
        some sort of acknowledgement to the       original command has
        been received. The command microservice is documented at
        https://mavlink.io/en/services/command.html

        target_system             : System executing long running command. Should
      not be broadcast (0). (type:uint8_t)
        target_component          : Component executing long running command. (type:uint8_t)
        command                   : Command ID (of command to cancel). (type:uint16_t, values:MAV_CMD)

        """
        self.send(self.command_cancel_encode(target_system, target_component, command), force_mavlink1=force_mavlink1)

    def file_transfer_protocol_encode(self, target_network, target_system, target_component, payload):
        """
        File transfer protocol message:
        https://mavlink.io/en/services/ftp.html.

        target_network            : Network ID (0 for broadcast) (type:uint8_t)
        target_system             : System ID (0 for broadcast) (type:uint8_t)
        target_component          : Component ID (0 for broadcast) (type:uint8_t)
        payload                   : Variable length payload. The length is defined by the remaining message length when subtracting the header and other fields. The content/format of this block is defined in https://mavlink.io/en/services/ftp.html. (type:uint8_t)

        """
        return MAVLink_file_transfer_protocol_message(target_network, target_system, target_component, payload)

    def file_transfer_protocol_send(self, target_network, target_system, target_component, payload, force_mavlink1=False):
        """
        File transfer protocol message:
        https://mavlink.io/en/services/ftp.html.

        target_network            : Network ID (0 for broadcast) (type:uint8_t)
        target_system             : System ID (0 for broadcast) (type:uint8_t)
        target_component          : Component ID (0 for broadcast) (type:uint8_t)
        payload                   : Variable length payload. The length is defined by the remaining message length when subtracting the header and other fields. The content/format of this block is defined in https://mavlink.io/en/services/ftp.html. (type:uint8_t)

        """
        self.send(self.file_transfer_protocol_encode(target_network, target_system, target_component, payload), force_mavlink1=force_mavlink1)

    def timesync_encode(self, tc1, ts1):
        """
        Time synchronization message.     The message is used for both
        timesync requests and responses.     The request is sent with
        `ts1=syncing component timestamp` and `tc1=0`, and may be
        broadcast or targeted to a specific system/component.     The
        response is sent with `ts1=syncing component timestamp`
        (mirror back unchanged), and `tc1=responding component
        timestamp`, with the `target_system` and `target_component`
        set to ids of the original request.     Systems can determine
        if they are receiving a request or response based on the value
        of `tc`.     If the response has
        `target_system==target_component==0` the remote system has not
        been updated to use the component IDs and cannot reliably
        timesync; the requestor may report an error.     Timestamps
        are UNIX Epoch time or time since system boot in nanoseconds
        (the timestamp format can be inferred by checking for the
        magnitude of the number; generally it doesn't matter as only
        the offset is used).     The message sequence is repeated
        numerous times with results being filtered/averaged to
        estimate the offset.

        tc1                       : Time sync timestamp 1. Syncing: 0. Responding: Timestamp of responding component. [ns] (type:int64_t)
        ts1                       : Time sync timestamp 2. Timestamp of syncing component (mirrored in response). [ns] (type:int64_t)

        """
        return MAVLink_timesync_message(tc1, ts1)

    def timesync_send(self, tc1, ts1, force_mavlink1=False):
        """
        Time synchronization message.     The message is used for both
        timesync requests and responses.     The request is sent with
        `ts1=syncing component timestamp` and `tc1=0`, and may be
        broadcast or targeted to a specific system/component.     The
        response is sent with `ts1=syncing component timestamp`
        (mirror back unchanged), and `tc1=responding component
        timestamp`, with the `target_system` and `target_component`
        set to ids of the original request.     Systems can determine
        if they are receiving a request or response based on the value
        of `tc`.     If the response has
        `target_system==target_component==0` the remote system has not
        been updated to use the component IDs and cannot reliably
        timesync; the requestor may report an error.     Timestamps
        are UNIX Epoch time or time since system boot in nanoseconds
        (the timestamp format can be inferred by checking for the
        magnitude of the number; generally it doesn't matter as only
        the offset is used).     The message sequence is repeated
        numerous times with results being filtered/averaged to
        estimate the offset.

        tc1                       : Time sync timestamp 1. Syncing: 0. Responding: Timestamp of responding component. [ns] (type:int64_t)
        ts1                       : Time sync timestamp 2. Timestamp of syncing component (mirrored in response). [ns] (type:int64_t)

        """
        self.send(self.timesync_encode(tc1, ts1), force_mavlink1=force_mavlink1)

    def message_interval_encode(self, message_id, interval_us):
        """
        The interval between messages for a particular MAVLink message ID.
        This message is sent in response to the
        MAV_CMD_REQUEST_MESSAGE command with param1=244 (this message)
        and param2=message_id (the id of the message for which the
        interval is required).         It may also be sent in response
        to MAV_CMD_GET_MESSAGE_INTERVAL.         This interface
        replaces DATA_STREAM.

        message_id                : The ID of the requested MAVLink message. v1.0 is limited to 254 messages. (type:uint16_t)
        interval_us               : The interval between two messages. A value of -1 indicates this stream is disabled, 0 indicates it is not available, > 0 indicates the interval at which it is sent. [us] (type:int32_t)

        """
        return MAVLink_message_interval_message(message_id, interval_us)

    def message_interval_send(self, message_id, interval_us, force_mavlink1=False):
        """
        The interval between messages for a particular MAVLink message ID.
        This message is sent in response to the
        MAV_CMD_REQUEST_MESSAGE command with param1=244 (this message)
        and param2=message_id (the id of the message for which the
        interval is required).         It may also be sent in response
        to MAV_CMD_GET_MESSAGE_INTERVAL.         This interface
        replaces DATA_STREAM.

        message_id                : The ID of the requested MAVLink message. v1.0 is limited to 254 messages. (type:uint16_t)
        interval_us               : The interval between two messages. A value of -1 indicates this stream is disabled, 0 indicates it is not available, > 0 indicates the interval at which it is sent. [us] (type:int32_t)

        """
        self.send(self.message_interval_encode(message_id, interval_us), force_mavlink1=force_mavlink1)

    def named_value_float_encode(self, time_boot_ms, name, value):
        """
        Send a key-value pair as float. The use of this message is discouraged
        for normal packets, but a quite efficient way for testing new
        messages and getting experimental debug output.

        time_boot_ms              : Timestamp (time since system boot). [ms] (type:uint32_t)
        name                      : Name of the debug variable (type:char)
        value                     : Floating point value (type:float)

        """
        return MAVLink_named_value_float_message(time_boot_ms, name, value)

    def named_value_float_send(self, time_boot_ms, name, value, force_mavlink1=False):
        """
        Send a key-value pair as float. The use of this message is discouraged
        for normal packets, but a quite efficient way for testing new
        messages and getting experimental debug output.

        time_boot_ms              : Timestamp (time since system boot). [ms] (type:uint32_t)
        name                      : Name of the debug variable (type:char)
        value                     : Floating point value (type:float)

        """
        self.send(self.named_value_float_encode(time_boot_ms, name, value), force_mavlink1=force_mavlink1)

    def named_value_int_encode(self, time_boot_ms, name, value):
        """
        Send a key-value pair as integer. The use of this message is
        discouraged for normal packets, but a quite efficient way for
        testing new messages and getting experimental debug output.

        time_boot_ms              : Timestamp (time since system boot). [ms] (type:uint32_t)
        name                      : Name of the debug variable (type:char)
        value                     : Signed integer value (type:int32_t)

        """
        return MAVLink_named_value_int_message(time_boot_ms, name, value)

    def named_value_int_send(self, time_boot_ms, name, value, force_mavlink1=False):
        """
        Send a key-value pair as integer. The use of this message is
        discouraged for normal packets, but a quite efficient way for
        testing new messages and getting experimental debug output.

        time_boot_ms              : Timestamp (time since system boot). [ms] (type:uint32_t)
        name                      : Name of the debug variable (type:char)
        value                     : Signed integer value (type:int32_t)

        """
        self.send(self.named_value_int_encode(time_boot_ms, name, value), force_mavlink1=force_mavlink1)

    def statustext_encode(self, severity, text):
        """
        Status text message. These messages are printed in yellow in the COMM
        console of QGroundControl. WARNING: They consume quite some
        bandwidth, so use only for important status and error
        messages. If implemented wisely, these messages are buffered
        on the MCU and sent only at a limited rate (e.g. 10 Hz).

        severity                  : Severity of status. Relies on the definitions within RFC-5424. (type:uint8_t, values:MAV_SEVERITY)
        text                      : Status text message, without null termination character (type:char)

        """
        return MAVLink_statustext_message(severity, text)

    def statustext_send(self, severity, text, force_mavlink1=False):
        """
        Status text message. These messages are printed in yellow in the COMM
        console of QGroundControl. WARNING: They consume quite some
        bandwidth, so use only for important status and error
        messages. If implemented wisely, these messages are buffered
        on the MCU and sent only at a limited rate (e.g. 10 Hz).

        severity                  : Severity of status. Relies on the definitions within RFC-5424. (type:uint8_t, values:MAV_SEVERITY)
        text                      : Status text message, without null termination character (type:char)

        """
        self.send(self.statustext_encode(severity, text), force_mavlink1=force_mavlink1)
