/*!
  * Copyright 2016,  Digital Reasoning
  *
  * Licensed under the Apache License, Version 2.0 (the "License");
  * you may not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  *     http://www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an "AS IS" BASIS,
  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
*/

define(["jquery","underscore","knockout","bootbox","moment","utils/utils","models/host","models/blueprint"],function(t,e,a,r,s,o,n,i){"use strict";function l(){this.calendar=function(){return""},this.toString=function(){return""}}function c(t,e){var r=!1;"string"==typeof t&&(t=parseInt(t)),"number"==typeof t&&(r=!0,t={id:t,url:"/api/stacks/"+t+"/"}),this.raw=t,this.parent=e,this.id=t.id,this.detailUrl="/stacks/"+this.id+"/",this.title=a.observable(),this.description=a.observable(),this.createUsers=a.observable(),this.activity=a.observable(),this.health=a.observable(),this.hostCount=a.observable(),this.labelClass=a.observable(),this.healthLabelClass=a.observable(),this.namespace=a.observable(),this.created=a.observable(new l),this.labelList=a.observable(),this.properties=a.observable({}),this.blueprint=a.observable(),this.availableActions=a.observableArray([]),this.history=a.observableArray([]),this.components=a.observableArray([]),this.hosts=a.observableArray([]),this.volumes=a.observableArray([]),this.commands=a.observableArray([]),this.securityGroups=a.observableArray([]),this.formulaVersions=a.observableArray([]),this.latestLogs=a.observableArray([]),this.historicalLogs=a.observableArray([]),r?this.waiting=this.reload():this._process(t)}return c.constructor=c,c.prototype.actionMessages={launch:'This will create new infrastructure, undoing a "terminate" action you may have previously performed.  This will also re-launch any spot instances that have died.',orchestrate:"This will re-run all of your custom formula components.  This may overwrite anything you have manually changed on your hosts.","propagate-ssh":'This will create new users for everyone with "ssh" permission.',provision:"This will re-run core provisioning, in addition to re-running all of your custom formula components.  This may overwrite anything you have manually changed on your hosts.",pause:"",resume:"",terminate:'This will terminate all infrastructure related to this stack.  You can get it all back by later running the "launch" action on this stack.'},c.prototype._processActivity=function(t){switch(this.activity(t),t){case"idle":this.labelClass("label-success");break;case"launching":case"provisioning":case"orchestrating":case"resuming":case"pausing":case"executing":case"terminating":this.labelClass("label-warning");break;case"queued":case"paused":case"terminated":this.labelClass("label-info");break;case"dead":this.labelClass("label-danger");break;case"unknown":default:this.labelClass("label-default")}},c.prototype._processHealth=function(t){switch(this.health(t),t){case"healthy":this.healthLabelClass("label-success");break;case"unstable":this.healthLabelClass("label-warning");break;case"unhealthy":this.healthLabelClass("label-danger");break;case"unknown":default:this.healthLabelClass("label-default")}},c.prototype._process=function(t){this.title(t.title),this.description(t.description),this.createUsers(t.create_users),this.hostCount(t.host_count),this.namespace(t.namespace),this.created(s(t.created)),this.labelList(t.label_list),this._processActivity(t.activity),this._processHealth(t.health)},c.prototype.reload=function(){var e=this;return t.ajax({method:"GET",url:e.raw.url}).done(function(t){e.raw=t,e._process(t)}).fail(function(t){403==t.status&&window.location.reload(!0)})},c.prototype.refreshActivity=function(){var e=this;return t.ajax({method:"GET",url:e.raw.url}).done(function(t){e.raw=t,e._processActivity(t.activity),e._processHealth(t.health)}).fail(function(t){403==t.status&&window.location.reload(!0)})},c.prototype.loadProperties=function(){var e=this;return this.raw.hasOwnProperty("properties")||(this.raw.properties=this.raw.url+"properties/"),t.ajax({method:"GET",url:this.raw.properties}).done(function(t){e.properties(t)})},c.prototype.saveProperties=function(){t.ajax({method:"PUT",url:this.raw.properties,data:JSON.stringify(this.properties())}).done(function(t){o.growlAlert("Successfully saved stack properties!","success")}).fail(function(t){var e;try{var a=JSON.parse(t.responseText);e=a.properties.join("<br>")}catch(t){e="Oops... there was a server error."}e+="  Your properties were not saved.",o.growlAlert(e,"danger")})},c.prototype.loadHosts=function(){var e=this;t.ajax({method:"GET",url:this.raw.hosts}).done(function(t){e.hosts(t.results.map(function(t){return new n(t,e.parent)}))})},c.prototype._addRemove=function(e,a,s){var o={action:e,host_definition:a.id,count:s},n=this;t.ajax({method:"POST",url:this.raw.hosts,data:JSON.stringify(o)}).done(function(){n.loadHosts()}).fail(function(t){var a;try{var s=JSON.parse(t.responseText);a="";for(var o in s)if(s.hasOwnProperty(o)){var n=o.replace("_"," ");s[o].forEach(function(t){a+="<dt>"+n+"</dt><dd>"+t+"</dd>"})}a&&(a='<dl class="dl-horizontal">'+a+"</dl>")}catch(t){a="Oops... there was a server error."}r.alert({title:"Error "+e+"ing hosts",message:a})})},c.prototype.addHosts=function(t,e){this._addRemove("add",t,e)},c.prototype.removeHosts=function(t,e){this._addRemove("remove",t,e)},c.prototype.loadBlueprint=function(){var e=this;return t.ajax({method:"GET",url:this.raw.blueprint}).done(function(t){e.blueprint(new i(t,e.parent))})},c.prototype.loadAvailableActions=function(){var e=this;this.raw.hasOwnProperty("action")||(this.raw.action=this.url+"action/"),t.ajax({method:"GET",url:this.raw.action}).done(function(t){e.availableActions(t.available_actions);try{e.parent.actionMap[e.id]=t.available_actions}catch(t){}})},c.prototype.runSingleSls=function(a,s){var n=this,i=e.escape(n.title());r.confirm({title:"Confirm component run for <strong>"+i+"</strong>",message:"Are you sure you want to run "+a+" on "+i+"?",buttons:{confirm:{label:"Run",className:"btn-primary"}},callback:function(e){if(e){var i={component:a};s&&(i.host_target=s),t.ajax({method:"POST",url:n.raw.action,data:JSON.stringify({action:"single-sls",args:[i]})}).done(function(){n.parent&&"function"==typeof n.parent.reload&&n.parent.reload(),o.growlAlert("Triggered "+a+".","success")}).fail(function(t){var e;try{var a=JSON.parse(t.responseText);e=a.action.join("<br>")}catch(t){e="Oops... there was a server error.  This has been reported to your administrators."}r.alert({title:"Error running component",message:e})})}}})},c.prototype.performAction=function(a){var s=this,o=e.escape(s.title()),n=this.actionMessages.hasOwnProperty(a)?this.actionMessages[a]:"";r.confirm({title:"Confirm action for <strong>"+o+"</strong>",message:'Are you sure you want to perform the "'+a+'" action on <strong>'+o+"</strong>?<br>"+n,buttons:{confirm:{label:a.capitalize().replace("_"," "),className:"btn-primary"}},callback:function(e){e&&t.ajax({method:"POST",url:s.raw.action,data:JSON.stringify({action:a})}).done(function(){s.parent&&"function"==typeof s.parent.reload?s.parent.reload():s.reload()}).fail(function(t){var e;try{var s=JSON.parse(t.responseText);e=s.action.join("<br>")}catch(t){e="Oops... there was a server error.  This has been reported to your administrators."}r.alert({title:'Error performing the "'+a+'" action',message:e})})}})},c.prototype._processStatus=function(t){switch(t.status){case"queued":t.statusPanel="panel-info",t.statusLabel="label-info";break;case"running":t.statusPanel="panel-warning",t.statusLabel="label-warning";break;case"succeeded":t.statusPanel="panel-success",t.statusLabel="label-success";break;case"failed":t.statusPanel="panel-danger",t.statusLabel="label-danger";break;case"cancelled":case"unknown":default:t.statusPanel="panel-default",t.statusLabel="label-default"}},c.prototype._processHostHealth=function(t){switch(t.health){case"healthy":t.healthPanel="panel-success",t.healthLabel="label-success";break;case"unstable":t.healthPanel="panel-warning",t.healthLabel="label-warning";break;case"unhealthy":t.healthPanel="panel-danger",t.healthLabel="label-danger";break;case"unknown":default:t.healthPanel="panel-default",t.healthLabel="label-default"}},c.prototype.loadComponents=function(){var e=this;return this.raw.hasOwnProperty("components")||(this.raw.components=this.raw.url+"components/"),t.ajax({method:"GET",url:this.raw.components}).done(function(t){t.results.forEach(function(t){t.htmlId=t.sls_path.replace(/\./g,"-"),t.hosts.forEach(function(t){t.timestamp=s(t.timestamp),e._processStatus(t),e._processHostHealth(t)}),e._processStatus(t),e._processHostHealth(t)}),e.components(t.results)})},c.prototype.loadHistory=function(){var e=this;return this.raw.hasOwnProperty("history")||(this.raw.history=this.raw.url+"history/"),t.ajax({method:"GET",url:this.raw.history}).done(function(t){t.results.forEach(function(t){t.timestamp=s(t.created)}),e.history(t.results)})},c.prototype.loadLogs=function(){var e=this;this.raw.hasOwnProperty("logs")||(this.raw.logs=this.raw.url+"logs/"),t.ajax({method:"GET",url:this.raw.logs}).done(function(t){var a=[];for(var r in t.latest)t.latest.hasOwnProperty(r)&&a.push({text:r,type:"item",url:t.latest[r]});e.latestLogs(a);var s=[];t.historical.forEach(function(t){var e=t.split("/");s.push({text:e[e.length-1],type:"item",url:t})}),e.historicalLogs(s)})},c.prototype.runCommand=function(e,a){var s=this;return t.ajax({method:"POST",url:this.raw.commands,data:JSON.stringify({host_target:e,command:a})}).done(function(){try{s.parent.reload()}catch(t){}}).fail(function(t){var e;try{var a=JSON.parse(t.responseText);e="";for(var s in a)if(a.hasOwnProperty(s)){var o=s.replace("_"," ");a[s].forEach(function(t){e+="<dt>"+o+"</dt><dd>"+t+"</dd>"})}e&&(e='<dl class="dl-horizontal">'+e+"</dl>")}catch(t){e="Oops... there was a server error."}r.alert({title:"Failed to run command",message:e})})},c.prototype.save=function(){var e=this,a=["title","description","create_users","namespace"];a.forEach(function(e){var a=t("#"+e);a.removeClass("has-error");var r=a.find(".help-block");r.remove()}),t.ajax({method:"PUT",url:e.raw.url,data:JSON.stringify({title:e.title(),description:e.description(),create_users:e.createUsers()})}).done(function(t){o.growlAlert("Successfully saved stack!","success");try{e.parent.stackTitle(t.title)}catch(t){}}).fail(function(t){o.parseSaveError(t,"stack",a)})},c.prototype.delete=function(){var a=this,s=e.escape(a.title());r.confirm({title:"Confirm delete of <strong>"+s+"</strong>",message:"Are you sure you want to delete <strong>"+s+"</strong>?<br>This will terminate all infrastructure, in addition to removing all history related to this stack.",buttons:{confirm:{label:"Delete",className:"btn-danger"}},callback:function(e){e&&t.ajax({method:"DELETE",url:a.raw.url}).done(function(t){a.raw=t,a._process(t),a.parent&&"function"==typeof a.parent.reload&&a.parent.reload()}).fail(function(t){var e;try{var a=JSON.parse(t.responseText);e=a.detail.join("<br>")}catch(t){e="Oops... there was a server error.  This has been reported to your administrators."}r.alert({title:"Error deleting stack",message:e})})}})},c});