"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticIp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
/**
 * The abstract base
 */
class ElasticIpBase extends aws_cdk_lib_1.Resource {
    grant(identity, ...actions) {
        return aws_iam_1.Grant.addToPrincipal({
            grantee: identity,
            actions,
            resourceArns: [this.elasticIpArn],
        });
    }
}
/**
 * An EC2 Elastic IP address.
 */
class ElasticIp extends ElasticIpBase {
    /**
     * Import an existing EIP from its ARN.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The scoped construct ID.
     * @param arn - The EIP ARN
     * @returns The imported Elastic IP
     */
    static fromElasticIpArn(scope, id, arn) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const parsed = stack.splitArn(arn, aws_cdk_lib_1.ArnFormat.SLASH_RESOURCE_NAME);
        return new (class ImportedArnEip extends ElasticIpBase {
            constructor() {
                super(...arguments);
                this.allocationId = parsed.resourceName;
                this.elasticIpArn = arn;
            }
        })(scope, id, { environmentFromArn: arn });
    }
    /**
     * Import an existing EIP from the given allocation ID.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The scoped construct ID.
     * @param allocationId - The EIP allocation ID.
     * @returns The imported Elastic IP
     */
    static fromAllocationId(scope, id, allocationId) {
        const elasticIpArn = aws_cdk_lib_1.Stack.of(scope).formatArn({
            service: "ec2",
            resource: "elastic-ip",
            resourceName: allocationId,
            arnFormat: aws_cdk_lib_1.ArnFormat.SLASH_RESOURCE_NAME,
        });
        return this.fromElasticIpArn(scope, id, elasticIpArn);
    }
    /**
     * Creates a new Elastic IP address.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The scoped construct ID.
     * @param props - Initialization properties for this construct.
     */
    constructor(scope, id, props = {}) {
        super(scope, id);
        const { removalPolicy } = props;
        const eip = new aws_ec2_1.CfnEIP(this, "Resource", { domain: "vpc" });
        this.allocationId = eip.ref;
        this.elasticIpArn = aws_cdk_lib_1.Stack.of(this).formatArn({
            service: "ec2",
            resource: "elastic-ip",
            resourceName: this.allocationId,
            arnFormat: aws_cdk_lib_1.ArnFormat.SLASH_RESOURCE_NAME,
        });
        this.publicIp = eip.attrPublicIp;
        if (removalPolicy) {
            this.applyRemovalPolicy(removalPolicy);
        }
    }
}
exports.ElasticIp = ElasticIp;
_a = JSII_RTTI_SYMBOL_1;
ElasticIp[_a] = { fqn: "shady-island.networking.ElasticIp", version: "0.1.23" };
//# sourceMappingURL=data:application/json;base64,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