"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContextLoader = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
/**
 * A utility to load context values into a construct node.
 *
 * If you want to use this utility in your own construct, make sure to invoke it
 * before you create any child constructs.
 */
class ContextLoader {
    /**
     * Parses JSON file contents, then provides the values to a Node's context.
     *
     * @param filename - The JSON file with an object to use as context values.
     * @param node - The constructs node to receive the context values.
     */
    static loadContext(filename, node) {
        try {
            fs.accessSync(filename, fs.constants.F_OK);
        }
        catch (err) {
            throw new Error(`Context file does not exist: ${filename}`);
        }
        try {
            fs.accessSync(filename, fs.constants.R_OK);
        }
        catch (err) {
            throw new Error(`Context file is not readable: ${filename}`);
        }
        const data = fs.readFileSync(filename, { encoding: "utf8" });
        let defaults = {};
        try {
            defaults = JSON.parse(data);
        }
        catch (e) {
            throw new Error(`Context file contains invalid JSON syntax: ${filename}`);
        }
        for (const [k, v] of Object.entries(defaults)) {
            node.setContext(k, v);
        }
    }
}
exports.ContextLoader = ContextLoader;
_a = JSII_RTTI_SYMBOL_1;
ContextLoader[_a] = { fqn: "shady-island.ContextLoader", version: "0.1.23" };
//# sourceMappingURL=data:application/json;base64,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