import * as React from 'react';
import { Severity } from '../tokens';
/**
 * Interface describing component properties.
 */
export interface IAlertProps {
    /**
     * Boolean indicating whether to display an alert.
     */
    open: boolean;
    /**
     * Alert message.
     */
    message: string;
    /**
     * Alert severity.
     */
    severity?: Severity;
    /**
     * Alert duration (in milliseconds).
     */
    duration?: number;
    /**
     * Callback invoked upon clicking on an alert.
     */
    onClick?: (event?: any) => void;
    /**
     * Callback invoked upon closing an alert.
     */
    onClose: (event?: any) => void;
}
/**
 * React component for rendering an alert.
 */
export declare class Alert extends React.Component<IAlertProps> {
    /**
     * Returns a React component for rendering an alert.
     *
     * @param props - component properties
     * @returns React component
     */
    constructor(props: IAlertProps);
    /**
     * Renders the component.
     *
     * @returns React element
     */
    render(): React.ReactElement;
    /**
     * Callback invoked upon clicking on an alert.
     *
     * @param event - event object
     */
    private _onClick;
    /**
     * Callback invoked upon closing an alert.
     *
     * @param event - event object
     * @param reason - reason why the callback was invoked
     */
    private _onClose;
}
