import { caretDownIcon, caretRightIcon } from '@jupyterlab/ui-components';
import * as React from 'react';
import { changeStageButtonStyle, sectionAreaStyle, sectionFileContainerStyle, sectionHeaderLabelStyle, sectionHeaderSizeStyle } from '../style/GitStageStyle';
export const GitStage = (props) => {
    const [showFiles, setShowFiles] = React.useState(true);
    return (React.createElement("div", { className: sectionFileContainerStyle },
        React.createElement("div", { className: sectionAreaStyle },
            props.collapsible && (React.createElement("button", { className: changeStageButtonStyle, onClick: () => {
                    if (props.nFiles > 0) {
                        setShowFiles(!showFiles);
                    }
                } }, showFiles && props.nFiles > 0 ? (React.createElement(caretDownIcon.react, null)) : (React.createElement(caretRightIcon.react, null)))),
            React.createElement("span", { className: sectionHeaderLabelStyle }, props.heading),
            props.actions,
            React.createElement("span", { className: sectionHeaderSizeStyle },
                "(",
                props.nFiles,
                ")")),
        showFiles && (React.createElement("ul", { className: sectionFileContainerStyle }, props.children))));
};
//# sourceMappingURL=GitStage.js.map