import * as React from 'react';
import { IGitExtension, ILogMessage } from '../tokens';
/**
 * Interface describing component properties.
 */
export interface IToolbarProps {
    /**
     * Git extension data model.
     */
    model: IGitExtension;
    /**
     * Boolean indicating whether branching is disabled.
     */
    branching: boolean;
    /**
     * Boolean indicating whether to enable UI suspension.
     */
    suspend: boolean;
    /**
     * Callback to invoke in order to refresh a repository.
     *
     * @returns promise which refreshes a repository
     */
    refresh: () => Promise<void>;
}
/**
 * Interface describing component state.
 */
export interface IToolbarState {
    /**
     * Boolean indicating whether a branch menu is shown.
     */
    branchMenu: boolean;
    /**
     * Boolean indicating whether a repository menu is shown.
     */
    repoMenu: boolean;
    /**
     * Current repository.
     */
    repository: string;
    /**
     * Current branch name.
     */
    branch: string;
    /**
     * Boolean indicating whether UI interaction should be suspended (e.g., due to pending command).
     */
    suspend: boolean;
    /**
     * Boolean indicating whether to show an alert.
     */
    alert: boolean;
    /**
     * Log message.
     */
    log: ILogMessage;
}
/**
 * React component for rendering a panel toolbar.
 */
export declare class Toolbar extends React.Component<IToolbarProps, IToolbarState> {
    /**
     * Returns a React component for rendering a panel toolbar.
     *
     * @param props - component properties
     * @returns React component
     */
    constructor(props: IToolbarProps);
    /**
     * Callback invoked immediately after mounting a component (i.e., inserting into a tree).
     */
    componentDidMount(): void;
    /**
     * Callback invoked when a component will no longer be mounted.
     */
    componentWillUnmount(): void;
    /**
     * Renders the component.
     *
     * @returns React element
     */
    render(): React.ReactElement;
    /**
     * Renders the top navigation.
     *
     * @returns React element
     */
    private _renderTopNav;
    /**
     * Renders a repository menu.
     *
     * @returns React element
     */
    private _renderRepoMenu;
    /**
     * Renders a branch menu.
     *
     * @returns React element
     */
    private _renderBranchMenu;
    /**
     * Renders a component to provide UI feedback.
     *
     * @returns React element
     */
    private _renderFeedback;
    /**
     * Adds model listeners.
     */
    private _addListeners;
    /**
     * Removes model listeners.
     */
    private _removeListeners;
    /**
     * Syncs the component state with the underlying model.
     */
    private _syncState;
    /**
     * Sets the suspension state.
     *
     * @param bool - boolean indicating whether to suspend UI interaction
     */
    private _suspend;
    /**
     * Sets the current component log message.
     *
     * @param msg - log message
     */
    private _log;
    /**
     * Callback invoked upon clicking a button to pull the latest changes.
     *
     * @param event - event object
     * @returns a promise which resolves upon pulling the latest changes
     */
    private _onPullClick;
    /**
     * Callback invoked upon clicking a button to push the latest changes.
     *
     * @param event - event object
     * @returns a promise which resolves upon pushing the latest changes
     */
    private _onPushClick;
    /**
     * Callback invoked upon clicking a button to change the current repository.
     *
     * @param event - event object
     */
    private _onRepositoryClick;
    /**
     * Callback invoked upon clicking a button to change the current branch.
     *
     * @param event - event object
     */
    private _onBranchClick;
    /**
     * Callback invoked upon clicking a button to refresh a repository.
     *
     * @param event - event object
     * @returns a promise which resolves upon refreshing a repository
     */
    private _onRefreshClick;
    /**
     * Callback invoked upon clicking on the feedback modal.
     *
     * @param event - event object
     */
    private _onFeedbackModalClick;
    /**
     * Callback invoked upon closing a feedback alert.
     *
     * @param event - event object
     */
    private _onFeedbackAlertClose;
    /**
     * Callback invoked upon clicking a button to view tags.
     *
     * @param event - event object
     */
    private _onTagClick;
}
