import CodeMirror from 'codemirror';
export declare const GutterID = "CodeMirror-patchgutter";
declare enum DiffStatus {
    Equal,
    Delete,
    Insert
}
export declare namespace MergeView {
    /**
     * Options available to MergeView.
     */
    interface IMergeViewEditorConfiguration extends CodeMirror.EditorConfiguration {
        /**
         * Determines whether the original editor allows editing. Defaults to false.
         */
        allowEditingOriginals?: boolean;
        /**
         * When true stretches of unchanged text will be collapsed. When a number is given, this indicates the amount
         * of lines to leave visible around such stretches (which defaults to 2). Defaults to false.
         */
        collapseIdentical?: boolean | number;
        /**
         * Sets the style used to connect changed chunks of code. By default, connectors are drawn. When this is set to "align",
         * the smaller chunk is padded to align with the bigger chunk instead.
         */
        connect?: string;
        /**
         * Should the whitespace be ignored when comparing text
         */
        ignoreWhitespace?: boolean;
        /**
         * Callback for when stretches of unchanged text are collapsed.
         */
        onCollapse?(mergeView: IMergeViewEditor, line: number, size: number, mark: CodeMirror.TextMarker): void;
        /**
         * Provides original version of the document to be shown on the right of the editor.
         */
        orig: any;
        /**
         * Provides original version of the document to be shown on the left of the editor.
         * To create a 2-way (as opposed to 3-way) merge view, provide only one of origLeft and origRight.
         */
        origLeft?: any;
        /**
         * Provides original version of document to be shown on the right of the editor.
         * To create a 2-way (as opposed to 3-way) merge view, provide only one of origLeft and origRight.
         */
        origRight?: any;
        /**
         * Determines whether buttons that allow the user to revert changes are shown. Defaults to true.
         */
        revertButtons?: boolean;
        /**
         * When true, changed pieces of text are highlighted. Defaults to true.
         */
        showDifferences?: boolean;
        revertChunk?: (mergeView: IMergeViewEditor, from: CodeMirror.Editor, origStart: CodeMirror.Position, origEnd: CodeMirror.Position, to: CodeMirror.Editor, editStart: CodeMirror.Position, editEnd: CodeMirror.Position) => void;
    }
    interface IMergeViewEditor {
        /**
         * Returns the editor instance.
         */
        editor(): CodeMirror.Editor;
        /**
         * Left side of the merge view.
         */
        left: IDiffView;
        leftChunks(): IMergeViewDiffChunk[];
        leftOriginal(): CodeMirror.Editor;
        /**
         * Right side of the merge view.
         */
        right: IDiffView;
        rightChunks(): IMergeViewDiffChunk[];
        rightOriginal(): CodeMirror.Editor;
        /**
         * Sets whether or not the merge view should show the differences between the editor views.
         */
        setShowDifferences(showDifferences: boolean): void;
    }
    /**
     * Tracks changes in chunks from oroginal to new.
     */
    interface IMergeViewDiffChunk {
        editFrom: number;
        editTo: number;
        origFrom: number;
        origTo: number;
    }
    interface IDiffView {
        /**
         * Forces the view to reload.
         */
        forceUpdate(): (mode: string) => void;
        /**
         * Sets whether or not the merge view should show the differences between the editor views.
         */
        setShowDifferences(showDifferences: boolean): void;
    }
    type Diff = [DiffStatus, string];
    interface IClasses {
        chunk: string;
        start: string;
        end: string;
        insert: string;
        del: string;
        connect: string;
        classLocation?: string[];
    }
    type PanelType = 'left' | 'right';
    interface IState {
        from: number;
        to: number;
        marked: CodeMirror.LineHandle[];
    }
}
/**
 * A function that calculates either a two-way or three-way merge between different sets of content.
 */
export declare function mergeView(node: HTMLElement, options?: MergeView.IMergeViewEditorConfiguration): MergeView.IMergeViewEditor;
export {};
