import { ReactWidget } from '@jupyterlab/apputils';
import * as React from 'react';
import { GitPanel } from '../components/GitPanel';
import { gitWidgetStyle } from '../style/GitWidgetStyle';
/**
 * A class that exposes the git plugin Widget.
 */
export class GitWidget extends ReactWidget {
    constructor(model, settings, renderMime, filebrowser, options) {
        super(options);
        this.node.id = 'GitSession-root';
        this.addClass(gitWidgetStyle);
        this._model = model;
        this._renderMime = renderMime;
        this._settings = settings;
        this._filebrowser = filebrowser;
    }
    render() {
        return (React.createElement(GitPanel, { model: this._model, renderMime: this._renderMime, settings: this._settings, filebrowser: this._filebrowser }));
    }
}
//# sourceMappingURL=GitWidget.js.map